/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import org.maachang.dbm.MaachangDbm;
import org.maachang.dbm.engine.MDbmEngine;
import org.maachang.util.ConvertParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaachangDbmOp {
    private MaachangDbm dbm = null;

    private MaachangDbmOp() {
    }

    public MaachangDbmOp(MaachangDbm dbm) throws Exception {
        if (dbm == null || !dbm.isUse()) {
            throw new IllegalArgumentException("MaachangDbm\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.dbm = dbm;
    }

    public void destroy() {
        this.dbm.destroy();
    }

    public MaachangDbm maachangDbm() {
        return this.dbm;
    }

    public void flush() throws Exception {
        this.dbm.flush();
    }

    public void put(byte[] key, byte[] value) throws Exception {
        this.dbm.put(key, value);
    }

    public void put(String key, byte[] value) throws Exception {
        this.dbm.put(MaachangDbmOp.convertString(key), value);
    }

    public void put(int key, byte[] value) throws Exception {
        this.dbm.put(MaachangDbmOp.convertInt(key), value);
    }

    public void put(long key, byte[] value) throws Exception {
        this.dbm.put(MaachangDbmOp.convertLong(key), value);
    }

    public void put(byte[] key, String value) throws Exception {
        this.dbm.put(key, MaachangDbmOp.convertString(value));
    }

    public void put(String key, String value) throws Exception {
        this.dbm.put(MaachangDbmOp.convertString(key), MaachangDbmOp.convertString(value));
    }

    public void put(int key, String value) throws Exception {
        this.dbm.put(MaachangDbmOp.convertInt(key), MaachangDbmOp.convertString(value));
    }

    public void put(long key, String value) throws Exception {
        this.dbm.put(MaachangDbmOp.convertLong(key), MaachangDbmOp.convertString(value));
    }

    public void put(byte[] key, Serializable value) throws Exception {
        this.dbm.put(key, MaachangDbmOp.convertBinary(value));
    }

    public void put(String key, Serializable value) throws Exception {
        this.dbm.put(MaachangDbmOp.convertString(key), MaachangDbmOp.convertBinary(value));
    }

    public void put(int key, Serializable value) throws Exception {
        this.dbm.put(MaachangDbmOp.convertInt(key), MaachangDbmOp.convertBinary(value));
    }

    public void put(long key, Serializable value) throws Exception {
        this.dbm.put(MaachangDbmOp.convertLong(key), MaachangDbmOp.convertBinary(value));
    }

    public void remove(byte[] key) throws Exception {
        this.dbm.remove(key);
    }

    public void remove(String key) throws Exception {
        this.dbm.remove(MaachangDbmOp.convertString(key));
    }

    public void remove(int key) throws Exception {
        this.dbm.remove(MaachangDbmOp.convertInt(key));
    }

    public void remove(long key) throws Exception {
        this.dbm.remove(MaachangDbmOp.convertLong(key));
    }

    public byte[] get(byte[] key) throws Exception {
        return this.dbm.get(key);
    }

    public byte[] get(String key) throws Exception {
        return this.dbm.get(MaachangDbmOp.convertString(key));
    }

    public byte[] get(int key) throws Exception {
        return this.dbm.get(MaachangDbmOp.convertInt(key));
    }

    public byte[] get(long key) throws Exception {
        return this.dbm.get(MaachangDbmOp.convertLong(key));
    }

    public String getString(byte[] key) throws Exception {
        byte[] b = this.dbm.get(key);
        if (b == null) {
            return null;
        }
        return new String(b, "UTF8");
    }

    public String getString(String key) throws Exception {
        byte[] b = this.dbm.get(MaachangDbmOp.convertString(key));
        if (b == null) {
            return null;
        }
        return new String(b, "UTF8");
    }

    public String getString(int key) throws Exception {
        byte[] b = this.dbm.get(MaachangDbmOp.convertInt(key));
        if (b == null) {
            return null;
        }
        return new String(b, "UTF8");
    }

    public String getString(long key) throws Exception {
        byte[] b = this.dbm.get(MaachangDbmOp.convertLong(key));
        if (b == null) {
            return null;
        }
        return new String(b, "UTF8");
    }

    public Serializable getObject(byte[] key) throws Exception {
        byte[] b = this.dbm.get(key);
        if (b == null) {
            return null;
        }
        return MaachangDbmOp.convertObject(b);
    }

    public Serializable getObject(String key) throws Exception {
        byte[] b = this.dbm.get(MaachangDbmOp.convertString(key));
        if (b == null) {
            return null;
        }
        return MaachangDbmOp.convertObject(b);
    }

    public Serializable getObject(int key) throws Exception {
        byte[] b = this.dbm.get(MaachangDbmOp.convertInt(key));
        if (b == null) {
            return null;
        }
        return MaachangDbmOp.convertObject(b);
    }

    public Serializable getObject(long key) throws Exception {
        byte[] b = this.dbm.get(MaachangDbmOp.convertLong(key));
        if (b == null) {
            return null;
        }
        return MaachangDbmOp.convertObject(b);
    }

    public Enumeration<byte[]> elements() {
        return this.dbm.elements();
    }

    public int size() {
        return this.dbm.size();
    }

    public String getDirectory() {
        return this.dbm.getDirectory();
    }

    public MDbmEngine getEngine() {
        return this.dbm.getEngine();
    }

    public boolean isUse() {
        return this.dbm.isUse();
    }

    private static final byte[] convertString(String key) throws Exception {
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return key.getBytes("UTF8");
    }

    private static final byte[] convertInt(int key) throws Exception {
        return ConvertParam.convertInt(key);
    }

    private static final byte[] convertLong(long key) throws Exception {
        return ConvertParam.convertLong(key);
    }

    private static final byte[] convertBinary(Serializable value) throws Exception {
        if (value == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] ret = null;
        ObjectOutputStream o = null;
        try {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            o = new ObjectOutputStream(b);
            o.writeObject(value);
            o.flush();
            ret = b.toByteArray();
        }
        finally {
            try {
                o.close();
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    private static final Serializable convertObject(byte[] bin) throws Exception {
        if (bin == null || bin.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        ObjectInputStream in = null;
        Serializable ret = null;
        try {
            in = new ObjectInputStream(new ByteArrayInputStream(bin));
            ret = (Serializable)in.readObject();
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            in = null;
        }
        return ret;
    }
}

