/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm;

import java.util.Enumeration;
import org.maachang.dbm.engine.MDbmEngine;
import org.maachang.dbm.engine.MDbmThread;
import org.maachang.dbm.engine.MHash;
import org.maachang.dbm.engine.MKey;
import org.maachang.dbm.engine.MSctArray;
import org.maachang.dbm.engine.MValue;
import org.maachang.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaachangDbm {
    private static final String BASE_FILE = "base.hash";
    private static final String KEY_FILE = "key.hash";
    private MDbmEngine engine = null;
    private MDbmThread thread = null;
    private String directory = null;

    private MaachangDbm() {
    }

    public MaachangDbm(String directory) throws Exception {
        if (directory == null || (directory = directory.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if ((directory = FileUtil.getFullPath(directory)).endsWith("\\") || directory.endsWith("/")) {
            directory = directory.substring(0, directory.length() - 1);
        }
        if (!FileUtil.isDirExists(directory)) {
            FileUtil.mkdirs(directory);
        }
        MHash hash = new MHash(directory + FileUtil.FILE_SPACE + BASE_FILE);
        MKey key = new MKey(hash, directory + FileUtil.FILE_SPACE + KEY_FILE);
        MValue value = new MValue(new MSctArray(directory));
        MDbmEngine engine = new MDbmEngine(key, value);
        MDbmThread thread = new MDbmThread(engine);
        this.engine = engine;
        this.thread = thread;
        this.directory = directory;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.thread != null) {
            this.thread.destroy();
        }
        this.thread = null;
        if (this.engine != null) {
            this.engine.destroy();
        }
        this.engine = null;
        this.directory = null;
    }

    public void flush() throws Exception {
        if (!this.isUse()) {
            return;
        }
        if (this.thread != null) {
            this.thread.destroyTiming();
        }
        if (this.engine != null) {
            this.engine.flush();
        }
    }

    public void put(byte[] key, byte[] value) throws Exception {
        if (!this.isUse()) {
            return;
        }
        this.engine.put(key, value);
        this.thread.setTiming();
    }

    public void remove(byte[] key) throws Exception {
        if (!this.isUse()) {
            return;
        }
        this.engine.remove(key);
        this.thread.setTiming();
    }

    public byte[] get(byte[] key) throws Exception {
        if (!this.isUse()) {
            return null;
        }
        return this.engine.get(key);
    }

    public Enumeration<byte[]> elements() {
        if (!this.isUse()) {
            return null;
        }
        return this.engine.elements();
    }

    public int size() {
        if (!this.isUse()) {
            return -1;
        }
        return this.engine.size();
    }

    public String getDirectory() {
        if (!this.isUse()) {
            return null;
        }
        return this.directory;
    }

    public MDbmEngine getEngine() {
        if (!this.isUse()) {
            return null;
        }
        return this.engine;
    }

    public boolean isUse() {
        if (this.engine == null) {
            return false;
        }
        return this.engine.isUse();
    }
}

