/*
 * @(#)SampleSearch.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package sample ;

import java.io.BufferedReader;
import java.io.InputStreamReader;

import org.maachang.index.MaachangResult;
import org.maachang.index.MaachangSearch;

/**
 * 検索サンプル.
 * <BR><BR>
 * 検索サンプルソース.<BR>
 * MaachangSearchで、検索処理を行う場合の一例です.<BR>
 * このサンプルは、コンソール上で利用するサンプルなので、[System.in]を使った、
 * コンソールアプリとなっています.<BR>
 * また、mainに渡す引数は、以下の通りです.<BR>
 * <BR>
 * args[ 0 ] インデックス生成先ディレクトリ.(必ず指定)<BR>
 * <BR>
 * また、このプログラムを動かす前に、インデックスを作成する必要があります.
 * <BR>
 * 以上.
 *
 * @version 2007/07/16
 * @author  masahito suzuki
 * @since   MaachangIndex 1.00
 */
public class SampleSearch {
    
    /**
     * main実行.
     * <BR><BR>
     * インデックスを作成するサンプルです.
     * <BR>
     * @param args コマンド引数.
     * @exception Exception 例外.
     */
    public static final void main( String[] args )
        throws Exception {
        new SampleIndex().execution( args ) ;
    }
    
    /**
     * コマンド.
     */
    private static final String CMD = "$" ;
    
    /**
     * コマンド要素 : 次ページ表示.
     */
    private static final char NEXT = 'n' ;
    
    /**
     * コマンド要素 : 前ページ表示.
     */
    private static final char BEFORE = 'b' ;
    
    /**
     * コマンド要素 : 終了.
     */
    private static final char QUIT = 'q' ;
    
    /**
     * 表示件数.
     */
    private static final int ONE_VIEW_LENGHT = 5 ;
    
    /**
     * 表示文字を区切る.
     */
    private static final int CUT_LENGTH = 48 ;
    
    /**
     * 実行処理.
     * <BR><BR>
     * インデックスを作成します.
     * <BR>
     * @param args コマンド引数.
     * @exception Exception 例外.
     */
    public void execution( String[] args )
        throws Exception {
        
        // 引数チェック.
        if( args == null || args.length < 1 ) {
            System.out.println( " 引数が足りません: [index-dir]" ) ;
            System.out.println( "   [index-dir] : インデックス生成先ディレクトリを設定します." ) ;
            return ;
        }
        
        String index_dir = args[ 0 ] ;
        
        BufferedReader in = new BufferedReader(
            new InputStreamReader( System.in ) ) ;
        
        // 検索内容を生成.
        // N-Gramは２で作成.
        // IndexChip(インデックスの主内容)キャッシュは2048.
        // 検索結果の生データキャッシュは0.
        // history(検索履歴保持)は0.
        // Keyキャッシュは512.
        // 
        MaachangResult res = null ;
        MaachangSearch search = new MaachangSearch( 2,2048,0,0,512,index_dir ) ;
        
        System.out.println( "start search." ) ;
        
        // 検索用コンソールアプリ開始.
        long t = System.currentTimeMillis() ;
        boolean resFlg = false ;
        for( boolean flg = false ;; ) {
            resFlg = true ;
            if( flg == true ) {
                break ;
            }
            
            System.out.print( "?>" ) ;
            String ln = in.readLine() ;
            if( ln == null ) {
                continue ;
            }
            ln = ln.trim() ;
            
            if( ln.startsWith( CMD ) == true ) {
                if( ln.length() <= 1 ) {
                    System.out.println( "コマンド説明:" ) ;
                    System.out.println( " $n : 次ページ内容を表示します." ) ;
                    System.out.println( " $b : 前ページ内容を表示します." ) ;
                    System.out.println( " $q : このプログラムを終了します." ) ;
                    continue ;
                }
                ln = ln.toLowerCase() ;
                char nl = ln.charAt( 1 ) ;
                switch( nl ) {
                    case NEXT :
                        if( res == null ) {
                            break ;
                        }
                        t = System.currentTimeMillis() ;
                        // 次ページを検索.
                        resFlg = search.nextSearch( res ) ;
                        break ;
                    case BEFORE :
                        if( res == null ) {
                            break ;
                        }
                        t = System.currentTimeMillis() ;
                        // 前ページを検索
                        resFlg = search.beforeSearch( res ) ;
                        break ;
                    case QUIT :
                        flg = true ;
                        break ;
                }
                if( flg == true ) {
                    continue ;
                }
            }
            else {
                // 指定キー名で検索.
                t = System.currentTimeMillis() ;
                res = search.searchByNewWord( ln,ONE_VIEW_LENGHT ) ;
            }
            
            // 検索結果が存在する場合は、その内容を表示.
            if( resFlg == true && res != null && res.size() > 0 ) {
                System.out.println( "検索結果(" + res.getSearchWord() + "): 総件数" + res.getMaxResult() + "件" +
                    " " + res.getOffset() + " 件から " + res.size() + " 件表示" ) ;
                System.out.println( " 検索時間:" + ( System.currentTimeMillis() - t ) + "msec" ) ;
                int len = res.size() ;
                for( int i = 0 ; i < len ; i ++ ) {
                    System.out.println( "[" + (res.getOffset()+i+1) + "件目] name:" +
                    res.getResult( i ).getSearchElement() +
                        " score:" + res.getResult( i ).getScore() ) ;
                    System.out.println( "  内容:" + cutCode( res.getResult( i ).getPartString(),CUT_LENGTH ) ) ;
                    System.out.println() ;
                }
            }
            
        }
        System.out.println( "exit search" ) ;
    }
    
    /**
     * 表示内容を指定長で区切る.
     */
    private static final String cutCode( String code,int len ) {
        if( code == null ) {
            return "" ;
        }
        else if( code.length() <= len ) {
            return code ;
        }
        StringBuilder buf = new StringBuilder( code.length() ) ;
        int p,b = 0 ;
        int max = code.length() ;
        for( ;; ) {
            p = b + len ;
            if( p >= max ) {
                buf.append( code.substring( b ) ) ;
                break ;
            }
            buf.append( code.substring( b,p ) ) ;
            buf.append( "\n       " ) ;
            b = p ;
        }
        return buf.toString() ;
    }
    
}
