/*
 * @(#)SampleIndex.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package sample ;
import java.io.File;
import java.util.ArrayList;

import org.maachang.index.MaachangIndex;
import org.maachang.util.FileUtil;

/**
 * インデックスサンプル.
 * <BR><BR>
 * インデックスサンプルソース.<BR>
 * MaachangIndexで、インデックス生成を行う場合の一例です.<BR>
 * このような感じで利用します.<BR>
 * <BR>
 * また、mainに渡す引数は、以下の通りです.<BR>
 * <BR>
 * args[ 0 ] インデックス作成元ソースディレクトリ.(必ず指定)<BR>
 * args[ 1 ] インデックス生成先ディレクトリ.(必ず指定)<BR>
 * args[ 2 ] HTMLキャラクターセット.(任意)<BR>
 * <BR>
 * 以上.
 *
 * @version 2007/07/16
 * @author  masahito suzuki
 * @since   MaachangIndex 1.00
 */
public class SampleIndex {
    
    /**
     * main実行.
     * <BR><BR>
     * インデックスを作成するサンプルです.
     * <BR>
     * @param args コマンド引数.
     * @exception Exception 例外.
     */
    public static final void main( String[] args )
        throws Exception {
        new SampleIndex().execution( args ) ;
    }
    
    /**
     * デフォルトキャラクタセット.
     */
    private static final String CHARSET = "UTF8" ;
    
    /**
     * 実行処理.
     * <BR><BR>
     * インデックスを作成します.
     * <BR>
     * @param args コマンド引数.
     * @exception Exception 例外.
     */
    public void execution( String[] args )
        throws Exception {
        
        // 引数チェック.
        if( args == null || args.length < 2 ) {
            System.out.println( " 引数が足りません: [src-dir] [index-dir]" ) ;
            System.out.println( "   [src-dir]:    インデックス作成元のソースディレクトリを設定します." ) ;
            System.out.println( "   [index-dir] : インデックス生成先ディレクトリを設定します." ) ;
            return ;
        }
        
        // 各引数を区分.
        String src_dir = args[ 0 ] ;
        String index_dir = args[ 1 ] ;
        String charset = CHARSET ;
        if( args.length >= 3 ) {
            charset = args[ 2 ] ;
        }
        
        // インデックス作成元ソースディレクトリから、ファイル名を保持するオブジェクト.
        ArrayList<String> lst = new ArrayList<String>() ;
        
        // インデックス作成元ソースディレクトリから、有効(HTML)ファイル名を取得
        getList( lst,src_dir ) ;
        
        // ソース内容が存在する場合.
        if( lst.size() > 0 ) {
            
            System.out.print( " target file-size(" + lst.size() + ")..." ) ;
            
            // インデックス作成.
            // N-Gram値は、２で生成.
            // IndexChip(インデックスの主内容)キャッシュは8192.
            // 検索SubKeyキャッシュサイズは512.
            // インデックス名キャッシュサイズは、512.
            // 
            // ヒント：IndexChipキャッシュを大きくすれば、インデックス生成時間を
            //        大幅に短縮できますが、その分メモリーをかなり多くとります.
            MaachangIndex index = new MaachangIndex( 2,8192,512,512,index_dir ) ;
            int len = lst.size() ;
            
            System.out.println( " start!!" ) ;
            // all時間.
            long all = System.currentTimeMillis() ;
            for( int i = 0 ; i < len ; i ++ ) {
                long t = System.currentTimeMillis() ;
                System.out.print( "(" + (i+1) + "/" + len + ")file:" + lst.get( i ) ) ;
                
                // ファイル内容を取得.
                String d = FileUtil.getFileByString( lst.get( i ),charset ) ;
                
                // ディレクトリ+ファイル名から、ファイル名だけを抜き出す.
                String name = FileUtil.getFileName( lst.get( i ) ) ;
                
                // インデックスとして追加.
                // 追加内容は以下の通り.
                // 1.インデックス名は、対象のディレクトリ+ファイル名.
                // 2.インデックスする内容(ファイル内容).
                // 3.要素名には、ファイル名だけをセット.
                // 4.検索マスクに対応させるための情報をセット(検索SubKey).
                //   この情報には、ファイル名の先頭名を小文字でセットする.
                index.put( lst.get( i ),d,name,name.substring( 0,1 ).toLowerCase() ) ;
                System.out.println( "...end:time[" + ( System.currentTimeMillis()-t) + "msec]" ) ;
            }
            System.out.println( "create(" + len + ") index ...end." ) ;
            // キャッシュに存在するインデックスを全てファイル出力.
            index.flush() ;
            System.out.println( "write index ...end." ) ;
            System.out.println( "(" + len + "):insert index -- total-time:" + ( System.currentTimeMillis() - all ) + "msec" ) ;
        }
        else {
            System.out.println( "有効なソース(HTML)はディレクトリ(" + src_dir + ")に存在しません" ) ;
        }
    }
    
    /**
     * file種別.
     */
    private static final String[] TARGET_TXT = { ".html",".htm","txt" } ;
    
    /**
     * HTMLファイル名を取得.
     */
    private static final void getList( ArrayList<String> lst,String name ) {
        if( name.endsWith( "\\" ) == false && name.endsWith( "/" ) == false ) {
            name = name + FileUtil.FILE_SPACE ;
        }
        
        File file = new File( name ) ;
        String[] names = file.list() ;
        file = null ;
        int len ;
        if( names != null && ( len = names.length ) > 0 ) {
            for( int i = 0 ; i < len ; i ++ ) {
                String target = name + names[ i ] ;
                names[ i ] = null ;
                File fp = new File( target ) ;
                
                if( fp.isDirectory() == true ) {
                    fp = null ;
                    getList( lst,target ) ;
                }
                else {
                    int lenJ = TARGET_TXT.length ;
                    for( int j = 0 ; j < lenJ ; j ++ ) {
                        if( target.endsWith( TARGET_TXT[ j ] ) == true ) {
                            lst.add( target ) ;
                            break ;
                        }
                    }
                }
            }
        }
    }

}

