/*
 * @(#)StringUtil.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.util ;

import java.util.ArrayList;

/**
 * 文字操作ユーティリティ.
 *
 * @version 2007/06/28
 * @author  masahito suzuki
 * @since   MaachangIndex 1.00
 */
public class StringUtil {
    
    /**
     * チェック情報単位で情報を区切ります。
     * <BR><BR>
     * @param str 区切り対象の情報を設置します.
     * @param check 区切り対象の文字情報をセットします.<BR>
     *              区切り対象文字を複数設定する事により、それらに対応した区切りとなります.
     * @return ArrayList 区切られた情報が格納されています.
     * @exception IllegalArgumentException 入力例外.
     */
    public static final ArrayList<String> cutString(String str,String check)
        throws IllegalArgumentException {
        ArrayList<String> ret = null ;
        
        ret = new ArrayList<String>() ;
        
        cutString( ret,str,check ) ;
        
        return ret ;
    }
    
    /**
     * チェック情報単位で情報を区切ります。
     * <BR><BR>
     * @param out 区切られた情報が格納されます.
     * @param str 区切り対象の情報を設置します.
     * @param check 区切り対象の文字情報をセットします.<BR>
     *              区切り対象文字を複数設定する事により、それらに対応した区切りとなります.
     * @exception IllegalArgumentException 入力例外.
     */
    public static final void cutString(ArrayList<String> out,String str,String check)
        throws IllegalArgumentException {
        int i,j ;
        int len ;
        int lenJ ;
        int s = -1 ;
        char strCode ;
        
        char[] checkCode = null ;
        String tmp = null ;
        
        if(
            out == null ||
            str == null || ( len = str.length() ) <= 0 ||
            check == null || check.length() <= 0
        )
        {
            throw new IllegalArgumentException( "引数が不正です" ) ;
        }
        
        out.clear() ;
        
        lenJ = check.length() ;
        checkCode = new char[ lenJ ] ;
        check.getChars( 0,lenJ,checkCode,0 ) ;
        
        if( lenJ == 1 ){
            
            for( i = 0,s = -1 ; i < len ; i ++ ){
                
                strCode = str.charAt( i ) ;
                s = ( s == -1 ) ? i : s ;
                
                if( strCode == checkCode[ 0 ] ){
                    
                    if( s < i ){
                        tmp = str.substring( s,i ) ;
                        out.add(tmp) ;
                        tmp = null ;
                        s = -1 ;
                    }
                    else{
                        s = -1 ;
                    }
                    
                }
                
            }
            
        }
        else{
            
            for( i = 0,s = -1 ; i < len ; i ++ ){
                
                strCode = str.charAt( i ) ;
                s = ( s == -1 ) ? i : s ;
                
                for( j = 0 ; j < lenJ ; j ++ ){
                    if( strCode == checkCode[ j ] ){
                        
                        if( s < i ){
                            tmp = str.substring( s,i ) ;
                            out.add(tmp) ;
                            tmp = null ;
                            s = -1 ;
                        }
                        else{
                            s = -1 ;
                        }
                        
                        break ;
                        
                    }
                }
                
            }
            
        }
        
        if(s != -1){
            
            tmp = str.substring( s,len ) ;
            out.add(tmp) ;
            tmp = null ;
        }
        
        checkCode = null ;
        tmp = null ;
    }
    
    /**
     * チェック情報単位で情報を区切ります。
     * <BR><BR>
     * @param cote コーテーション対応であるか設定します.<BR>
     *             [true]を設定した場合、各コーテーション ( ",' ) で囲った情報内は
     *             区切り文字と判別しません.<BR>
     *             [false]を設定した場合、コーテーション対応を行いません.
     * @param coteFlg コーテーションが入っている場合に、コーテーションを範囲に含むか否かを
     *                設定します.<BR>
     *                [true]を設定した場合、コーテーション情報も範囲に含みます.<BR>
     *                [false]を設定した場合、コーテーション情報を範囲としません.
     * @param str 区切り対象の情報を設置します.
     * @param check 区切り対象の文字情報をセットします.<BR>
     *              区切り対象文字を複数設定する事により、それらに対応した区切りとなります.
     * @return ArrayList 区切られた情報が格納されています.
     * @exception IllegalArgumentException 入力例外.
     */
    public static final ArrayList<String> cutString(boolean cote,boolean coteFlg,String str,String check)
        throws IllegalArgumentException {
        ArrayList<String> ret = null ;
        
        ret = new ArrayList<String>() ;
        
        cutString( ret,cote,coteFlg,str,check ) ;
        
        return ret ;
    }
    
    /**
     * チェック情報単位で情報を区切ります。
     * <BR><BR>
     * @param out 区切られた情報が格納されます.
     * @param cote コーテーション対応であるか設定します.<BR>
     *             [true]を設定した場合、各コーテーション ( ",' ) で囲った情報内は
     *             区切り文字と判別しません.<BR>
     *             [false]を設定した場合、コーテーション対応を行いません.
     * @param coteFlg コーテーションが入っている場合に、コーテーションを範囲に含むか否かを
     *                設定します.<BR>
     *                [true]を設定した場合、コーテーション情報も範囲に含みます.<BR>
     *                [false]を設定した場合、コーテーション情報を範囲としません.
     * @param str 区切り対象の情報を設置します.
     * @param check 区切り対象の文字情報をセットします.<BR>
     *              区切り対象文字を複数設定する事により、それらに対応した区切りとなります.
     * @exception IllegalArgumentException 入力例外.
     */
    public static final void cutString(ArrayList<String> out,boolean cote,boolean coteFlg,String str,String check)
        throws IllegalArgumentException
    {
        int i,j ;
        int len ;
        int lenJ ;
        int s = -1 ;
        
        char coteChr ;
        char nowChr ;
        char strCode ;
        
        char[] checkCode = null ;
        String tmp = null ;
        
        if( cote == false ){
            StringUtil.cutString( out,str,check ) ;
        }
        else{
            
            if(
                out == null ||
                str == null || ( len = str.length() ) <= 0 ||
                check == null || check.length() <= 0
            )
            {
                throw new IllegalArgumentException( "引数が不正です" ) ;
            }
            
            out.clear() ;
            
            lenJ = check.length() ;
            checkCode = new char[ lenJ ] ;
            check.getChars( 0,lenJ,checkCode,0 ) ;
            
            if( lenJ == 1 ){
                
                for( i = 0,s = -1,coteChr = 0 ; i < len ; i ++ ){
                    
                    strCode = str.charAt( i ) ;
                    nowChr = strCode ;
                    s = ( s == -1 ) ? i : s ;
                    
                    if( coteChr == 0 ){
                        
                        if( nowChr == '\'' || nowChr == '\"' ){
                            
                            coteChr = nowChr ;
                            
                            if( s < i ){
                                tmp = str.substring( s,i ) ;
                                out.add(tmp) ;
                                tmp = null ;
                                s = -1 ;
                            }
                            else{
                                s = -1 ;
                            }
                            
                        }
                        else if( strCode == checkCode[ 0 ] ){
                            
                            if( s < i ){
                                tmp = str.substring( s,i ) ;
                                out.add(tmp) ;
                                tmp = null ;
                                s = -1 ;
                            }
                            else{
                                s = -1 ;
                            }
                            
                        }
                    }
                    else if( coteChr == nowChr ){
                        
                        coteChr = 0 ;
                        
                        if( s == i && coteFlg == true ){
                            out.add( new StringBuilder().append( strCode ).append( strCode ).toString() ) ;
                            s = -1 ;
                        }
                        else if( s < i ){
                            
                            if( coteFlg == true ){
                                tmp = str.substring( s-1,i+1 ) ;
                            }
                            else{
                                tmp = str.substring( s,i ) ;
                            }
                            
                            out.add(tmp) ;
                            tmp = null ;
                            s = -1 ;
                        }
                        else{
                            s = -1 ;
                        }
                        
                    }
                    
                }
            }
            else{
                
                for( i = 0,s = -1,coteChr = 0 ; i < len ; i ++ ){
                    
                    strCode = str.charAt( i ) ;
                    nowChr = strCode ;
                    s = ( s == -1 ) ? i : s ;
                    
                    if( coteChr == 0 ){
                        
                        if( nowChr == '\'' || nowChr == '\"' ){
                            
                            coteChr = nowChr ;
                            
                            if( s < i ){
                                tmp = str.substring( s,i ) ;
                                out.add(tmp) ;
                                tmp = null ;
                                s = -1 ;
                            }
                            else{
                                s = -1 ;
                            }
                            
                        }
                        else{
                            
                            for( j = 0 ; j < lenJ ; j ++ ){
                                
                                if( strCode == checkCode[ j ] ){
                                    
                                    if( s < i ){
                                        tmp = str.substring( s,i ) ;
                                        out.add(tmp) ;
                                        tmp = null ;
                                        s = -1 ;
                                    }
                                    else{
                                        s = -1 ;
                                    }
                                    
                                    break ;
                                    
                                }
                                
                            }
                            
                        }
                    }
                    else if( coteChr == nowChr ){
                        
                        coteChr = 0 ;
                        
                        if( s == i && coteFlg == true ){
                            out.add( new StringBuilder().append( strCode ).append( strCode ).toString() ) ;
                            s = -1 ;
                        }
                        else if( s < i ){
                            
                            if( coteFlg == true ){
                                tmp = str.substring( s-1,i+1 ) ;
                            }
                            else{
                                tmp = str.substring( s,i ) ;
                            }
                            
                            out.add(tmp) ;
                            tmp = null ;
                            s = -1 ;
                        }
                        else{
                            s = -1 ;
                        }
                        
                    }
                    
                }
            }
            
            if(s != -1){
                
                if( coteChr != 0 && coteFlg == true ){
                    tmp = str.substring( s-1,len ) + ( char )coteChr ;
                }
                else{
                    tmp = str.substring( s,len ) ;
                }
                
                out.add(tmp) ;
                tmp = null ;
                
            }
            
            checkCode = null ;
            tmp = null ;
            
        }
    }
    
    /**
     * 指定コードを置き換えます.
     * <BR><BR>
     * 指定文字列に対して、変更対象の文字列を指定して
     * 変更後の文字列に置き換えます.
     * <BR>
     * @param str 変更を行う文字列を指定します.
     * @param src 変更対象の文字列を指定します.
     * @param dest 変更後の文字列を指定します.
     * @return String 変更された文字列が返されます.
     * @exception IllegalArgumentException 入力例外.
     */
    public static final String changeString( String str,String src,String dest )
        throws IllegalArgumentException
    {
        int pnt ;
        int end ;
        int srcLen ;
        
        StringBuilder buf = null ;
        
        if(
            str == null || str.length() <= 0 ||
            src == null || ( srcLen = src.length() ) <= 0
        )
        {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        
        if( dest == null || dest.length() <= 0 ) {
            dest = "" ;
        }
        
        buf = new StringBuilder() ;
        
        pnt = str.indexOf( src ) ;
        if( pnt == -1 ){
            return str ;
        }
        else if( pnt == 0 ){
            buf.append( dest ) ;
            end = srcLen ;
        }
        else{
            buf.append( str.substring( 0,pnt ) ) ;
            buf.append( dest ) ;
            end = pnt + srcLen ;
        }
        
        for( pnt += srcLen ;; ){
            if( ( pnt = str.indexOf( src,pnt ) ) == -1 ){
                buf.append( str.substring( end ) ) ;
                break ;
            }
            if( pnt == end ){
                buf.append( dest ) ;
            }
            else{
                buf.append( str.substring( end,pnt ) ) ;
                buf.append( dest ) ;
            }
            
            end = pnt + srcLen ;
            pnt += srcLen ;
            
        }
        
        return buf.toString() ;
    }
    
}

