/*
 * @(#)IndexVersion.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.index.core.element ;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Date;

import org.maachang.util.ConvertBinary;
import org.maachang.util.FileUtil;
import org.maachang.util.ReadBinary;

/**
 * Indexバージョン管理.
 *
 * @version 2007/06/28
 * @author  masahito suzuki
 * @since   MaachangIndex 1.00
 */
public class IndexVersion {
    
    /**
     * バージョンファイル名.
     */
    private static final String FILE_NAME = "version" ;
    
    /**
     * バージョン情報.
     */
    private long version = 0L ;
    
    /**
     * 作成日付.
     */
    private Date createDate = null ;
    
    /**
     * 更新日付.
     */
    private Date updateDate = null ;
    
    /**
     * コンストラクタ.
     */
    public IndexVersion() {
        version = 1L ;
        createDate = new Date() ;
        updateDate = createDate ;
    }
    
    /**
     * バージョンオブジェクトを取得.
     * <BR><BR>
     * バージョンオブジェクトを取得します.
     * <BR>
     * @param dir 対象の基本ディレクトリ名を取得します.
     * @return IndexVersion バージョン情報が返されます.
     */
    public static final IndexVersion getIndexVersion( String dir ) {
        if( dir.endsWith( "/" ) == true || dir.endsWith( "\\" ) == true ) {
            dir.substring( 0,dir.length()-1 ) ;
        }
        String file = new StringBuilder().append( dir ).append( FileUtil.FILE_SPACE ).
            append( FILE_NAME ).toString() ;
        if( FileUtil.isFileExists( file ) == false ) {
            return null ;
        }
        BufferedInputStream in = null ;
        try{
            in = new BufferedInputStream(
                new FileInputStream( file )
            ) ;
            IndexVersion ret = new IndexVersion() ;
            ret.toObject( in ) ;
            return ret ;
        }catch( Exception e ){
        }finally{
            try{
                in.close() ;
            }catch( Exception e ){
            }
            in = null ;
        }
        return null ;
    }
    
    /**
     * バージョンオブジェクトを保存.
     * <BR><BR>
     * バージョンオブジェクトを保存します.
     * <BR>
     * @param dir 対象の基本ディレクトリ名を取得します.
     */
    public void putIndexVersion( String dir ) {
        if( dir.endsWith( "/" ) == true || dir.endsWith( "\\" ) == true ) {
            dir.substring( 0,dir.length()-1 ) ;
        }
        String file = new StringBuilder().append( dir ).append( FileUtil.FILE_SPACE ).
            append( FILE_NAME ).toString() ;
        BufferedOutputStream o = null ;
        try{
            o = new BufferedOutputStream( new FileOutputStream( file ) ) ;
            toFile( o ) ;
        }catch( Exception e ){
        }finally{
            try{
                o.close() ;
            }catch( Exception e ){
            }
            o = null ;
        }
    }
    
    /**
     * バージョンを１つ上げる.
     * <BR><BR>
     * バージョンを１つ上げます.
     */
    public void update() {
        version += 1L ;
        updateDate = new Date() ;
    }
    
    /**
     * バージョンを取得.
     * <BR><BR>
     * バージョンを取得します.
     * <BR>
     * @return long バージョン情報が返されます.
     */
    public long getVersion() {
        return this.version ;
    }
    
    /**
     * 生成日付を取得.
     * <BR><BR>
     * 生成日付を取得します.
     * <BR>
     * @return Date 生成日付が返されます.
     */
    public Date getCreateDate() {
        return this.createDate ;
    }
    
    /**
     * 更新日付を取得.
     * <BR><BR>
     * 更新日付を取得します.
     * <BR>
     * @return Date 更新日付が返されます.
     */
    public Date getUpdateDate() {
        return this.updateDate ;
    }
    
    /**
     * オブジェクトをファイル化.
     */
    private void toFile( BufferedOutputStream bo )
        throws Exception {
        bo.write( ConvertBinary.convertLong( version ) ) ;
        bo.write( ConvertBinary.convertLong( createDate.getTime() ) ) ;
        bo.write( ConvertBinary.convertLong( updateDate.getTime() ) ) ;
        bo.flush() ;
    }
    
    /**
     * ファイルからオブジェクトに変換.
     */
    private void toObject( BufferedInputStream bi )
        throws Exception {
        ReadBinary r = new ReadBinary( bi ) ;
        version = ConvertBinary.convertLong( 0,r.getBinary( 8 ) ) ;
        createDate = new Date( ConvertBinary.convertLong( 0,r.getBinary( 8 ) ) ) ;
        updateDate = new Date( ConvertBinary.convertLong( 0,r.getBinary( 8 ) ) ) ;
    }
}

