/*
 * @(#)IndexKey.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.index.core.element ;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashSet;

import org.maachang.util.ConvertBinary;
import org.maachang.util.FileUtil;
import org.maachang.util.ReadBinary;

/**
 * IndexKey.
 *
 * @version 2007/06/28
 * @author  masahito suzuki
 * @since   MaachangIndex 1.00
 */
public class IndexKey {
    
    /**
     * キー名.
     */
    private String key = null ;
    
    /**
     * 項番.
     */
    private int number = 0 ;
    
    /**
     * ID管理.
     */
    private HashSet<Long> map = null ;
    
    /**
     * コンストラクタ.
     */
    private IndexKey() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * キー名と項番を設定してオブジェクトを生成します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @param number 対象の項番を設定します.
     */
    public IndexKey( String key,int number ) {
        this.key = key ;
        this.number = number ;
        this.map = new HashSet<Long>() ;
    }
    
    /**
     * 外部ファイルとして出力.
     * <BR><BR>
     * 外部ファイルとして出力します.
     * <BR>
     * @param baseDir 対象のディレクトリ名を設定します.
     * @exception Exception 例外.
     */
    public void putSerializable( String baseDir )
        throws Exception {
        String file = new StringBuilder().append( baseDir ).append( FileUtil.FILE_SPACE ).
            append( number ).append( "_" ).append( key ).toString() ;
        BufferedOutputStream o = null ;
        try{
            o = new BufferedOutputStream( new FileOutputStream( file ) ) ;
            toFile( o ) ;
        }catch( Exception e ){
            e.printStackTrace() ;
        }finally{
            try{
                o.close() ;
            }catch( Exception e ){
            }
            o = null ;
        }
    }
    
    /**
     * 外部ファイルから取得.
     * <BR><BR>
     * 外部ファイルがら取得します.
     * <BR>
     * @param baseDir 対象のディレクトリ名を設定します.
     * @param key 対象のキー名を設定します.
     * @param number 対象の項番を設定します.
     * @return IndexKey オブジェクトが返されます.
     * @exception Exception 例外.
     */
    public static final IndexKey getSerializable( String baseDir,String key,int number )
        throws Exception {
        String file = new StringBuilder().append( baseDir ).append( FileUtil.FILE_SPACE ).
            append( number ).append( "_" ).append( key ).toString() ;
        if( FileUtil.isFileExists( file ) == false ) {
            return null ;
        }
        BufferedInputStream in = null ;
        try{
            in = new BufferedInputStream(
                new FileInputStream( file )
            ) ;
            IndexKey ret = new IndexKey() ;
            ret.toObject( in ) ;
            return ret ;
        }catch( Exception e ){
            e.printStackTrace() ;
        }finally{
            try{
                in.close() ;
            }catch( Exception e ){
            }
            in = null ;
        }
        return null ;
    }
    
    /**
     * 対象情報を削除.
     * <BR><BR>
     * 対象情報を削除します.
     * <BR>
     * @param baseDir 対象のディレクトリ名を設定します.
     */
    public static final void removeSerializable( String baseDir,String key,int number ) {
        String file = new StringBuilder().append( baseDir ).append( FileUtil.FILE_SPACE ).
            append( number ).append( "_" ).append( key ).toString() ;
        if( FileUtil.isFileExists( file ) == true ) {
            FileUtil.removeFile( file ) ;
        }
    }
    
    /**
     * 条件が存在するかチェック.
     * <BR><BR>
     * 条件が存在するかチェックします.
     * <BR>
     * @param baseDir 対象のディレクトリ名を設定します.
     * @param key 対象のキー名を設定します.
     * @param number 対象の項番を設定します.
     * @return boolean チェック結果が返されます.
     */
    public static final boolean isUse( String baseDir,String key,int number ) {
        String file = new StringBuilder().append( baseDir ).append( FileUtil.FILE_SPACE ).
            append( number ).append( "_" ).append( key ).toString() ;
        if( FileUtil.isFileExists( file ) == false ) {
            return false ;
        }
        return true ;
    }
    
    /**
     * ID追加.
     * <BR><BR>
     * 対象のIDを追加します.
     * <BR>
     * @param ID 対象のIDを追加します.
     */
    public void add( Long id ) {
        map.add( id ) ;
    }
    
    /**
     * ID削除.
     * <BR><BR>
     * 対象のIDを削除します.
     * <BR>
     * @param ID 対象のIDを設定します.
     */
    public void remove( Long id ) {
        map.remove( id ) ;
    }
    
    /**
     * ID数を取得.
     * <BR><BR>
     * ID数を取得します.
     * <BR>
     * @return int 登録されているID数が返されます.
     */
    public int size() {
        return map.size() ;
    }
     
    /**
     * Keyを取得.
     * <BR><BR>
     * Keyを取得します.
     * <BR>
     * @return String key情報が返されます.
     */
    public String getKey() {
        return this.key ;
    }
    
    /**
     * 項番を取得.
     * <BR><BR>
     * 項番を取得します.
     * <BR>
     * @return int 項番が返されます.
     */
    public int getNumber() {
        return this.number ;
    }
    
    /**
     * 対象IDが存在するかチェック.
     * <BR><BR>
     * 対象IDが存在するかチェックします.
     * <BR>
     * @param id チェック対象のIDを設定します.
     * @return boolean チェック結果が返されます.
     */
    public boolean isId( Long id ) {
        return map.contains( id ) ;
    }
    
    /**
     * オブジェクトをファイル化.
     */
    private void toFile( BufferedOutputStream bo )
        throws Exception {
        byte[] bin = null ;
        bin = ConvertBinary.convertString( key ) ;
        bo.write( ConvertBinary.convertInt( bin.length ) ) ;
        bo.write( bin ) ;bin = null ;
        bo.write( ConvertBinary.convertInt( number ) ) ;
        if( map != null ) {
            Object[] objs = map.toArray() ;
            if( objs != null && objs.length > 0 ) {
                int len = objs.length ;
                bo.write( ConvertBinary.convertInt( len ) ) ;
                for( int i = 0 ; i < len ; i ++ ) {
                    bo.write( ConvertBinary.convertLong( ( ( Long )objs[ i ] ).longValue() ) ) ;
                }
            }
            else {
                bo.write( ConvertBinary.convertInt( 0 ) ) ;
            }
        }
        else {
            bo.write( ConvertBinary.convertInt( 0 ) ) ;
        }
        bo.flush() ;
    }
    
    /**
     * ファイルからオブジェクトに変換.
     */
    private void toObject( BufferedInputStream bi )
        throws Exception {
        int len ;
        ReadBinary r = new ReadBinary( bi ) ;
        len = ConvertBinary.convertInt( 0,r.getBinary( 4 ) ) ;
        key = ConvertBinary.convertString( 0,len,r.getBinary( len ) ) ;
        number = ConvertBinary.convertInt( 0,r.getBinary( 4 ) ) ;
        this.map = new HashSet<Long>() ;
        len = ConvertBinary.convertInt( 0,r.getBinary( 4 ) ) ;
        if( len > 0 ) {
            for( int i = 0 ; i < len ; i ++ ) {
                Long id = new Long( ConvertBinary.convertLong( 0,r.getBinary( 8 ) ) ) ;
                map.add( id ) ;
            }
        }
    }
}

