/*
 * @(#)ChipCache.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.index.core.element ;

import org.maachang.util.FileUtil;
import org.maachang.util.ObjectArray;


/**
 * IndexChip名一覧を管理します.
 *
 * @version 2007/06/28
 * @author  masahito suzuki
 * @since   MaachangIndex 1.00
 */
public class ChipCache {
    /**
     * IndexChip名一覧管理.
     */
    private String chips = "" ;
    
    /**
     * IndexChipディレクトリ.
     */
    private String indexDir = null ;
    
    /**
     * コンストラクタ.
     */
    private ChipCache() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * IndexChipディレクトリ名を設定してオブジェクトを生成します.
     * <BR>
     * @param indexDir ディレクトリ名を設定します.
     */
    public ChipCache( String indexDir ) {
        this.indexDir = indexDir ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * IndexChipディレクトリ名を設定してオブジェクトを生成します.
     * <BR>
     * @param indexDir ディレクトリ名を設定します.
     * @param chips 設定対象のIndexChipsを設定します.
     */
    public ChipCache( String indexDir,String chips ) {
        this.chips = chips ;
    }
    
    /**
     * IndexChip名一覧を取得.
     * <BR><BR>
     * IndexChip名一覧を取得します.
     */
    public void create() {
        int len ;
        String[] names = FileUtil.getFileList( indexDir ) ;
        if( names != null && ( len = names.length ) > 0 ) {
            StringBuilder buf = new StringBuilder( len * 4 ) ;
            for( int i = 0 ; i < len ; i ++ ) {
                buf.append( " " ).append( names[ i ] ) ;
                names[ i ] = null ;
            }
            names = null ;
            chips = buf.append( " " ).toString() ;
            buf = null ;
        }
        else {
            chips = "" ;
        }
    }
    
    /**
     * 指定IndexChip名から、その情報を含む内容群を取得.
     * <BR><BR>
     * 指定IndexChip名から、その情報を含む内容群を取得します.
     * <BR>
     * @param chip 対象のIndexChip名を設定します.
     * @return String[] 指定IndexChip名を含む内容が返されます.
     */
    public String[] getIndexChip( String chip ) {
        if( chip == null || chip.length() <= 0 ||
            chips == null || chips.length() <= 0 ) {
            return null ;
        }
        ObjectArray ary = new ObjectArray() ;
        int p,b ;
        for( p = 0,b = 0 ;; ) {
            p = chips.indexOf( chip,b ) ;
            if( p == -1 ) {
                break ;
            }
            b = getNextCutPos( p ) ;
            if( b == -1 ) {
                break ;
            }
            ary.add( chips.substring( getBeforeCutPos( p )+1,b ) ) ;
        }
        if( ary.size() <= 0 ) {
            return null ;
        }
        int len = ary.size() ;
        String[] ret = new String[ len ] ;
        System.arraycopy( ary.getObjects(),0,ret,0,len ) ;
        ary = null ;
        return ret ;
    }
    
    /**
     * 指定ポイントより後ろのSpace位置を取得.
     */
    private int getNextCutPos( int p ) {
        int len = chips.length() ;
        for( int i = p ; i < len ; i ++ ) {
            if( chips.charAt( p ) == ' ' ) {
                return p ;
            }
            p ++ ;
        }
        return -1 ;
    }
    
    /**
     * 指定ポイントより前のSpace位置を取得.
     */
    private int getBeforeCutPos( int p ) {
        int len = chips.length() ;
        for( int i = len-p ; i >= 0 ; i -- ) {
            if( chips.charAt( p ) == ' ' ) {
                return p ;
            }
            p -- ;
        }
        return -1 ;
    }
}

