/*
 * @(#)ResultChildImpl.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.index.core ;

import java.util.ArrayList;
import java.util.Arrays;

import org.maachang.index.MaachangResult;
import org.maachang.index.ResultChild;
import org.maachang.index.core.element.IndexBase;
import org.maachang.index.core.element.SearchBaseCache;

/**
 * １つの検索結果情報.
 *
 * @version 2007/06/28
 * @author  masahito suzuki
 * @since   MaachangIndex 1.00
 */
class ResultChildImpl implements ResultChild {
    
    /**
     * 検索結果順位.
     */
    private int searchNo = -1 ;
    
    /**
     * 検索結果IndexBaseID.
     */
    private Long id = null ;
    
    /**
     * キャッシュオブジェクト.
     */
    private SearchBaseCache baseCache = null ;
    
    /**
     * IndexBase一時情報.
     */
    private IndexBase bean = null ;
    
    /**
     * 親オブジェクト.
     */
    private MaachangResult parent = null ;
    
    /**
     * 部分表示キャッシュ.
     */
    private String partString = null ;
    
    /**
     * 得点.
     */
    private int score = 0 ;
    
    /**
     * コンストラクタ.
     */
    private ResultChildImpl() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 条件を設定してオブジェクトを生成します.
     * <BR>
     * @param id 対象IndexBaseIDを設定します.
     * @param searchNo 検索項番を設定します.
     * @param score 得点を設定します.
     * @param baseCache IndexBaseをキャッシュしているオブジェクトを設定します.
     * @param parent 親オブジェクトを設定します.
     */
    public ResultChildImpl( int searchNo,Long id,int score,SearchBaseCache baseCache,MaachangResult parent ) {
        this.id = id ;
        this.searchNo = searchNo ;
        this.baseCache = baseCache ;
        this.parent = parent ;
        this.score = score ;
    }
    
    /**
     * 検索結果項番を取得.
     * <BR><BR>
     * 検索結果項番を取得します.
     * <BR>
     * @return int 検索結果項番が返されます.
     */
    public int getSearchNo() {
        return this.searchNo ;
    }
    
    /**
     * IndexBaseIDを取得.
     * <BR><BR>
     * IndexBaseIDを取得します.
     * <BR>
     * @return Long IndexBaseIDが返されます.
     */
    public Long getId() {
        return this.id ;
    }
    
    /**
     * 検索結果内容を取得.
     * <BR><BR>
     * 検索結果内容を取得します.
     * <BR>
     * @return String 検索結果内容が返されます.
     */
    public String getSearchValue() {
        //IndexBase b = getIndexBaseBean( true,false ) ;
        IndexBase b = IndexBase.getSerializable( baseCache.getIndexBaseDirectory(),this.id,false,true ) ;
        if( b != null ) {
            return b.getValue() ;
        }
        return null ;
    }
    
    /**
     * 検索結果内容名を取得.
     * <BR><BR>
     * 検索結果内容名を取得します.
     * <BR>
     * @return String 検索結果内容内容が返されます.
     */
    public String getSearchName() {
        IndexBase b = getIndexBaseBean( true,false ) ;
        if( b != null ) {
            return b.getName() ;
        }
        return null ;
    }
    
    /**
     * 検索結果要素を取得.
     * <BR><BR>
     * 検索結果要素を取得します.
     * <BR>
     * @return String 検索結果要素が返されます.
     */
    public String getSearchElement() {
        IndexBase b = getIndexBaseBean( true,false ) ;
        if( b != null ) {
            return b.getElement() ;
        }
        return null ;
    }
    
    /**
     * 検索文字などを含む内容の前後を取得.
     * <BR><BR>
     * 検索文字などを含む内容の前後を取得します.
     * <BR>
     * @return String 検索文字などを含む内容を取得します.
     */
    public String getPartString() {
        if( partString != null ) {
            return partString ;
        }
        String word = parent.getSearchWord() ;
        if( word == null || ( word = word.trim() ).length() <= 0 ) {
            return "" ;
        }
        IndexBase b = getIndexBaseBean( true,false ) ;
        if( b == null ) {
            return "" ;
        }
        String string = b.getPart() ;
        b = null ;
        String[] searchs = IndexUtil.cutSearchString( word ) ;
        if( searchs == null || searchs.length <= 0 ) {
            return "" ;
        }
        int i ;
        int len = searchs.length ;
        int partLen = ( ( MaachangResultImpl )parent ).getPartLength() ;
        int outPlus = partLen / 3 ;
        int p = 0 ;
        ArrayList<PartCode> pos = new ArrayList<PartCode>() ;
        String lower = string.toLowerCase() ;
        for( i = 0 ; i < len ; i ++ ) {
            for( p = 0 ;; ) {
                if( ( p = lower.indexOf( searchs[ i ],p ) ) <= -1 ) {
                    break ;
                }
                PartCode pa = new PartCode() ;
                pa.setNum( i ) ;
                pa.setPos( p ) ;
                pos.add( pa ) ;
                p ++ ;
            }
        }
        lower = null ;
        if( pos.size() <= 0 ) {
            return string.substring( 0,( ( string.length() >= partLen ) ? partLen : string.length() ) ) + PART_END ;
        }
        len = pos.size() ;
        PartCode[] ps = new PartCode[ len ] ;
        for( i = 0 ; i < len ; i ++ ) {
            ps[ i ] = pos.get( i ) ;
        }
        pos = null ;
        Arrays.sort( ps ) ;
        String ret = null ;
        switch( searchs.length ) {
            case 1 :
                ret = partStringByOne( ps,string,len,partLen,outPlus ) ;
                break ;
            case 2 :
                ret = partStringByTwo( ps,string,len,partLen,outPlus ) ;
                break ;
            default :
                ret = partStringByThree( ps,string,len,partLen,outPlus ) ;
                break ;
        }
        partString = ret ;
        return ret ;
    }
    
    /**
     * 得点を取得.
     * <BR><BR>
     * 得点を取得します.
     * <BR>
     * @return int 得点が返されます.
     */
    public int getScore() {
        return score ;
    }
    
    /**
     * 部分文字エンド.
     */
    private static final String PART_END = "..." ;
    
    /**
     * 検索文字列が１つの場合の部分表示.
     */
    private static final String partStringByOne( PartCode[] part,String string,int len,int partLen,int outPlus ) {
        int p = part[ 0 ].getPos() ;
        int allLen = string.length() ;
        int outLen = partLen - PART_END.length() ;
        p = beforeSpace( p,string,outPlus ) ;
        return string.substring( p,( ( allLen >= p+outLen ) ? p+outLen : allLen ) ) + PART_END ;
    }
    
    /**
     * 検索文字列が２つの場合の部分表示.
     */
    private static final String partStringByTwo( PartCode[] part,String string,int len,int partLen,int outPlus ) {
        int allLen = string.length() ;
        int outLen = ( partLen  / 2 ) - PART_END.length() ;
        int outMax = partLen - PART_END.length() ;
        int ep,en ;
        int p,num ;
        int i ;
        ep = en = -1 ;
        for( int x = 0 ; x < 3 ; x ++ ) {
            p = part[ 0 ].getPos() ;
            num = part[ 0 ].getNum() ;
            for( i = 1 ; i < len ; i ++ ) {
                if( x == 0 ) {
                    if( num != part[ i ].getNum() ) {
                        if( ( p + outMax ) >= part[ i ].getPos() ) {
                            p = beforeSpace( p,string,outPlus ) ;
                            return string.substring( p,( ( allLen >= p+outMax ) ? p+outMax : allLen ) ) + PART_END ;
                        }
                    }
                    p = part[ i ].getPos() ;
                    num = part[ i ].getNum() ;
                }
                else if( x == 1 ) {
                    if( num != part[ i ].getNum() ) {
                        p = beforeSpace( p,string,outPlus ) ;
                        StringBuilder buf = new StringBuilder() ;
                        buf.append( string.substring( p,( ( allLen >= p+outLen ) ? p+outLen : allLen ) ) ) ;
                        buf.append( PART_END ) ;
                        p = part[ i ].getPos() ;
                        p = beforeSpace( p,string,outPlus ) ;
                        buf.append( " " ) ;
                        buf.append( string.substring( p,( ( allLen >= p+outLen ) ? p+outLen : allLen ) ) ) ;
                        buf.append( PART_END ) ;
                        return buf.toString() ;
                    }
                    p = part[ i ].getPos() ;
                    num = part[ i ].getNum() ;
                }
            }
            if( x >= 2 ) {
                for( i = 0 ; i < len ; i ++ ) {
                    if( ep == -1 || en == -1 ) {
                        ep = part[ i ].getPos() ;
                        en = part[ i ].getNum() ;
                        continue ;
                    }
                    if( en != part[ i ].getNum() ) {
                        p = ep ;
                        p = beforeSpace( p,string,outPlus ) ;
                        StringBuilder buf = new StringBuilder() ;
                        buf.append( string.substring( p,( ( allLen >= p+outLen ) ? p+outLen : allLen ) ) ) ;
                        buf.append( PART_END ) ;
                        p = part[ i ].getPos() ;
                        p = beforeSpace( p,string,outPlus ) ;
                        buf.append( " " ) ;
                        buf.append( string.substring( p,( ( allLen >= p+outLen ) ? p+outLen : allLen ) ) ) ;
                        buf.append( PART_END ) ;
                        return buf.toString() ;
                    }
                }
            }
        }
        return partStringByOne( part,string,len,partLen,outPlus ) ;
    }
    
    /**
     * 検索文字列が３以上の場合の部分表示.
     */
    private static final String partStringByThree( PartCode[] part,String string,int len,int partLen,int outPlus ) {
        int allLen = string.length() ;
        int outLen = ( partLen  / 2 ) - PART_END.length() ;
        int outMax = partLen - PART_END.length() ;
        int ep,en,ep1,en1 ;
        int p,num,p1,num1 ;
        int i ;
        ep = en = ep1 = en1 = -1 ;
        for( int x = 0 ; x < 3 ; x ++ ) {
            p = part[ 0 ].getPos() ;
            num = part[ 0 ].getNum() ;
            p1 = part[ 1 ].getPos() ;
            num1 = part[ 1 ].getNum() ;
            for( i = 2 ; i < len ; i ++ ) {
                if( x == 0 ) {
                    if( num != num1 && num != part[ i ].getNum() && num1 != part[ i ].getNum() ) {
                        if( ( p + outMax ) >= p1 && ( p + outMax ) >= part[ i ].getPos()  ) {
                            p = beforeSpace( p,string,outPlus ) ;
                            return string.substring( p,( ( allLen >= p+outMax ) ? p+outMax : allLen ) ) + PART_END ;
                        }
                    }
                    p = p1 ;
                    num = num1 ;
                    p1 = part[ i ].getPos() ;
                    num1 = part[ i ].getNum() ;
                }
                else if( x == 1 ) {
                    if( num != num1 && num != part[ i ].getNum() && num1 != part[ i ].getNum() ) {
                        p = beforeSpace( p,string,outPlus ) ;
                        StringBuilder buf = new StringBuilder() ;
                        buf.append( string.substring( p,( ( allLen >= p+outLen ) ? p+outLen : allLen ) ) ) ;
                        buf.append( PART_END ) ;
                        p = p1 ;
                        p = beforeSpace( p,string,outPlus ) ;
                        buf.append( " " ) ;
                        buf.append( string.substring( p,( ( allLen >= p+outLen ) ? p+outLen : allLen ) ) ) ;
                        buf.append( PART_END ) ;
                        p = part[ i ].getPos() ;
                        p = beforeSpace( p,string,outPlus ) ;
                        buf.append( " " ) ;
                        buf.append( string.substring( p,( ( allLen >= p+outLen ) ? p+outLen : allLen ) ) ) ;
                        buf.append( PART_END ) ;
                        return buf.toString() ;
                    }
                    else {
                        p = p1 ;
                        num = num1 ;
                        p1 = part[ i ].getPos() ;
                        num1 = part[ i ].getNum() ;
                    }
                }
            }
            if( x >= 2 ) {
                for( i = 0 ; i < len ; i ++ ) {
                    if( ep == -1 || en == -1 ) {
                        ep = part[ i ].getPos() ;
                        en = part[ i ].getNum() ;
                        continue ;
                    }
                    if( ep1 == -1 || en1 == -1 ) {
                        if( en != part[ i ].getNum() ) {
                            ep1 = part[ i ].getPos() ;
                            en1 = part[ i ].getNum() ;
                        }
                        continue ;
                    }
                    if( en != part[ i ].getNum() && en1 != part[ i ].getNum() ) {
                        p = ep ;
                        p = beforeSpace( p,string,outPlus ) ;
                        StringBuilder buf = new StringBuilder() ;
                        buf.append( string.substring( p,( ( allLen >= p+outLen ) ? p+outLen : allLen ) ) ) ;
                        buf.append( PART_END ) ;
                        p = ep1 ;
                        p = beforeSpace( p,string,outPlus ) ;
                        buf.append( " " ) ;
                        buf.append( string.substring( p,( ( allLen >= p+outLen ) ? p+outLen : allLen ) ) ) ;
                        buf.append( PART_END ) ;
                        p = part[ i ].getPos() ;
                        p = beforeSpace( p,string,outPlus ) ;
                        buf.append( " " ) ;
                        buf.append( string.substring( p,( ( allLen >= p+outLen ) ? p+outLen : allLen ) ) ) ;
                        buf.append( PART_END ) ;
                        return buf.toString() ;
                    }
                }
            }
        }
        return partStringByOne( part,string,len,partLen,outPlus ) ;
    }
    
    /**
     * 対象IDに対するIndexBaseを取得します.
     */
    private IndexBase getIndexBaseBean( boolean partFlag,boolean valueFlag ) {
        if( this.bean != null ) {
            return this.bean ;
        }
        this.bean = baseCache.get( this.id,partFlag,valueFlag ) ;
        return this.bean ;
    }
    
    /**
     * 文字変換.
     * <BR><BR>
     * 対象のオブジェクトを文字列変換します.
     * <BR>
     * @return String 文字列に変換された情報が返されます.
     */
    public String toString() {
        return new StringBuilder().
            append( "no:" ).
            append( searchNo ).
            append( " name:" ).
            append( this.getSearchName() ).
            append( " element:" ).
            append( this.getSearchElement() ).
            append( " part:" ).
            append( this.getPartString() ).
            toString() ;
    }
    
    /**
     * 前項のスペース区切りの条件を取得.
     */
    private static final int beforeSpace( int p,String string,int outPlus ) {
        int ret = string.lastIndexOf( " ",p ) ;
        if( ret <= -1 ) {
            return p ;
        }
        if( ( p - ret ) > outPlus ) {
            return p ;
        }
        return ret ;
    }
}

/**
 * 部分表示用オブジェクト.
 */
class PartCode implements Comparable {
    private int pos ;
    private int num ;
    public PartCode() {
        
    }
    public void setPos( int pos ) {
        this.pos = pos ;
    }
    public int getPos() {
        return this.pos ;
    }
    public void setNum( int num ) {
        this.num = num ;
    }
    public int getNum() {
        return this.num ;
    }
    public int compareTo( Object o ) {
        return this.pos - ( ( PartCode )o ).pos ;
    }
}
