/*
 * @(#)ResultChild.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.index ;


/**
 * １つの検索結果情報.
 *
 * @version 2007/06/28
 * @author  masahito suzuki
 * @since   MaachangIndex 1.00
 */
public interface ResultChild {
    
    /**
     * 検索結果項番を取得.
     * <BR><BR>
     * 検索結果項番を取得します.
     * <BR>
     * @return int 検索結果項番が返されます.
     */
    public int getSearchNo() ;
    
    /**
     * IndexBaseIDを取得.
     * <BR><BR>
     * IndexBaseIDを取得します.
     * <BR>
     * @return Long IndexBaseIDが返されます.
     */
    public Long getId() ;
    
    /**
     * 検索結果内容を取得.
     * <BR><BR>
     * 検索結果内容を取得します.
     * <BR>
     * @return String 検索結果内容が返されます.
     */
    public String getSearchValue() ;
    
    /**
     * 検索結果内容名を取得.
     * <BR><BR>
     * 検索結果内容名を取得します.
     * <BR>
     * @return String 検索結果内容内容が返されます.
     */
    public String getSearchName() ;
    
    /**
     * 検索結果要素を取得.
     * <BR><BR>
     * 検索結果要素を取得します.
     * <BR>
     * @return String 検索結果要素が返されます.
     */
    public String getSearchElement() ;
    
    /**
     * 検索文字などを含む内容の前後を取得.
     * <BR><BR>
     * 検索文字などを含む内容の前後を取得します.
     * <BR>
     * @return String 検索文字などを含む内容を取得します.
     */
    public String getPartString() ;
    
    /**
     * 得点を取得.
     * <BR><BR>
     * 得点を取得します.
     * <BR>
     * @return int 得点が返されます.
     */
    public int getScore() ;
    
}

