/*
 * @(#)MaachangResult.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.index ;


/**
 * 検索結果情報.
 *
 * @version 2007/06/28
 * @author  masahito suzuki
 * @since   MaachangIndex 1.00
 */
public interface MaachangResult {
    
    /**
     * 検索キーワードを取得.
     * <BR><BR>
     * 検索キーワードを取得します.
     * <BR>
     * @return String 検索キーワードが返されます.
     */
    public String getSearchWord() ;
    
    /**
     * 最大データ件数を取得.
     * <BR><BR>
     * 最大データ件数を取得します.
     * <BR>
     * @return int 最大データ件数が返されます.
     */
    public int getMaxResult() ;
    
    /**
     * 現在検索開始位置の取得.
     * <BR><BR>
     * 現在の検索開始位置を取得します.
     * <BR>
     * @return int 現在の検索開始位置が返されます.
     */
    public int getOffset() ;
    
    /**
     * １度に検索結果を取得する検索情報件数を取得.
     * <BR><BR>
     * １度に検索結果を取得する検索情報件数を取得します.
     * <BR>
     * @return int １度に検索結果を取得する情報件数を取得します.
     */
    public int getViewLength() ;
    
    /**
     * 現在の有効件数を取得.
     * <BR><BR>
     * 現在の有効件数を取得します.
     * <BR>
     * @return int 現在の有効件数が返されます.
     */
    public int size() ;
    
    /**
     * 最大ページ項番を取得.
     * <BR><BR>
     * 最大ページ項番を取得します.
     * <BR>
     * @return int 最大ページ項番が返されます.
     */
    public int getMaxPageNo() ;
    
    /**
     * 現在のページ項番を取得.
     * <BR><BR>
     * 現在のページ項番を取得します.
     * <BR>
     * @return int 現在のページ項番が返されます.
     */
    public int getNowPageNo() ;
    
    /**
     * 検索内容を取得.
     * <BR><BR>
     * 検索内容を取得します.
     * <BR>
     * @param no 取得対象項番を設定します.
     * @return ResultChild 検索内容が返されます.
     */
    public ResultChild getResult( int no ) ;
    
    /**
     * 次ページの情報が存在するかチェック.
     * <BR><BR>
     * 次ページの情報が存在するかチェックします.
     * <BR>
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、次ページ情報は存在します.
     */
    public boolean isNext() ;
    
    /**
     * 前ページの情報が存在するかチェック.
     * <BR><BR>
     * 前ページの情報が存在するかチェックします.
     * <BR>
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、前ページ情報は存在します.
     */
    public boolean isBefore() ;
    
    /**
     * 指定ページに遷移できるかチェック.
     * <BR><BR>
     * 指定ページに遷移できるかチェックします.
     * <BR>
     * @param no 対象のページNoを設定します.
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、指定ページ情報は存在します.
     */
    public boolean isPage( int no ) ;
    
}

