/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.spring;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.XelException;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zkplus.spring.SpringUtil;

public class DelegatingVariableResolver
implements VariableResolver,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(DelegatingVariableResolver.class);
    protected transient List<VariableResolver> _variableResolvers = new ArrayList<VariableResolver>();

    public DelegatingVariableResolver() {
        Execution exec = Executions.getCurrent();
        String classes = null;
        if (exec != null) {
            classes = exec.getDesktop().getWebApp().getConfiguration().getPreference("org.zkoss.spring.VariableResolver", null);
        }
        if (classes == null) {
            classes = Library.getProperty((String)"org.zkoss.spring.VariableResolver.class");
        }
        if (classes != null) {
            String[] vrClss = classes.split(",");
            for (int i = 0; i < vrClss.length; ++i) {
                try {
                    VariableResolver o = (VariableResolver)Classes.newInstanceByThread((String)vrClss[i]);
                    if (this._variableResolvers.contains(o)) continue;
                    this._variableResolvers.add(o);
                    continue;
                }
                catch (Throwable e) {
                    log.warn("Ignored: failed to instantiate " + vrClss[i], e);
                }
            }
        } else {
            this._variableResolvers.add(new DefaultDelegatingVariableResolver());
        }
    }

    public Object resolveVariable(String name) {
        Object o = null;
        for (VariableResolver resolver : this._variableResolvers) {
            o = resolver.resolveVariable(name);
            if (o == null) continue;
            return o;
        }
        return o;
    }

    public int hashCode() {
        return Objects.hashCode(this._variableResolvers);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof DelegatingVariableResolver && Objects.equals(this._variableResolvers, ((DelegatingVariableResolver)obj)._variableResolvers);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this._variableResolvers.size());
        for (VariableResolver o : this._variableResolvers) {
            if (o instanceof DefaultDelegatingVariableResolver) {
                s.writeObject("");
                continue;
            }
            s.writeObject(o);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._variableResolvers = new ArrayList<VariableResolver>();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            Object o = s.readObject();
            if (o instanceof String) {
                this._variableResolvers.add(new DefaultDelegatingVariableResolver());
                continue;
            }
            this._variableResolvers.add((VariableResolver)o);
        }
    }

    private static class DefaultDelegatingVariableResolver
    implements VariableResolver {
        private ApplicationContext _ctx;

        private DefaultDelegatingVariableResolver() {
        }

        private ApplicationContext getApplicationContext() {
            if (this._ctx != null) {
                return this._ctx;
            }
            this._ctx = SpringUtil.getApplicationContext();
            return this._ctx;
        }

        public Object resolveVariable(String name) throws XelException {
            if ("springContext".equals(name)) {
                return this.getApplicationContext();
            }
            return SpringUtil.getBean(name);
        }

        public int hashCode() {
            return Objects.hashCode(this.getClass());
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof DefaultDelegatingVariableResolver && this.getClass() == obj.getClass();
        }
    }
}

