/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.util;

import java.util.Iterator;
import java.util.regex.Pattern;

public class ParseSeq
implements Iterable<Character> {
    public static String MSG_NOT_NULL = "configuration must is a not null or non empty string";
    public static String MSG_ONLY_NUNBER = "your value must contain only number character";
    public static String MSG_CONTAIN_DUP = "your value must contain non duplicate character";
    private String orderConfiguration;
    private Pattern regCheckOnlyNumber = Pattern.compile("\\d+");
    private Pattern regCheckDupChar = Pattern.compile("(\\w).*\\1");

    private ParseSeq(String orderConfiguration, boolean allowDupCharacter, boolean onlyNumber) {
        this.parseValue(orderConfiguration, allowDupCharacter, onlyNumber);
        this.orderConfiguration = orderConfiguration;
    }

    protected void parseValue(String orderConfiguration, boolean allowDupCharacter, boolean onlyNumber) {
        if (orderConfiguration == null || orderConfiguration.length() == 0) {
            throw new IllegalArgumentException(MSG_NOT_NULL);
        }
        if (onlyNumber && !this.regCheckOnlyNumber.matcher(orderConfiguration).matches()) {
            throw new IllegalArgumentException(MSG_ONLY_NUNBER);
        }
        if (!allowDupCharacter && this.regCheckDupChar.matcher(orderConfiguration).find()) {
            throw new IllegalArgumentException(MSG_CONTAIN_DUP);
        }
    }

    @Override
    public Iterator<Character> iterator() {
        return new IteratorOrderUtil(this.orderConfiguration);
    }

    public static ParseSeq getNumberOrder(String orderConfiguration) {
        ParseSeq numberOrder = null;
        try {
            numberOrder = new ParseSeq(orderConfiguration, false, true);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        return numberOrder;
    }

    public static void main(String[] args) {
        ParseSeq test = null;
        try {
            test = new ParseSeq("e345", true, true);
            System.out.printf("Test for check only number case has non number:%s", false);
            System.out.println();
        }
        catch (IllegalArgumentException ex) {
            System.out.printf("Test for check only number case has non number:%1$s", MSG_ONLY_NUNBER.equals(ex.getMessage()));
            System.out.println();
        }
        try {
            test = new ParseSeq("345", true, true);
            System.out.printf("Test for check only number case normal:%1$s", true);
            System.out.println();
        }
        catch (IllegalArgumentException ex) {
            System.out.printf("Test for check only number case normal:%1$s", false);
            System.out.println();
        }
        try {
            test = new ParseSeq("3545", true, true);
            System.out.printf("Test for check dup character case allow:%1$s", true);
            System.out.println();
        }
        catch (IllegalArgumentException ex) {
            System.out.printf("Test for check dup character case allow:%1$s", false);
            System.out.println();
        }
        try {
            test = new ParseSeq("3afa5", true, false);
            System.out.printf("Test for check dup character case allow:%1$s", true);
            System.out.println();
        }
        catch (IllegalArgumentException ex) {
            System.out.printf("Test for check dup character case allow:%1$s", false);
            System.out.println();
        }
        try {
            test = new ParseSeq("3545", false, false);
            System.out.printf("Test for check dup character case disallow:%1$s", false);
            System.out.println();
        }
        catch (IllegalArgumentException ex) {
            System.out.printf("Test for check dup character case disallow:%1$s", MSG_CONTAIN_DUP.equals(ex.getMessage()));
            System.out.println();
        }
        try {
            test = new ParseSeq("3afa5", false, false);
            System.out.printf("Test for check dup character case disallow:%1$s", false);
            System.out.println();
        }
        catch (IllegalArgumentException ex) {
            System.out.printf("Test for check dup character case disallow:%1$s", MSG_CONTAIN_DUP.equals(ex.getMessage()));
            System.out.println();
        }
        try {
            test = new ParseSeq("3sfa5", false, false);
            System.out.printf("Test for check dup character case disallow:%1$s", true);
            System.out.println();
        }
        catch (IllegalArgumentException ex) {
            System.out.printf("Test for check dup character case disallow:%1$s", false);
            System.out.println();
        }
        test = ParseSeq.getNumberOrder("4567289");
        System.out.printf("travel configuration:%1$s", "4567289");
        System.out.println();
        for (Character ch : test) {
            System.out.print(ch);
        }
    }

    public String toString() {
        return "OrderConfiguration=" + this.orderConfiguration;
    }

    public static class IteratorOrderUtil
    implements Iterator<Character> {
        private String orderConfiguration;
        int currentIndex = -1;

        public IteratorOrderUtil(String orderConfiguration) {
            this.orderConfiguration = orderConfiguration;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.orderConfiguration.length() - 1;
        }

        @Override
        public Character next() {
            ++this.currentIndex;
            return Character.valueOf(this.orderConfiguration.charAt(this.currentIndex));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Don't support this action");
        }
    }
}

