/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.fa.process;

import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MAssetAddition;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProject;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class ProjectCreateAsset
extends SvrProcess {
    private int m_C_Project_ID = 0;
    private int m_Product_ID = 0;
    private int m_UseLifeYears = 0;
    private Timestamp m_DateTrx = null;
    private String message = "";

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i2 = 0;
        while (i2 < para.length) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() != null) {
                if (para[i2].getParameterName().equalsIgnoreCase("C_Project_ID")) {
                    this.m_C_Project_ID = para[i2].getParameterAsInt();
                } else if (para[i2].getParameterName().equalsIgnoreCase("M_Product_ID")) {
                    this.m_Product_ID = para[i2].getParameterAsInt();
                } else if (para[i2].getParameterName().equalsIgnoreCase("UseLifeYears")) {
                    this.m_UseLifeYears = para[i2].getParameterAsInt();
                } else if (para[i2].getParameterName().equalsIgnoreCase("DateTrx")) {
                    this.m_DateTrx = (Timestamp)para[i2].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.m_C_Project_ID == 0 || this.m_Product_ID == 0) {
            return "Missing Mandatory Field Value (Project / Product)";
        }
        MProject project = new MProject(this.getCtx(), this.m_C_Project_ID, this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("doIt - " + project);
        }
        MProduct product = new MProduct(this.getCtx(), this.m_Product_ID, this.get_TrxName());
        MProductCategory pc = MProductCategory.get(this.getCtx(), product.getM_Product_Category_ID());
        if (pc.getA_Asset_Group_ID() == 0) {
            return "Product is not asset type";
        }
        MAssetAddition assetAdd = MAssetAddition.createAsset(project, product);
        assetAdd.setDateAcct(this.m_DateTrx);
        assetAdd.setDateDoc(this.m_DateTrx);
        assetAdd.setM_Product_ID(this.m_Product_ID);
        if (this.m_UseLifeYears > 0) {
            assetAdd.setDeltaUseLifeYears(this.m_UseLifeYears);
            assetAdd.setDeltaUseLifeYears_F(this.m_UseLifeYears);
        }
        assetAdd.saveEx();
        if (!assetAdd.processIt("CO")) {
            return "Error Process Asset Addition";
        }
        assetAdd.saveEx();
        this.message = String.valueOf(this.message) + ". @A_Asset_Addition_ID@ - " + assetAdd;
        return "Asset Created " + this.message;
    }
}

