/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.fa.model;

import java.math.BigDecimal;
import java.util.Properties;
import org.adempiere.model.GridTabWrapper;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.I_A_Asset_Addition;
import org.compiere.model.MAssetAddition;
import org.compiere.model.MConversionRateUtil;
import org.compiere.model.MProject;
import org.compiere.model.SetGetUtil;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class CalloutA_Asset_Addition
extends CalloutEngine {
    public String matchInv(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int M_MatchInv_ID = ((Number)value).intValue();
        if (M_MatchInv_ID > 0) {
            MAssetAddition.setM_MatchInv(SetGetUtil.wrap(mTab), M_MatchInv_ID);
        }
        return this.amt(ctx, WindowNo, mTab, mField, value);
    }

    public String project(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive()) {
            return "";
        }
        int project_id = 0;
        if (value == null || !(value instanceof Number)) {
            return "";
        }
        project_id = ((Number)value).intValue();
        BigDecimal amt = Env.ZERO;
        if (project_id > 0) {
            MProject prj = new MProject(ctx, project_id, null);
            amt = prj.getProjectBalanceAmt();
            mTab.setValue("C_Currency_ID", (Object)prj.getC_Currency_ID());
        }
        mTab.setValue("AssetSourceAmt", (Object)amt);
        return this.amt(ctx, WindowNo, mTab, mField, value);
    }

    public String amt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive()) {
            return "";
        }
        String columnName = mField.getColumnName();
        if ("A_Accumulated_Depr".equals(columnName)) {
            mTab.setValue("A_Accumulated_Depr_F", value);
        } else {
            BigDecimal amtEntered = (BigDecimal)mTab.getValue("AssetAmtEntered");
            mTab.setValue("AssetSourceAmt", (Object)amtEntered);
            MConversionRateUtil.convertBase(SetGetUtil.wrap(mTab), "DateAcct", "AssetSourceAmt", "AssetValueAmt", mField.getColumnName());
        }
        return "";
    }

    public String dateDoc(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        mTab.setValue("DateAcct", value);
        return "";
    }

    public String uselife(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if ("DeltaUseLifeYears".equals(mField.getColumnName())) {
            mTab.setValue("DeltaUseLifeYears_F", value);
        }
        return "";
    }

    public String periodOffset(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        I_A_Asset_Addition aa = GridTabWrapper.create(mTab, I_A_Asset_Addition.class);
        if (!aa.isA_Accumulated_Depr_Adjust()) {
            return "";
        }
        int periods = TimeUtil.getMonthsBetween(aa.getDateDoc(), aa.getDateAcct());
        if (periods <= 0) {
            return "";
        }
        int uselifeMonths = aa.getDeltaUseLifeYears() * 12;
        if (uselifeMonths == 0) {
            return "";
        }
        double monthlyExpenseSL = aa.getAssetValueAmt().doubleValue() / (double)uselifeMonths * (double)periods;
        aa.setA_Period_Start(periods + 1);
        aa.setA_Accumulated_Depr(BigDecimal.valueOf(monthlyExpenseSL));
        aa.setA_Accumulated_Depr_F(BigDecimal.valueOf(monthlyExpenseSL));
        return "";
    }
}

