/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.fa.feature;

import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MAssetGroup;
import org.compiere.model.PO;
import org.compiere.model.SetGetModel;
import org.compiere.model.SetGetUtil;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.idempiere.fa.feature.UseLife;

public class UseLifeImpl
implements UseLife {
    private static final String FIELD_UseLifeYears = "UseLifeYears";
    private static final String FIELD_UseLifeMonths = "UseLifeMonths";
    private static final String FIELD_FiscalPostfix = "_F";
    private SetGetModel m_obj = null;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private boolean fiscal = false;

    public static UseLifeImpl get(SetGetModel obj) {
        return new UseLifeImpl(obj, false);
    }

    public static UseLifeImpl get(SetGetModel obj, boolean fiscal) {
        return new UseLifeImpl(obj, fiscal);
    }

    public UseLifeImpl(SetGetModel obj, boolean fiscal) {
        this.m_obj = obj;
        this.fiscal = fiscal;
    }

    @Override
    public Properties getCtx() {
        return this.m_obj.getCtx();
    }

    @Override
    public int get_Table_ID() {
        return this.m_obj.get_Table_ID();
    }

    @Override
    public String get_TableName() {
        return this.m_obj.get_TableName();
    }

    private static final String getFieldName(String fieldName, boolean fiscal) {
        String field = fieldName;
        if (fiscal) {
            field = String.valueOf(field) + FIELD_FiscalPostfix;
        }
        return field;
    }

    public boolean isFiscal() {
        return this.fiscal;
    }

    @Override
    public boolean set_AttrValue(String name, Object value) {
        return this.m_obj.set_AttrValue(name, value);
    }

    @Override
    public Object get_AttrValue(String name) {
        return this.m_obj.get_AttrValue(name);
    }

    @Override
    public boolean is_AttrValueChanged(String name) {
        return this.m_obj.is_AttrValueChanged(name);
    }

    @Override
    public String get_TrxName() {
        return this.m_obj.get_TrxName();
    }

    public void setUseLifeMonths(int value) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Entering: value=" + value + ", " + this);
        }
        this.m_obj.set_AttrValue(UseLifeImpl.getFieldName(FIELD_UseLifeMonths, this.fiscal), value);
        this.m_obj.set_AttrValue(UseLifeImpl.getFieldName(FIELD_UseLifeYears, this.fiscal), value / 12);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Leaving: value=" + value + ", " + this);
        }
    }

    public int getUseLifeMonths() {
        Object obj = this.m_obj.get_AttrValue(UseLifeImpl.getFieldName(FIELD_UseLifeMonths, this.fiscal));
        if (obj != null && obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        return 0;
    }

    public void setUseLifeYears(int value) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Entering: value=" + value + ", " + this);
        }
        this.m_obj.set_AttrValue(UseLifeImpl.getFieldName(FIELD_UseLifeYears, this.fiscal), value);
        this.m_obj.set_AttrValue(UseLifeImpl.getFieldName(FIELD_UseLifeMonths, this.fiscal), value * 12);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Leaving: value=" + value + ", " + this);
        }
    }

    public int getUseLifeYears() {
        Object obj = this.m_obj.get_AttrValue(UseLifeImpl.getFieldName(FIELD_UseLifeYears, this.fiscal));
        if (obj != null && obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        return 0;
    }

    public void adjustUseLifeYears(int deltaUseLifeYears, boolean reset) {
        int uselife = reset ? 0 : this.getUseLifeYears();
        int new_uselife = uselife + deltaUseLifeYears;
        this.setUseLifeYears(new_uselife);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("UseLifeYears=" + uselife + ", delta=" + deltaUseLifeYears + " => new UseLifeYears=" + new_uselife + " (isFiscal=" + this.isFiscal() + ")");
        }
    }

    @Override
    public Timestamp getAssetServiceDate() {
        if (this.m_obj instanceof UseLife) {
            return ((UseLife)this.m_obj).getAssetServiceDate();
        }
        Object obj = this.m_obj.get_AttrValue("AssetServiceDate");
        if (obj != null && obj instanceof Timestamp) {
            return (Timestamp)obj;
        }
        return null;
    }

    public static void copyValues(PO to, PO from) {
        SetGetUtil.copyValues(to, from, new String[]{FIELD_UseLifeMonths, FIELD_UseLifeYears, "UseLifeMonths_F", "UseLifeYears_F"}, null);
    }

    public boolean validate() {
        return this.validate(true);
    }

    public boolean validate(boolean saveError) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Entering: " + this);
        }
        int useLifeYears = 0;
        int useLifeMonths = 0;
        useLifeYears = this.getUseLifeYears();
        useLifeMonths = this.getUseLifeMonths();
        if (useLifeMonths == 0) {
            useLifeMonths = useLifeYears * 12;
        }
        if (useLifeMonths % 12 != 0) {
            if (saveError) {
                this.log.saveError("Error", "@Invalid@ @UseLifeMonths@=" + useLifeMonths + "(@Diff@=" + useLifeMonths % 12 + ")");
            }
            return false;
        }
        if (useLifeYears == 0) {
            useLifeYears = useLifeMonths / 12;
        }
        this.setUseLifeMonths(useLifeMonths);
        this.setUseLifeYears(useLifeYears);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Leaving [RETURN TRUE]");
        }
        return true;
    }

    public String toString() {
        return "UseLifeImpl[UseLife=" + this.getUseLifeYears() + "|" + this.getUseLifeMonths() + ", isFiscal=" + this.isFiscal() + ", AssetServiceDate=" + this.getAssetServiceDate() + ", m_obj=" + this.m_obj + "]";
    }

    public static Timestamp getDateAcct(Timestamp assetServiceDate, int A_Current_Period) {
        if (assetServiceDate == null) {
            return null;
        }
        return TimeUtil.addMonths(assetServiceDate, A_Current_Period);
    }

    public static class Callout
    extends CalloutEngine {
        private String validate(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
            Timestamp AssetServiceDate = (Timestamp)mTab.getValue("AssetServiceDate");
            if (AssetServiceDate == null) {
                return "";
            }
            Integer UseLifeMonths = (Integer)mTab.getValue(UseLifeImpl.FIELD_UseLifeMonths);
            if (UseLifeMonths == null) {
                UseLifeMonths = 0;
            }
            return "";
        }

        public String assetServiceDate(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
            if (this.isCalloutActive() || value == null) {
                return "";
            }
            return this.validate(ctx, WindowNo, mTab, mField, value, oldValue);
        }

        public String useLife(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
            String columnName;
            if (this.isCalloutActive()) {
                return "";
            }
            String sufix = "";
            int ivalue = 0;
            int UseLifeYears = 0;
            int UseLifeMonths = 0;
            String errmsg = "";
            if (value != null) {
                ivalue = (Integer)value;
            }
            if ((columnName = mField.getColumnName().toUpperCase()).endsWith(UseLifeImpl.FIELD_FiscalPostfix)) {
                sufix = UseLifeImpl.FIELD_FiscalPostfix;
                columnName = columnName.substring(0, columnName.length() - UseLifeImpl.FIELD_FiscalPostfix.length());
            }
            if (columnName.equalsIgnoreCase(UseLifeImpl.FIELD_UseLifeMonths)) {
                if (ivalue % 12 != 0) {
                    errmsg = "@Invalid@ @UseLifeMonths " + sufix + "@=" + ivalue;
                } else {
                    UseLifeYears = ivalue / 12;
                    mTab.setValue(UseLifeImpl.FIELD_UseLifeYears + sufix, (Object)UseLifeYears);
                }
            } else if (columnName.equalsIgnoreCase(UseLifeImpl.FIELD_UseLifeYears)) {
                UseLifeMonths = ivalue * 12;
                mTab.setValue(UseLifeImpl.FIELD_UseLifeMonths + sufix, (Object)UseLifeMonths);
            }
            if (errmsg.length() > 0) {
                errmsg = Msg.parseTranslation(ctx, errmsg);
            }
            return errmsg;
        }

        public String assetGroup(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
            if (this.isCalloutActive()) {
                return "";
            }
            int A_Asset_Group_ID = -1;
            if (value != null && value instanceof Number) {
                A_Asset_Group_ID = ((Number)value).intValue();
            }
            MAssetGroup.updateAsset(SetGetUtil.wrap(mTab), A_Asset_Group_ID);
            return "";
        }
    }
}

