/*
 * Decompiled with CFR 0.152.
 */
package org.globalqss.process;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MBPartner;
import org.compiere.model.MConversionType;
import org.compiere.model.MElementValue;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalGenerator;
import org.compiere.model.MJournalGeneratorLine;
import org.compiere.model.MJournalGeneratorSource;
import org.compiere.model.MJournalLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.report.MReportTree;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;

public class GLJournalGenerate
extends SvrProcess {
    private Timestamp p_ProcessingDateFrom;
    private Timestamp p_ProcessingDateTo;
    private Timestamp p_DateAcct;
    private boolean p_IsSimulation = true;
    private String p_DocAction = null;
    private String p_DocumentNo;
    private int p_C_BPartner_ID = 0;
    private int p_M_Product_ID = 0;
    private int p_QSS_JournalGenerator_ID;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i2 = 0;
        while (i2 < para.length) {
            String name = para[i2].getParameterName();
            if (name.equals("ProcessingDate")) {
                this.p_ProcessingDateFrom = (Timestamp)para[i2].getParameter();
                this.p_ProcessingDateTo = (Timestamp)para[i2].getParameter_To();
            } else if (name.equals("DateAcct")) {
                this.p_DateAcct = (Timestamp)para[i2].getParameter();
            } else if (name.equals("IsSimulation")) {
                this.p_IsSimulation = para[i2].getParameterAsBoolean();
            } else if (name.equals("DocAction")) {
                this.p_DocAction = (String)para[i2].getParameter();
            } else if (name.equals("DocumentNo")) {
                this.p_DocumentNo = (String)para[i2].getParameter();
            } else if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i2].getParameterAsInt();
            } else if (name.equals("M_Product_ID")) {
                this.p_M_Product_ID = para[i2].getParameterAsInt();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i2;
        }
        this.p_QSS_JournalGenerator_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("QSS_Journal_Generator_ID=" + this.p_QSS_JournalGenerator_ID + ", ProcessingDate=" + this.p_ProcessingDateFrom + "/" + this.p_ProcessingDateTo + ", DateAcct=" + this.p_DateAcct + ", IsSimulation=" + this.p_IsSimulation + ", DocAction=" + this.p_DocAction + ", DocumentNo=" + this.p_DocumentNo + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", M_Product_ID=" + this.p_M_Product_ID);
        }
        MJournalGenerator journalGenerator = new MJournalGenerator(this.getCtx(), this.p_QSS_JournalGenerator_ID, this.get_TrxName());
        MAcctSchema as = (MAcctSchema)journalGenerator.getC_AcctSchema();
        BigDecimal totalAmount = Env.ZERO;
        ArrayList<List<Integer>> listDimOut = new ArrayList<List<Integer>>();
        ArrayList listColOut = new ArrayList();
        ArrayList<BigDecimal> listDrAmtOut = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> listCrAmtOut = new ArrayList<BigDecimal>();
        ArrayList<Integer> listAccountOut = new ArrayList<Integer>();
        ArrayList<MJournalGeneratorLine> listLinesOut = new ArrayList<MJournalGeneratorLine>();
        MJournalGeneratorLine[] mJournalGeneratorLineArray = journalGenerator.getLines();
        int n = mJournalGeneratorLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MJournalGeneratorLine line = mJournalGeneratorLineArray[n2];
            int idxBPColumn = -1;
            ArrayList<String> groupColumns = new ArrayList<String>();
            groupColumns.add("AD_Client_ID");
            if (line.isCopyAllDimensions()) {
                MAcctSchemaElement[] mAcctSchemaElementArray = as.getAcctSchemaElements();
                int n3 = mAcctSchemaElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    MAcctSchemaElement element = mAcctSchemaElementArray[n4];
                    String columnName = MAcctSchemaElement.getColumnName(element.getElementType());
                    if (!groupColumns.contains(columnName)) {
                        groupColumns.add(columnName);
                    }
                    ++n4;
                }
            } else {
                if ("S".equals(line.getBPDimensionType())) {
                    groupColumns.add("C_BPartner_ID");
                } else if ("C".equals(line.getBPDimensionType())) {
                    String[] parts = line.getBPColumn().split("\\.");
                    String tablename = parts[0];
                    groupColumns.add(String.valueOf(tablename) + "_ID");
                    idxBPColumn = groupColumns.size() - 1;
                }
                if (line.isSameProduct()) {
                    groupColumns.add("M_Product_ID");
                }
            }
            String groupBy = "";
            for (String column : groupColumns) {
                groupBy = groupBy.length() == 0 ? String.valueOf(groupBy) + column : String.valueOf(groupBy) + "," + column;
            }
            ArrayList listDim = new ArrayList();
            ArrayList<BigDecimal> listAmt = new ArrayList<BigDecimal>();
            int p_AD_Org_ID = line.getAD_Org_ID();
            if (p_AD_Org_ID == 0) {
                p_AD_Org_ID = journalGenerator.getAD_Org_ID();
            }
            if (p_AD_Org_ID == 0) {
                p_AD_Org_ID = Env.getAD_Org_ID(this.getCtx());
            }
            MJournalGeneratorSource[] mJournalGeneratorSourceArray = line.getSources();
            int n5 = mJournalGeneratorSourceArray.length;
            int n6 = 0;
            while (n6 < n5) {
                MJournalGeneratorSource source = mJournalGeneratorSourceArray[n6];
                String sql = "SELECT SUM(AmtAcctDr-AmtAcctCr), " + groupBy + " FROM Fact_Acct " + " WHERE PostingType='A' " + "   AND IsActive='Y' " + "   AND DateAcct BETWEEN ? AND ? " + "   AND C_AcctSchema_ID=? " + "   AND AD_Client_ID=? ";
                if (p_AD_Org_ID > 0) {
                    sql = String.valueOf(sql) + "   AND AD_Org_ID=" + p_AD_Org_ID;
                }
                if (this.p_C_BPartner_ID > 0) {
                    sql = String.valueOf(sql) + "   AND C_BPartner_ID=" + this.p_C_BPartner_ID;
                }
                if (this.p_M_Product_ID > 0) {
                    sql = String.valueOf(sql) + "   AND M_Product_ID=" + this.p_M_Product_ID;
                }
                if (source.getGL_Category_ID() > 0) {
                    sql = String.valueOf(sql) + "   AND GL_Category_ID=" + source.getGL_Category_ID();
                }
                sql = String.valueOf(sql) + "   AND (";
                sql = String.valueOf(sql) + MReportTree.getWhereClause(this.getCtx(), 0, "AC", source.getC_ElementValue_ID());
                sql = String.valueOf(sql) + ")";
                sql = String.valueOf(sql) + " GROUP BY " + groupBy;
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, this.get_TrxName());
                        pstmt.setTimestamp(1, this.p_ProcessingDateFrom);
                        pstmt.setTimestamp(2, this.p_ProcessingDateTo);
                        pstmt.setInt(3, journalGenerator.getC_AcctSchema_ID());
                        pstmt.setInt(4, this.getAD_Client_ID());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            BigDecimal sourceAmt = rs.getBigDecimal(1);
                            if (sourceAmt == null || sourceAmt.signum() == 0) continue;
                            sourceAmt = this.applyMultiplierAndFactor(sourceAmt, source.getAmtMultiplier(), source.getRoundFactor());
                            ArrayList<Integer> dimensions = new ArrayList<Integer>();
                            int idxCol = 0;
                            for (String column : groupColumns) {
                                if (idxBPColumn == idxCol) {
                                    int bpIdOut = 0;
                                    String[] parts = line.getBPColumn().split("\\.");
                                    String tablename = parts[0];
                                    String columnname = parts[1];
                                    int id = rs.getInt(column);
                                    if (id > 0) {
                                        MTable table2 = MTable.get(this.getCtx(), tablename);
                                        PO po = table2.getPO(id, this.get_TrxName());
                                        bpIdOut = po.get_ValueAsInt(columnname);
                                    }
                                    dimensions.add(bpIdOut);
                                } else {
                                    dimensions.add(rs.getInt(column));
                                }
                                ++idxCol;
                            }
                            if (listDim.contains(dimensions)) {
                                int idx = listDim.indexOf(dimensions);
                                BigDecimal dimAmt = (BigDecimal)listAmt.get(idx);
                                dimAmt = dimAmt.add(sourceAmt);
                                listAmt.set(idx, dimAmt);
                                continue;
                            }
                            listDim.add(dimensions);
                            listAmt.add(sourceAmt);
                        }
                    }
                    catch (SQLException e) {
                        throw new DBException(e, sql);
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                ++n6;
            }
            ArrayList<String> columnsOut = new ArrayList<String>();
            if (line.isCopyAllDimensions()) {
                columnsOut = groupColumns;
            } else {
                columnsOut.add("AD_Client_ID");
                if ("S".equals(line.getBPDimensionType()) || "F".equals(line.getBPDimensionType()) || "C".equals(line.getBPDimensionType())) {
                    columnsOut.add("C_BPartner_ID");
                }
                if (line.isSameProduct()) {
                    columnsOut.add("M_Product_ID");
                }
            }
            int i2 = 0;
            while (i2 < listDim.size()) {
                List dimensions = (List)listDim.get(i2);
                BigDecimal amount = (BigDecimal)listAmt.get(i2);
                List<Integer> dimensionsOut = new ArrayList<Integer>();
                if (amount != null && amount.signum() != 0) {
                    amount = this.applyMultiplierAndFactor(amount, line.getAmtMultiplier(), line.getRoundFactor());
                    if (line.isCopyAllDimensions()) {
                        dimensionsOut = dimensions;
                    } else {
                        dimensionsOut.add((Integer)dimensions.get(0));
                        if ("S".equals(line.getBPDimensionType())) {
                            dimensionsOut.add((Integer)dimensions.get(groupColumns.indexOf("C_BPartner_ID")));
                        } else if ("F".equals(line.getBPDimensionType())) {
                            dimensionsOut.add(line.getC_BPartner_ID());
                        } else if ("C".equals(line.getBPDimensionType())) {
                            String[] parts = line.getBPColumn().split("\\.");
                            String tablename = parts[0];
                            dimensionsOut.add((Integer)dimensions.get(groupColumns.indexOf(String.valueOf(tablename) + "_ID")));
                        }
                        if (line.isSameProduct()) {
                            dimensionsOut.add((Integer)dimensions.get(groupColumns.indexOf("M_Product_ID")));
                        }
                    }
                    if (line.getC_ElementValueDR_ID() > 0) {
                        listAccountOut.add(line.getC_ElementValueDR_ID());
                        listDrAmtOut.add(amount);
                        listCrAmtOut.add(Env.ZERO);
                        listDimOut.add(dimensionsOut);
                        listColOut.add(columnsOut);
                        listLinesOut.add(line);
                        totalAmount = totalAmount.add(amount);
                    }
                    if (line.getC_ElementValueCR_ID() > 0) {
                        listAccountOut.add(line.getC_ElementValueCR_ID());
                        listDrAmtOut.add(Env.ZERO);
                        listCrAmtOut.add(amount);
                        listDimOut.add(dimensionsOut);
                        listColOut.add(columnsOut);
                        listLinesOut.add(line);
                        totalAmount = totalAmount.subtract(amount);
                    }
                    if (line.getC_ElementValueDR_ID() == 0 && line.getC_ElementValueCR_ID() == 0 && line.isCopyAllDimensions()) {
                        int accountId = (Integer)dimensions.get(groupColumns.indexOf("Account_ID"));
                        listAccountOut.add(accountId);
                        if (amount.signum() > 0) {
                            listDrAmtOut.add(amount);
                            listCrAmtOut.add(Env.ZERO);
                            totalAmount = totalAmount.add(amount);
                        } else {
                            listDrAmtOut.add(Env.ZERO);
                            listCrAmtOut.add(amount.negate());
                            totalAmount = totalAmount.add(amount);
                        }
                        listDimOut.add(dimensionsOut);
                        listColOut.add(columnsOut);
                        listLinesOut.add(line);
                    }
                }
                ++i2;
            }
            ++n2;
        }
        if (totalAmount.signum() < 0 && journalGenerator.getC_ElementValueAdjustDR_ID() > 0) {
            listAccountOut.add(journalGenerator.getC_ElementValueAdjustDR_ID());
            listDrAmtOut.add(totalAmount.negate());
            listCrAmtOut.add(Env.ZERO);
            listDimOut.add(null);
            listColOut.add(null);
            listLinesOut.add(null);
        } else if (totalAmount.signum() > 0 && journalGenerator.getC_ElementValueAdjustCR_ID() > 0) {
            listAccountOut.add(journalGenerator.getC_ElementValueAdjustCR_ID());
            listDrAmtOut.add(Env.ZERO);
            listCrAmtOut.add(totalAmount);
            listDimOut.add(null);
            listColOut.add(null);
            listLinesOut.add(null);
        }
        MJournal j = null;
        int lineNo = 10;
        int i3 = 0;
        while (i3 < listDimOut.size()) {
            List dimensions = (List)listDimOut.get(i3);
            List columnsOut = (List)listColOut.get(i3);
            BigDecimal dr = (BigDecimal)listDrAmtOut.get(i3);
            BigDecimal cr = (BigDecimal)listCrAmtOut.get(i3);
            int accountId = (Integer)listAccountOut.get(i3);
            MJournalGeneratorLine line = (MJournalGeneratorLine)listLinesOut.get(i3);
            if (this.p_IsSimulation) {
                MElementValue ev = new MElementValue(this.getCtx(), accountId, this.get_TrxName());
                String msg = "Account=" + ev.getValue() + ", DR=" + dr + ", CR=" + cr;
                int idxcol = 0;
                if (columnsOut != null) {
                    for (String col : columnsOut) {
                        int id = (Integer)dimensions.get(idxcol);
                        if (id == 0) continue;
                        if ("C_BPartner_ID".equals(col)) {
                            MBPartner bp = MBPartner.get(this.getCtx(), id);
                            msg = String.valueOf(msg) + ", C_BPartner=" + bp.getValue();
                        } else if ("M_Product_ID".equals(col)) {
                            MProduct pr = MProduct.get(this.getCtx(), id);
                            msg = String.valueOf(msg) + ", M_Product=" + pr.getValue();
                        } else if (!"AD_Client_ID".equals(col)) {
                            msg = String.valueOf(msg) + ", " + col + "=" + id;
                        }
                        ++idxcol;
                    }
                }
                this.addLog(msg);
            } else {
                MAccount combination;
                if (j == null) {
                    j = new MJournal(this.getCtx(), 0, this.get_TrxName());
                    if (journalGenerator.getAD_Org_ID() > 0) {
                        j.setAD_Org_ID(journalGenerator.getAD_Org_ID());
                    } else {
                        j.setAD_Org_ID(Env.getAD_Org_ID(this.getCtx()));
                    }
                    if (j.getAD_Org_ID() == 0) {
                        throw new AdempiereException(Msg.getMsg(Language.getBaseAD_Language(), "Org0NotAllowed"));
                    }
                    j.setC_Currency_ID(as.getC_Currency_ID());
                    j.setC_DocType_ID(journalGenerator.getC_DocType_ID());
                    j.setControlAmt(Env.ZERO);
                    j.setDateAcct(this.p_DateAcct);
                    int C_Period_ID = MPeriod.getC_Period_ID(this.getCtx(), this.p_DateAcct, j.getAD_Org_ID());
                    if (C_Period_ID > 0) {
                        j.setC_Period_ID(C_Period_ID);
                    }
                    j.setDateDoc(this.p_DateAcct);
                    j.setDescription(journalGenerator.getDescription());
                    j.setDocumentNo(this.p_DocumentNo);
                    j.set_ValueOfColumn("GL_Category_ID", (Object)journalGenerator.getGL_Category_ID());
                    j.setPostingType(journalGenerator.getPostingType());
                    j.setC_AcctSchema_ID(as.getC_AcctSchema_ID());
                    j.setC_ConversionType_ID(MConversionType.getDefault(as.getAD_Client_ID()));
                    j.saveEx();
                }
                MJournalLine jl = new MJournalLine(j);
                jl.setLine(lineNo);
                lineNo += 10;
                int AD_Client_ID = this.getAD_Client_ID();
                int AD_Org_ID = 0;
                if (line != null) {
                    AD_Org_ID = line.getAD_Org_ID();
                }
                if (AD_Org_ID == 0) {
                    AD_Org_ID = journalGenerator.getAD_Org_ID();
                }
                if (AD_Org_ID == 0) {
                    AD_Org_ID = Env.getAD_Org_ID(this.getCtx());
                }
                int C_AcctSchema_ID = journalGenerator.getC_AcctSchema_ID();
                int Account_ID = accountId;
                int C_SubAcct_ID = 0;
                int M_Product_ID = 0;
                int C_BPartner_ID = 0;
                int AD_OrgTrx_ID = 0;
                int C_LocFrom_ID = 0;
                int C_LocTo_ID = 0;
                int C_SalesRegion_ID = 0;
                int C_Project_ID = 0;
                int C_Campaign_ID = 0;
                int C_Activity_ID = 0;
                int User1_ID = 0;
                int User2_ID = 0;
                int UserElement1_ID = 0;
                int UserElement2_ID = 0;
                if (columnsOut != null) {
                    int idxcol = 0;
                    for (String col : columnsOut) {
                        int id = (Integer)dimensions.get(idxcol);
                        if ("M_Product_ID".equals(col)) {
                            M_Product_ID = id;
                        } else if ("C_BPartner_ID".equals(col)) {
                            C_BPartner_ID = id;
                        } else if ("AD_OrgTrx_ID".equals(col)) {
                            AD_OrgTrx_ID = id;
                        } else if ("C_LocFrom_ID".equals(col)) {
                            C_LocFrom_ID = id;
                        } else if ("C_LocTo_ID".equals(col)) {
                            C_LocTo_ID = id;
                        } else if ("C_SalesRegion_ID".equals(col)) {
                            C_SalesRegion_ID = id;
                        } else if ("C_Project_ID".equals(col)) {
                            C_Project_ID = id;
                        } else if ("C_Campaign_ID".equals(col)) {
                            C_Campaign_ID = id;
                        } else if ("C_Activity_ID".equals(col)) {
                            C_Activity_ID = id;
                        } else if ("User1_ID".equals(col)) {
                            User1_ID = id;
                        } else if ("User2_ID".equals(col)) {
                            User2_ID = id;
                        } else if ("UserElement1_ID".equals(col)) {
                            UserElement1_ID = id;
                        } else if ("UserElement2_ID".equals(col)) {
                            UserElement2_ID = id;
                        }
                        ++idxcol;
                    }
                }
                if ((combination = MAccount.get(this.getCtx(), AD_Client_ID, AD_Org_ID, C_AcctSchema_ID, Account_ID, C_SubAcct_ID, M_Product_ID, C_BPartner_ID, AD_OrgTrx_ID, C_LocFrom_ID, C_LocTo_ID, C_SalesRegion_ID, C_Project_ID, C_Campaign_ID, C_Activity_ID, User1_ID, User2_ID, UserElement1_ID, UserElement2_ID, this.get_TrxName())) == null) {
                    throw new AdempiereException("Could not create combination");
                }
                jl.setC_ValidCombination_ID(combination);
                if (line != null) {
                    jl.setDescription(line.getDescription());
                }
                jl.setAmtSourceDr(dr);
                jl.setAmtAcctDr(dr);
                jl.setAmtSourceCr(cr);
                jl.setAmtAcctCr(cr);
                jl.saveEx();
            }
            ++i3;
        }
        if (j != null && this.p_DocAction != null) {
            if (!j.processIt(this.p_DocAction)) {
                throw new AdempiereException("Couldn't set docAction: " + this.p_DocAction + j.getProcessMsg() + " journal");
            }
            j.saveEx();
        }
        if (j == null) {
            return "0 @GL_Journal_ID@ @Created@";
        }
        StringBuilder msg = new StringBuilder(Msg.parseTranslation(this.getCtx(), "@Created@ @GL_Journal_ID@=")).append(j.getDocumentNo());
        this.addLog(j.get_ID(), null, null, msg.toString(), 224, j.get_ID());
        return "@OK@";
    }

    private BigDecimal applyMultiplierAndFactor(BigDecimal sourceAmt, BigDecimal amtMultiplier, int roundFactor) {
        if (amtMultiplier.compareTo(Env.ONE) != 0) {
            sourceAmt = sourceAmt.multiply(amtMultiplier, MathContext.UNLIMITED);
        }
        if (roundFactor < 0) {
            BigDecimal divisor = BigDecimal.valueOf(Math.pow(10.0, -roundFactor));
            sourceAmt = sourceAmt.divide(divisor, MathContext.UNLIMITED);
            sourceAmt = sourceAmt.setScale(0, RoundingMode.HALF_UP);
            sourceAmt = sourceAmt.multiply(divisor, MathContext.UNLIMITED);
            sourceAmt = sourceAmt.setScale(0, RoundingMode.HALF_UP);
        } else {
            sourceAmt = sourceAmt.setScale(roundFactor, RoundingMode.HALF_UP);
        }
        return sourceAmt;
    }
}

