/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.logging.Level;
import org.compiere.model.MProduct;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.ValueNamePair;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;

public class PP_Product_BOM_Check
extends SvrProcess {
    private int p_Record_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i2 = 0;
        while (i2 < para.length) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() != null) {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i2;
        }
        this.p_Record_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("Check BOM Structure");
        MProduct xp = new MProduct(Env.getCtx(), this.p_Record_ID, this.get_TrxName());
        if (!xp.isBOM()) {
            this.log.info("Product is not a BOM");
            return "OK";
        }
        int lowlevel = MPPProductBOMLine.getLowLevel(this.getCtx(), this.p_Record_ID, this.get_TrxName());
        xp.setLowLevel(lowlevel);
        xp.setIsVerified(true);
        xp.saveEx();
        MPPProductBOM tbom = MPPProductBOM.getDefault(xp, this.get_TrxName());
        if (tbom == null) {
            this.raiseError("No Default BOM found: ", "Check BOM Parent search key");
        }
        if (tbom.getM_Product_ID() != 0) {
            MPPProductBOMLine[] tbomlines;
            MPPProductBOMLine[] mPPProductBOMLineArray = tbomlines = tbom.getLines();
            int n = tbomlines.length;
            int n2 = 0;
            while (n2 < n) {
                MPPProductBOMLine tbomline = mPPProductBOMLineArray[n2];
                lowlevel = tbomline.getLowLevel();
                MProduct p2 = new MProduct(this.getCtx(), tbomline.getM_Product_ID(), this.get_TrxName());
                p2.setLowLevel(lowlevel);
                p2.setIsVerified(true);
                p2.saveEx();
                ++n2;
            }
        }
        return "OK";
    }

    private void raiseError(String string, String hint) throws Exception {
        DB.rollback(false, this.get_TrxName());
        MProduct xp = new MProduct(this.getCtx(), this.p_Record_ID, null);
        xp.setIsVerified(false);
        xp.saveEx();
        String msg = string;
        ValueNamePair pp = CLogger.retrieveError();
        if (pp != null) {
            msg = String.valueOf(pp.getName()) + " - ";
        }
        msg = String.valueOf(msg) + hint;
        throw new AdempiereUserError(msg);
    }
}

