/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MColumn;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.X_I_Movement;

public class ImportInventoryMove
extends SvrProcess {
    private boolean m_DeleteOldImported = false;
    private boolean m_IsImportOnlyNoErrors = true;
    private boolean m_ErrorsFound = false;
    private String m_docAction = "PR";
    private boolean isImported = false;
    private int imported = 0;
    private int notimported = 0;
    private List<String> idsPr = new ArrayList<String>();

    @Override
    protected void prepare() {
        ProcessInfoParameter[] parameters;
        ProcessInfoParameter[] processInfoParameterArray = parameters = this.getParameter();
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if (para.getParameter() != null) {
                if (name.equals("IsImportOnlyNoErrors")) {
                    this.m_IsImportOnlyNoErrors = "Y".equals(para.getParameter());
                } else if (name.equals("DeleteOldImported")) {
                    this.m_DeleteOldImported = "Y".equals(para.getParameter());
                } else if (name.equals("DocAction")) {
                    this.m_docAction = (String)para.getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++n2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.m_DeleteOldImported) {
            int no = 0;
            for (X_I_Movement move : this.getRecords(true, false)) {
                move.deleteEx(true);
                ++no;
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Delete Old Impored =" + no);
            }
        }
        this.fillIDValues();
        this.importRecords();
        return "Imported: " + this.imported + ", Not imported: " + this.notimported;
    }

    private void importRecords() {
        if (this.m_IsImportOnlyNoErrors && this.m_ErrorsFound) {
            return;
        }
        this.isImported = false;
        for (X_I_Movement imove : this.getRecords(false, true)) {
            MMovement mov = this.importMInventoryMove(imove);
            if (mov != null) {
                imove.setM_Movement_ID(mov.getM_Movement_ID());
                imove.saveEx();
                this.isImported = this.importMInventoryMoveLine(mov, imove);
            } else {
                this.isImported = false;
            }
            if (this.isImported) {
                imove.setI_IsImported(true);
                imove.setProcessed(true);
                imove.saveEx();
                ++this.imported;
                this.addForProcess(mov.getM_Movement_ID());
                mov.saveEx();
                continue;
            }
            imove.setI_IsImported(false);
            imove.setProcessed(false);
            imove.saveEx();
            ++this.notimported;
        }
        this.processAll();
    }

    private void addForProcess(int id) {
        String ids = String.valueOf(id);
        boolean enc = false;
        for (String idx : this.idsPr) {
            if (!idx.equals(ids)) continue;
            enc = true;
        }
        if (!enc) {
            this.idsPr.add(ids);
        }
    }

    private void processAll() {
        for (String idx : this.idsPr) {
            int id = Integer.parseInt(idx);
            MMovement move = new MMovement(Env.getCtx(), id, this.get_TrxName());
            move.processIt(this.m_docAction);
            move.saveEx();
        }
    }

    private boolean importMInventoryMoveLine(MMovement move, X_I_Movement imove) {
        this.isImported = false;
        MMovementLine moveLine = this.getMInventoryMoveLine(move, imove);
        if (moveLine == null) {
            moveLine = new MMovementLine(Env.getCtx(), 0, this.get_TrxName());
        }
        try {
            moveLine.setM_Movement_ID(move.getM_Movement_ID());
            moveLine.setAD_Org_ID(imove.getAD_Org_ID());
            moveLine.setM_Product_ID(imove.getM_Product_ID());
            moveLine.setM_Locator_ID(imove.getM_Locator_ID());
            moveLine.setM_LocatorTo_ID(imove.getM_LocatorTo_ID());
            moveLine.setMovementQty(imove.getMovementQty());
            moveLine.saveEx();
            imove.setM_MovementLine_ID(moveLine.getM_MovementLine_ID());
            imove.saveEx();
            this.isImported = true;
        }
        catch (Exception e) {
            imove.setI_ErrorMsg(e.getMessage());
            this.isImported = false;
        }
        return this.isImported;
    }

    private MMovementLine getMInventoryMoveLine(MMovement move, X_I_Movement imove) {
        StringBuilder whereClause = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        MColumn[] cols = this.getMInventoryMoveColumns();
        int count = 0;
        MColumn[] mColumnArray = cols;
        int n = cols.length;
        int n2 = 0;
        while (n2 < n) {
            MColumn col = mColumnArray[n2];
            if ("AD_Org_ID".equals(col.getColumnName()) || "M_Product_ID".equals(col.getColumnName()) || "M_Locator_ID".equals(col.getColumnName()) || "M_LocatorTo_ID".equals(col.getColumnName())) {
                whereClause.append(col.getColumnName()).append("=?");
                parameters.add(imove.get_Value(col.getColumnName()));
                if (count < 3) {
                    whereClause.append(" AND ");
                    ++count;
                }
            }
            ++n2;
        }
        whereClause.append(" AND M_Movement_ID=?");
        parameters.add(move.getM_Movement_ID());
        return (MMovementLine)new Query(this.getCtx(), "M_MovementLine", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(parameters).first();
    }

    private MColumn[] getMInventoryMoveColumns() {
        return MTable.get(this.getCtx(), "M_MovementLine").getColumns(false);
    }

    private MMovement importMInventoryMove(X_I_Movement imove) {
        String whereClause = "MovementDate= ? AND DocumentNo=? AND C_DocType_ID=?";
        int oldID = new Query(Env.getCtx(), "M_Movement", "MovementDate= ? AND DocumentNo=? AND C_DocType_ID=?", this.get_TrxName()).setClient_ID().setParameters(imove.getMovementDate(), imove.getDocumentNo(), imove.getC_DocType_ID()).firstId();
        MMovement move = null;
        if (oldID <= 0) {
            oldID = 0;
        }
        move = new MMovement(Env.getCtx(), oldID, this.get_TrxName());
        try {
            move.setDocumentNo(imove.getDocumentNo());
            move.setC_DocType_ID(imove.getC_DocType_ID());
            move.setAD_Org_ID(imove.getAD_Org_ID());
            move.setMovementDate(imove.getMovementDate());
            move.setC_DocType_ID(imove.getC_DocType_ID());
            move.setDocumentNo(imove.getDocumentNo());
            move.setC_BPartner_ID(imove.getC_BPartner_ID());
            move.setM_Shipper_ID(imove.getM_Shipper_ID());
            move.setC_Project_ID(imove.getC_Project_ID());
            move.setC_Campaign_ID(imove.getC_Campaign_ID());
            move.setAD_OrgTrx_ID(imove.getAD_OrgTrx_ID());
            move.saveEx();
        }
        catch (Exception e) {
            imove.setI_ErrorMsg(e.getMessage());
            this.isImported = false;
        }
        return move;
    }

    private void fillIDValues() {
        this.m_ErrorsFound = false;
        for (X_I_Movement imove : this.getRecords(false, false)) {
            int orgId;
            if (imove.getAD_Org_ID() == 0 && (orgId = this.getID("AD_Org", "Value = ?", new Object[]{imove.getOrgValue()})) >= 0) {
                imove.setAD_Org_ID(orgId);
            }
            if (imove.getM_Product_ID() == 0) {
                imove.setM_Product_ID(this.getID("M_Product", "Value = ?", new Object[]{imove.getProductValue()}));
            }
            if (imove.getM_Locator_ID() == 0) {
                imove.setM_Locator_ID(this.getID("M_Locator", "Value = ?", new Object[]{imove.getLocatorValue()}));
            }
            if (imove.getM_LocatorTo_ID() == 0) {
                imove.setM_LocatorTo_ID(this.getID("M_Locator", "Value = ?", new Object[]{imove.getLocatorToValue()}));
            }
            if (imove.getC_DocType_ID() == 0) {
                imove.setC_DocType_ID(this.getID("C_DocType", "Name=?", new Object[]{imove.getDocTypeName()}));
            }
            if (imove.getC_BPartner_ID() == 0) {
                imove.setC_BPartner_ID(this.getID("C_BPartner", "Value =?", new Object[]{imove.getBPartnerValue()}));
            }
            if (imove.getM_Shipper_ID() == 0) {
                imove.setM_Shipper_ID(this.getID("M_Shipper", "Name = ?", new Object[]{imove.getShipperName()}));
            }
            if (imove.getC_Project_ID() == 0) {
                imove.setC_Project_ID(this.getID("C_Project", "Value = ?", new Object[]{imove.getProjectValue()}));
            }
            if (imove.getC_Campaign_ID() == 0) {
                imove.setC_Campaign_ID(this.getID("C_Campaign", "Value = ?", new Object[]{imove.getCampaignValue()}));
            }
            if (imove.getAD_OrgTrx_ID() == 0) {
                imove.setAD_OrgTrx_ID(this.getID("AD_Org", "Value = ?", new Object[]{imove.getOrgTrxValue()}));
            }
            StringBuilder err = new StringBuilder("");
            if (imove.getAD_Org_ID() <= 0) {
                err.append(" @AD_Org_ID@ @NotFound@,");
            }
            if (imove.getM_Product_ID() <= 0) {
                err.append(" @M_Product_ID@ @NotFound@,");
            }
            if (imove.getM_Locator_ID() <= 0) {
                err.append(" @M_Locator_ID@ @NotFound@,");
            }
            if (imove.getM_LocatorTo_ID() <= 0) {
                err.append(" @M_LocatorTo_ID@ @NotFound@,");
            }
            if (imove.getC_DocType_ID() <= 0) {
                err.append(" @C_DocType_ID@ @NotFound@,");
            }
            if (imove.getMovementQty().signum() == 0) {
                err.append(" @MovementQty@ @NotFound@,");
            }
            if (err.toString() != null && err.toString().length() > 0) {
                ++this.notimported;
                this.m_ErrorsFound = true;
                imove.setI_ErrorMsg(Msg.parseTranslation(this.getCtx(), err.toString()));
            } else {
                imove.setI_ErrorMsg(null);
            }
            imove.saveEx();
        }
    }

    private int getID(String tableName, String whereClause, Object[] values) {
        return new Query(this.getCtx(), tableName, whereClause, this.get_TrxName()).setClient_ID().setParameters(values).firstId();
    }

    private Collection<X_I_Movement> getRecords(boolean imported, boolean isWithoutError) {
        StringBuffer whereClause = new StringBuffer("I_IsImported").append("=?");
        if (isWithoutError) {
            whereClause.append(" AND ").append("I_ErrorMsg").append(" IS NULL");
        }
        return new Query(this.getCtx(), "I_Movement", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(imported).list();
    }
}

