/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.Adempiere;
import org.compiere.model.MPInstance;
import org.compiere.model.MSequence;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogMgt;
import org.compiere.util.CacheMgt;
import org.compiere.util.Env;

public class EnableNativeSequence
extends SvrProcess {
    @Override
    protected void prepare() {
    }

    @Override
    protected String doIt() throws Exception {
        boolean SYSTEM_NATIVE_SEQUENCE = MSysConfig.getBooleanValue("SYSTEM_NATIVE_SEQUENCE", false);
        if (SYSTEM_NATIVE_SEQUENCE) {
            throw new AdempiereException("Native Sequence is Actived");
        }
        MSysConfig conf = new MSysConfig(this.getCtx(), 50016, null);
        conf.setValue("Y");
        conf.saveEx();
        CacheMgt.get().reset("AD_SysConfig");
        try {
            this.createSequence("AD_Sequence", null);
            this.createSequence("AD_Issue", null);
            this.createSequence("AD_ChangeLog", null);
            String whereClause = "TableName NOT IN ('AD_Sequence', 'AD_Issue', 'AD_ChangeLog')";
            List tables = new Query(this.getCtx(), "AD_Table", "TableName NOT IN ('AD_Sequence', 'AD_Issue', 'AD_ChangeLog')", this.get_TrxName()).setOrderBy("TableName").list();
            for (MTable table2 : tables) {
                this.createSequence(table2, this.get_TrxName());
            }
        }
        catch (Exception e) {
            conf.setValue("N");
            conf.saveEx();
            throw e;
        }
        return "@OK@";
    }

    private void createSequence(MTable table2, String trxName) {
        if (!table2.isView()) {
            if (!MSequence.createTableSequence(this.getCtx(), table2.getTableName(), trxName)) {
                throw new AdempiereException("Can not create Native Sequence for table " + table2.getTableName());
            }
            this.addLog("Create Native Sequence for : " + table2.getTableName());
        }
    }

    private void createSequence(String tableName, String trxName) {
        this.createSequence(MTable.get(this.getCtx(), tableName), trxName);
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment(true);
        CLogMgt.setLevel(Level.INFO);
        Properties ctx = Env.getCtx();
        int AD_Process_ID = 53156;
        MPInstance pinstance = new MPInstance(ctx, AD_Process_ID, -1);
        pinstance.saveEx();
        ProcessInfo pi = new ProcessInfo("", AD_Process_ID, 0, 0);
        pi.setAD_Client_ID(Env.getAD_Client_ID(ctx));
        pi.setAD_User_ID(Env.getAD_User_ID(ctx));
        pi.setAD_PInstance_ID(pinstance.getAD_PInstance_ID());
        EnableNativeSequence proc = new EnableNativeSequence();
        proc.startProcess(ctx, pi, null);
        if (pi.isError()) {
            throw new AdempiereException(pi.getSummary());
        }
    }
}

