/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MCharge;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MUOM;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.X_DD_OrderLine;

public class MDDOrderLine
extends X_DD_OrderLine {
    private static final long serialVersionUID = -8878804332001384969L;
    private static CLogger s_log = CLogger.getCLogger(MDDOrderLine.class);
    private int m_M_PriceList_ID = 0;
    private boolean m_IsSOTrx = true;
    private MProduct m_product = null;
    private MDDOrder m_parent = null;

    public static BigDecimal getNotReserved(Properties ctx, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int excludeDD_OrderLine_ID) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(M_Locator_ID);
        params.add(M_Product_ID);
        params.add(excludeDD_OrderLine_ID);
        String sql = "SELECT SUM(QtyOrdered-QtyDelivered-QtyReserved) FROM DD_OrderLine ol INNER JOIN DD_Order o ON (ol.DD_Order_ID=o.DD_Order_ID) WHERE ol.M_Locator_ID=? AND M_Product_ID=? AND o.IsSOTrx='N' AND o.DocStatus='DR' AND QtyOrdered-QtyDelivered-QtyReserved<>0 AND ol.DD_OrderLine_ID<>?";
        if (M_AttributeSetInstance_ID != 0) {
            sql = String.valueOf(sql) + " AND M_AttributeSetInstance_ID=?";
            params.add(M_AttributeSetInstance_ID);
        }
        return DB.getSQLValueBD(null, sql.toString(), params);
    }

    public MDDOrderLine(Properties ctx, int C_OrderLine_ID, String trxName) {
        super(ctx, C_OrderLine_ID, trxName);
        if (C_OrderLine_ID == 0) {
            this.setFreightAmt(Env.ZERO);
            this.setLineNetAmt(Env.ZERO);
            this.setM_AttributeSetInstance_ID(0);
            this.setQtyEntered(Env.ZERO);
            this.setQtyInTransit(Env.ZERO);
            this.setConfirmedQty(Env.ZERO);
            this.setTargetQty(Env.ZERO);
            this.setPickedQty(Env.ZERO);
            this.setQtyOrdered(Env.ZERO);
            this.setQtyDelivered(Env.ZERO);
            this.setQtyReserved(Env.ZERO);
            this.setIsDescription(false);
            this.setProcessed(false);
            this.setLine(0);
        }
    }

    public MDDOrderLine(MDDOrder order) {
        this(order.getCtx(), 0, order.get_TrxName());
        if (order.get_ID() == 0) {
            throw new IllegalArgumentException("Header not saved");
        }
        this.setDD_Order_ID(order.getDD_Order_ID());
        this.setOrder(order);
    }

    public MDDOrderLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setOrder(MDDOrder order) {
        this.setClientOrg(order);
        this.setDateOrdered(order.getDateOrdered());
        this.setDatePromised(order.getDatePromised());
        this.setHeaderInfo(order);
    }

    public void setHeaderInfo(MDDOrder order) {
        this.m_parent = order;
        this.m_IsSOTrx = order.isSOTrx();
    }

    public MDDOrder getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MDDOrder(this.getCtx(), this.getDD_Order_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setProduct(MProduct product) {
        this.m_product = product;
        if (this.m_product != null) {
            this.setM_Product_ID(this.m_product.getM_Product_ID());
            this.setC_UOM_ID(this.m_product.getC_UOM_ID());
        } else {
            this.setM_Product_ID(0);
            this.set_ValueNoCheck("C_UOM_ID", null);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, boolean setUOM) {
        if (setUOM) {
            this.setProduct(MProduct.get(this.getCtx(), M_Product_ID));
        } else {
            super.setM_Product_ID(M_Product_ID);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, int C_UOM_ID) {
        super.setM_Product_ID(M_Product_ID);
        if (C_UOM_ID != 0) {
            super.setC_UOM_ID(C_UOM_ID);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public MProduct getProduct() {
        if (this.m_product == null && this.getM_Product_ID() != 0) {
            this.m_product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        }
        return this.m_product;
    }

    @Override
    public void setM_AttributeSetInstance_ID(int M_AttributeSetInstance_ID) {
        if (M_AttributeSetInstance_ID == 0) {
            this.set_Value("M_AttributeSetInstance_ID", (Object)0);
        } else {
            super.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        }
    }

    public boolean canChangeWarehouse() {
        if (this.getQtyDelivered().signum() != 0) {
            this.log.saveError("Error", String.valueOf(Msg.translate(this.getCtx(), "QtyDelivered")) + "=" + this.getQtyDelivered());
            return false;
        }
        if (this.getQtyReserved().signum() != 0) {
            this.log.saveError("Error", String.valueOf(Msg.translate(this.getCtx(), "QtyReserved")) + "=" + this.getQtyReserved());
            return false;
        }
        return true;
    }

    @Override
    public int getC_Project_ID() {
        int ii = super.getC_Project_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Project_ID();
        }
        return ii;
    }

    @Override
    public int getC_Activity_ID() {
        int ii = super.getC_Activity_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Activity_ID();
        }
        return ii;
    }

    @Override
    public int getC_Campaign_ID() {
        int ii = super.getC_Campaign_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Campaign_ID();
        }
        return ii;
    }

    @Override
    public int getUser1_ID() {
        int ii = super.getUser1_ID();
        if (ii == 0) {
            ii = this.getParent().getUser1_ID();
        }
        return ii;
    }

    @Override
    public int getUser2_ID() {
        int ii = super.getUser2_ID();
        if (ii == 0) {
            ii = this.getParent().getUser2_ID();
        }
        return ii;
    }

    @Override
    public int getAD_OrgTrx_ID() {
        int ii = super.getAD_OrgTrx_ID();
        if (ii == 0) {
            ii = this.getParent().getAD_OrgTrx_ID();
        }
        return ii;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MDDOrderLine[").append(this.get_ID()).append(",Line=").append(this.getLine()).append(",Ordered=").append(this.getQtyOrdered()).append(",Delivered=").append(this.getQtyDelivered()).append(",Reserved=").append(this.getQtyReserved()).append("]");
        return sb.toString();
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(desc) + " | " + description);
        }
    }

    public String getDescriptionText() {
        return super.getDescription();
    }

    public String getName() {
        this.getProduct();
        if (this.m_product != null) {
            return this.m_product.getName();
        }
        if (this.getC_Charge_ID() != 0) {
            MCharge charge = MCharge.get(this.getCtx(), this.getC_Charge_ID());
            return charge.getName();
        }
        return "";
    }

    @Override
    public void setC_Charge_ID(int C_Charge_ID) {
        super.setC_Charge_ID(C_Charge_ID);
        if (C_Charge_ID > 0) {
            this.set_ValueNoCheck("C_UOM_ID", null);
        }
    }

    public void setQty(BigDecimal Qty) {
        super.setQtyEntered(Qty);
        super.setQtyOrdered(this.getQtyEntered());
    }

    @Override
    public void setQtyEntered(BigDecimal QtyEntered) {
        if (QtyEntered != null && this.getC_UOM_ID() != 0) {
            int precision = MUOM.getPrecision(this.getCtx(), this.getC_UOM_ID());
            QtyEntered = QtyEntered.setScale(precision, RoundingMode.HALF_UP);
        }
        super.setQtyEntered(QtyEntered);
    }

    @Override
    public void setQtyOrdered(BigDecimal QtyOrdered) {
        MProduct product = this.getProduct();
        if (QtyOrdered != null && product != null) {
            int precision = product.getUOMPrecision();
            QtyOrdered = QtyOrdered.setScale(precision, RoundingMode.HALF_UP);
        }
        super.setQtyOrdered(QtyOrdered);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MProduct product;
        int C_UOM_ID;
        if (newRecord && this.getParent().isComplete()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "DD_OrderLine"));
            return false;
        }
        if (this.m_M_PriceList_ID == 0) {
            this.setHeaderInfo(this.getParent());
        }
        if (!newRecord && (this.is_ValueChanged("M_Product_ID") || this.is_ValueChanged("M_Locator_ID") || this.is_ValueChanged("M_LocatorTo_ID")) && !this.canChangeWarehouse()) {
            return false;
        }
        if (this.getC_Charge_ID() != 0 && this.getM_Product_ID() != 0) {
            this.setM_Product_ID(0);
        }
        if (this.getM_Product_ID() == 0) {
            this.setM_AttributeSetInstance_ID(0);
        }
        if (this.getC_UOM_ID() == 0 && (this.getM_Product_ID() != 0 || this.getC_Charge_ID() != 0) && (C_UOM_ID = MUOM.getDefault_UOM_ID(this.getCtx())) > 0) {
            this.setC_UOM_ID(C_UOM_ID);
        }
        if (newRecord || this.is_ValueChanged("QtyEntered")) {
            this.setQtyEntered(this.getQtyEntered());
        }
        if (newRecord || this.is_ValueChanged("QtyOrdered")) {
            this.setQtyOrdered(this.getQtyOrdered());
        }
        if (this.m_IsSOTrx && this.getM_AttributeSetInstance_ID() != 0 && (newRecord || this.is_ValueChanged("M_Product_ID") || this.is_ValueChanged("M_AttributeSetInstance_ID") || this.is_ValueChanged("M_Warehouse_ID")) && (product = this.getProduct()).isStocked()) {
            boolean isInstance;
            int M_AttributeSet_ID = product.getM_AttributeSet_ID();
            boolean bl = isInstance = M_AttributeSet_ID != 0;
            if (isInstance) {
                MAttributeSet mas = MAttributeSet.get(this.getCtx(), M_AttributeSet_ID);
                isInstance = mas.isInstanceAttribute();
            }
            if (isInstance) {
                MLocator locator_from = MLocator.get(this.getCtx(), this.getM_Locator_ID());
                MStorageOnHand[] storages = MStorageOnHand.getWarehouse(this.getCtx(), locator_from.getM_Warehouse_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), null, true, false, 0, this.get_TrxName());
                BigDecimal qty = Env.ZERO;
                int i2 = 0;
                while (i2 < storages.length) {
                    if (storages[i2].getM_AttributeSetInstance_ID() == this.getM_AttributeSetInstance_ID()) {
                        qty = qty.add(storages[i2].getQtyOnHand());
                    }
                    ++i2;
                }
                if (this.getQtyOrdered().compareTo(qty) > 0) {
                    this.log.warning("Qty - Stock=" + qty + ", Ordered=" + this.getQtyOrdered());
                    this.log.saveError("QtyInsufficient", "=" + qty);
                    return false;
                }
            }
        }
        if (Env.ZERO.compareTo(this.getFreightAmt()) != 0) {
            this.setFreightAmt(Env.ZERO);
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM C_OrderLine WHERE C_Order_ID=?";
            int ii = DB.getSQLValue(this.get_TrxName(), sql, this.getDD_Order_ID());
            this.setLine(ii);
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        if (Env.ZERO.compareTo(this.getQtyDelivered()) != 0) {
            this.log.saveError("DeleteError", String.valueOf(Msg.translate(this.getCtx(), "QtyDelivered")) + "=" + this.getQtyDelivered());
            return false;
        }
        if (Env.ZERO.compareTo(this.getQtyReserved()) != 0) {
            this.log.saveError("DeleteError", String.valueOf(Msg.translate(this.getCtx(), "QtyReserved")) + "=" + this.getQtyReserved());
            return false;
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return true;
    }

    public BigDecimal getQtyToDeliver() {
        return this.getQtyOrdered().subtract(this.getQtyInTransit()).subtract(this.getQtyDelivered());
    }
}

