/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wf;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.AdempiereProcessor2;
import org.compiere.model.AdempiereProcessorLog;
import org.compiere.model.MSchedule;
import org.compiere.model.Query;
import org.compiere.model.X_AD_WorkflowProcessor;
import org.compiere.util.DB;
import org.compiere.wf.MWorkflowProcessorLog;

public class MWorkflowProcessor
extends X_AD_WorkflowProcessor
implements AdempiereProcessor,
AdempiereProcessor2 {
    private static final long serialVersionUID = 6110376502075157361L;

    public static MWorkflowProcessor[] getActive(Properties ctx) {
        List<MWorkflowProcessor> list = new Query(ctx, "AD_WorkflowProcessor", null, null).setOnlyActiveRecords(true).list();
        MWorkflowProcessor[] retValue = new MWorkflowProcessor[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MWorkflowProcessor(Properties ctx, int AD_WorkflowProcessor_ID, String trxName) {
        super(ctx, AD_WorkflowProcessor_ID, trxName);
    }

    public MWorkflowProcessor(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String getServerID() {
        return "WorkflowProcessor" + this.get_ID();
    }

    @Override
    public Timestamp getDateNextRun(boolean requery) {
        if (requery) {
            this.load(this.get_TrxName());
        }
        return this.getDateNextRun();
    }

    @Override
    public AdempiereProcessorLog[] getLogs() {
        List<AdempiereProcessorLog> list = new Query(this.getCtx(), "AD_WorkflowProcessorLog", "AD_WorkflowProcessor_ID=?", this.get_TrxName()).setParameters(this.getAD_WorkflowProcessor_ID()).setOrderBy("Created DESC").list();
        AdempiereProcessorLog[] retValue = new MWorkflowProcessorLog[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int deleteLog() {
        if (this.getKeepLogDays() < 1) {
            return 0;
        }
        String sql = "DELETE AD_WorkflowProcessorLog WHERE AD_WorkflowProcessor_ID=" + this.getAD_WorkflowProcessor_ID() + " AND (Created+" + this.getKeepLogDays() + ") < SysDate";
        int no = DB.executeUpdate(sql, this.get_TrxName());
        return no;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        long nextWork;
        if ((newRecord || this.is_ValueChanged("AD_Schedule_ID")) && (nextWork = MSchedule.getNextRunMS(System.currentTimeMillis(), this.getScheduleType(), this.getFrequencyType(), this.getFrequency(), this.getCronPattern())) > 0L) {
            this.setDateNextRun(new Timestamp(nextWork));
        }
        return true;
    }

    @Override
    public String getFrequencyType() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getFrequencyType();
    }

    @Override
    public int getFrequency() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getFrequency();
    }

    @Override
    public boolean isIgnoreProcessingTime() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).isIgnoreProcessingTime();
    }

    @Override
    public String getScheduleType() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getScheduleType();
    }

    @Override
    public String getCronPattern() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getCronPattern();
    }
}

