/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wf;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.compiere.Adempiere;
import org.compiere.model.MColumn;
import org.compiere.model.MMenu;
import org.compiere.model.MProduct;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Workflow;
import org.compiere.process.DocAction;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.process.StateEngine;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWFProcess;
import org.compiere.wf.MWorkflowAccess;

public class MWorkflow
extends X_AD_Workflow {
    private static final long serialVersionUID = 1905448790453650036L;
    private static CCache<String, MWorkflow> s_cache = new CCache("AD_Workflow", 20);
    private static CCache<String, MWorkflow[]> s_cacheDocValue = new CCache("AD_Workflow", "AD_Workflow_Document_Value", 5);
    private static CLogger s_log = CLogger.getCLogger(MWorkflow.class);
    private List<MWFNode> m_nodes = new ArrayList<MWFNode>();
    private String m_name_trl = null;
    private String m_description_trl = null;
    private String m_help_trl = null;
    private boolean m_translated = false;

    public static MWorkflow get(Properties ctx, int AD_Workflow_ID) {
        String key = String.valueOf(Env.getAD_Language(ctx)) + "_" + AD_Workflow_ID;
        MWorkflow retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MWorkflow(ctx, AD_Workflow_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static MWorkflow[] getDocValue(Properties ctx, int AD_Client_ID, int AD_Table_ID, String trxName) {
        String key = "C" + AD_Client_ID + "T" + AD_Table_ID;
        if (s_cacheDocValue.isReset()) {
            String whereClause = "WorkflowType=? AND IsValid=?";
            List workflows = new Query(ctx, "AD_Workflow", "WorkflowType=? AND IsValid=?", trxName).setParameters("V", true).setOnlyActiveRecords(true).setOrderBy("AD_Client_ID, AD_Table_ID").list();
            ArrayList<MWorkflow> list = new ArrayList<MWorkflow>();
            String oldKey = "";
            String newKey = null;
            for (MWorkflow wf : workflows) {
                newKey = "C" + wf.getAD_Client_ID() + "T" + wf.getAD_Table_ID();
                if (!newKey.equals(oldKey) && list.size() > 0) {
                    MWorkflow[] wfs = new MWorkflow[list.size()];
                    list.toArray(wfs);
                    s_cacheDocValue.put(oldKey, wfs);
                    list = new ArrayList();
                }
                oldKey = newKey;
                list.add(wf);
            }
            if (list.size() > 0) {
                MWorkflow[] wfs = new MWorkflow[list.size()];
                list.toArray(wfs);
                s_cacheDocValue.put(oldKey, wfs);
            }
            if (s_log.isLoggable(Level.CONFIG)) {
                s_log.config("#" + s_cacheDocValue.size());
            }
        }
        MWorkflow[] retValue = s_cacheDocValue.get(key);
        return retValue;
    }

    public MWorkflow(Properties ctx, int AD_Workflow_ID, String trxName) {
        super(ctx, AD_Workflow_ID, trxName);
        if (AD_Workflow_ID == 0) {
            this.setAccessLevel("1");
            this.setAuthor("ComPiere, Inc.");
            this.setDurationUnit("D");
            this.setDuration(1);
            this.setEntityType("U");
            this.setIsDefault(false);
            this.setPublishStatus("U");
            this.setVersion(0);
            this.setCost(Env.ZERO);
            this.setWaitingTime(0);
            this.setWorkingTime(0);
            this.setIsBetaFunctionality(false);
        }
        this.loadTrl();
        this.loadNodes();
    }

    public MWorkflow(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.loadTrl();
        this.loadNodes();
    }

    private void loadTrl() {
        if (Env.isBaseLanguage(this.getCtx(), "AD_Workflow") || this.get_ID() == 0) {
            return;
        }
        String sql = "SELECT Name, Description, Help FROM AD_Workflow_Trl WHERE AD_Workflow_ID=? AND AD_Language=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.get_ID());
                pstmt.setString(2, Env.getAD_Language(this.getCtx()));
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.m_name_trl = rs.getString(1);
                    this.m_description_trl = rs.getString(2);
                    this.m_help_trl = rs.getString(3);
                    this.m_translated = true;
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Translated=" + this.m_translated);
        }
    }

    private void loadNodes() {
        this.m_nodes = new Query(this.getCtx(), "AD_WF_Node", "AD_WorkFlow_ID=?", this.get_TrxName()).setParameters(this.get_ID()).setOnlyActiveRecords(true).list();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_nodes.size());
        }
    }

    public int getNodeCount() {
        return this.m_nodes.size();
    }

    public MWFNode[] getNodes(boolean ordered, int AD_Client_ID) {
        if (ordered) {
            return this.getNodesInOrder(AD_Client_ID);
        }
        ArrayList<MWFNode> list = new ArrayList<MWFNode>();
        int i2 = 0;
        while (i2 < this.m_nodes.size()) {
            MWFNode node = this.m_nodes.get(i2);
            if (node.isActive() && (node.getAD_Client_ID() == 0 || node.getAD_Client_ID() == AD_Client_ID)) {
                list.add(node);
            }
            ++i2;
        }
        MWFNode[] retValue = new MWFNode[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public void reloadNodes() {
        this.m_nodes = null;
        this.loadNodes();
    }

    public MWFNode getFirstNode() {
        return this.getNode(this.getAD_WF_Node_ID());
    }

    protected MWFNode getNode(int AD_WF_Node_ID) {
        int i2 = 0;
        while (i2 < this.m_nodes.size()) {
            MWFNode node = this.m_nodes.get(i2);
            if (node.getAD_WF_Node_ID() == AD_WF_Node_ID) {
                return node;
            }
            ++i2;
        }
        return null;
    }

    public MWFNode[] getNextNodes(int AD_WF_Node_ID, int AD_Client_ID) {
        MWFNode node = this.getNode(AD_WF_Node_ID);
        if (node == null || node.getNextNodeCount() == 0) {
            return null;
        }
        MWFNodeNext[] nexts = node.getTransitions(AD_Client_ID);
        ArrayList<MWFNode> list = new ArrayList<MWFNode>();
        int i2 = 0;
        while (i2 < nexts.length) {
            MWFNode next = this.getNode(nexts[i2].getAD_WF_Next_ID());
            if (next != null) {
                list.add(next);
            }
            ++i2;
        }
        MWFNode[] retValue = new MWFNode[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    private MWFNode[] getNodesInOrder(int AD_Client_ID) {
        ArrayList<MWFNode> list = new ArrayList<MWFNode>();
        this.addNodesSF(list, this.getAD_WF_Node_ID(), AD_Client_ID);
        if (this.m_nodes.size() != list.size()) {
            int n = 0;
            while (n < this.m_nodes.size()) {
                MWFNode node = this.m_nodes.get(n);
                if (node.isActive() && (node.getAD_Client_ID() == 0 || node.getAD_Client_ID() == AD_Client_ID)) {
                    boolean found = false;
                    int i2 = 0;
                    while (i2 < list.size()) {
                        MWFNode existing = list.get(i2);
                        if (existing.getAD_WF_Node_ID() == node.getAD_WF_Node_ID()) {
                            found = true;
                            break;
                        }
                        ++i2;
                    }
                    if (!found) {
                        this.log.log(Level.WARNING, "Added Node w/o transition: " + node);
                        list.add(node);
                    }
                }
                ++n;
            }
        }
        MWFNode[] nodeArray = new MWFNode[list.size()];
        list.toArray(nodeArray);
        return nodeArray;
    }

    private void addNodesSF(ArrayList<MWFNode> list, int AD_WF_Node_ID, int AD_Client_ID) {
        ArrayList<MWFNode> tmplist = new ArrayList<MWFNode>();
        MWFNode node = this.getNode(AD_WF_Node_ID);
        if (node != null && (node.getAD_Client_ID() == 0 || node.getAD_Client_ID() == AD_Client_ID)) {
            if (!list.contains(node)) {
                list.add(node);
            }
            MWFNodeNext[] nexts = node.getTransitions(AD_Client_ID);
            int i2 = 0;
            while (i2 < nexts.length) {
                MWFNode child = this.getNode(nexts[i2].getAD_WF_Next_ID());
                if (child != null && child.isActive() && (child.getAD_Client_ID() == 0 || child.getAD_Client_ID() == AD_Client_ID) && !list.contains(child)) {
                    list.add(child);
                    tmplist.add(child);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < tmplist.size()) {
                this.addNodesSF(list, ((MWFNode)tmplist.get(i2)).get_ID(), AD_Client_ID);
                ++i2;
            }
        }
    }

    public int getNext(int AD_WF_Node_ID, int AD_Client_ID) {
        MWFNode[] nodes = this.getNodesInOrder(AD_Client_ID);
        int i2 = 0;
        while (i2 < nodes.length) {
            if (nodes[i2].getAD_WF_Node_ID() == AD_WF_Node_ID) {
                MWFNodeNext[] nexts = nodes[i2].getTransitions(AD_Client_ID);
                if (nexts.length > 0) {
                    return nexts[0].getAD_WF_Next_ID();
                }
                return 0;
            }
            ++i2;
        }
        return 0;
    }

    public MWFNodeNext[] getNodeNexts(int AD_WF_Node_ID, int AD_Client_ID) {
        MWFNode[] nodes = this.getNodesInOrder(AD_Client_ID);
        int i2 = 0;
        while (i2 < nodes.length) {
            if (nodes[i2].getAD_WF_Node_ID() == AD_WF_Node_ID) {
                return nodes[i2].getTransitions(AD_Client_ID);
            }
            ++i2;
        }
        return null;
    }

    public int getPrevious(int AD_WF_Node_ID, int AD_Client_ID) {
        MWFNode[] nodes = this.getNodesInOrder(AD_Client_ID);
        int i2 = 0;
        while (i2 < nodes.length) {
            if (nodes[i2].getAD_WF_Node_ID() == AD_WF_Node_ID) {
                if (i2 > 0) {
                    return nodes[i2 - 1].getAD_WF_Node_ID();
                }
                return 0;
            }
            ++i2;
        }
        return 0;
    }

    public int getLast(int AD_WF_Node_ID, int AD_Client_ID) {
        MWFNode[] nodes = this.getNodesInOrder(AD_Client_ID);
        if (nodes.length > 0) {
            return nodes[nodes.length - 1].getAD_WF_Node_ID();
        }
        return 0;
    }

    public boolean isFirst(int AD_WF_Node_ID, int AD_Client_ID) {
        return AD_WF_Node_ID == this.getAD_WF_Node_ID();
    }

    public boolean isLast(int AD_WF_Node_ID, int AD_Client_ID) {
        MWFNode[] nodes = this.getNodesInOrder(AD_Client_ID);
        return AD_WF_Node_ID == nodes[nodes.length - 1].getAD_WF_Node_ID();
    }

    public String getName(boolean translated) {
        if (translated && this.m_translated) {
            return this.m_name_trl;
        }
        return this.getName();
    }

    public String getDescription(boolean translated) {
        if (translated && this.m_translated) {
            return this.m_description_trl;
        }
        return this.getDescription();
    }

    public String getHelp(boolean translated) {
        if (translated && this.m_translated) {
            return this.m_help_trl;
        }
        return this.getHelp();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MWorkflow[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        this.validate();
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        int i2;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Success=" + success);
        }
        if (!success) {
            return false;
        }
        if (newRecord) {
            MWFNode[] nodes = this.getNodesInOrder(0);
            i2 = 0;
            while (i2 < nodes.length) {
                nodes[i2].saveEx(this.get_TrxName());
                ++i2;
            }
        }
        if (newRecord) {
            int AD_Role_ID = Env.getAD_Role_ID(this.getCtx());
            MWorkflowAccess wa = new MWorkflowAccess(this, AD_Role_ID);
            wa.saveEx();
        } else if (this.is_ValueChanged("IsActive") || this.is_ValueChanged("Name") || this.is_ValueChanged("Description")) {
            MMenu[] menues = MMenu.get(this.getCtx(), "AD_Workflow_ID=" + this.getAD_Workflow_ID(), this.get_TrxName());
            i2 = 0;
            while (i2 < menues.length) {
                menues[i2].setIsActive(this.isActive());
                menues[i2].setName(this.getName());
                menues[i2].setDescription(this.getDescription());
                menues[i2].saveEx();
                ++i2;
            }
        }
        return success;
    }

    public MWFProcess start(ProcessInfo pi) {
        return this.start(pi, null);
    }

    public MWFProcess start(ProcessInfo pi, String trxName) {
        MWFProcess retValue;
        block13: {
            retValue = null;
            Trx localTrx = null;
            if (trxName == null) {
                localTrx = Trx.get(Trx.createTrxName("WFP"), true);
                localTrx.setDisplayName(String.valueOf(this.getClass().getName()) + "_start");
            }
            try {
                try {
                    retValue = new MWFProcess(this, pi, trxName != null ? trxName : localTrx.getTrxName());
                    retValue.saveEx();
                    pi.setSummary(Msg.getMsg(this.getCtx(), "Processing"));
                    retValue.startWork();
                    if (localTrx != null) {
                        localTrx.commit(true);
                    }
                }
                catch (Exception e) {
                    if (localTrx != null) {
                        localTrx.rollback();
                    }
                    this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    pi.setSummary(e.getMessage(), true);
                    retValue = null;
                    if (localTrx != null) {
                        localTrx.close();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (localTrx != null) {
                    localTrx.close();
                }
                throw throwable;
            }
            if (localTrx != null) {
                localTrx.close();
            }
        }
        if (retValue != null) {
            String summary = retValue.getProcessMsg();
            StateEngine state = retValue.getState();
            if (summary == null || summary.trim().length() == 0) {
                summary = state.toString();
            }
            pi.setSummary(summary, state.isTerminated() || state.isAborted());
        }
        return retValue;
    }

    public MWFProcess startWait(ProcessInfo pi) {
        int SLEEP = 500;
        int MAXLOOPS = 30;
        MWFProcess process = this.start(pi, pi.getTransactionName());
        if (process == null) {
            return null;
        }
        Thread.yield();
        StateEngine state = process.getState();
        int loops = 0;
        while (!state.isClosed() && !state.isSuspended()) {
            if (loops > 30) {
                this.log.warning("Timeout after sec 15");
                pi.setSummary(Msg.getMsg(this.getCtx(), "ProcessRunning"));
                pi.setIsTimeout(true);
                return process;
            }
            try {
                Thread.sleep(500L);
                ++loops;
            }
            catch (InterruptedException e) {
                this.log.log(Level.SEVERE, "startWait interrupted", e);
                pi.setSummary("Interrupted");
                return process;
            }
            Thread.yield();
            state = process.getState();
        }
        String summary = process.getProcessMsg();
        if (summary == null || summary.trim().length() == 0) {
            summary = state.toString();
        }
        pi.setSummary(summary, state.isTerminated() || state.isAborted());
        this.log.fine(summary);
        return process;
    }

    public long getDurationBaseSec() {
        if (this.getDurationUnit() == null) {
            return 0L;
        }
        if ("s".equals(this.getDurationUnit())) {
            return 1L;
        }
        if ("m".equals(this.getDurationUnit())) {
            return 60L;
        }
        if ("h".equals(this.getDurationUnit())) {
            return 3600L;
        }
        if ("D".equals(this.getDurationUnit())) {
            return 86400L;
        }
        if ("M".equals(this.getDurationUnit())) {
            return 2592000L;
        }
        if ("Y".equals(this.getDurationUnit())) {
            return 31536000L;
        }
        return 0L;
    }

    public int getDurationCalendarField() {
        if (this.getDurationUnit() == null) {
            return 12;
        }
        if ("s".equals(this.getDurationUnit())) {
            return 13;
        }
        if ("m".equals(this.getDurationUnit())) {
            return 12;
        }
        if ("h".equals(this.getDurationUnit())) {
            return 10;
        }
        if ("D".equals(this.getDurationUnit())) {
            return 6;
        }
        if ("M".equals(this.getDurationUnit())) {
            return 2;
        }
        if ("Y".equals(this.getDurationUnit())) {
            return 1;
        }
        return 12;
    }

    public String validate() {
        StringBuffer errors = new StringBuffer();
        if (this.getAD_WF_Node_ID() == 0) {
            errors.append(" - No Start Node");
        }
        if ("V".equals(this.getWorkflowType()) && (this.getDocValueLogic() == null || this.getDocValueLogic().length() == 0)) {
            errors.append(" - No Document Value Logic");
        }
        if (this.getWorkflowType().equals("M")) {
            this.setAD_Table_ID(0);
        }
        boolean valid = errors.length() == 0;
        this.setIsValid(valid);
        if (!valid && this.log.isLoggable(Level.INFO)) {
            this.log.info("validate: " + errors);
        }
        return errors.toString();
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        MWorkflow wf = new MWorkflow(Env.getCtx(), 0, null);
        wf.setValue("Process_xx");
        wf.setName(wf.getValue());
        wf.setDescription("(Standard " + wf.getValue());
        wf.setEntityType("D");
        wf.saveEx();
        MWFNode node10 = new MWFNode(wf, "10", "(Start)");
        node10.setDescription("(Standard Node)");
        node10.setEntityType("D");
        node10.setAction("Z");
        node10.setWaitTime(0);
        node10.setPosition(5, 5);
        node10.saveEx();
        wf.setAD_WF_Node_ID(node10.getAD_WF_Node_ID());
        wf.saveEx();
        MWFNode node20 = new MWFNode(wf, "20", "(DocAuto)");
        node20.setDescription("(Standard Node)");
        node20.setEntityType("D");
        node20.setAction("D");
        node20.setDocAction("--");
        node20.setPosition(5, 120);
        node20.saveEx();
        MWFNodeNext tr10_20 = new MWFNodeNext(node10, node20.getAD_WF_Node_ID());
        tr10_20.setEntityType("D");
        tr10_20.setDescription("(Standard Transition)");
        tr10_20.setSeqNo(100);
        tr10_20.saveEx();
        MWFNode node100 = new MWFNode(wf, "100", "(DocPrepare)");
        node100.setDescription("(Standard Node)");
        node100.setEntityType("D");
        node100.setAction("D");
        node100.setDocAction("PR");
        node100.setPosition(170, 5);
        node100.saveEx();
        MWFNodeNext tr10_100 = new MWFNodeNext(node10, node100.getAD_WF_Node_ID());
        tr10_100.setEntityType("D");
        tr10_100.setDescription("(Standard Approval)");
        tr10_100.setIsStdUserWorkflow(true);
        tr10_100.setSeqNo(10);
        tr10_100.saveEx();
        MWFNode node200 = new MWFNode(wf, "200", "(DocComplete)");
        node200.setDescription("(Standard Node)");
        node200.setEntityType("D");
        node200.setAction("D");
        node200.setDocAction("CO");
        node200.setPosition(170, 120);
        node200.saveEx();
        MWFNodeNext tr100_200 = new MWFNodeNext(node100, node200.getAD_WF_Node_ID());
        tr100_200.setEntityType("D");
        tr100_200.setDescription("(Standard Transition)");
        tr100_200.setSeqNo(100);
        tr100_200.saveEx();
    }

    public static int getWorkflowSearchKey(MProduct product) {
        int AD_Client_ID = Env.getAD_Client_ID(product.getCtx());
        String sql = "SELECT AD_Workflow_ID FROM AD_Workflow  WHERE Value = ? AND AD_Client_ID = ?";
        return DB.getSQLValueEx(null, sql, product.getValue(), AD_Client_ID);
    }

    public boolean isValidFromTo(Timestamp date) {
        Timestamp validFrom = this.getValidFrom();
        Timestamp validTo = this.getValidTo();
        if (validFrom != null && date.before(validFrom)) {
            return false;
        }
        return validTo == null || !date.after(validTo);
    }

    public static ProcessInfo runDocumentActionWorkflow(PO po, String docAction) {
        int AD_Table_ID = po.get_Table_ID();
        MTable table2 = MTable.get(Env.getCtx(), AD_Table_ID);
        MColumn column = table2.getColumn("DocAction");
        if (column == null) {
            return null;
        }
        if (!docAction.equals(po.get_Value(column.getColumnName()))) {
            po.set_ValueOfColumn(column.getColumnName(), (Object)docAction);
            po.saveEx();
        }
        ProcessInfo processInfo = new ProcessInfo(((DocAction)((Object)po)).getDocumentInfo(), column.getAD_Process_ID(), po.get_Table_ID(), po.get_ID());
        processInfo.setTransactionName(po.get_TrxName());
        processInfo.setPO(po);
        ServerProcessCtl.process(processInfo, Trx.get(processInfo.getTransactionName(), false));
        return processInfo;
    }
}

