/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.Adempiere;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.TrxEventListener;
import org.compiere.util.TrxRunnable;

public class Trx {
    private static final Map<String, Trx> s_cache = new ConcurrentHashMap<String, Trx>();
    private static final TrxMonitor s_monitor = new TrxMonitor();
    private List<TrxEventListener> listeners = new ArrayList<TrxEventListener>();
    protected Exception trace;
    private String m_displayName;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private Connection m_connection = null;
    private String m_trxName = null;
    private boolean m_active = false;
    private long m_startTime;
    private int m_timeout = 7200;

    public static Trx get(String trxName, boolean createNew) {
        if (trxName == null || trxName.length() == 0) {
            throw new IllegalArgumentException("No Transaction Name");
        }
        Trx retValue = s_cache.get(trxName);
        if (retValue == null && createNew) {
            retValue = new Trx(trxName);
            s_cache.put(trxName, retValue);
        }
        return retValue;
    }

    public static void startTrxMonitor() {
        Adempiere.getThreadPoolExecutor().scheduleWithFixedDelay(s_monitor, 5L, 5L, TimeUnit.MINUTES);
    }

    public static String createTrxName(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            prefix = "Trx";
        }
        prefix = String.valueOf(prefix) + "_" + UUID.randomUUID();
        Trx.get(prefix, true);
        return prefix;
    }

    public static String createTrxName() {
        return Trx.createTrxName(null);
    }

    private Trx(String trxName) {
        this(trxName, null);
    }

    private Trx(String trxName, Connection con) {
        this.setTrxName(trxName);
        if (trxName.length() < 36) {
            String msg = "Illegal transaction name format, not prefix+UUID or UUID: " + trxName;
            this.log.log(Level.SEVERE, msg, new Exception(msg));
        }
        this.setConnection(con);
    }

    public Connection getConnection() {
        return this.getConnection(true);
    }

    public synchronized Connection getConnection(boolean createNew) {
        if (this.log.isLoggable(Level.ALL)) {
            this.log.log(Level.ALL, "Active=" + this.isActive() + ", Connection=" + this.m_connection);
        }
        if (this.m_connection == null) {
            if (createNew) {
                if (!s_cache.containsKey(this.m_trxName)) {
                    new Exception("Illegal to getConnection for Trx that is not register.").printStackTrace();
                    return null;
                }
                this.setConnection(DB.createConnection(false, 2));
            } else {
                return null;
            }
        }
        if (!this.isActive()) {
            this.start();
        }
        if (MSysConfig.getBooleanValue("TRACE_ALL_TRX_CONNECTION_GET", false)) {
            this.trace = new Exception();
        }
        return this.m_connection;
    }

    private void setConnection(Connection conn) {
        if (conn == null) {
            return;
        }
        this.m_connection = conn;
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Connection=" + conn);
        }
        try {
            this.m_connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "connection", e);
        }
        this.trace = new Exception();
    }

    private void setTrxName(String trxName) {
        if (trxName == null || trxName.length() == 0) {
            throw new IllegalArgumentException("No Transaction Name");
        }
        this.m_trxName = trxName;
    }

    public String getTrxName() {
        return this.m_trxName;
    }

    public boolean start() {
        if (this.m_active) {
            this.log.warning("Trx in progress " + this.m_trxName);
            return false;
        }
        this.m_active = true;
        this.m_startTime = System.currentTimeMillis();
        return true;
    }

    public Date getStartTime() {
        return new Date(this.m_startTime);
    }

    public boolean isActive() {
        return this.m_active;
    }

    public synchronized boolean rollback(boolean throwException) throws SQLException {
        block3: {
            try {
                if (this.m_connection != null) {
                    this.m_connection.rollback();
                    this.log.log(this.isLocalTrx(this.m_trxName) ? Level.FINE : Level.INFO, "**** " + this.m_trxName);
                    this.m_active = false;
                    this.fireAfterRollbackEvent(true);
                    return true;
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, this.m_trxName, e);
                if (!throwException) break block3;
                this.m_active = false;
                this.fireAfterRollbackEvent(false);
                throw e;
            }
        }
        this.m_active = false;
        this.fireAfterRollbackEvent(false);
        return false;
    }

    private void fireAfterRollbackEvent(boolean success) {
        TrxEventListener[] copies;
        TrxEventListener[] trxEventListenerArray = copies = this.listeners.toArray(new TrxEventListener[0]);
        int n = copies.length;
        int n2 = 0;
        while (n2 < n) {
            TrxEventListener l = trxEventListenerArray[n2];
            l.afterRollback(this, success);
            ++n2;
        }
    }

    public boolean rollback() {
        try {
            return this.rollback(false);
        }
        catch (SQLException e) {
            return false;
        }
    }

    public boolean rollback(Savepoint savepoint) throws SQLException {
        try {
            if (this.m_connection != null) {
                this.m_connection.rollback(savepoint);
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("**** " + this.m_trxName);
                }
                return true;
            }
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, this.m_trxName, e);
            throw e;
        }
        return false;
    }

    public synchronized boolean commit(boolean throwException) throws SQLException {
        try {
            if (this.m_connection != null) {
                this.m_connection.commit();
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("**** " + this.m_trxName);
                }
                this.m_active = false;
                this.fireAfterCommitEvent(true);
                return true;
            }
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, this.m_trxName, e);
            if (throwException) {
                this.m_active = false;
                this.fireAfterCommitEvent(false);
                throw e;
            }
            String msg = DBException.getDefaultDBExceptionMessage(e);
            this.log.saveError(msg != null ? msg : e.getLocalizedMessage(), e);
        }
        this.m_active = false;
        this.fireAfterCommitEvent(false);
        return false;
    }

    private void fireAfterCommitEvent(boolean success) {
        TrxEventListener[] copies;
        TrxEventListener[] trxEventListenerArray = copies = this.listeners.toArray(new TrxEventListener[0]);
        int n = copies.length;
        int n2 = 0;
        while (n2 < n) {
            TrxEventListener l = trxEventListenerArray[n2];
            l.afterCommit(this, success);
            ++n2;
        }
    }

    public boolean commit() {
        try {
            return this.commit(false);
        }
        catch (SQLException e) {
            return false;
        }
    }

    public synchronized boolean rollbackAndCloseOnTimeout() {
        s_cache.remove(this.getTrxName());
        if (this.m_connection == null) {
            return true;
        }
        if (this.isActive()) {
            this.rollback();
        }
        try {
            this.m_connection.close();
            this.m_connection = null;
            this.m_active = false;
            this.fireAfterCloseEvent();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, this.m_trxName, e);
        }
        this.log.config(this.m_trxName);
        return true;
    }

    public synchronized boolean close() {
        block13: {
            s_cache.remove(this.getTrxName());
            if (this.m_connection == null) {
                return true;
            }
            if (this.isActive()) {
                this.commit();
            }
            try {
                try {
                    this.m_connection.setAutoCommit(true);
                }
                catch (SQLException sQLException) {
                    try {
                        this.m_connection.close();
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, this.m_trxName, e);
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.m_connection.close();
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, this.m_trxName, e);
                }
                throw throwable;
            }
            try {
                this.m_connection.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, this.m_trxName, e);
            }
        }
        this.m_connection = null;
        this.trace = null;
        this.m_active = false;
        this.fireAfterCloseEvent();
        this.log.config(this.m_trxName);
        return true;
    }

    private void fireAfterCloseEvent() {
        TrxEventListener[] copies;
        TrxEventListener[] trxEventListenerArray = copies = this.listeners.toArray(new TrxEventListener[0]);
        int n = copies.length;
        int n2 = 0;
        while (n2 < n) {
            TrxEventListener l = trxEventListenerArray[n2];
            l.afterClose(this);
            ++n2;
        }
    }

    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        if (this.m_connection == null) {
            this.getConnection();
        }
        if (this.m_connection != null) {
            if (name != null) {
                return this.m_connection.setSavepoint(name);
            }
            return this.m_connection.setSavepoint();
        }
        return null;
    }

    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (DB.isOracle()) {
            return;
        }
        if (this.m_connection == null) {
            this.getConnection();
        }
        if (this.m_connection != null) {
            this.m_connection.releaseSavepoint(savepoint);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Trx[");
        sb.append(this.getDisplayName()).append(",Active=").append(this.isActive()).append("]");
        return sb.toString();
    }

    public static Trx[] getActiveTransactions() {
        Collection<Trx> collections = s_cache.values();
        Trx[] trxs = new Trx[collections.size()];
        collections.toArray(trxs);
        return trxs;
    }

    public static void run(TrxRunnable r) {
        Trx.run(null, r);
    }

    public static void run(String trxName, TrxRunnable r) {
        boolean localTrx = false;
        if (trxName == null) {
            trxName = Trx.createTrxName("TrxRun");
            localTrx = true;
        }
        Trx trx = Trx.get(trxName, true);
        Savepoint savepoint = null;
        try {
            try {
                if (!localTrx) {
                    savepoint = trx.setSavepoint(null);
                }
                r.run(trxName);
                if (localTrx) {
                    trx.commit(true);
                }
            }
            catch (Throwable e) {
                if (localTrx) {
                    trx.rollback();
                } else if (savepoint != null) {
                    try {
                        trx.rollback(savepoint);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new AdempiereException(e);
            }
        }
        finally {
            if (localTrx && trx != null) {
                trx.close();
                trx = null;
            }
        }
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    public void setTimeout(int timeout) {
        this.m_timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrxEventListener(TrxEventListener listener) {
        List<TrxEventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTrxEventListener(TrxEventListener listener) {
        List<TrxEventListener> list = this.listeners;
        synchronized (list) {
            return this.listeners.remove(listener);
        }
    }

    public String getStrackTrace() {
        if (this.trace != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.trace.printStackTrace(printWriter);
            return stringWriter.getBuffer().toString();
        }
        return "";
    }

    public String getDisplayName() {
        return this.m_displayName != null ? this.m_displayName : this.m_trxName;
    }

    public void setDisplayName(String displayName) {
        this.m_displayName = displayName;
    }

    private boolean isLocalTrx(String trxName) {
        return trxName == null || trxName.startsWith("POSave");
    }

    protected void finalize() throws Throwable {
        if (this.m_connection != null && this.trace != null) {
            final Trx me = this;
            Adempiere.getThreadPoolExecutor().schedule(new Runnable(){

                @Override
                public void run() {
                    if (me.m_connection != null && me.trace != null) {
                        Trx.this.log.log(Level.WARNING, "Trx Not Close: " + me.getStrackTrace());
                        me.trace = null;
                        me.close();
                    }
                }
            }, 2L, TimeUnit.SECONDS);
        }
    }

    static class TrxMonitor
    implements Runnable {
        TrxMonitor() {
        }

        @Override
        public void run() {
            if (!s_cache.isEmpty()) {
                Trx[] trxs = s_cache.values().toArray(new Trx[0]);
                int i2 = 0;
                while (i2 < trxs.length) {
                    long since;
                    if (trxs[i2].m_startTime > 0L && (since = System.currentTimeMillis() - trxs[i2].m_startTime) > (long)(trxs[i2].getTimeout() * 1000)) {
                        trxs[i2].log.log(Level.WARNING, "Transaction timeout. Name=" + trxs[i2].getTrxName() + ", timeout(sec)=" + since / 1000L);
                        if (trxs[i2].trace != null) {
                            trxs[i2].log.log(Level.WARNING, "Transaction timeout. Trace:\n" + trxs[i2].getStrackTrace());
                        }
                        trxs[i2].rollbackAndCloseOnTimeout();
                    }
                    ++i2;
                }
            }
        }
    }
}

