/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.crypto.Cipher;
import org.adempiere.base.Core;
import org.adempiere.base.IKeyStore;
import org.compiere.util.CLogger;
import org.compiere.util.DefaultKeyStore;
import org.compiere.util.SecureInterface;

public class Secure
implements SecureInterface {
    private MessageDigest m_md = null;
    private IKeyStore m_keyStore = null;
    private static CLogger log = CLogger.getCLogger(Secure.class.getName());

    public static int hash(String key) {
        long tableSize = Integer.MAX_VALUE;
        long hashValue = 0L;
        int i2 = 0;
        while (i2 < key.length()) {
            hashValue = 37L * hashValue + (long)(key.charAt(i2) - 31);
            ++i2;
        }
        if ((hashValue %= tableSize) < 0L) {
            hashValue += tableSize;
        }
        int retValue = (int)hashValue;
        return retValue;
    }

    public static String convertToHexString(byte[] bytes) {
        int size = bytes.length;
        StringBuilder buffer = new StringBuilder(size * 2);
        int i2 = 0;
        while (i2 < size) {
            String tmp;
            int x = bytes[i2];
            if (x < 0) {
                x += 256;
            }
            if ((tmp = Integer.toHexString(x)).length() == 1) {
                buffer.append("0");
            }
            buffer.append(tmp);
            ++i2;
        }
        return buffer.toString();
    }

    public static byte[] convertHexString(String hexString) {
        if (hexString == null || hexString.length() == 0) {
            return null;
        }
        int size = hexString.length() / 2;
        byte[] retValue = new byte[size];
        String inString = hexString.toLowerCase();
        try {
            int i2 = 0;
            while (i2 < size) {
                int index = i2 * 2;
                int ii = Integer.parseInt(inString.substring(index, index + 2), 16);
                retValue[i2] = (byte)ii;
                ++i2;
            }
            return retValue;
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(String.valueOf(hexString) + " - " + e.getLocalizedMessage());
            }
            return null;
        }
    }

    public Secure() {
        this.initCipher();
    }

    private synchronized void initCipher() {
        if (this.m_keyStore == null) {
            this.m_keyStore = this.getKeyStore();
        }
    }

    @Override
    public String encrypt(String value, int AD_Client_ID) {
        String clearText = value;
        if (clearText == null) {
            clearText = "";
        }
        if (this.m_keyStore == null) {
            this.initCipher();
        }
        try {
            Cipher cipher = Cipher.getInstance(this.m_keyStore.getAlgorithm());
            cipher.init(1, this.m_keyStore.getKey(AD_Client_ID));
            byte[] encBytes = cipher.doFinal(clearText.getBytes("UTF8"));
            String encString = Secure.convertToHexString(encBytes);
            return encString;
        }
        catch (Exception ex) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "Problem encrypting string", ex);
            }
            return "xyz" + value;
        }
    }

    @Override
    public String decrypt(String value, int AD_Client_ID) {
        block8: {
            byte[] data;
            boolean isEncrypted;
            if (value == null || value.length() == 0) {
                return value;
            }
            boolean bl = isEncrypted = value.startsWith("~") && value.endsWith("~");
            if (isEncrypted) {
                value = value.substring("~".length(), value.length() - "~".length());
            }
            if ((data = Secure.convertHexString(value)) == null) {
                if (isEncrypted) {
                    log.info("Failed");
                    return null;
                }
                return value;
            }
            if (this.m_keyStore == null) {
                this.initCipher();
            }
            if (value != null && value.length() > 0) {
                try {
                    Cipher cipher = Cipher.getInstance(this.m_keyStore.getAlgorithm());
                    AlgorithmParameters ap = cipher.getParameters();
                    cipher.init(2, (Key)this.m_keyStore.getKey(AD_Client_ID), ap);
                    byte[] out = cipher.doFinal(data);
                    String retValue = new String(out, "UTF8");
                    return retValue;
                }
                catch (Exception ex) {
                    if (!log.isLoggable(Level.INFO)) break block8;
                    log.info("Failed decrypting " + ex.toString());
                }
            }
        }
        return null;
    }

    @Override
    public Integer encrypt(Integer value, int ad_client_id) {
        return value;
    }

    @Override
    public Integer decrypt(Integer value, int ad_client_id) {
        return value;
    }

    @Override
    public BigDecimal encrypt(BigDecimal value, int ad_client_id) {
        return value;
    }

    @Override
    public BigDecimal decrypt(BigDecimal value, int ad_client_id) {
        return value;
    }

    @Override
    public Timestamp encrypt(Timestamp value, int ad_client_id) {
        return value;
    }

    @Override
    public Timestamp decrypt(Timestamp value, int ad_client_id) {
        return value;
    }

    @Override
    public String getDigest(String value) {
        if (this.m_md == null) {
            try {
                this.m_md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException nsae) {
                nsae.printStackTrace();
            }
        }
        byte[] input2 = value.getBytes();
        byte[] output = null;
        if (this.m_md != null) {
            this.m_md.reset();
            this.m_md.update(input2);
            output = this.m_md.digest();
            this.m_md.reset();
        }
        return Secure.convertToHexString(output);
    }

    @Override
    public boolean isDigest(String value) {
        if (value == null || value.length() != 32) {
            return false;
        }
        return Secure.convertHexString(value) != null;
    }

    @Override
    public String getSHA512Hash(int iterations, String value, byte[] salt) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest digest = MessageDigest.getInstance("SHA-512");
        digest.reset();
        digest.update(salt);
        byte[] input2 = digest.digest(value.getBytes("UTF-8"));
        int i2 = 0;
        while (i2 < iterations) {
            digest.reset();
            input2 = digest.digest(input2);
            ++i2;
        }
        digest.reset();
        return Secure.convertToHexString(input2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Secure[");
        sb.append(this.m_keyStore.getAlgorithm()).append("]");
        return sb.toString();
    }

    public IKeyStore getKeyStore() {
        IKeyStore keyStore = Core.getKeyStore();
        if (keyStore == null) {
            keyStore = new DefaultKeyStore();
        }
        return keyStore;
    }
}

