/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.compiere.util.CLogger;

public class FileUpload {
    protected CLogger log;
    private String m_fileName;
    private byte[] m_data;
    private String m_error;
    private String m_requestDataString;

    public static form createForm(String action) {
        form upload = new form(action, "post", "multipart/form-data");
        upload.addElement((Element)new label("File").setFor("file"));
        String textbtn = "file";
        String text = "Browse";
        input filebtn = new input("file", textbtn, "  " + text);
        filebtn.setSize(40);
        filebtn.setID(text);
        filebtn.setClass("filebtn");
        upload.addElement((Element)filebtn);
        textbtn = "upload";
        text = "Upload";
        input submitbtn = new input("submit", textbtn, "  " + text);
        submitbtn.setID(text);
        submitbtn.setClass("submitbtn");
        upload.addElement((Element)submitbtn);
        return upload;
    }

    public FileUpload(HttpServletRequest request) {
        block2: {
            this.log = CLogger.getCLogger(this.getClass());
            this.m_fileName = null;
            this.m_data = null;
            this.m_error = null;
            this.m_requestDataString = null;
            try {
                this.m_error = this.upload(request);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "FileUpload", e);
                this.m_error = e.getLocalizedMessage();
                if (this.m_error != null && this.m_error.length() != 0) break block2;
                this.m_error = e.toString();
            }
        }
    }

    public byte[] getData() {
        return this.m_data;
    }

    public String getFileName() {
        int index;
        if (this.m_fileName != null && (index = Math.max(this.m_fileName.lastIndexOf(47), this.m_fileName.lastIndexOf(92))) > 0) {
            return this.m_fileName.substring(index + 1);
        }
        return this.m_fileName;
    }

    public String getError() {
        return this.m_error;
    }

    private String upload(HttpServletRequest request) throws ServletException, IOException {
        int sizeKB;
        int MAX_KB = 250;
        int formDataLength = request.getContentLength();
        String contentType = request.getContentType();
        int index = contentType.lastIndexOf(61);
        String boundary = contentType.substring(index + 1);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(formDataLength) + " - " + boundary);
        }
        if ((sizeKB = formDataLength / 1024) > 250) {
            this.log.warning("File too large " + sizeKB);
            return "File too large = " + sizeKB + "kB - Allowed = " + 250 + "kB";
        }
        DataInputStream in = new DataInputStream((InputStream)request.getInputStream());
        byte[] data = new byte[formDataLength];
        int bytesRead = 0;
        int totalBytesRead = 0;
        while (totalBytesRead < formDataLength) {
            bytesRead = in.read(data, totalBytesRead, formDataLength);
            totalBytesRead += bytesRead;
        }
        this.m_requestDataString = new String(data, "ISO-8859-1");
        if (this.m_requestDataString.length() != data.length) {
            return "Internal conversion Error";
        }
        index = this.m_requestDataString.indexOf("filename=\"");
        this.m_fileName = this.m_requestDataString.substring(index + 10);
        index = this.m_fileName.indexOf(34);
        if (index < 1) {
            return "No File Name";
        }
        this.m_fileName = this.m_fileName.substring(0, index);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("upload - " + this.m_fileName);
        }
        int posStart = this.m_requestDataString.indexOf("filename=\"");
        posStart = this.m_requestDataString.indexOf("\n", posStart) + 1;
        posStart = this.m_requestDataString.indexOf("\n", posStart) + 1;
        posStart = this.m_requestDataString.indexOf("\n", posStart) + 1;
        int posEnd = this.m_requestDataString.indexOf(boundary, posStart) - 4;
        int length = posEnd - posStart;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("uploadFile - Start=" + posStart + ", End=" + posEnd + ", Length=" + length);
        }
        this.m_data = new byte[length];
        int i2 = 0;
        while (i2 < length) {
            this.m_data[i2] = data[posStart + i2];
            ++i2;
        }
        return null;
    }

    public String getParameter(String parameterName) {
        if (this.m_requestDataString == null) {
            return null;
        }
        String retValue = null;
        String search = "name=\"" + parameterName + "\"";
        int index = this.m_requestDataString.indexOf(search);
        if (index <= 0) {
            this.log.warning("getParameter Not found - " + parameterName);
            return null;
        }
        retValue = this.m_requestDataString.substring(index);
        retValue = retValue.substring(retValue.indexOf("\n") + 1);
        retValue = retValue.substring(retValue.indexOf("\n") + 1);
        retValue = retValue.substring(0, retValue.indexOf("\n"));
        retValue = retValue.trim();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("getParameter = " + parameterName + "=" + retValue);
        }
        return retValue;
    }

    public int getParameterAsInt(String parameterName) {
        String result = this.getParameter(parameterName);
        try {
            if (result != null && result.length() > 0) {
                return Integer.parseInt(result);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getParameterAsInt - " + parameterName + "=" + result, e);
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FileUpload[");
        if (this.m_fileName != null) {
            sb.append(this.m_fileName);
        }
        if (this.m_error != null) {
            sb.append(";Error=").append(this.m_error);
        }
        if (this.m_data != null) {
            sb.append(";Length=").append(this.m_data.length);
        }
        sb.append("]");
        return sb.toString();
    }
}

