/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.adempiere.base.Core;
import org.adempiere.base.IResourceFinder;
import org.adempiere.util.IProcessUI;
import org.adempiere.util.ServerContext;
import org.adempiere.util.ServerContextProvider;
import org.compiere.db.CConnection;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MLookupCache;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MSession;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MZoomCondition;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CCache;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CacheMgt;
import org.compiere.util.ContextProvider;
import org.compiere.util.DB;
import org.compiere.util.DefaultContextProvider;
import org.compiere.util.DisplayType;
import org.compiere.util.IEnvEventListener;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Util;

public final class Env {
    public static final String STANDARD_REPORT_FOOTER_TRADEMARK_TEXT = "#STANDARD_REPORT_FOOTER_TRADEMARK_TEXT";
    public static final String AD_ROLE_ID = "#AD_Role_ID";
    public static final String AD_USER_ID = "#AD_User_ID";
    public static final String AD_ORG_ID = "#AD_Org_ID";
    public static final String AD_CLIENT_ID = "#AD_Client_ID";
    public static final String AD_ORG_NAME = "#AD_Org_Name";
    public static final String M_WAREHOUSE_ID = "#M_Warehouse_ID";
    private static final ContextProvider clientContextProvider = new DefaultContextProvider();
    private static List<IEnvEventListener> eventListeners = new ArrayList<IEnvEventListener>();
    public static int adWindowDummyID = 200054;
    private static CLogger log = CLogger.getCLogger(Env.class);
    public static final int WINDOW_MAIN = 0;
    public static final int TAB_INFO = 1113;
    public static final String LANGUAGE = "#AD_Language";
    public static final String POS_ID = "#POS_ID";
    private static CCache<Integer, GridWindowVO> s_windowsvo = new CCache("AD_Window", 10);
    public static final BigDecimal ZERO = BigDecimal.valueOf(0.0);
    public static final BigDecimal ONE = BigDecimal.valueOf(1.0);
    public static final BigDecimal ONEHUNDRED = BigDecimal.valueOf(100.0);
    public static final String NL = System.getProperty("line.separator");

    static {
        Env.getCtx().put(LANGUAGE, Language.getBaseAD_Language());
    }

    public static void setContextProvider(ContextProvider provider) {
    }

    public static void addEventListener(IEnvEventListener listener) {
        eventListeners.add(listener);
    }

    public static boolean removeEventListener(IEnvEventListener listener) {
        return eventListeners.remove(listener);
    }

    public static void exitEnv(int status) {
        MSession session;
        if (DB.isConnected(false) && (session = MSession.get(Env.getCtx(), false)) != null) {
            session.logout();
        }
        Env.reset(true);
        CLogMgt.shutdown();
        if (Ini.isClient()) {
            System.exit(status);
        }
    }

    public static void logout() {
        MSession session = MSession.get(Env.getCtx(), false);
        if (session != null) {
            session.logout();
        }
        Env.reset(true);
        CConnection.get().setAppServerCredential(null, null);
    }

    public static void reset(boolean finalCall) {
        IEnvEventListener[] listeners;
        IEnvEventListener[] iEnvEventListenerArray = listeners = eventListeners.toArray(new IEnvEventListener[0]);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IEnvEventListener listener = iEnvEventListenerArray[n2];
            listener.onReset(finalCall);
            ++n2;
        }
        if (finalCall) {
            Env.getCtx().clear();
        } else {
            Object[] keys = Env.getCtx().keySet().toArray();
            int i2 = 0;
            while (i2 < keys.length) {
                String tag = keys[i2].toString();
                if (Character.isDigit(tag.charAt(0))) {
                    Env.getCtx().remove(keys[i2]);
                }
                ++i2;
            }
        }
        if (Ini.isClient()) {
            DB.closeTarget();
        }
        if (!finalCall) {
            MRole defaultRole;
            if (Ini.isClient()) {
                CacheMgt.get().resetLocalCache();
                DB.setDBTarget(CConnection.get());
            }
            if ((defaultRole = MRole.getDefault(Env.getCtx(), false)) != null) {
                defaultRole.loadAccess(true);
            }
        }
    }

    public static final Properties getCtx() {
        return Env.getContextProvider().getContext();
    }

    public static ContextProvider getContextProvider() {
        if (Ini.isClient()) {
            return clientContextProvider;
        }
        return ServerContextProvider.INSTANCE;
    }

    public static void setCtx(Properties ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        if (ServerContext.getCurrentInstance() == ctx) {
            return;
        }
        Env.getCtx().clear();
        Env.getCtx().putAll((Map<?, ?>)ctx);
    }

    public static void setContext(Properties ctx, String context, String value) {
        if (ctx == null || context == null) {
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Context " + context + "==" + value);
        }
        if (value == null || value.length() == 0) {
            ctx.remove(context);
        } else {
            ctx.setProperty(context, value);
        }
    }

    public static void setContext(Properties ctx, String context, Timestamp value) {
        if (ctx == null || context == null) {
            return;
        }
        if (value == null) {
            ctx.remove(context);
            if (log.isLoggable(Level.FINER)) {
                log.finer("Context " + context + "==" + value);
            }
        } else {
            String stringValue = "";
            Calendar c1 = Calendar.getInstance();
            c1.setTime(value);
            stringValue = DisplayType.getTimestampFormat_Default().format(c1.getTime());
            ctx.setProperty(context, stringValue);
            if (log.isLoggable(Level.FINER)) {
                log.finer("Context " + context + "==" + stringValue);
            }
        }
    }

    public static void setContext(Properties ctx, String context, int value) {
        if (ctx == null || context == null) {
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Context " + context + "==" + value);
        }
        ctx.setProperty(context, String.valueOf(value));
    }

    public static void setContext(Properties ctx, String context, boolean value) {
        Env.setContext(ctx, context, Env.convert(value));
    }

    public static void setContext(Properties ctx, int WindowNo, String context, String value) {
        if (ctx == null || context == null) {
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Context(" + WindowNo + ") " + context + "==" + value);
        }
        if (value == null || value.equals("")) {
            ctx.remove(String.valueOf(WindowNo) + "|" + context);
        } else {
            ctx.setProperty(String.valueOf(WindowNo) + "|" + context, value);
        }
    }

    public static void setContext(Properties ctx, int WindowNo, String context, Timestamp value) {
        if (ctx == null || context == null) {
            return;
        }
        if (value == null) {
            ctx.remove(String.valueOf(WindowNo) + "|" + context);
            if (log.isLoggable(Level.FINER)) {
                log.finer("Context(" + WindowNo + ") " + context + "==" + value);
            }
        } else {
            String stringValue = "";
            Calendar c1 = Calendar.getInstance();
            c1.setTime(value);
            stringValue = DisplayType.getTimestampFormat_Default().format(c1.getTime());
            ctx.setProperty(String.valueOf(WindowNo) + "|" + context, stringValue);
            if (log.isLoggable(Level.FINER)) {
                log.finer("Context(" + WindowNo + ") " + context + "==" + stringValue);
            }
        }
    }

    public static void setContext(Properties ctx, int WindowNo, String context, int value) {
        if (ctx == null || context == null) {
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Context(" + WindowNo + ") " + context + "==" + value);
        }
        ctx.setProperty(String.valueOf(WindowNo) + "|" + context, String.valueOf(value));
    }

    public static void setContext(Properties ctx, int WindowNo, int TabNo, String context, int value) {
        if (ctx == null || context == null) {
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Context(" + WindowNo + ") " + context + "==" + value);
        }
        ctx.setProperty(String.valueOf(WindowNo) + "|" + TabNo + "|" + context, String.valueOf(value));
    }

    public static void setContext(Properties ctx, int WindowNo, String context, boolean value) {
        Env.setContext(ctx, WindowNo, context, Env.convert(value));
    }

    private static String convert(boolean value) {
        return value ? "Y" : "N";
    }

    public static void setContext(Properties ctx, int WindowNo, int TabNo, String context, boolean value) {
        Env.setContext(ctx, WindowNo, TabNo, context, Env.convert(value));
    }

    public static void setContext(Properties ctx, int WindowNo, int TabNo, String context, String value) {
        if (ctx == null || context == null) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Context(" + WindowNo + "," + TabNo + ") " + context + "==" + value);
        }
        if (value == null) {
            value = context.endsWith("_ID") ? new String("0") : new String("");
        }
        ctx.setProperty(String.valueOf(WindowNo) + "|" + TabNo + "|" + context, value);
    }

    @Deprecated
    public static void setAutoCommit(Properties ctx, boolean autoCommit) {
        if (ctx == null) {
            return;
        }
        ctx.setProperty("AutoCommit", Env.convert(autoCommit));
    }

    public static void setAutoCommit(Properties ctx, int WindowNo, boolean autoCommit) {
        if (ctx == null) {
            return;
        }
        ctx.setProperty(String.valueOf(WindowNo) + "|AutoCommit", Env.convert(autoCommit));
    }

    @Deprecated
    public static void setAutoNew(Properties ctx, boolean autoNew) {
        if (ctx == null) {
            return;
        }
        ctx.setProperty("AutoNew", Env.convert(autoNew));
    }

    public static void setAutoNew(Properties ctx, int WindowNo, boolean autoNew) {
        if (ctx == null) {
            return;
        }
        ctx.setProperty(String.valueOf(WindowNo) + "|AutoNew", Env.convert(autoNew));
    }

    public static void setSOTrx(Properties ctx, boolean isSOTrx) {
        if (ctx == null) {
            return;
        }
        ctx.setProperty("IsSOTrx", Env.convert(isSOTrx));
    }

    public static String getContext(Properties ctx, String context) {
        if (ctx == null || context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        return ctx.getProperty(context, "");
    }

    public static String getContext(Properties ctx, int WindowNo, String context, boolean onlyWindow) {
        if (ctx == null) {
            throw new IllegalArgumentException("No Ctx");
        }
        if (context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = ctx.getProperty(String.valueOf(WindowNo) + "|" + context);
        if (s == null) {
            if (context.startsWith("#") || context.startsWith("$") || context.startsWith("P|")) {
                return Env.getContext(ctx, context);
            }
            if (onlyWindow) {
                return "";
            }
            return Env.getContext(ctx, "#" + context);
        }
        return s;
    }

    public static String getContext(Properties ctx, int WindowNo, String context) {
        return Env.getContext(ctx, WindowNo, context, false);
    }

    public static String getContext(Properties ctx, int WindowNo, int TabNo, String context) {
        if (ctx == null || context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = ctx.getProperty(String.valueOf(WindowNo) + "|" + TabNo + "|" + context);
        if (1113 == TabNo) {
            return s != null ? s : "";
        }
        if (Util.isEmpty(s)) {
            return Env.getContext(ctx, WindowNo, context, false);
        }
        return s;
    }

    public static String getContext(Properties ctx, int WindowNo, int TabNo, String context, boolean onlyTab) {
        return Env.getContext(ctx, WindowNo, TabNo, context, onlyTab, onlyTab);
    }

    public static String getContext(Properties ctx, int WindowNo, int TabNo, String context, boolean onlyTab, boolean onlyWindow) {
        if (ctx == null || context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = ctx.getProperty(String.valueOf(WindowNo) + "|" + TabNo + "|" + context);
        if (1113 == TabNo) {
            return s != null ? s : "";
        }
        if (Util.isEmpty(s) && !onlyTab) {
            return Env.getContext(ctx, WindowNo, context, onlyWindow);
        }
        return s;
    }

    public static int getContextAsInt(Properties ctx, String context) {
        if (ctx == null || context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = Env.getContext(ctx, context);
        if (s.length() == 0) {
            s = Env.getContext(ctx, 0, context, false);
        }
        if (s.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            log.log(Level.SEVERE, "(" + context + ") = " + s, e);
            return 0;
        }
    }

    public static int getContextAsInt(Properties ctx, int WindowNo, String context) {
        String s = Env.getContext(ctx, WindowNo, context, false);
        if (s.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            log.log(Level.SEVERE, "(" + context + ") = " + s, e);
            return 0;
        }
    }

    public static int getContextAsInt(Properties ctx, int WindowNo, String context, boolean onlyWindow) {
        String s = Env.getContext(ctx, WindowNo, context, onlyWindow);
        if (s.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            log.log(Level.SEVERE, "(" + context + ") = " + s, e);
            return 0;
        }
    }

    public static int getContextAsInt(Properties ctx, int WindowNo, int TabNo, String context) {
        String s = Env.getContext(ctx, WindowNo, TabNo, context);
        if (Util.isEmpty(s)) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            log.log(Level.SEVERE, "(" + context + ") = " + s, e);
            return 0;
        }
    }

    public static boolean isAutoCommit(Properties ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = Env.getContext(ctx, "AutoCommit");
        return s != null && s.equals("Y");
    }

    public static boolean isAutoCommit(Properties ctx, int WindowNo) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = Env.getContext(ctx, WindowNo, "AutoCommit", false);
        if (s != null) {
            return s.equals("Y");
        }
        return Env.isAutoCommit(ctx);
    }

    public static boolean isAutoNew(Properties ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = Env.getContext(ctx, "AutoNew");
        return s != null && s.equals("Y");
    }

    public static boolean isAutoNew(Properties ctx, int WindowNo) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = Env.getContext(ctx, WindowNo, "AutoNew", false);
        if (s != null) {
            return s.equals("Y");
        }
        return Env.isAutoNew(ctx);
    }

    public static boolean isSOTrx(Properties ctx) {
        String s = Env.getContext(ctx, "IsSOTrx");
        return s == null || !s.equals("N");
    }

    public static boolean isSOTrx(Properties ctx, int WindowNo) {
        String s = Env.getContext(ctx, WindowNo, "IsSOTrx", true);
        return s == null || !s.equals("N");
    }

    public static Timestamp getContextAsDate(Properties ctx, String context) {
        return Env.getContextAsDate(ctx, 0, context);
    }

    public static Timestamp getContextAsDate(Properties ctx, int WindowNo, String context) {
        if (ctx == null || context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = Env.getContext(ctx, WindowNo, context, false);
        if (Util.isEmpty(s)) {
            return new Timestamp(System.currentTimeMillis());
        }
        Date date = null;
        try {
            date = DisplayType.getTimestampFormat_Default().parse(s);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        Timestamp timeStampDate = new Timestamp(date.getTime());
        return timeStampDate;
    }

    public static int getAD_Client_ID(Properties ctx) {
        return Env.getContextAsInt(ctx, AD_CLIENT_ID);
    }

    public static int getAD_Org_ID(Properties ctx) {
        return Env.getContextAsInt(ctx, AD_ORG_ID);
    }

    public static int getAD_User_ID(Properties ctx) {
        return Env.getContextAsInt(ctx, AD_USER_ID);
    }

    public static int getAD_Role_ID(Properties ctx) {
        return Env.getContextAsInt(ctx, AD_ROLE_ID);
    }

    public static String getPreference(Properties ctx, int AD_Window_ID, String context, boolean system) {
        if (ctx == null || context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String retValue = null;
        if (!system) {
            retValue = ctx.getProperty("P" + AD_Window_ID + "|" + context);
            if (retValue == null) {
                retValue = ctx.getProperty("P|" + context);
            }
        } else {
            retValue = ctx.getProperty("#" + context);
            if (retValue == null) {
                retValue = ctx.getProperty("$" + context);
            }
        }
        return retValue == null ? "" : retValue;
    }

    public static String getPreference(Properties ctx, int AD_Window_ID, int AD_InfoWindow, int AD_Process_ID_Of_Panel, String context) {
        if (ctx == null || context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String retValue = null;
        retValue = ctx.getProperty("P" + AD_Window_ID + "|" + AD_InfoWindow + "|" + AD_Process_ID_Of_Panel + "|" + context);
        return retValue == null ? "" : retValue;
    }

    public static String getPreference(Properties ctx, int AD_Window_ID, int AD_InfoWindow, String context) {
        if (ctx == null || context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String retValue = null;
        retValue = ctx.getProperty("P" + AD_Window_ID + "|" + AD_InfoWindow + "|" + context);
        return retValue == null ? "" : retValue;
    }

    public static boolean isBaseLanguage(Properties ctx, String tableName) {
        return Language.isBaseLanguage(Env.getAD_Language(ctx));
    }

    public static boolean isBaseLanguage(String AD_Language, String tableName) {
        return Language.isBaseLanguage(AD_Language);
    }

    public static boolean isBaseLanguage(Language language, String tableName) {
        return language.isBaseLanguage();
    }

    public static boolean isBaseTranslation(String tableName) {
        return tableName.startsWith("AD") || tableName.equals("C_Country_Trl");
    }

    public static boolean isMultiLingualDocument(Properties ctx) {
        return MClient.get(ctx).isMultiLingualDocument();
    }

    public static String getAD_Language(Properties ctx) {
        String lang;
        if (ctx != null && !Util.isEmpty(lang = Env.getContext(ctx, LANGUAGE))) {
            return lang;
        }
        return Language.getBaseAD_Language();
    }

    public static Language getLanguage(Properties ctx) {
        String lang;
        if (ctx != null && !Util.isEmpty(lang = Env.getContext(ctx, LANGUAGE))) {
            return Language.getLanguage(lang);
        }
        return Language.getBaseLanguage();
    }

    public static Language getLoginLanguage(Properties ctx) {
        return Language.getLoginLanguage();
    }

    public static ArrayList<String> getSupportedLanguages() {
        ArrayList<String> AD_Languages;
        block6: {
            AD_Languages = new ArrayList<String>();
            String sql = "SELECT DISTINCT AD_Language FROM AD_Message_Trl";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String AD_Language = rs.getString(1);
                        Language.getLanguage(AD_Language);
                        AD_Languages.add(AD_Language);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, "", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return AD_Languages;
    }

    public static ArrayList<String> getLoginLanguages() {
        ArrayList<String> AD_Languages;
        block6: {
            AD_Languages = new ArrayList<String>();
            String sql = "SELECT AD_Language FROM AD_Language WHERE IsActive='Y' AND IsLoginLocale = 'Y'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String AD_Language = rs.getString(1);
                        Language.getLanguage(AD_Language);
                        AD_Languages.add(AD_Language);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, "", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return AD_Languages;
    }

    public static void verifyLanguage(Properties ctx, Language language) {
        ArrayList<String> AD_Languages;
        boolean isSystemLanguage;
        block13: {
            if (language.isBaseLanguage()) {
                return;
            }
            isSystemLanguage = false;
            AD_Languages = new ArrayList<String>();
            AD_Languages.add(Language.getBaseAD_Language());
            String sql = "SELECT DISTINCT AD_Language FROM AD_Message_Trl";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String AD_Language = rs.getString(1);
                        if (AD_Language.equals(language.getAD_Language())) {
                            isSystemLanguage = true;
                            break;
                        }
                        AD_Languages.add(AD_Language);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, "", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block13;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (isSystemLanguage) {
            return;
        }
        if (AD_Languages.size() == 0) {
            log.warning("NO System Language - Set to Base " + Language.getBaseAD_Language());
            language.setAD_Language(Language.getBaseAD_Language());
            return;
        }
        int i2 = 0;
        while (i2 < AD_Languages.size()) {
            String langCompare;
            String AD_Language = (String)AD_Languages.get(i2);
            String lang = AD_Language.substring(0, 2);
            if (lang.equals(langCompare = language.getAD_Language().substring(0, 2))) {
                if (log.isLoggable(Level.INFO)) {
                    log.info("Found similar Language " + AD_Language);
                }
                language.setAD_Language(AD_Language);
                return;
            }
            ++i2;
        }
        log.warning("Not System Language=" + language + " - Set to Base Language " + Language.getBaseAD_Language());
        language.setAD_Language(Language.getBaseAD_Language());
    }

    public static String[] getEntireContext(Properties ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        Iterator<Object> keyIterator = ctx.keySet().iterator();
        String[] sList = new String[ctx.size()];
        int i2 = 0;
        while (keyIterator.hasNext()) {
            Object key = keyIterator.next();
            sList[i2++] = String.valueOf(key.toString()) + " == " + ctx.get(key).toString();
        }
        return sList;
    }

    public static String getHeader(Properties ctx, int WindowNo) {
        StringBuilder sb = new StringBuilder();
        if (WindowNo > 0) {
            sb.append(Env.getContext(ctx, WindowNo, "_WinInfo_WindowName", false)).append("  ");
            String documentNo = Env.getContext(ctx, WindowNo, "DocumentNo", false);
            String value = Env.getContext(ctx, WindowNo, "Value", false);
            String name = Env.getContext(ctx, WindowNo, "Name", false);
            if (!"".equals(documentNo)) {
                sb.append(documentNo).append("  ");
            }
            if (!"".equals(value)) {
                sb.append(value).append("  ");
            }
            if (!"".equals(name)) {
                sb.append(name).append("  ");
            }
        }
        sb.append(Env.getContext(ctx, "#AD_User_Name")).append("@").append(Env.getContext(ctx, "#AD_Client_Name")).append(".").append(Env.getContext(ctx, AD_ORG_NAME)).append(" [").append(CConnection.get().toString()).append("]");
        return sb.toString();
    }

    public static void clearWinContext(Properties ctx, int WindowNo) {
        IEnvEventListener[] listeners;
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        Object[] keys = ctx.keySet().toArray();
        int i2 = 0;
        while (i2 < keys.length) {
            String tag = keys[i2].toString();
            if (tag.startsWith(String.valueOf(WindowNo) + "|")) {
                ctx.remove(keys[i2]);
            }
            ++i2;
        }
        MLookupCache.cacheReset(WindowNo);
        IEnvEventListener[] iEnvEventListenerArray = listeners = eventListeners.toArray(new IEnvEventListener[0]);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IEnvEventListener listener = iEnvEventListenerArray[n2];
            listener.onClearWindowContext(WindowNo);
            ++n2;
        }
    }

    public static void clearTabContext(Properties ctx, int WindowNo, int TabNo) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        Object[] keys = ctx.keySet().toArray();
        int i2 = 0;
        while (i2 < keys.length) {
            String tag = keys[i2].toString();
            if (tag.startsWith(String.valueOf(WindowNo) + "|" + TabNo + "|") && !tag.startsWith(String.valueOf(WindowNo) + "|" + TabNo + "|_TabInfo")) {
                ctx.remove(keys[i2]);
            }
            ++i2;
        }
    }

    public static void clearContext(Properties ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Require Context");
        }
        ctx.clear();
    }

    public static String parseContext(Properties ctx, int WindowNo, String value, boolean onlyWindow, boolean ignoreUnparsable) {
        if (value == null || value.length() == 0) {
            return "";
        }
        String inStr = new String(value);
        StringBuilder outStr = new StringBuilder();
        int i2 = inStr.indexOf(64);
        while (i2 != -1) {
            String ctxInfo;
            outStr.append(inStr.substring(0, i2));
            inStr = inStr.substring(i2 + 1, inStr.length());
            int j = inStr.indexOf(64);
            if (j < 0) {
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "No second tag: " + inStr);
                }
                outStr.append("@");
                break;
            }
            String token = inStr.substring(0, j);
            String defaultV = null;
            int idx = token.indexOf(":");
            if (idx >= 0) {
                defaultV = token.substring(idx + 1, token.length());
                token = token.substring(0, idx);
            }
            if ((ctxInfo = Env.getContext(ctx, WindowNo, token, onlyWindow)).length() == 0 && (token.startsWith("#") || token.startsWith("$"))) {
                ctxInfo = Env.getContext(ctx, token);
            }
            if (ctxInfo.length() == 0 && defaultV != null) {
                ctxInfo = defaultV;
            }
            if (ctxInfo.length() == 0) {
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("No Context Win=" + WindowNo + " for: " + token);
                }
                if (!ignoreUnparsable) {
                    return "";
                }
            } else {
                outStr.append(ctxInfo);
            }
            inStr = inStr.substring(j + 1, inStr.length());
            i2 = inStr.indexOf(64);
        }
        outStr.append(inStr);
        return outStr.toString();
    }

    public static String parseContext(Properties ctx, int WindowNo, int tabNo, String value, boolean onlyTab, boolean ignoreUnparsable) {
        if (value == null || value.length() == 0) {
            return "";
        }
        String inStr = new String(value);
        StringBuilder outStr = new StringBuilder();
        int i2 = inStr.indexOf(64);
        while (i2 != -1) {
            String ctxInfo;
            outStr.append(inStr.substring(0, i2));
            inStr = inStr.substring(i2 + 1, inStr.length());
            int j = inStr.indexOf(64);
            if (j < 0) {
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "No second tag: " + inStr);
                }
                outStr.append("@");
                break;
            }
            String token = inStr.substring(0, j);
            String defaultV = null;
            int idx = token.indexOf(":");
            if (idx >= 0) {
                defaultV = token.substring(idx + 1, token.length());
                token = token.substring(0, idx);
            }
            if ((ctxInfo = Env.getContext(ctx, WindowNo, tabNo, token, onlyTab)).length() == 0 && (token.startsWith("#") || token.startsWith("$"))) {
                ctxInfo = Env.getContext(ctx, token);
            }
            if (ctxInfo.length() == 0 && defaultV != null) {
                ctxInfo = defaultV;
            }
            if (ctxInfo.length() == 0) {
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("No Context Win=" + WindowNo + " for: " + token);
                }
                if (!ignoreUnparsable) {
                    return "";
                }
            } else {
                outStr.append(ctxInfo);
            }
            inStr = inStr.substring(j + 1, inStr.length());
            i2 = inStr.indexOf(64);
        }
        outStr.append(inStr);
        return outStr.toString();
    }

    public static String parseContext(Properties ctx, int WindowNo, String value, boolean onlyWindow) {
        return Env.parseContext(ctx, WindowNo, value, onlyWindow, false);
    }

    public static String parseContext(Properties ctx, int WindowNo, int tabNo, String value, boolean onlyWindow) {
        return Env.parseContext(ctx, WindowNo, tabNo, value, onlyWindow, false);
    }

    public static String parseVariable(String expression, PO po, String trxName, boolean keepUnparseable) {
        if (expression == null || expression.length() == 0) {
            return "";
        }
        String inStr = new String(expression);
        StringBuilder outStr = new StringBuilder();
        int i2 = inStr.indexOf(64);
        while (i2 != -1) {
            Object v;
            Properties ctx;
            outStr.append(inStr.substring(0, i2));
            inStr = inStr.substring(i2 + 1, inStr.length());
            int j = inStr.indexOf(64);
            if (j < 0) {
                log.log(Level.SEVERE, "No second tag: " + inStr);
                return "";
            }
            String token = inStr.substring(0, j);
            String format = "";
            int f = token.indexOf(60);
            if (f > 0 && token.endsWith(">")) {
                format = token.substring(f + 1, token.length() - 1);
                token = token.substring(0, f);
            }
            Properties properties = ctx = po != null ? po.getCtx() : Env.getCtx();
            if (token.startsWith("#") || token.startsWith("$")) {
                v = Env.getContext(ctx, token);
                if (v != null && ((String)v).length() > 0) {
                    outStr.append((String)v);
                } else if (keepUnparseable) {
                    outStr.append("@").append(token);
                    if (!Util.isEmpty(format)) {
                        outStr.append("<").append(format).append(">");
                    }
                    outStr.append("@");
                }
            } else if (po != null) {
                if (po.get_ColumnIndex(token) >= 0) {
                    v = po.get_Value(token);
                    MColumn colToken = MColumn.get(ctx, po.get_TableName(), token);
                    String foreignTable = colToken.getReferenceTableName();
                    if (v != null) {
                        if (format != null && format.length() > 0) {
                            if (v instanceof Integer && (Integer)v > 0 && !Util.isEmpty(foreignTable)) {
                                String columnName;
                                MColumn column;
                                int tblIndex = format.indexOf(".");
                                String tableName = null;
                                tableName = tblIndex > 0 ? format.substring(0, tblIndex) : foreignTable;
                                MTable table2 = MTable.get(ctx, tableName);
                                if (table2 != null && tableName.equalsIgnoreCase(foreignTable) && (column = table2.getColumn(columnName = tblIndex > 0 ? format.substring(tblIndex + 1) : format)) != null) {
                                    if (column.isSecure()) {
                                        outStr.append("********");
                                    } else {
                                        String value = DB.getSQLValueString(trxName, "SELECT " + columnName + " FROM " + tableName + " WHERE " + tableName + "_ID = ?", (Integer)v);
                                        if (value != null) {
                                            outStr.append(value);
                                        }
                                    }
                                }
                            } else if (v instanceof Date) {
                                SimpleDateFormat df = new SimpleDateFormat(format);
                                outStr.append(df.format((Date)v));
                            } else if (v instanceof Number) {
                                DecimalFormat df = new DecimalFormat(format);
                                outStr.append(df.format(((Number)v).doubleValue()));
                            } else {
                                MessageFormat mf = new MessageFormat(format);
                                outStr.append(mf.format(v));
                            }
                        } else {
                            if (colToken != null && colToken.isSecure()) {
                                v = "********";
                            }
                            outStr.append(v.toString());
                        }
                    }
                } else if (keepUnparseable) {
                    outStr.append("@").append(token);
                    if (!Util.isEmpty(format)) {
                        outStr.append("<").append(format).append(">");
                    }
                    outStr.append("@");
                }
            } else if (keepUnparseable) {
                outStr.append("@" + token);
                if (format.length() > 0) {
                    outStr.append("<" + format + ">");
                }
                outStr.append("@");
            }
            inStr = inStr.substring(j + 1, inStr.length());
            i2 = inStr.indexOf(64);
        }
        outStr.append(inStr);
        return outStr.toString();
    }

    public static void clearWinContext(int WindowNo) {
        Env.clearWinContext(Env.getCtx(), WindowNo);
    }

    public static void clearContext() {
        Env.getCtx().clear();
    }

    public static Graphics getGraphics(Container container) {
        Container element = container;
        while (element != null) {
            Graphics g = element.getGraphics();
            if (g != null) {
                return g;
            }
            element = element.getParent();
        }
        return null;
    }

    public static Window getParent(Container container) {
        Container element = container;
        while (element != null) {
            if (element instanceof JDialog || element instanceof JFrame) {
                return (Window)element;
            }
            if (element instanceof Window) {
                return (Window)element;
            }
            element = element.getParent();
        }
        return null;
    }

    public static Image getImage(String fileNameInImageDir) {
        IResourceFinder rf = Core.getResourceFinder();
        URL url = rf.getResource("images/" + fileNameInImageDir);
        if (url == null) {
            log.log(Level.SEVERE, "Not found: " + fileNameInImageDir);
            return null;
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        return tk.getImage(url);
    }

    public static ImageIcon getImageIcon(String fileNameInImageDir) {
        IResourceFinder rf = Core.getResourceFinder();
        URL url = rf.getResource("images/" + fileNameInImageDir);
        if (url == null) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "Not found: " + fileNameInImageDir);
            }
            return null;
        }
        return new ImageIcon(url);
    }

    public static ImageIcon getImageIcon2(String fileName) {
        IResourceFinder rf = Core.getResourceFinder();
        URL url = rf.getResource("images/" + fileName + ".gif");
        if (url == null) {
            url = rf.getResource("images/" + fileName + ".png");
        }
        if (url == null) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "GIF/PNG Not found: " + fileName);
            }
            return null;
        }
        return new ImageIcon(url);
    }

    public static void startBrowser(String url) {
        if (log.isLoggable(Level.INFO)) {
            log.info(url);
        }
        Env.getContextProvider().showURL(url);
    }

    public static boolean isMac() {
        String osName = System.getProperty("os.name");
        return (osName = osName.toLowerCase()).indexOf("mac") != -1;
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return (osName = osName.toLowerCase()).indexOf("windows") != -1;
    }

    public static void sleep(int sec) {
        if (log.isLoggable(Level.INFO)) {
            log.info("Start - Seconds=" + sec);
        }
        try {
            Thread.sleep(sec * 1000);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "", e);
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("End");
        }
    }

    public static Properties getRemoteCallCtx(Properties ctx) {
        Properties p2 = new Properties();
        Set<Object> keys = ctx.keySet();
        for (Object key : keys) {
            Object value;
            if (!(key instanceof String) || !((value = ctx.get(key)) instanceof String)) continue;
            p2.put(key, value);
        }
        return p2;
    }

    public static GridWindowVO getMWindowVO(int WindowNo, int AD_Window_ID, int AD_Menu_ID) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Window=" + WindowNo + ", AD_Window_ID=" + AD_Window_ID);
        }
        GridWindowVO mWindowVO = null;
        if (AD_Window_ID != 0 && Ini.isCacheWindow() && (mWindowVO = s_windowsvo.get(AD_Window_ID)) != null) {
            mWindowVO = mWindowVO.clone(WindowNo);
            if (log.isLoggable(Level.INFO)) {
                log.info("Cached=" + mWindowVO);
            }
        }
        if (mWindowVO == null) {
            if (log.isLoggable(Level.CONFIG)) {
                log.config("create local");
            }
            if ((mWindowVO = GridWindowVO.create(Env.getCtx(), WindowNo, AD_Window_ID, AD_Menu_ID)) != null) {
                s_windowsvo.put(AD_Window_ID, mWindowVO);
            }
        }
        if (mWindowVO == null) {
            return null;
        }
        if (!mWindowVO.ctx.equals(Env.getCtx())) {
            Enumeration<Object> keyEnum = mWindowVO.ctx.keys();
            while (keyEnum.hasMoreElements()) {
                String key = (String)keyEnum.nextElement();
                if (!key.startsWith(String.valueOf(WindowNo) + "|")) continue;
                String value = mWindowVO.ctx.getProperty(key);
                Env.setContext(Env.getCtx(), key, value);
            }
            mWindowVO.setCtx(Env.getCtx());
        }
        return mWindowVO;
    }

    public static IProcessUI getProcessUI(Properties ctx) {
        return (IProcessUI)ctx.get("ProcessUI");
    }

    public static ProcessInfo getProcessInfo(Properties ctx) {
        return (ProcessInfo)ctx.get("ProcessInfo");
    }

    public static String getStandardReportFooterTrademarkText() {
        String s = MSysConfig.getValue("STANDARD_REPORT_FOOTER_TRADEMARK_TEXT", Env.getAD_Client_ID(Env.getCtx()));
        if (Util.isEmpty(s, true)) {
            s = Env.getContext(Env.getCtx(), STANDARD_REPORT_FOOTER_TRADEMARK_TEXT);
        }
        if (Util.isEmpty(s)) {
            s = "iDempiere\u00ae";
        }
        return s;
    }

    public static int getZoomWindowID(MQuery query) {
        int AD_Window_ID = MZoomCondition.findZoomWindow(query);
        if (AD_Window_ID <= 0) {
            int PO_Window_ID;
            String TableName;
            block10: {
                TableName = query.getTableName();
                PO_Window_ID = 0;
                String sql = "SELECT AD_Window_ID, PO_Window_ID FROM AD_Table WHERE TableName=?";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, null);
                        pstmt.setString(1, TableName);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            AD_Window_ID = rs.getInt(1);
                            PO_Window_ID = rs.getInt(2);
                        }
                    }
                    catch (SQLException e) {
                        log.log(Level.SEVERE, sql, e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            if (AD_Window_ID == 0) {
                return AD_Window_ID;
            }
            boolean isSOTrx = true;
            if (PO_Window_ID != 0 && !(isSOTrx = DB.isSOTrx(TableName, query.getWhereClause(false)))) {
                AD_Window_ID = PO_Window_ID;
            }
            if (log.isLoggable(Level.CONFIG)) {
                log.config(query + " (IsSOTrx=" + isSOTrx + ")");
            }
        }
        return AD_Window_ID;
    }

    public static int getZoomWindowID(int AD_Table_ID, int Record_ID) {
        return Env.getZoomWindowID(AD_Table_ID, Record_ID, 0);
    }

    public static int getZoomWindowID(int AD_Table_ID, int Record_ID, int windowNo) {
        int AD_Window_ID = MZoomCondition.findZoomWindowByTableId(AD_Table_ID, Record_ID, windowNo);
        if (AD_Window_ID <= 0) {
            MTable table2 = MTable.get(Env.getCtx(), AD_Table_ID);
            AD_Window_ID = table2.getAD_Window_ID();
            if (AD_Window_ID == 0) {
                return AD_Window_ID;
            }
            boolean isSOTrx = true;
            if (table2.getPO_Window_ID() != 0) {
                String whereClause = String.valueOf(table2.getTableName()) + "_ID=" + Record_ID;
                isSOTrx = DB.isSOTrx(table2.getTableName(), whereClause, windowNo);
                if (!isSOTrx) {
                    AD_Window_ID = table2.getPO_Window_ID();
                }
            }
            if (log.isLoggable(Level.CONFIG)) {
                log.config(String.valueOf(table2.getTableName()) + " - Record_ID=" + Record_ID + " (IsSOTrx=" + isSOTrx + ")");
            }
        }
        return AD_Window_ID;
    }
}

