/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import org.adempiere.base.IDisplayTypeFactory;
import org.adempiere.base.Service;
import org.compiere.model.MLanguage;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Util;

public final class DisplayType {
    public static final int String = 10;
    public static final int Integer = 11;
    public static final int Amount = 12;
    public static final int ID = 13;
    public static final int Text = 14;
    public static final int Date = 15;
    public static final int DateTime = 16;
    public static final int List = 17;
    public static final int Table = 18;
    public static final int TableDir = 19;
    public static final int YesNo = 20;
    public static final int Location = 21;
    public static final int Number = 22;
    public static final int Binary = 23;
    public static final int Time = 24;
    public static final int Account = 25;
    public static final int RowID = 26;
    public static final int Color = 27;
    public static final int Button = 28;
    public static final int Quantity = 29;
    public static final int Search = 30;
    public static final int Locator = 31;
    public static final int Image = 32;
    public static final int Assignment = 33;
    public static final int Memo = 34;
    public static final int PAttribute = 35;
    public static final int TextLong = 36;
    public static final int CostPrice = 37;
    public static final int FilePath = 38;
    public static final int FileName = 39;
    public static final int URL = 40;
    public static final int PrinterName = 42;
    public static final int Payment = 200012;
    public static final int Chart = 53370;
    public static final int DashboardContent = 200122;
    public static final int SingleSelectionGrid = 200127;
    public static final int MultipleSelectionGrid = 200128;
    private static final int MAX_DIGITS = 28;
    private static final int INTEGER_DIGITS = 10;
    private static final int MAX_FRACTION = 12;
    private static final int AMOUNT_FRACTION = 2;
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DEFAULT_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private static CLogger s_log = CLogger.getCLogger(DisplayType.class);

    public static boolean isID(int displayType) {
        if (displayType == 13 || displayType == 18 || displayType == 19 || displayType == 30 || displayType == 21 || displayType == 31 || displayType == 25 || displayType == 33 || displayType == 35 || displayType == 32 || displayType == 53370) {
            return true;
        }
        List<IDisplayTypeFactory> factoryList = Service.locator().list(IDisplayTypeFactory.class).getServices();
        for (IDisplayTypeFactory factory : factoryList) {
            if (!factory.isID(displayType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNumeric(int displayType) {
        if (displayType == 12 || displayType == 22 || displayType == 37 || displayType == 11 || displayType == 29) {
            return true;
        }
        List<IDisplayTypeFactory> factoryList = Service.locator().list(IDisplayTypeFactory.class).getServices();
        for (IDisplayTypeFactory factory : factoryList) {
            if (!factory.isNumeric(displayType)) continue;
            return true;
        }
        return false;
    }

    public static int getDefaultPrecision(int displayType) {
        if (displayType == 12) {
            return 2;
        }
        if (displayType == 22) {
            return 6;
        }
        if (displayType == 37 || displayType == 29) {
            return 4;
        }
        List<IDisplayTypeFactory> factoryList = Service.locator().list(IDisplayTypeFactory.class).getServices();
        for (IDisplayTypeFactory factory : factoryList) {
            if (factory.getDefaultPrecision(displayType) == null) continue;
            return factory.getDefaultPrecision(displayType);
        }
        return 0;
    }

    public static boolean isText(int displayType) {
        if (displayType == 10 || displayType == 14 || displayType == 36 || displayType == 34 || displayType == 38 || displayType == 39 || displayType == 40 || displayType == 42 || displayType == 200127 || displayType == 27 || displayType == 200128) {
            return true;
        }
        List<IDisplayTypeFactory> factoryList = Service.locator().list(IDisplayTypeFactory.class).getServices();
        for (IDisplayTypeFactory factory : factoryList) {
            if (!factory.isText(displayType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDate(int displayType) {
        if (displayType == 15 || displayType == 16 || displayType == 24) {
            return true;
        }
        List<IDisplayTypeFactory> factoryList = Service.locator().list(IDisplayTypeFactory.class).getServices();
        for (IDisplayTypeFactory factory : factoryList) {
            if (!factory.isDate(displayType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLookup(int displayType) {
        if (displayType == 17 || displayType == 18 || displayType == 19 || displayType == 30) {
            return true;
        }
        List<IDisplayTypeFactory> factoryList = Service.locator().list(IDisplayTypeFactory.class).getServices();
        for (IDisplayTypeFactory factory : factoryList) {
            if (!factory.isLookup(displayType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLOB(int displayType) {
        if (displayType == 23 || displayType == 36) {
            return true;
        }
        List<IDisplayTypeFactory> factoryList = Service.locator().list(IDisplayTypeFactory.class).getServices();
        for (IDisplayTypeFactory factory : factoryList) {
            if (!factory.isLOB(displayType)) continue;
            return true;
        }
        return false;
    }

    public static DecimalFormat getNumberFormat(int displayType, Language language, String pattern) {
        Language myLanguage = language;
        if (myLanguage == null) {
            myLanguage = Language.getLoginLanguage();
        }
        Locale locale = myLanguage.getLocale();
        DecimalFormat format = null;
        format = locale != null ? (DecimalFormat)NumberFormat.getNumberInstance(locale) : (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        if (pattern != null && pattern.length() > 0) {
            try {
                format.applyPattern(pattern);
                return format;
            }
            catch (IllegalArgumentException e) {
                s_log.log(Level.WARNING, "Invalid number format: " + pattern);
            }
        } else if (displayType == 11) {
            format.setParseIntegerOnly(true);
            format.setMaximumIntegerDigits(10);
            format.setMaximumFractionDigits(0);
        } else if (displayType == 29) {
            format.setMaximumIntegerDigits(28);
            format.setMaximumFractionDigits(12);
        } else if (displayType == 12) {
            format.setMaximumIntegerDigits(28);
            format.setMaximumFractionDigits(12);
            format.setMinimumFractionDigits(2);
        } else if (displayType == 37) {
            format.setMaximumIntegerDigits(28);
            format.setMaximumFractionDigits(12);
            format.setMinimumFractionDigits(2);
        } else {
            List<IDisplayTypeFactory> factoryList = Service.locator().list(IDisplayTypeFactory.class).getServices();
            for (IDisplayTypeFactory factory : factoryList) {
                DecimalFormat osgiFormat = factory.getNumberFormat(displayType, myLanguage, pattern);
                if (osgiFormat == null) continue;
                return osgiFormat;
            }
            format.setMaximumIntegerDigits(28);
            format.setMaximumFractionDigits(12);
            format.setMinimumFractionDigits(1);
        }
        return format;
    }

    public static DecimalFormat getNumberFormat(int displayType, Language language) {
        return DisplayType.getNumberFormat(displayType, language, null);
    }

    public static DecimalFormat getNumberFormat(int displayType) {
        return DisplayType.getNumberFormat(displayType, null);
    }

    public static SimpleDateFormat getDateFormat() {
        return DisplayType.getDateFormat(15, null);
    }

    public static SimpleDateFormat getDateFormat(Language language) {
        return DisplayType.getDateFormat(15, language);
    }

    public static SimpleDateFormat getDateFormat(int displayType) {
        return DisplayType.getDateFormat(displayType, null);
    }

    public static SimpleDateFormat getDateFormat(int displayType, Language language) {
        return DisplayType.getDateFormat(displayType, language, null);
    }

    public static SimpleDateFormat getDateFormat(int displayType, Language language, String pattern) {
        Language myLanguage = language;
        if (myLanguage == null) {
            myLanguage = Env.getLanguage(Env.getCtx());
        }
        if (pattern != null && pattern.length() > 0) {
            SimpleDateFormat format = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, language.getLocale());
            try {
                format.applyPattern(pattern);
                return format;
            }
            catch (IllegalArgumentException e) {
                s_log.log(Level.WARNING, "Invalid date pattern: " + pattern);
            }
        }
        MLanguage lang = MLanguage.get(Env.getCtx(), myLanguage);
        if (displayType == 16) {
            if (!Util.isEmpty(lang.getDatePattern()) && !Util.isEmpty(lang.getTimePattern())) {
                return new SimpleDateFormat(java.lang.String.valueOf(lang.getDatePattern()) + " " + lang.getTimePattern());
            }
            return myLanguage.getDateTimeFormat();
        }
        if (displayType == 24) {
            if (!Util.isEmpty(lang.getTimePattern())) {
                return new SimpleDateFormat(lang.getTimePattern());
            }
            return myLanguage.getTimeFormat();
        }
        List<IDisplayTypeFactory> factoryList = Service.locator().list(IDisplayTypeFactory.class).getServices();
        for (IDisplayTypeFactory factory : factoryList) {
            SimpleDateFormat osgiFormat = factory.getDateFormat(displayType, myLanguage, pattern);
            if (osgiFormat == null) continue;
            return osgiFormat;
        }
        if (!Util.isEmpty(lang.getDatePattern())) {
            return new SimpleDateFormat(lang.getDatePattern());
        }
        return myLanguage.getDateFormat();
    }

    public static SimpleDateFormat getDateFormat_JDBC() {
        return new SimpleDateFormat(DEFAULT_DATE_FORMAT);
    }

    public static SimpleDateFormat getTimestampFormat_Default() {
        return new SimpleDateFormat(DEFAULT_TIMESTAMP_FORMAT);
    }

    public static SimpleDateFormat getTimeFormat_Default() {
        return new SimpleDateFormat(DEFAULT_TIME_FORMAT);
    }

    public static Class<?> getClass(int displayType, boolean yesNoAsBoolean) {
        if (DisplayType.isText(displayType) || displayType == 17 || displayType == 200012) {
            return String.class;
        }
        if (DisplayType.isID(displayType) || displayType == 11) {
            return Integer.class;
        }
        if (DisplayType.isNumeric(displayType)) {
            return BigDecimal.class;
        }
        if (DisplayType.isDate(displayType)) {
            return Timestamp.class;
        }
        if (displayType == 20) {
            return yesNoAsBoolean ? Boolean.class : String.class;
        }
        if (displayType == 28) {
            return String.class;
        }
        if (DisplayType.isLOB(displayType)) {
            return byte[].class;
        }
        List<IDisplayTypeFactory> factoryList = Service.locator().list(IDisplayTypeFactory.class).getServices();
        for (IDisplayTypeFactory factory : factoryList) {
            Class<?> osgiClass = factory.getClass(displayType, yesNoAsBoolean);
            if (osgiClass == null) continue;
            return osgiClass;
        }
        return Object.class;
    }

    public static String getSQLDataType(int displayType, String columnName, int fieldLength) {
        if (columnName.equals("EntityType") || columnName.equals("AD_Language")) {
            return "VARCHAR2(" + fieldLength + ")";
        }
        if (DisplayType.isID(displayType)) {
            if (displayType == 32 && columnName.equals("BinaryData")) {
                return "BLOB";
            }
            if (columnName.endsWith("_ID") || columnName.endsWith("tedBy") || columnName.endsWith("_Acct")) {
                return "NUMBER(10)";
            }
            if (fieldLength < 4) {
                return "CHAR(" + fieldLength + ")";
            }
            return "VARCHAR2(" + fieldLength + ")";
        }
        if (displayType == 11) {
            return "NUMBER(10)";
        }
        if (DisplayType.isDate(displayType)) {
            return "DATE";
        }
        if (DisplayType.isNumeric(displayType)) {
            return "NUMBER";
        }
        if (displayType == 23) {
            return "BLOB";
        }
        if (displayType == 36 || displayType == 14 && fieldLength >= 4000) {
            return "CLOB";
        }
        if (displayType == 20) {
            return "CHAR(1)";
        }
        if (displayType == 17 || displayType == 200012) {
            if (fieldLength == 1) {
                return "CHAR(" + fieldLength + ")";
            }
            return "VARCHAR2(" + fieldLength + ")";
        }
        if (displayType == 27) {
            return "VARCHAR2(" + fieldLength + ")";
        }
        if (displayType == 28) {
            if (columnName.endsWith("_ID")) {
                return "NUMBER(10)";
            }
            return "CHAR(" + fieldLength + ")";
        }
        List<IDisplayTypeFactory> factoryList = Service.locator().list(IDisplayTypeFactory.class).getServices();
        for (IDisplayTypeFactory factory : factoryList) {
            String osgiSQLDataType = factory.getSQLDataType(displayType, columnName, fieldLength);
            if (osgiSQLDataType == null) continue;
            return osgiSQLDataType;
        }
        if (!DisplayType.isText(displayType)) {
            s_log.severe("Unhandled Data Type = " + displayType);
        }
        if (columnName.endsWith("_ID")) {
            return "NUMBER(10)";
        }
        return "VARCHAR2(" + fieldLength + ")";
    }

    public static String getDescription(int displayType) {
        if (displayType == 10) {
            return "String";
        }
        if (displayType == 11) {
            return "Integer";
        }
        if (displayType == 12) {
            return "Amount";
        }
        if (displayType == 13) {
            return "ID";
        }
        if (displayType == 14) {
            return "Text";
        }
        if (displayType == 15) {
            return "Date";
        }
        if (displayType == 16) {
            return "DateTime";
        }
        if (displayType == 17) {
            return "List";
        }
        if (displayType == 18) {
            return "Table";
        }
        if (displayType == 19) {
            return "TableDir";
        }
        if (displayType == 20) {
            return "YesNo";
        }
        if (displayType == 21) {
            return "Location";
        }
        if (displayType == 22) {
            return "Number";
        }
        if (displayType == 23) {
            return "Binary";
        }
        if (displayType == 24) {
            return "Time";
        }
        if (displayType == 25) {
            return "Account";
        }
        if (displayType == 26) {
            return "RowID";
        }
        if (displayType == 27) {
            return "Color";
        }
        if (displayType == 28) {
            return "Button";
        }
        if (displayType == 29) {
            return "Quantity";
        }
        if (displayType == 30) {
            return "Search";
        }
        if (displayType == 31) {
            return "Locator";
        }
        if (displayType == 32) {
            return "Image";
        }
        if (displayType == 33) {
            return "Assignment";
        }
        if (displayType == 34) {
            return "Memo";
        }
        if (displayType == 35) {
            return "PAttribute";
        }
        if (displayType == 36) {
            return "TextLong";
        }
        if (displayType == 37) {
            return "CostPrice";
        }
        if (displayType == 38) {
            return "FilePath";
        }
        if (displayType == 39) {
            return "FileName";
        }
        if (displayType == 40) {
            return "URL";
        }
        if (displayType == 42) {
            return "PrinterName";
        }
        if (displayType == 200012) {
            return "Payment";
        }
        if (displayType == 53370) {
            return "Chart";
        }
        List<IDisplayTypeFactory> factoryList = Service.locator().list(IDisplayTypeFactory.class).getServices();
        for (IDisplayTypeFactory factory : factoryList) {
            String osgiDescription = factory.getDescription(displayType);
            if (osgiDescription == null) continue;
            return osgiDescription;
        }
        return "UNKNOWN DisplayType=" + displayType;
    }

    public static NumberFormat getCurrencyFormat(String langcode, String currencyCode) {
        Locale locale = Language.getLocale(langcode);
        NumberFormat currencyFormatter = NumberFormat.getCurrencyInstance(locale);
        Currency currency = Currency.getInstance(currencyCode);
        currencyFormatter.setCurrency(currency);
        return currencyFormatter;
    }
}

