/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.util.Properties;
import java.util.logging.Level;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.adempiere.base.IKeyStore;
import org.compiere.util.CLogger;
import org.compiere.util.Ini;
import org.compiere.util.Util;

public class DefaultKeyStore
implements IKeyStore {
    private static final String LEGACY_ALGORITHM = "DES";
    private static final String IDEMPIERE_KEYSTORE_PROPERTIES = "idempiere-ks.properties";
    private static final String IDEMPIERE_KEYSTORE = "idempiere.ks";
    private static CLogger log = CLogger.getCLogger(DefaultKeyStore.class.getName());
    private SecretKey m_key = null;
    private KeyStore keyStore;
    private char[] password = null;
    private String algorithm;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DefaultKeyStore() {
        File file = new File(Ini.getAdempiereHome(), IDEMPIERE_KEYSTORE_PROPERTIES);
        if (file.exists()) {
            FileInputStream is = null;
            try {
                try {
                    is = new FileInputStream(file);
                    Properties p2 = new Properties();
                    p2.load(is);
                    String s = p2.getProperty("password");
                    String a2 = p2.getProperty("algorithm");
                    if (!Util.isEmpty(s) && !Util.isEmpty(a2)) {
                        this.password = s.toCharArray();
                        this.algorithm = a2;
                        this.keyStore = KeyStore.getInstance("JCEKS");
                        file = new File(Ini.getAdempiereHome(), IDEMPIERE_KEYSTORE);
                        if (file.exists()) {
                            FileInputStream stream = new FileInputStream(file);
                            this.keyStore.load(stream, this.password);
                            return;
                        }
                        this.keyStore.load(null, this.password);
                        return;
                    }
                    this.createLegacyKey();
                    return;
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "", ex);
                    this.password = null;
                    this.createLegacyKey();
                    try {
                        if (is == null) return;
                        is.close();
                        return;
                    }
                    catch (Exception exception) {}
                }
                return;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        this.createLegacyKey();
    }

    private void createLegacyKey() {
        this.m_key = new SecretKeySpec(new byte[]{100, 25, 28, -122, -26, 94, -3, -26}, LEGACY_ALGORITHM);
    }

    @Override
    public synchronized SecretKey getKey(int AD_Client_ID) {
        if (this.password != null) {
            try {
                KeyStore.PasswordProtection protParam = new KeyStore.PasswordProtection(this.password);
                String alias = "ad_client_" + AD_Client_ID;
                KeyStore.SecretKeyEntry entry = (KeyStore.SecretKeyEntry)this.keyStore.getEntry(alias, protParam);
                if (entry == null) {
                    KeyGenerator generator = KeyGenerator.getInstance(this.algorithm);
                    SecretKey key = generator.generateKey();
                    entry = new KeyStore.SecretKeyEntry(key);
                    this.keyStore.setEntry(alias, entry, protParam);
                    File file = new File(IDEMPIERE_KEYSTORE);
                    FileOutputStream stream = null;
                    try {
                        stream = new FileOutputStream(file);
                        this.keyStore.store(stream, this.password);
                        stream.flush();
                    }
                    finally {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                return entry.getSecretKey();
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "", ex);
            }
        }
        return this.m_key;
    }

    @Override
    public String getAlgorithm() {
        if (this.algorithm == null) {
            return LEGACY_ALGORITHM;
        }
        return this.algorithm;
    }
}

