/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.Serializable;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.compiere.util.CLogMgt;
import org.compiere.util.Env;
import org.compiere.util.ValueNamePair;

public class CLogger
extends Logger
implements Serializable {
    private static final long serialVersionUID = 6492376264463028357L;
    private static final String LAST_INFO = "org.compiere.util.CLogger.lastInfo";
    private static final String LAST_WARNING = "org.compiere.util.CLogger.lastWarning";
    private static final String LAST_ERROR = "org.compiere.util.CLogger.lastError";
    private static final String LAST_EXCEPTION = "org.compiere.util.CLogger.lastException";
    private static volatile CLogger s_logger = null;

    public static synchronized CLogger getCLogger(String className) {
        return CLogger.getCLogger(className, true);
    }

    public static synchronized CLogger getCLogger(String className, boolean usePackageLevel) {
        Logger result;
        LogManager manager = LogManager.getLogManager();
        if (className == null || className.trim().length() == 0) {
            className = "";
        }
        if ((result = manager.getLogger(className)) != null && result instanceof CLogger) {
            return (CLogger)result;
        }
        Logger packageLogger = null;
        if (className.indexOf(".") > 0 && usePackageLevel) {
            String s = className.substring(0, className.lastIndexOf("."));
            while (s.indexOf(".") > 0) {
                result = manager.getLogger(s);
                if (result != null && result instanceof CLogger) {
                    packageLogger = result;
                    break;
                }
                s = s.substring(0, s.lastIndexOf("."));
            }
        }
        CLogger newLogger = new CLogger(className, null);
        if (packageLogger != null && packageLogger.getLevel() != null) {
            newLogger.setLevel(packageLogger.getLevel());
        } else {
            newLogger.setLevel(CLogMgt.getLevel());
        }
        manager.addLogger(newLogger);
        return newLogger;
    }

    public static CLogger getCLogger(Class<?> clazz) {
        if (clazz == null) {
            return CLogger.get();
        }
        return CLogger.getCLogger(clazz.getName());
    }

    public static CLogger get() {
        if (s_logger == null) {
            s_logger = CLogger.getCLogger("org.compiere.default");
        }
        return s_logger;
    }

    private CLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
    }

    public boolean saveError(String AD_Message, String message) {
        return this.saveError(AD_Message, message, true);
    }

    public boolean saveError(String AD_Message, Exception ex) {
        Env.getCtx().put(LAST_EXCEPTION, ex);
        return this.saveError(AD_Message, ex.getLocalizedMessage(), true);
    }

    public boolean saveError(String AD_Message, Exception ex, boolean issueError) {
        Env.getCtx().put(LAST_EXCEPTION, ex);
        return this.saveError(AD_Message, ex.getLocalizedMessage(), issueError);
    }

    public boolean saveError(String AD_Message, String message, boolean issueError) {
        ValueNamePair lastError = new ValueNamePair(AD_Message, message);
        Env.getCtx().put(LAST_ERROR, lastError);
        if (issueError) {
            this.severe(String.valueOf(AD_Message) + " - " + message);
        }
        return true;
    }

    public static ValueNamePair retrieveError() {
        ValueNamePair vp = (ValueNamePair)Env.getCtx().remove(LAST_ERROR);
        return vp;
    }

    public static String retrieveErrorString(String defaultMsg) {
        ValueNamePair vp = CLogger.retrieveError();
        if (vp == null) {
            return defaultMsg;
        }
        return vp.getName();
    }

    public static Exception retrieveException() {
        Exception ex = (Exception)Env.getCtx().remove(LAST_EXCEPTION);
        return ex;
    }

    public boolean saveWarning(String AD_Message, String message) {
        ValueNamePair lastWarning = new ValueNamePair(AD_Message, message);
        Env.getCtx().put(LAST_WARNING, lastWarning);
        this.warning(String.valueOf(AD_Message) + " - " + message);
        return true;
    }

    public static ValueNamePair retrieveWarning() {
        ValueNamePair vp = (ValueNamePair)Env.getCtx().remove(LAST_WARNING);
        return vp;
    }

    public boolean saveInfo(String AD_Message, String message) {
        ValueNamePair lastInfo = new ValueNamePair(AD_Message, message);
        Env.getCtx().put(LAST_INFO, lastInfo);
        return true;
    }

    public static ValueNamePair retrieveInfo() {
        ValueNamePair vp = (ValueNamePair)Env.getCtx().remove(LAST_INFO);
        return vp;
    }

    public static void resetLast() {
        Env.getCtx().remove(LAST_ERROR);
        Env.getCtx().remove(LAST_EXCEPTION);
        Env.getCtx().remove(LAST_WARNING);
        Env.getCtx().remove(LAST_INFO);
    }

    public static Throwable getRootCause(Throwable t) {
        Throwable cause = t;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CLogger[");
        sb.append(this.getName()).append(",Level=").append(this.getLevel()).append("]");
        return sb.toString();
    }
}

