/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.compiere.model.MIssue;
import org.compiere.util.CLogFilter;
import org.compiere.util.CLogFormatter;
import org.compiere.util.CLogMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CLogErrorBuffer
extends Handler {
    private static final String ISSUE_ERROR_KEY = "org.compiere.util.CLogErrorBuffer.issueError";
    private static final String HISTORY_KEY = "org.compiere.util.CLogErrorBuffer.history";
    private static final String ERRORS_KEY = "org.compiere.util.CLogErrorBuffer.errors";
    private static final String LOGS_KEY = "org.compiere.util.CLogErrorBuffer.logs";
    private static final int ERROR_SIZE = 20;
    private static final int LOG_SIZE = 100;

    public CLogErrorBuffer() {
        this.initialize();
    }

    private void initialize() {
        this.setFormatter(CLogFormatter.get());
        super.setLevel(Level.INFO);
        this.setFilter(CLogFilter.get());
    }

    public boolean isIssueError() {
        Boolean b = (Boolean)Env.getCtx().get(ISSUE_ERROR_KEY);
        if (b == null) {
            b = Boolean.TRUE;
            this.setIssueError(b);
        }
        return b;
    }

    public void setIssueError(boolean issueError) {
        Env.getCtx().put(ISSUE_ERROR_KEY, (Object)issueError);
    }

    @Override
    public synchronized void setLevel(Level newLevel) throws SecurityException {
        if (newLevel == null) {
            return;
        }
        if (newLevel == Level.OFF) {
            super.setLevel(Level.SEVERE);
        } else if (newLevel == Level.ALL || newLevel == Level.FINEST || newLevel == Level.FINER) {
            super.setLevel(Level.FINE);
        } else {
            super.setLevel(newLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        this.checkContext();
        LinkedList m_logs = (LinkedList)Env.getCtx().get(LOGS_KEY);
        if (!this.isLoggable(record) || m_logs == null) {
            return;
        }
        LinkedList linkedList = m_logs;
        synchronized (linkedList) {
            if (m_logs.size() >= 100) {
                m_logs.removeFirst();
            }
            m_logs.add(record);
        }
        if (record.getLevel() == Level.SEVERE) {
            LinkedList m_errors = (LinkedList)Env.getCtx().get(ERRORS_KEY);
            LinkedList m_history = (LinkedList)Env.getCtx().get(HISTORY_KEY);
            if (m_errors.size() >= 20) {
                m_errors.removeFirst();
                m_history.removeFirst();
            }
            m_errors.add(record);
            record.getSourceClassName();
            ArrayList<LogRecord> history = new ArrayList<LogRecord>();
            int i2 = m_logs.size() - 1;
            while (i2 >= 0) {
                LogRecord rec = (LogRecord)m_logs.get(i2);
                if (rec.getLevel() == Level.SEVERE) {
                    if (history.size() != 0) break;
                    history.add(rec);
                } else {
                    history.add(rec);
                    if (history.size() > 10) break;
                }
                --i2;
            }
            LogRecord[] historyArray = new LogRecord[history.size()];
            int no = 0;
            int i3 = history.size() - 1;
            while (i3 >= 0) {
                historyArray[no++] = (LogRecord)history.get(i3);
                --i3;
            }
            m_history.add(historyArray);
            if (this.isIssueError()) {
                String methodName;
                String loggerName = record.getLoggerName();
                if (loggerName == null) {
                    loggerName = "";
                }
                if ((methodName = record.getSourceMethodName()) == null) {
                    methodName = "";
                }
                if (DB.isConnected(false) && methodName != null && !methodName.equals("saveError") && !methodName.equals("get_Value") && !methodName.equals("dataSave") && loggerName.indexOf("Issue") == -1 && loggerName.indexOf("CConnection") == -1) {
                    this.setIssueError(false);
                    try {
                        MIssue.create(record);
                        this.setIssueError(true);
                    }
                    catch (Throwable e) {
                        System.err.println(this.getFormatter().format(record));
                        this.setIssueError(false);
                    }
                } else if (!(methodName == null || methodName.equals("saveError") || methodName.equals("get_Value") || methodName.equals("dataSave") || loggerName.indexOf("Issue") != -1 || loggerName.indexOf("CConnection") != -1)) {
                    System.err.println(this.getFormatter().format(record));
                }
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        Env.getCtx().remove(LOGS_KEY);
        Env.getCtx().remove(ERRORS_KEY);
        Env.getCtx().remove(HISTORY_KEY);
    }

    public Vector<String> getColumnNames(Properties ctx) {
        Vector<String> cn = new Vector<String>();
        cn.add(Msg.getMsg(ctx, "DateTime"));
        cn.add(Msg.getMsg(ctx, "Level"));
        cn.add(Msg.getMsg(ctx, "Class.Method"));
        cn.add(Msg.getMsg(ctx, "Message"));
        cn.add(Msg.getMsg(ctx, "Parameter"));
        cn.add(Msg.getMsg(ctx, "Trace"));
        return cn;
    }

    public Vector<Vector<Object>> getLogData(boolean errorsOnly) {
        LogRecord[] records = this.getRecords(errorsOnly);
        Vector<Vector<Object>> rows = new Vector<Vector<Object>>(records.length);
        int i2 = 0;
        while (i2 < records.length) {
            LogRecord record = records[i2];
            Vector<Object> cols = new Vector<Object>();
            cols.add(new Timestamp(record.getMillis()));
            cols.add(record.getLevel().getName());
            cols.add(CLogFormatter.getClassMethod(record));
            cols.add(record.getMessage());
            cols.add(CLogFormatter.getParameters(record));
            cols.add(CLogFormatter.getExceptionTrace(record));
            rows.add(cols);
            ++i2;
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogRecord[] getRecords(boolean errorsOnly) {
        this.checkContext();
        LinkedList m_logs = (LinkedList)Env.getCtx().get(LOGS_KEY);
        LinkedList m_errors = (LinkedList)Env.getCtx().get(ERRORS_KEY);
        LogRecord[] retValue = null;
        if (errorsOnly) {
            LinkedList linkedList = m_errors;
            synchronized (linkedList) {
                retValue = new LogRecord[m_errors.size()];
                m_errors.toArray(retValue);
            }
        }
        LinkedList linkedList = m_logs;
        synchronized (linkedList) {
            retValue = new LogRecord[m_logs.size()];
            m_logs.toArray(retValue);
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetBuffer(boolean errorsOnly) {
        this.checkContext();
        LinkedList m_logs = (LinkedList)Env.getCtx().get(LOGS_KEY);
        LinkedList m_errors = (LinkedList)Env.getCtx().get(ERRORS_KEY);
        LinkedList m_history = (LinkedList)Env.getCtx().get(HISTORY_KEY);
        LinkedList linkedList = m_errors;
        synchronized (linkedList) {
            m_errors.clear();
            m_history.clear();
        }
        if (!errorsOnly) {
            linkedList = m_logs;
            synchronized (linkedList) {
                m_logs.clear();
            }
        }
    }

    public String getErrorInfo(Properties ctx, boolean errorsOnly) {
        this.checkContext();
        StringBuffer sb = new StringBuffer();
        if (errorsOnly) {
            LinkedList m_history = (LinkedList)Env.getCtx().get(HISTORY_KEY);
            int i2 = 0;
            while (i2 < m_history.size()) {
                sb.append("-------------------------------\n");
                LogRecord[] records = (LogRecord[])m_history.get(i2);
                int j = 0;
                while (j < records.length) {
                    LogRecord record = records[j];
                    sb.append(this.getFormatter().format(record));
                    ++j;
                }
                ++i2;
            }
        } else {
            LinkedList m_logs = (LinkedList)Env.getCtx().get(LOGS_KEY);
            int i3 = 0;
            while (i3 < m_logs.size()) {
                LogRecord record = (LogRecord)m_logs.get(i3);
                sb.append(this.getFormatter().format(record));
                ++i3;
            }
        }
        sb.append("\n");
        CLogMgt.getInfo(sb);
        CLogMgt.getInfoDetail(sb, ctx);
        return sb.toString();
    }

    private void checkContext() {
        if (!Env.getCtx().containsKey(LOGS_KEY)) {
            LinkedList m_logs = new LinkedList();
            Env.getCtx().put(LOGS_KEY, m_logs);
        }
        if (!Env.getCtx().containsKey(ERRORS_KEY)) {
            LinkedList m_errors = new LinkedList();
            Env.getCtx().put(ERRORS_KEY, m_errors);
        }
        if (!Env.getCtx().containsKey(HISTORY_KEY)) {
            LinkedList m_history = new LinkedList();
            Env.getCtx().put(HISTORY_KEY, m_history);
        }
    }

    public String toString() {
        this.checkContext();
        LinkedList m_logs = (LinkedList)Env.getCtx().get(LOGS_KEY);
        LinkedList m_errors = (LinkedList)Env.getCtx().get(ERRORS_KEY);
        LinkedList m_history = (LinkedList)Env.getCtx().get(HISTORY_KEY);
        StringBuilder sb = new StringBuilder("CLogErrorBuffer[");
        sb.append("Errors=").append(m_errors.size()).append(",History=").append(m_history.size()).append(",Logs=").append(m_logs.size()).append(",Level=").append(this.getLevel()).append("]");
        return sb.toString();
    }

    public static CLogErrorBuffer get(boolean create) {
        Handler handler;
        Handler[] handlers;
        Handler[] handlerArray = handlers = CLogMgt.getHandlers();
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            handler = handlerArray[n2];
            if (handler instanceof CLogErrorBuffer) {
                return (CLogErrorBuffer)handler;
            }
            ++n2;
        }
        if (create) {
            handler = new CLogErrorBuffer();
            CLogMgt.addHandler(handler);
            return handler;
        }
        return null;
    }
}

