/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.adempiere.base.Service;
import org.compiere.util.CacheInterface;
import org.compiere.util.CacheMgt;
import org.idempiere.distributed.ICacheService;

public class CCache<K, V>
implements CacheInterface,
Map<K, V>,
Serializable {
    private static final long serialVersionUID = -2268565219001179841L;
    private Map<K, V> cache = null;
    private Set<K> nullList = null;
    private String m_tableName;
    private boolean m_distributed;
    private int m_maxSize = 0;
    private String m_name = null;
    private int m_expire = 0;
    private volatile long m_timeExp = 0L;
    private boolean m_justReset = true;
    private VetoableChangeSupport m_changeSupport = null;
    private static String PROPERTYNAME = "cache";

    public CCache(String name, int initialCapacity) {
        this(name, name, initialCapacity);
    }

    public CCache(String name, int initialCapacity, int expireMinutes) {
        this(name, initialCapacity, expireMinutes, false);
    }

    public CCache(String name, int initialCapacity, int expireMinutes, boolean distributed) {
        this(name, name, initialCapacity, expireMinutes, distributed);
    }

    public CCache(String name, int initialCapacity, int expireMinutes, boolean distributed, int maxSize) {
        this(name, name, initialCapacity, expireMinutes, distributed, maxSize);
    }

    public CCache(String tableName, String name, int initialCapacity) {
        this(tableName, name, initialCapacity, false);
    }

    public CCache(String tableName, String name, int initialCapacity, boolean distributed) {
        this(tableName, name, initialCapacity, 60, distributed);
    }

    public CCache(String tableName, String name, int initialCapacity, int expireMinutes, boolean distributed) {
        this(tableName, name, initialCapacity, expireMinutes, distributed, CacheMgt.MAX_SIZE);
    }

    public CCache(String tableName, String name, int initialCapacity, int expireMinutes, boolean distributed, int maxSize) {
        ICacheService provider;
        this.m_name = name;
        this.m_tableName = tableName;
        this.setExpireMinutes(expireMinutes);
        this.m_maxSize = maxSize;
        this.cache = CacheMgt.get().register(this, distributed);
        this.m_distributed = distributed;
        if (distributed && (provider = Service.locator().locate(ICacheService.class).getService()) != null) {
            this.nullList = provider.getSet(name);
        }
        if (this.nullList == null) {
            this.nullList = Collections.synchronizedSet(new HashSet());
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getTableName() {
        return this.m_tableName;
    }

    public void setExpireMinutes(int expireMinutes) {
        if (expireMinutes > 0) {
            this.m_expire = expireMinutes;
            long addMS = 60000L * (long)this.m_expire;
            this.m_timeExp = System.currentTimeMillis() + addMS;
        } else {
            this.m_expire = 0;
            this.m_timeExp = 0L;
        }
    }

    public int getExpireMinutes() {
        return this.m_expire;
    }

    public boolean isReset() {
        return this.m_justReset;
    }

    public void setUsed() {
        this.m_justReset = false;
    }

    @Override
    public int reset() {
        int no = this.cache.size() + this.nullList.size();
        this.clear();
        return no;
    }

    private void expire() {
        if (this.m_expire != 0 && this.m_timeExp < System.currentTimeMillis()) {
            this.reset();
        }
    }

    public String toString() {
        return "CCache[" + this.m_name + ",Exp=" + this.getExpireMinutes() + ", #" + this.cache.size() + "]";
    }

    @Override
    public void clear() {
        if (this.m_changeSupport != null) {
            try {
                this.m_changeSupport.fireVetoableChange(PROPERTYNAME, this.cache.size(), 0);
            }
            catch (Exception e) {
                System.out.println("CCache.clear - " + e);
                return;
            }
        }
        this.cache.clear();
        this.nullList.clear();
        if (this.m_expire != 0) {
            long addMS = 60000L * (long)this.m_expire;
            this.m_timeExp = System.currentTimeMillis() + addMS;
        }
        this.m_justReset = true;
    }

    @Override
    public boolean containsKey(Object key) {
        this.expire();
        return this.cache.containsKey(key) || this.nullList.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.expire();
        return this.cache.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.expire();
        return this.cache.entrySet();
    }

    @Override
    public V get(Object key) {
        this.expire();
        return this.cache.get(key);
    }

    @Override
    public V put(K key, V value) {
        this.expire();
        this.m_justReset = false;
        if (value == null) {
            this.cache.remove(key);
            this.nullList.add(key);
            return null;
        }
        if (!this.nullList.isEmpty()) {
            this.nullList.remove(key);
        }
        return this.cache.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.expire();
        this.m_justReset = false;
        this.cache.putAll(m);
    }

    @Override
    public boolean isEmpty() {
        this.expire();
        return this.cache.isEmpty() && this.nullList.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        this.expire();
        return this.cache.keySet();
    }

    @Override
    public int size() {
        this.expire();
        return this.cache.size() + this.nullList.size();
    }

    public int sizeNoExpire() {
        return this.cache.size() + this.nullList.size();
    }

    @Override
    public Collection<V> values() {
        this.expire();
        return this.cache.values();
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (this.m_changeSupport == null) {
            this.m_changeSupport = new VetoableChangeSupport(this);
        }
        if (listener != null) {
            this.m_changeSupport.addVetoableChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (this.m_changeSupport != null && listener != null) {
            this.m_changeSupport.removeVetoableChangeListener(listener);
        }
    }

    @Override
    public V remove(Object key) {
        if (!this.nullList.isEmpty() && this.nullList.remove(key)) {
            return null;
        }
        return this.cache.remove(key);
    }

    @Override
    public int reset(int recordId) {
        if (recordId <= 0) {
            return this.reset();
        }
        if (!this.nullList.isEmpty() && this.nullList.remove(recordId)) {
            return 1;
        }
        V removed = this.cache.remove(recordId);
        return removed != null ? 1 : 0;
    }

    @Override
    public void newRecord(int record_ID) {
    }

    public int getMaxSize() {
        return this.m_maxSize;
    }
}

