/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.compiere.util.AmtInWords;

public class AmtInWords_ZH
implements AmtInWords {
    private static final String[] scaleNames = new String[]{"\u5206", "\u89d2", "\u5143", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u5146"};
    private static final String[] numNames = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String CNY_NEGATIVE = "\u8d1f";
    private static final String CNY_FULL = "\u6574";
    private static final String CNY_ZEOR_FULL = "\u96f6\u5143\u6574";

    private String convert(BigDecimal number) {
        StringBuffer sb = new StringBuffer();
        int signum = number.signum();
        int numUnit = 0;
        int numIndex = 0;
        int zeroSize = 0;
        if (signum == 0) {
            return CNY_ZEOR_FULL;
        }
        long lnumber = number.movePointRight(2).setScale(0, RoundingMode.HALF_UP).abs().longValue();
        if (lnumber >= 1000000000000000L) {
            return "\u4eb2\uff0c\u91d1\u989d\u8f6c\u6362\u4e0a\u9650\u4e3a10\u5146\uff0810\u4e07\u4ebf\uff09";
        }
        long decamt = lnumber % 100L;
        boolean getZero = false;
        if (decamt <= 0L) {
            numIndex = 2;
            lnumber /= 100L;
            getZero = true;
        }
        if (decamt > 0L && decamt % 10L <= 0L) {
            numIndex = 1;
            lnumber /= 10L;
            getZero = true;
        }
        while (lnumber > 0L) {
            numUnit = (int)(lnumber % 10L);
            if (numUnit > 0) {
                if (numIndex == 9 && zeroSize >= 3) {
                    sb.insert(0, scaleNames[6]);
                }
                if (numIndex == 13 && zeroSize >= 3) {
                    sb.insert(0, scaleNames[10]);
                }
                sb.insert(0, scaleNames[numIndex]);
                sb.insert(0, numNames[numUnit]);
                getZero = false;
                zeroSize = 0;
            } else {
                ++zeroSize;
                if (!getZero & numIndex != 2) {
                    sb.insert(0, numNames[numUnit]);
                }
                if (numIndex == 2) {
                    sb.insert(0, scaleNames[numIndex]);
                } else if ((numIndex - 2) % 4 == 0 && lnumber % 1000L > 0L) {
                    sb.insert(0, scaleNames[numIndex]);
                }
                getZero = true;
            }
            lnumber /= 10L;
            ++numIndex;
        }
        if (decamt <= 0L) {
            sb.append(CNY_FULL);
        }
        if (signum == -1) {
            sb.insert(0, CNY_NEGATIVE);
        }
        return sb.toString();
    }

    @Override
    public String getAmtInWords(String amount) throws Exception {
        if (amount == null || amount.length() <= 0) {
            return amount;
        }
        amount = amount.replaceAll(",", "");
        StringBuilder sb = new StringBuilder();
        BigDecimal cny = new BigDecimal(amount);
        sb.append(this.convert(cny));
        return sb.toString();
    }

    private void print(String amt) {
        try {
            System.out.println(String.valueOf(amt) + " = " + this.getAmtInWords(amt));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AmtInWords_ZH aiw = new AmtInWords_ZH();
        aiw.print(null);
        aiw.print("");
        aiw.print("0.00");
        aiw.print("0.03");
        aiw.print("0.234");
        aiw.print("1.001");
        aiw.print("1.035");
        aiw.print("1.205");
        aiw.print("1.3345");
        aiw.print("10.03");
        aiw.print("10.23");
        aiw.print("23.00");
        aiw.print("100.20");
        aiw.print("103.45");
        aiw.print("2,345");
        aiw.print("1020.45");
        aiw.print("1,234.56");
        aiw.print("12345.78");
        aiw.print("100457.89");
        aiw.print("103457.89");
        aiw.print("107000.03");
        aiw.print("9,000,000.00");
        aiw.print("10,000,000.00");
        aiw.print("10220134");
        aiw.print("100,234,578.90");
        aiw.print("203010000.56");
        aiw.print("103,004,000.90");
        aiw.print("1,201,034,578.90");
        aiw.print("90,000,000,000");
        aiw.print("100,000,000,000");
        aiw.print("1,932,110,345,780");
        aiw.print("10,000,000,000,000");
        aiw.print("-1220.354");
    }
}

