/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.sla;

import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MSLACriteria;
import org.compiere.model.MSLAGoal;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.sla.SLACriteria;
import org.compiere.util.AdempiereUserError;

public class SLAGoalProcess
extends SvrProcess {
    private int p_PA_SLA_Goal_ID;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i2 = 0;
        while (i2 < para.length) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() != null) {
                this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
            }
            ++i2;
        }
        this.p_PA_SLA_Goal_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        MSLAGoal goal;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("PA_SLA_Goal_ID=" + this.p_PA_SLA_Goal_ID);
        }
        if ((goal = new MSLAGoal(this.getCtx(), this.p_PA_SLA_Goal_ID, this.get_TrxName())).get_ID() == 0) {
            throw new AdempiereUserError("@PA_SLA_Goal_ID@ " + this.p_PA_SLA_Goal_ID);
        }
        MSLACriteria criteria = MSLACriteria.get(this.getCtx(), goal.getPA_SLA_Criteria_ID(), this.get_TrxName());
        if (criteria.get_ID() == 0) {
            throw new AdempiereUserError("@PA_SLA_Criteria_ID@ " + goal.getPA_SLA_Criteria_ID());
        }
        SLACriteria pgm = criteria.newInstance();
        int no = pgm.createMeasures(goal);
        goal.setMeasureActual(pgm.calculateMeasure(goal));
        goal.setDateLastRun(new Timestamp(System.currentTimeMillis()));
        goal.saveEx();
        return "@Created@ " + no + " - @MeasureActual@=" + goal.getMeasureActual();
    }
}

