/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import org.compiere.model.MPeriod;
import org.compiere.model.MReportCube;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.report.FinReportPeriod;
import org.compiere.report.MReport;
import org.compiere.report.MReportColumn;
import org.compiere.report.MReportLine;
import org.compiere.report.MReportTree;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.TimeUtil;

public class FinReport
extends SvrProcess {
    private int p_C_Period_ID = 0;
    private int p_Org_ID = 0;
    private int p_C_BPartner_ID = 0;
    private int p_M_Product_ID = 0;
    private int p_C_Project_ID = 0;
    private int p_C_Activity_ID = 0;
    private int p_C_SalesRegion_ID = 0;
    private int p_C_Campaign_ID = 0;
    private int p_User1_ID = 0;
    private int p_User2_ID = 0;
    private int p_UserElement1_ID = 0;
    private int p_UserElement2_ID = 0;
    private boolean p_DetailsSourceFirst = false;
    private int p_PA_Hierarchy_ID = 0;
    private int p_PA_ReportCube_ID = 0;
    private String p_AdjPeriodToExclude = "";
    private long m_start = System.currentTimeMillis();
    private MReport m_report = null;
    private FinReportPeriod[] m_periods = null;
    private int m_reportPeriod = -1;
    private StringBuffer m_parameterWhere = new StringBuffer();
    private MReportColumn[] m_columns;
    private MReportLine[] m_lines;

    @Override
    protected void prepare() {
        int adjPeriodToExclude_ID;
        MPeriod per;
        StringBuffer sb = new StringBuffer("Record_ID=").append(this.getRecord_ID());
        ProcessInfoParameter[] para = this.getParameter();
        int i2 = 0;
        while (i2 < para.length) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() != null) {
                if (name.equals("C_Period_ID")) {
                    this.p_C_Period_ID = para[i2].getParameterAsInt();
                } else if (name.equals("PA_Hierarchy_ID")) {
                    this.p_PA_Hierarchy_ID = para[i2].getParameterAsInt();
                } else if (name.equals("Org_ID")) {
                    this.p_Org_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                } else if (name.equals("M_Product_ID")) {
                    this.p_M_Product_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                } else if (name.equals("C_Project_ID")) {
                    this.p_C_Project_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                } else if (name.equals("C_Activity_ID")) {
                    this.p_C_Activity_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                } else if (name.equals("C_SalesRegion_ID")) {
                    this.p_C_SalesRegion_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                } else if (name.equals("C_Campaign_ID")) {
                    this.p_C_Campaign_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                } else if (name.equals("User1_ID")) {
                    this.p_User1_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                } else if (name.equals("User2_ID")) {
                    this.p_User2_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                } else if (name.equals("UserElement1_ID")) {
                    this.p_UserElement1_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                } else if (name.equals("UserElement2_ID")) {
                    this.p_UserElement2_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                } else if (name.equals("DetailsSourceFirst")) {
                    this.p_DetailsSourceFirst = "Y".equals(para[i2].getParameter());
                } else if (name.equals("PA_ReportCube_ID")) {
                    this.p_PA_ReportCube_ID = para[i2].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i2;
        }
        if (this.p_Org_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "OO", this.p_Org_ID));
        }
        if (this.p_C_BPartner_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "BP", this.p_C_BPartner_ID));
        }
        if (this.p_M_Product_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "PR", this.p_M_Product_ID));
        }
        if (this.p_C_Project_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "PJ", this.p_C_Project_ID));
        }
        if (this.p_C_Activity_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "AY", this.p_C_Activity_ID));
        }
        if (this.p_C_Campaign_ID != 0) {
            this.m_parameterWhere.append(" AND C_Campaign_ID=").append(this.p_C_Campaign_ID);
        }
        if (this.p_C_SalesRegion_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "SR", this.p_C_SalesRegion_ID));
        }
        if (this.p_User1_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "U1", this.p_User1_ID));
        }
        if (this.p_User2_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "U2", this.p_User2_ID));
        }
        if (this.p_UserElement1_ID != 0) {
            this.m_parameterWhere.append(" AND UserElement1_ID=").append(this.p_UserElement1_ID);
        }
        if (this.p_UserElement2_ID != 0) {
            this.m_parameterWhere.append(" AND UserElement2_ID=").append(this.p_UserElement2_ID);
        }
        this.m_report = new MReport(this.getCtx(), this.getRecord_ID(), null);
        sb.append(" - ").append(this.m_report);
        if (this.p_C_Period_ID > 0 && "S".equals((per = MPeriod.get(this.getCtx(), this.p_C_Period_ID)).getPeriodType()) && (adjPeriodToExclude_ID = DB.getSQLValue(this.get_TrxName(), "SELECT C_Period_ID FROM C_Period WHERE IsActive='Y' AND PeriodType=? AND EndDate=? AND C_Year_ID=?", "A", per.getEndDate(), per.getC_Year_ID())) > 0) {
            this.p_AdjPeriodToExclude = " C_Period_ID!=" + adjPeriodToExclude_ID + " AND ";
            this.log.warning("Will Exclude Adjustment Period -> " + this.p_AdjPeriodToExclude);
        }
        this.setPeriods();
        sb.append(" - C_Period_ID=").append(this.p_C_Period_ID).append(" - ").append(this.m_parameterWhere);
        if (this.p_PA_ReportCube_ID > 0) {
            this.m_parameterWhere.append(" AND PA_ReportCube_ID=").append(this.p_PA_ReportCube_ID);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(sb.toString());
        }
    }

    private void setPeriods() {
        ArrayList<FinReportPeriod> list;
        block9: {
            MPeriod per;
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("C_Calendar_ID=" + this.m_report.getC_Calendar_ID());
            }
            Timestamp today = TimeUtil.getDay(System.currentTimeMillis());
            if (this.p_C_Period_ID > 0 && "A".equals((per = MPeriod.get(this.getCtx(), this.p_C_Period_ID)).getPeriodType())) {
                today = per.getEndDate();
                this.p_C_Period_ID = 0;
            }
            list = new ArrayList<FinReportPeriod>();
            String sql = "SELECT p.C_Period_ID, p.Name, p.StartDate, p.EndDate, MIN(p1.StartDate) FROM C_Period p  INNER JOIN C_Year y ON (p.C_Year_ID=y.C_Year_ID), C_Period p1 WHERE y.C_Calendar_ID=? AND p.IsActive='Y' AND p.PeriodType='S'  AND p1.C_Year_ID=y.C_Year_ID AND p1.PeriodType='S' GROUP BY p.C_Period_ID, p.Name, p.StartDate, p.EndDate ORDER BY p.StartDate";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, this.m_report.getC_Calendar_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        FinReportPeriod frp = new FinReportPeriod(rs.getInt(1), rs.getString(2), rs.getTimestamp(3), rs.getTimestamp(4), rs.getTimestamp(5));
                        list.add(frp);
                        if (this.p_C_Period_ID != 0 || !frp.inPeriod(today)) continue;
                        this.p_C_Period_ID = frp.getC_Period_ID();
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_periods = new FinReportPeriod[list.size()];
        list.toArray(this.m_periods);
        if (this.p_C_Period_ID == 0) {
            this.m_reportPeriod = this.m_periods.length - 1;
            this.p_C_Period_ID = this.m_periods[this.m_reportPeriod].getC_Period_ID();
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("AD_PInstance_ID=" + this.getAD_PInstance_ID());
        }
        if (this.p_PA_ReportCube_ID > 0) {
            MReportCube cube = new MReportCube(this.getCtx(), this.p_PA_ReportCube_ID, this.get_TrxName());
            String result = cube.update(false, false);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, result);
            }
        }
        int PA_ReportLineSet_ID = this.m_report.getLineSet().getPA_ReportLineSet_ID();
        StringBuffer sql = new StringBuffer("INSERT INTO T_Report (AD_PInstance_ID, PA_ReportLine_ID, Record_ID,Fact_Acct_ID, SeqNo,LevelNo, Name,Description) SELECT ").append(this.getAD_PInstance_ID()).append(", PA_ReportLine_ID, 0,0, SeqNo,0, Name,Description FROM PA_ReportLine WHERE IsActive='Y' AND PA_ReportLineSet_ID=").append(PA_ReportLineSet_ID);
        int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Report Lines = " + no);
        }
        this.m_columns = this.m_report.getColumnSet().getColumns();
        if (this.m_columns.length == 0) {
            throw new AdempiereUserError("@No@ @PA_ReportColumn_ID@");
        }
        this.m_lines = this.m_report.getLineSet().getLiness();
        if (this.m_lines.length == 0) {
            throw new AdempiereUserError("@No@ @PA_ReportLine_ID@");
        }
        int line = 0;
        while (line < this.m_lines.length) {
            if (this.m_lines[line].isLineTypeSegmentValue()) {
                this.insertLine(line);
            }
            ++line;
        }
        this.insertLineDetail();
        this.doCalculations();
        this.doColumnPercentageOfLineForMultiRange();
        this.deleteUnprintedLines();
        this.scaleResults();
        if (Ini.isClient()) {
            this.getProcessInfo().setTransientObject(this.getPrintFormat());
        } else {
            this.getProcessInfo().setSerializableObject(this.getPrintFormat());
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(System.currentTimeMillis() - this.m_start) + " ms");
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     */
    private void insertLine(int line) {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("" + this.m_lines[line]);
        }
        if (this.m_lines[line] == null || this.m_lines[line].getSources().length == 0) {
            this.log.warning("No Source lines: " + this.m_lines[line]);
            return;
        }
        StringBuffer update = new StringBuffer();
        int col = 0;
        while (col < this.m_columns.length) {
            block32: {
                StringBuffer select;
                StringBuilder info;
                block31: {
                    String sql;
                    FinReportPeriod frp;
                    block36: {
                        block38: {
                            block37: {
                                block34: {
                                    String sql2;
                                    block35: {
                                        block33: {
                                            if (this.m_columns[col].isColumnTypeCalculation()) break block32;
                                            info = new StringBuilder();
                                            info.append("Line=").append(line).append(",Col=").append(col);
                                            select = new StringBuffer("SELECT ");
                                            if (this.m_lines[line].getPAAmountType() == null) break block33;
                                            sql2 = this.m_lines[line].getSelectClause(true);
                                            select.append(sql2);
                                            info.append(": LineAmtType=").append(this.m_lines[line].getPAAmountType());
                                            break block34;
                                        }
                                        if (this.m_columns[col].getPAAmountType() != null) break block35;
                                        this.log.warning("No Amount Type in line: " + this.m_lines[line] + " or column: " + this.m_columns[col]);
                                        break block32;
                                    }
                                    sql2 = this.m_columns[col].getSelectClause(true);
                                    select.append(sql2);
                                    info.append(": ColumnAmtType=").append(this.m_columns[col].getPAAmountType());
                                }
                                if (this.p_PA_ReportCube_ID > 0) {
                                    select.append(" FROM Fact_Acct_Summary fa WHERE ").append(this.p_AdjPeriodToExclude).append("DateAcct ");
                                } else {
                                    select.append(" FROM Fact_Acct fa WHERE ").append(this.p_AdjPeriodToExclude).append("TRUNC(DateAcct) ");
                                }
                                BigDecimal relativeOffset = null;
                                if (this.m_columns[col].isColumnTypeRelativePeriod()) {
                                    relativeOffset = this.m_columns[col].getRelativePeriod();
                                }
                                frp = this.getPeriod(relativeOffset);
                                if (this.m_lines[line].getPAPeriodType() == null) break block36;
                                info.append(" - LineDateAcct=");
                                if (!this.m_lines[line].isPeriod()) break block37;
                                sql = frp.getPeriodWhere();
                                info.append("Period");
                                select.append(sql);
                                break block31;
                            }
                            if (!this.m_lines[line].isYear()) break block38;
                            sql = frp.getYearWhere();
                            info.append("Year");
                            select.append(sql);
                            break block31;
                        }
                        if (this.m_lines[line].isTotal()) {
                            sql = frp.getTotalWhere();
                            info.append("Total");
                            select.append(sql);
                            break block31;
                        } else if (this.m_lines[line].isNatural()) {
                            select.append(frp.getNaturalWhere("fa"));
                            break block31;
                        } else {
                            this.log.log(Level.SEVERE, "No valid Line PAPeriodType");
                            select.append("=0");
                        }
                        break block31;
                    }
                    if (this.m_columns[col].getPAPeriodType() != null) {
                        info.append(" - ColumnDateAcct=");
                        if (this.m_columns[col].isPeriod()) {
                            sql = frp.getPeriodWhere();
                            info.append("Period");
                            select.append(sql);
                        } else if (this.m_columns[col].isYear()) {
                            sql = frp.getYearWhere();
                            info.append("Year");
                            select.append(sql);
                        } else if (this.m_columns[col].isTotal()) {
                            sql = frp.getTotalWhere();
                            info.append("Total");
                            select.append(sql);
                        } else if (this.m_columns[col].isNatural()) {
                            select.append(frp.getNaturalWhere("fa"));
                        } else {
                            this.log.log(Level.SEVERE, "No valid Column PAPeriodType");
                            select.append("=0");
                        }
                    }
                }
                String s = this.m_lines[line].getWhereClause(this.p_PA_Hierarchy_ID);
                if (s != null && s.length() > 0) {
                    select.append(" AND ").append(s);
                }
                if ((s = this.m_report.getWhereClause()) != null && s.length() > 0) {
                    select.append(" AND ").append(s);
                }
                if (!this.m_lines[line].isPostingType()) {
                    String PostingType = this.m_columns[col].getPostingType();
                    if (PostingType != null && PostingType.length() > 0) {
                        select.append(" AND PostingType='").append(PostingType).append("'");
                    }
                    if ("B".equals(PostingType) && this.m_columns[col].getGL_Budget_ID() > 0) {
                        select.append(" AND GL_Budget_ID=" + this.m_columns[col].getGL_Budget_ID());
                    }
                }
                if (this.m_columns[col].isColumnTypeSegmentValue()) {
                    select.append(this.m_columns[col].getWhereClause(this.p_PA_Hierarchy_ID));
                }
                select.append(this.m_parameterWhere);
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("Line=" + line + ",Col=" + line + ": " + select);
                }
                if (update.length() > 0) {
                    update.append(", ");
                }
                update.append("Col_").append(col).append(" = (").append(select).append(")");
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest(info.toString());
                }
            }
            ++col;
        }
        if (update.length() > 0) {
            update.insert(0, "UPDATE T_Report SET ");
            update.append(" WHERE AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND PA_ReportLine_ID=").append(this.m_lines[line].getPA_ReportLine_ID()).append(" AND ABS(LevelNo)<2");
            int no = DB.executeUpdate(update.toString(), this.get_TrxName());
            if (no != 1) {
                this.log.log(Level.SEVERE, "#=" + no + " for " + update);
            }
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest(update.toString());
            }
        }
    }

    private void doCalculations() {
        int line = 0;
        while (line < this.m_lines.length) {
            if (this.m_lines[line].isLineTypeCalculation()) {
                int no;
                int col;
                Iterator iterator;
                StringBuilder sb;
                int oper_1;
                int col2;
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Line " + line + " = #" + this.m_lines[line].getOper_1_ID() + " " + this.m_lines[line].getCalculationType() + " #" + this.m_lines[line].getOper_2_ID());
                }
                ArrayList<Integer> addList = new ArrayList<Integer>();
                ArrayList<Integer> notAddList = new ArrayList<Integer>();
                boolean inverse = this.m_lines[line].isInverseDebitCreditOnly();
                if (this.m_lines[line].isCalculationTypeAdd() || this.m_lines[line].isCalculationTypeRange()) {
                    col2 = 0;
                    while (col2 < this.m_columns.length) {
                        if (this.m_columns[col2].isColumnTypeCalculation() || !inverse) {
                            addList.add(col2);
                        } else {
                            String amountType = this.m_columns[col2].getPAAmountType();
                            if (amountType != null && (amountType.startsWith("C") || amountType.startsWith("D"))) {
                                notAddList.add(col2);
                            } else {
                                addList.add(col2);
                            }
                        }
                        ++col2;
                    }
                } else if (this.m_lines[line].isCalculationTypeSubtract()) {
                    col2 = 0;
                    while (col2 < this.m_columns.length) {
                        if (this.m_columns[col2].isColumnTypeCalculation() || !inverse) {
                            notAddList.add(col2);
                        } else {
                            String amountType = this.m_columns[col2].getPAAmountType();
                            if (amountType != null && (amountType.startsWith("C") || amountType.startsWith("D"))) {
                                addList.add(col2);
                            } else {
                                notAddList.add(col2);
                            }
                        }
                        ++col2;
                    }
                } else {
                    col2 = 0;
                    while (col2 < this.m_columns.length) {
                        notAddList.add(col2);
                        ++col2;
                    }
                }
                if (addList.size() > 0) {
                    int oper_2;
                    oper_1 = this.m_lines[line].getOper_1_ID();
                    if (oper_1 > (oper_2 = this.m_lines[line].getOper_2_ID())) {
                        int temp = oper_1;
                        oper_1 = oper_2;
                        oper_2 = temp;
                    }
                    sb = new StringBuilder("UPDATE T_Report SET ");
                    if (DB.isPostgreSQL()) {
                        iterator = addList.iterator();
                        while (iterator.hasNext()) {
                            col = (Integer)iterator.next();
                            if (col > 0) {
                                sb.append(",");
                            }
                            sb.append("Col_").append(col).append("=").append("r2.c").append(col);
                        }
                        sb.append(" FROM ( SELECT ");
                        iterator = addList.iterator();
                        while (iterator.hasNext()) {
                            col = (Integer)iterator.next();
                            if (col > 0) {
                                sb.append(",");
                            }
                            sb.append("COALESCE(SUM(r2.Col_").append(col).append("),0) AS c").append(col);
                        }
                    } else {
                        sb.append(" (");
                        iterator = addList.iterator();
                        while (iterator.hasNext()) {
                            col = (Integer)iterator.next();
                            if (col > 0) {
                                sb.append(",");
                            }
                            sb.append("Col_").append(col);
                        }
                        sb.append(") = (SELECT ");
                        iterator = addList.iterator();
                        while (iterator.hasNext()) {
                            col = (Integer)iterator.next();
                            if (col > 0) {
                                sb.append(",");
                            }
                            sb.append("COALESCE(SUM(r2.Col_").append(col).append("),0)");
                        }
                    }
                    sb.append(" FROM T_Report r2 WHERE r2.AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND r2.PA_ReportLine_ID IN (");
                    if (this.m_lines[line].isCalculationTypeAdd()) {
                        sb.append(oper_1).append(",").append(oper_2);
                    } else {
                        sb.append(this.getLineIDs(oper_1, oper_2));
                    }
                    sb.append(") AND ABS(r2.LevelNo)<1) ");
                    if (DB.isPostgreSQL()) {
                        sb.append(" r2 ");
                    }
                    sb.append("WHERE T_Report.AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND T_Report.PA_ReportLine_ID=").append(this.m_lines[line].getPA_ReportLine_ID()).append(" AND ABS(T_Report.LevelNo)<1");
                    no = DB.executeUpdate(sb.toString(), this.get_TrxName());
                    if (no != 1) {
                        this.log.log(Level.SEVERE, "(+) #=" + no + " for " + this.m_lines[line] + " - " + sb.toString());
                    } else {
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("(+) Line=" + line + " - " + this.m_lines[line]);
                        }
                        if (this.log.isLoggable(Level.FINEST)) {
                            this.log.finest("(+) " + sb.toString());
                        }
                    }
                }
                if (notAddList.size() > 0) {
                    oper_1 = this.m_lines[line].getOper_1_ID();
                    int oper_2 = this.m_lines[line].getOper_2_ID();
                    sb = new StringBuilder("UPDATE T_Report SET ");
                    if (DB.isPostgreSQL()) {
                        iterator = notAddList.iterator();
                        while (iterator.hasNext()) {
                            col = (Integer)iterator.next();
                            if (col > 0) {
                                sb.append(",");
                            }
                            sb.append("Col_").append(col).append("=r2.c").append(col);
                        }
                        sb.append(" FROM (SELECT ");
                        iterator = notAddList.iterator();
                        while (iterator.hasNext()) {
                            col = (Integer)iterator.next();
                            if (col > 0) {
                                sb.append(",");
                            }
                            sb.append("COALESCE(r2.Col_").append(col).append(",0) AS c").append(col);
                        }
                    } else {
                        sb.append(" (");
                        iterator = notAddList.iterator();
                        while (iterator.hasNext()) {
                            col = (Integer)iterator.next();
                            if (col > 0) {
                                sb.append(",");
                            }
                            sb.append("Col_").append(col);
                        }
                        sb.append(") = (SELECT ");
                        iterator = notAddList.iterator();
                        while (iterator.hasNext()) {
                            col = (Integer)iterator.next();
                            if (col > 0) {
                                sb.append(",");
                            }
                            sb.append("COALESCE(r2.Col_").append(col).append(",0)");
                        }
                    }
                    sb.append(" FROM T_Report r2 WHERE r2.AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND r2.PA_ReportLine_ID=").append(oper_1).append(" AND r2.Record_ID=0 AND r2.Fact_Acct_ID=0) ");
                    if (DB.isPostgreSQL()) {
                        sb.append(" r2 ");
                    }
                    sb.append("WHERE T_Report.AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND T_Report.PA_ReportLine_ID=").append(this.m_lines[line].getPA_ReportLine_ID()).append(" AND ABS(T_Report.LevelNo)<1");
                    no = DB.executeUpdate(sb.toString(), this.get_TrxName());
                    if (no != 1) {
                        this.log.severe("(x) #=" + no + " for " + this.m_lines[line] + " - " + sb.toString());
                    } else {
                        Iterator iterator2;
                        sb = new StringBuilder("UPDATE T_Report r1 SET ");
                        if (DB.isPostgreSQL()) {
                            iterator2 = notAddList.iterator();
                            while (iterator2.hasNext()) {
                                int col3 = (Integer)iterator2.next();
                                if (col3 > 0) {
                                    sb.append(",");
                                }
                                sb.append("Col_").append(col3).append("=");
                                sb.append("COALESCE(r1.Col_").append(col3).append(",0)");
                                if (this.m_lines[line].isCalculationTypeSubtract()) {
                                    sb.append("-");
                                    sb.append(" r2.c").append(col3);
                                } else {
                                    sb.append("/ r2.c").append(col3);
                                }
                                if (!this.m_lines[line].isCalculationTypePercent()) continue;
                                sb.append(" *100");
                            }
                            sb.append(" FROM (SELECT ");
                            iterator2 = notAddList.iterator();
                            while (iterator2.hasNext()) {
                                int col4 = (Integer)iterator2.next();
                                if (col4 > 0) {
                                    sb.append(",");
                                }
                                if (this.m_lines[line].isCalculationTypeSubtract()) {
                                    sb.append("COALESCE(r2.Col_").append(col4).append(",0) AS c").append(col4);
                                    continue;
                                }
                                sb.append("CASE WHEN r2.Col_").append(col4).append("=0 THEN NULL ELSE r2.Col_").append(col4).append(" END AS c").append(col4);
                            }
                        } else {
                            sb.append(" (");
                            iterator2 = notAddList.iterator();
                            while (iterator2.hasNext()) {
                                int col5 = (Integer)iterator2.next();
                                if (col5 > 0) {
                                    sb.append(",");
                                }
                                sb.append("Col_").append(col5);
                            }
                            sb.append(") = (SELECT ");
                            iterator2 = notAddList.iterator();
                            while (iterator2.hasNext()) {
                                int col6 = (Integer)iterator2.next();
                                if (col6 > 0) {
                                    sb.append(",");
                                }
                                sb.append("COALESCE(r1.Col_").append(col6).append(",0)");
                                if (this.m_lines[line].isCalculationTypeSubtract()) {
                                    sb.append("-");
                                    sb.append("COALESCE(r2.Col_").append(col6).append(",0)");
                                } else {
                                    sb.append("/");
                                    sb.append("CASE WHEN r2.Col_").append(col6).append("=0 THEN NULL ELSE r2.Col_").append(col6).append(" END");
                                }
                                if (!this.m_lines[line].isCalculationTypePercent()) continue;
                                sb.append(" *100");
                            }
                        }
                        sb.append(" FROM T_Report r2 WHERE r2.AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND r2.PA_ReportLine_ID=").append(oper_2).append(" AND r2.Record_ID=0 AND r2.Fact_Acct_ID=0) ");
                        if (DB.isPostgreSQL()) {
                            sb.append(" r2 ");
                        }
                        sb.append("WHERE r1.AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND r1.PA_ReportLine_ID=").append(this.m_lines[line].getPA_ReportLine_ID()).append(" AND ABS(r1.LevelNo)<1");
                        no = DB.executeUpdate(sb.toString(), this.get_TrxName());
                        if (no != 1) {
                            this.log.severe("(x) #=" + no + " for " + this.m_lines[line] + " - " + sb.toString());
                        } else {
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("(x) Line=" + line + " - " + this.m_lines[line]);
                            }
                            if (this.log.isLoggable(Level.FINEST)) {
                                this.log.finest(sb.toString());
                            }
                        }
                    }
                }
            }
            ++line;
        }
        int col = 0;
        while (col < this.m_columns.length) {
            block87: {
                StringBuilder sb;
                block92: {
                    int ii_2;
                    int ii_1;
                    block90: {
                        block91: {
                            block89: {
                                block88: {
                                    if (!this.m_columns[col].isColumnTypeCalculation()) break block87;
                                    sb = new StringBuilder("UPDATE T_Report SET ");
                                    sb.append("Col_").append(col).append("=");
                                    ii_1 = this.getColumnIndex(this.m_columns[col].getOper_1_ID());
                                    if (ii_1 >= 0) break block88;
                                    this.log.log(Level.SEVERE, "Column Index for Operator 1 not found - " + this.m_columns[col]);
                                    break block87;
                                }
                                ii_2 = this.getColumnIndex(this.m_columns[col].getOper_2_ID());
                                if (ii_2 >= 0) break block89;
                                this.log.log(Level.SEVERE, "Column Index for Operator 2 not found - " + this.m_columns[col]);
                                break block87;
                            }
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("Column " + col + " = #" + ii_1 + " " + this.m_columns[col].getCalculationType() + " #" + ii_2);
                            }
                            if (ii_1 > ii_2 && this.m_columns[col].isCalculationTypeRange()) {
                                if (this.log.isLoggable(Level.FINE)) {
                                    this.log.fine("Swap operands from " + ii_1 + " op " + ii_2);
                                }
                                int temp = ii_1;
                                ii_1 = ii_2;
                                ii_2 = temp;
                            }
                            if (this.m_columns[col].isCalculationTypeAdd()) {
                                sb.append("COALESCE(Col_").append(ii_1).append(",0)").append("+").append("COALESCE(Col_").append(ii_2).append(",0)");
                            } else if (this.m_columns[col].isCalculationTypeSubtract()) {
                                sb.append("COALESCE(Col_").append(ii_1).append(",0)").append("-").append("COALESCE(Col_").append(ii_2).append(",0)");
                            }
                            if (!this.m_columns[col].isCalculationTypePercent()) break block90;
                            String oper2Line = (String)this.m_columns[col].get_Value("Oper_2_LineName");
                            String oper1col = "Col_" + ii_1;
                            String oper2col = "Col_" + ii_2;
                            if (oper2Line == null) break block91;
                            String oper2 = null;
                            String[] multi = oper2Line.split("[,]");
                            if (multi.length > 1) break block87;
                            String colsql = "SELECT a." + oper2col + " FROM T_Report a " + " INNER JOIN PA_ReportLine b ON a.PA_ReportLine_ID = b.PA_ReportLine_ID " + " WHERE a.AD_PInstance_ID = " + this.getAD_PInstance_ID() + " AND b.Name = ?";
                            BigDecimal value2 = DB.getSQLValueBD(this.get_TrxName(), colsql, oper2Line);
                            if (value2 != null && value2.signum() != 0) {
                                oper2 = value2.toPlainString();
                            }
                            if (oper2 == null) {
                                sb.append(" NULL ");
                            } else {
                                sb.append("Round(");
                                sb.append("COALESCE(").append(oper1col).append(",0)").append("/").append(oper2).append("*100 ");
                                sb.append(", 2)");
                            }
                            break block92;
                        }
                        sb.append("CASE WHEN COALESCE(Col_").append(ii_2).append(",0)=0 THEN NULL ELSE ").append("COALESCE(Col_").append(ii_1).append(",0)").append("/").append("Col_").append(ii_2).append("*100 END");
                        break block92;
                    }
                    if (this.m_columns[col].isCalculationTypeRange()) {
                        sb.append("COALESCE(Col_").append(ii_1).append(",0)");
                        int ii = ii_1 + 1;
                        while (ii <= ii_2) {
                            sb.append("+COALESCE(Col_").append(ii).append(",0)");
                            ++ii;
                        }
                    }
                }
                sb.append(" WHERE AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND ABS(LevelNo)<2");
                int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
                if (no < 1) {
                    this.log.severe("#=" + no + " for " + this.m_columns[col] + " - " + sb.toString());
                } else {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Col=" + col + " - " + this.m_columns[col]);
                    }
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest(sb.toString());
                    }
                }
            }
            ++col;
        }
    }

    private void doColumnPercentageOfLineForMultiRange() {
        int col = 0;
        while (col < this.m_columns.length) {
            if (this.m_columns[col].isColumnTypeCalculation() && this.m_columns[col].isCalculationTypePercent()) {
                int ii_1 = this.getColumnIndex(this.m_columns[col].getOper_1_ID());
                if (ii_1 < 0) {
                    this.log.log(Level.SEVERE, "Column Index for Operator 1 not found - " + this.m_columns[col]);
                } else {
                    int ii_2 = this.getColumnIndex(this.m_columns[col].getOper_2_ID());
                    if (ii_2 < 0) {
                        this.log.log(Level.SEVERE, "Column Index for Operator 2 not found - " + this.m_columns[col]);
                    } else {
                        this.log.fine("Column " + col + " = #" + ii_1 + " " + this.m_columns[col].getCalculationType() + " #" + ii_2);
                        if (ii_1 > ii_2 && this.m_columns[col].isCalculationTypeRange()) {
                            this.log.fine("Swap operands from " + ii_1 + " op " + ii_2);
                            int temp = ii_1;
                            ii_1 = ii_2;
                            ii_2 = temp;
                        }
                        String oper2Line = (String)this.m_columns[col].get_Value("Oper_2_LineName");
                        String oper1col = "Col_" + ii_1;
                        String oper2col = "Col_" + ii_2;
                        if (oper2Line != null) {
                            String oper2 = null;
                            String[] multi = oper2Line.split("[,]");
                            if (multi.length >= 2) {
                                boolean lteq = true;
                                String seqsql = "SELECT b.seqNo FROM T_Report a  INNER JOIN PA_ReportLine b ON a.PA_ReportLine_ID = b.PA_ReportLine_ID  WHERE a.AD_PInstance_ID = " + this.getAD_PInstance_ID() + " AND b.Name = ?";
                                int seqNo = -1;
                                try {
                                    seqNo = Integer.parseInt(multi[0].trim());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (seqNo == -1) {
                                    seqNo = DB.getSQLValue(this.get_TrxName(), seqsql, multi[0].trim());
                                }
                                if (seqNo >= 0) {
                                    String countsql = "SELECT count(*) FROM T_Report a  INNER JOIN PA_ReportLine b ON a.PA_ReportLine_ID = b.PA_ReportLine_ID  WHERE a.AD_PInstance_ID = " + this.getAD_PInstance_ID() + " AND b.seqNo < ? AND a." + oper1col + " IS NOT NULL " + " AND a." + oper2col + " IS NOT NULL ";
                                    int count = DB.getSQLValue(this.get_TrxName(), countsql, seqNo);
                                    if (count == 0) {
                                        lteq = false;
                                    }
                                    ArrayList<Integer> seqlist = new ArrayList<Integer>();
                                    seqlist.add(seqNo);
                                    int i2 = 1;
                                    while (i2 < multi.length) {
                                        seqNo = -1;
                                        try {
                                            seqNo = Integer.parseInt(multi[i2].trim());
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        if (seqNo == -1) {
                                            seqNo = DB.getSQLValue(this.get_TrxName(), seqsql, multi[i2].trim());
                                        }
                                        if (seqNo >= 0) {
                                            seqlist.add(seqNo);
                                        }
                                        ++i2;
                                    }
                                    i2 = 0;
                                    while (i2 < seqlist.size()) {
                                        int no;
                                        int currentSeq = (Integer)seqlist.get(i2);
                                        StringBuffer sb = new StringBuffer("UPDATE T_Report SET ");
                                        sb.append("Col_").append(col).append("=");
                                        String colsql = "SELECT a." + oper2col + " FROM T_Report a " + " INNER JOIN PA_ReportLine b ON a.PA_ReportLine_ID = b.PA_ReportLine_ID " + " WHERE a.AD_PInstance_ID = " + this.getAD_PInstance_ID() + " AND b.seqNo = ?";
                                        BigDecimal value2 = DB.getSQLValueBD(this.get_TrxName(), colsql, currentSeq);
                                        if (value2 != null && value2.signum() != 0) {
                                            oper2 = value2.toPlainString();
                                        }
                                        if (oper2 == null) {
                                            sb.append(" NULL ");
                                        } else {
                                            sb.append("Round(");
                                            sb.append("COALESCE(").append(oper1col).append(",0)").append("/").append(oper2).append("*100 ");
                                            sb.append(", 2)");
                                        }
                                        sb.append(" WHERE AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND ABS(LevelNo)<2");
                                        if (lteq) {
                                            sb.append(" AND seqNo <= " + currentSeq);
                                            if (i2 > 0) {
                                                int prevSeq = (Integer)seqlist.get(i2 - 1);
                                                sb.append(" AND seqNo > " + prevSeq);
                                            }
                                        } else {
                                            sb.append(" AND seqNo >= " + currentSeq);
                                            if (i2 + 1 < seqlist.size()) {
                                                int nextSeq = (Integer)seqlist.get(i2 + 1);
                                                sb.append(" AND seqNo < " + nextSeq);
                                            }
                                        }
                                        if ((no = DB.executeUpdate(sb.toString(), this.get_TrxName())) < 1) {
                                            this.log.severe("#=" + no + " for " + this.m_columns[col] + " - " + sb.toString());
                                        } else {
                                            this.log.fine("Col=" + col + " - " + this.m_columns[col]);
                                            this.log.finest(sb.toString());
                                        }
                                        ++i2;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            ++col;
        }
    }

    private String getLineIDs(int fromID, int toID) {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("From=" + fromID + " To=" + toID);
        }
        int firstPA_ReportLine_ID = 0;
        int lastPA_ReportLine_ID = 0;
        int line = 0;
        while (line < this.m_lines.length) {
            int PA_ReportLine_ID = this.m_lines[line].getPA_ReportLine_ID();
            if (PA_ReportLine_ID == fromID || PA_ReportLine_ID == toID) {
                if (firstPA_ReportLine_ID == 0) {
                    firstPA_ReportLine_ID = PA_ReportLine_ID;
                } else {
                    lastPA_ReportLine_ID = PA_ReportLine_ID;
                    break;
                }
            }
            ++line;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(firstPA_ReportLine_ID);
        boolean addToList = false;
        int line2 = 0;
        while (line2 < this.m_lines.length) {
            int PA_ReportLine_ID = this.m_lines[line2].getPA_ReportLine_ID();
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Add=" + addToList + " ID=" + PA_ReportLine_ID + " - " + this.m_lines[line2]);
            }
            if (addToList) {
                sb.append(",").append(PA_ReportLine_ID);
                if (PA_ReportLine_ID == lastPA_ReportLine_ID) {
                    break;
                }
            } else if (PA_ReportLine_ID == firstPA_ReportLine_ID) {
                addToList = true;
            }
            ++line2;
        }
        return sb.toString();
    }

    private int getColumnIndex(int PA_ReportColumn_ID) {
        int i2 = 0;
        while (i2 < this.m_columns.length) {
            if (this.m_columns[i2].getPA_ReportColumn_ID() == PA_ReportColumn_ID) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    private FinReportPeriod getPeriod(BigDecimal relativeOffset) {
        if (relativeOffset == null) {
            return this.getPeriod(0);
        }
        return this.getPeriod(relativeOffset.intValue());
    }

    private FinReportPeriod getPeriod(int relativeOffset) {
        if (this.m_reportPeriod < 0) {
            int i2 = 0;
            while (i2 < this.m_periods.length) {
                if (this.p_C_Period_ID == this.m_periods[i2].getC_Period_ID()) {
                    this.m_reportPeriod = i2;
                    break;
                }
                ++i2;
            }
        }
        if (this.m_reportPeriod < 0 || this.m_reportPeriod >= this.m_periods.length) {
            throw new UnsupportedOperationException("Period index not found - ReportPeriod=" + this.m_reportPeriod + ", C_Period_ID=" + this.p_C_Period_ID);
        }
        int index = this.m_reportPeriod + relativeOffset;
        if (index < 0) {
            this.log.log(Level.SEVERE, "Relative Offset(" + relativeOffset + ") not valid for selected Period(" + this.m_reportPeriod + ")");
            index = 0;
        } else if (index >= this.m_periods.length) {
            this.log.log(Level.SEVERE, "Relative Offset(" + relativeOffset + ") not valid for selected Period(" + this.m_reportPeriod + ")");
            index = this.m_periods.length - 1;
        }
        return this.m_periods[index];
    }

    private void insertLineDetail() {
        int no;
        StringBuilder sql;
        if (!this.m_report.isListSources()) {
            return;
        }
        this.log.info("");
        int line = 0;
        while (line < this.m_lines.length) {
            if (this.m_lines[line].isLineTypeSegmentValue()) {
                this.insertLineSource(line);
            }
            ++line;
        }
        boolean listSourceNoTrx = this.m_report.isListSourcesXTrx();
        if (!listSourceNoTrx) {
            sql = new StringBuilder("DELETE FROM T_Report WHERE ABS(LevelNo)<>0").append(" AND Col_0 IS NULL AND Col_1 IS NULL AND Col_2 IS NULL AND Col_3 IS NULL AND Col_4 IS NULL AND Col_5 IS NULL AND Col_6 IS NULL AND Col_7 IS NULL AND Col_8 IS NULL AND Col_9 IS NULL").append(" AND Col_10 IS NULL AND Col_11 IS NULL AND Col_12 IS NULL AND Col_13 IS NULL AND Col_14 IS NULL AND Col_15 IS NULL AND Col_16 IS NULL AND Col_17 IS NULL AND Col_18 IS NULL AND Col_19 IS NULL AND Col_20 IS NULL");
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Deleted empty #=" + no);
            }
        }
        sql = new StringBuilder("UPDATE T_Report r1 SET SeqNo = (SELECT SeqNo FROM T_Report r2 WHERE r1.AD_PInstance_ID=r2.AD_PInstance_ID AND r1.PA_ReportLine_ID=r2.PA_ReportLine_ID AND r2.Record_ID=0 AND r2.Fact_Acct_ID=0)WHERE SeqNo IS NULL");
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("SeqNo #=" + no);
        }
        if (!this.m_report.isListTrx()) {
            return;
        }
        String sql_select = "SELECT e.Name, fa.Description FROM Fact_Acct fa INNER JOIN AD_Table t ON (fa.AD_Table_ID=t.AD_Table_ID) INNER JOIN AD_Element e ON (t.TableName||'_ID'=e.ColumnName) WHERE r.Fact_Acct_ID=fa.Fact_Acct_ID";
        sql = new StringBuilder("UPDATE T_Report r SET (Name,Description)=(").append(sql_select).append(") WHERE Fact_Acct_ID <> 0 AND AD_PInstance_ID=").append(this.getAD_PInstance_ID());
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Trx Name #=" + no + " - " + sql.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void insertLineSource(int line) {
        String s;
        StringBuffer unionWhere;
        StringBuffer unionInsert;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Line=" + line + " - " + this.m_lines[line]);
        }
        if (this.m_lines[line] == null || this.m_lines[line].getSources().length == 0) {
            return;
        }
        String variable = this.m_lines[line].getSourceColumnName();
        if (variable == null || variable.equals("")) {
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Variable=" + variable);
        }
        StringBuffer insert = new StringBuffer("INSERT INTO T_Report (AD_PInstance_ID, PA_ReportLine_ID, Record_ID,Fact_Acct_ID,LevelNo ");
        int col = 0;
        while (col < this.m_columns.length) {
            insert.append(",Col_").append(col);
            ++col;
        }
        insert.append(") SELECT ").append(this.getAD_PInstance_ID()).append(",").append(this.m_lines[line].getPA_ReportLine_ID()).append(",").append(variable).append(",0,");
        boolean listSourceNoTrx = this.m_report.isListSourcesXTrx() && variable.equalsIgnoreCase("Account_ID");
        StringBuffer stringBuffer = unionInsert = listSourceNoTrx ? new StringBuffer() : null;
        if (listSourceNoTrx) {
            unionInsert.append(" UNION SELECT ").append(this.getAD_PInstance_ID()).append(",").append(this.m_lines[line].getPA_ReportLine_ID()).append(",").append(variable).append(",0,");
        }
        if (this.p_DetailsSourceFirst) {
            insert.append("-1 ");
            if (listSourceNoTrx) {
                unionInsert.append("-1 ");
            }
        } else {
            insert.append("1 ");
            if (listSourceNoTrx) {
                unionInsert.append("1 ");
            }
        }
        int col2 = 0;
        while (col2 < this.m_columns.length) {
            block54: {
                String s2;
                StringBuffer select;
                block52: {
                    FinReportPeriod frp;
                    block58: {
                        block59: {
                            block56: {
                                block57: {
                                    block55: {
                                        block53: {
                                            insert.append(", ");
                                            if (listSourceNoTrx) {
                                                unionInsert.append(", Cast(NULL AS NUMBER)");
                                            }
                                            if (!this.m_columns[col2].isColumnTypeCalculation()) break block53;
                                            insert.append("Cast(NULL AS NUMBER)");
                                            break block54;
                                        }
                                        select = new StringBuffer("SELECT ");
                                        if (this.m_lines[line].getPAAmountType() == null) break block55;
                                        select.append(this.m_lines[line].getSelectClause(true));
                                        break block56;
                                    }
                                    if (this.m_columns[col2].getPAAmountType() != null) break block57;
                                    insert.append("Cast(NULL AS NUMBER)");
                                    break block54;
                                }
                                select.append(this.m_columns[col2].getSelectClause(true));
                            }
                            if (this.p_PA_ReportCube_ID > 0) {
                                select.append(" FROM Fact_Acct_Summary fb WHERE ").append(this.p_AdjPeriodToExclude).append("DateAcct ");
                            } else {
                                select.append(" FROM Fact_Acct fb WHERE ").append(this.p_AdjPeriodToExclude).append("TRUNC(DateAcct) ");
                            }
                            frp = this.getPeriod(this.m_columns[col2].getRelativePeriod());
                            if (this.m_lines[line].getPAPeriodType() == null) break block58;
                            if (!this.m_lines[line].isPeriod()) break block59;
                            select.append(frp.getPeriodWhere());
                            break block52;
                        }
                        if (this.m_lines[line].isYear()) {
                            select.append(frp.getYearWhere());
                            break block52;
                        } else if (this.m_lines[line].isNatural()) {
                            select.append(frp.getNaturalWhere("fb"));
                            break block52;
                        } else {
                            select.append(frp.getTotalWhere());
                        }
                        break block52;
                    }
                    if (this.m_columns[col2].getPAPeriodType() != null) {
                        if (this.m_columns[col2].isPeriod()) {
                            select.append(frp.getPeriodWhere());
                        } else if (this.m_columns[col2].isYear()) {
                            select.append(frp.getYearWhere());
                        } else if (this.m_columns[col2].isNatural()) {
                            select.append(frp.getNaturalWhere("fb"));
                        } else {
                            select.append(frp.getTotalWhere());
                        }
                    }
                }
                select.append(" AND fb.").append(variable).append("=x.").append(variable);
                if (!this.m_lines[line].isPostingType()) {
                    String PostingType = this.m_columns[col2].getPostingType();
                    if (PostingType != null && PostingType.length() > 0) {
                        select.append(" AND fb.PostingType='").append(PostingType).append("'");
                    }
                    if ("B".equals(PostingType) && this.m_columns[col2].getGL_Budget_ID() > 0) {
                        select.append(" AND GL_Budget_ID=" + this.m_columns[col2].getGL_Budget_ID());
                    }
                }
                if ((s2 = this.m_report.getWhereClause()) != null && s2.length() > 0) {
                    select.append(" AND ").append(s2);
                }
                if (this.m_columns[col2].isColumnTypeSegmentValue()) {
                    select.append(this.m_columns[col2].getWhereClause(this.p_PA_Hierarchy_ID));
                }
                select.append(this.m_parameterWhere);
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("Col=" + col2 + ", Line=" + line + ": " + select);
                }
                insert.append("(").append(select).append(")");
            }
            ++col2;
        }
        StringBuffer where = new StringBuffer(this.m_lines[line].getWhereClause(this.p_PA_Hierarchy_ID));
        StringBuffer stringBuffer2 = unionWhere = listSourceNoTrx ? new StringBuffer() : null;
        if (listSourceNoTrx && this.m_lines[line].getSources() != null && this.m_lines[line].getSources().length > 0) {
            if (this.m_lines[line].getSources().length == 1 && this.m_lines[line].getSources()[0].getElementType().equalsIgnoreCase("AC")) {
                unionWhere.append(this.m_lines[line].getSources()[0].getWhereClause(this.p_PA_Hierarchy_ID));
            } else {
                StringBuffer sb = new StringBuffer("(");
                int i2 = 0;
                while (i2 < this.m_lines[line].getSources().length) {
                    if (this.m_lines[line].getSources()[i2].getElementType().equalsIgnoreCase("AC")) {
                        if (i2 > 0) {
                            sb.append(" OR ");
                        }
                        sb.append(this.m_lines[line].getSources()[i2].getWhereClause(this.p_PA_Hierarchy_ID));
                    }
                    ++i2;
                }
                sb.append(")");
                unionWhere.append(sb.toString());
            }
        }
        if ((s = this.m_report.getWhereClause()) != null && s.length() > 0) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append(s);
            if (listSourceNoTrx) {
                if (unionWhere.length() > 0) {
                    unionWhere.append(" AND ");
                }
                unionWhere.append(s);
            }
        }
        if (where.length() > 0) {
            where.append(" AND ");
        }
        where.append(variable).append(" IS NOT NULL");
        if (this.p_PA_ReportCube_ID > 0) {
            insert.append(" FROM Fact_Acct_Summary x WHERE ").append(this.p_AdjPeriodToExclude).append(where);
        } else {
            insert.append(" FROM Fact_Acct x WHERE ").append(this.p_AdjPeriodToExclude).append(where);
        }
        insert.append(this.m_parameterWhere).append(" GROUP BY ").append(variable);
        if (listSourceNoTrx) {
            if (unionWhere.length() > 0) {
                unionWhere.append(" AND ");
            }
            unionWhere.append(variable).append(" IS NOT NULL");
            unionWhere.append(" AND Account_ID not in (select Account_ID ");
            if (this.p_PA_ReportCube_ID > 0) {
                unionWhere.append(" from Fact_Acct_Summary x WHERE ").append(this.p_AdjPeriodToExclude).append(where);
            } else {
                unionWhere.append(" from Fact_Acct x WHERE ").append(this.p_AdjPeriodToExclude).append(where);
            }
            unionWhere.append(this.m_parameterWhere).append(")");
            unionInsert.append(" FROM (select c_elementvalue.c_elementvalue_id as Account_ID, c_acctschema_element.C_AcctSchema_ID from c_elementvalue inner join c_acctschema_element on (c_elementvalue.c_element_id = c_acctschema_element.c_element_id)) x WHERE ").append(unionWhere);
            unionInsert.append(" GROUP BY ").append(variable);
            insert.append(unionInsert);
        }
        int no = DB.executeUpdate(insert.toString(), this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Source #=" + no + " - " + insert);
        }
        if (no == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer("UPDATE T_Report SET (Name,Description)=(").append(this.m_lines[line].getSourceValueQuery()).append("T_Report.Record_ID) WHERE Record_ID <> 0 AND AD_PInstance_ID=").append(this.getAD_PInstance_ID()).append(" AND PA_ReportLine_ID=").append(this.m_lines[line].getPA_ReportLine_ID()).append(" AND Fact_Acct_ID=0");
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Name #=" + no + " - " + sql.toString());
        }
        if (this.m_report.isListTrx()) {
            this.insertLineTrx(line, variable);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void insertLineTrx(int line, String variable) {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Line=" + line + " - Variable=" + variable);
        }
        StringBuffer insert = new StringBuffer("INSERT INTO T_Report (AD_PInstance_ID, PA_ReportLine_ID, Record_ID,Fact_Acct_ID,LevelNo ");
        int col = 0;
        while (col < this.m_columns.length) {
            insert.append(",Col_").append(col);
            ++col;
        }
        insert.append(") SELECT ").append(this.getAD_PInstance_ID()).append(",").append(this.m_lines[line].getPA_ReportLine_ID()).append(",").append(variable).append(",Fact_Acct_ID, ");
        if (this.p_DetailsSourceFirst) {
            insert.append("-2 ");
        } else {
            insert.append("2 ");
        }
        col = 0;
        while (col < this.m_columns.length) {
            block30: {
                String s;
                StringBuffer select;
                block28: {
                    FinReportPeriod frp;
                    block34: {
                        block35: {
                            block32: {
                                block33: {
                                    block31: {
                                        block29: {
                                            insert.append(", ");
                                            if (!this.m_columns[col].isColumnTypeCalculation()) break block29;
                                            insert.append("Cast(NULL AS NUMBER)");
                                            break block30;
                                        }
                                        select = new StringBuffer("SELECT ");
                                        if (this.m_lines[line].getPAAmountType() == null) break block31;
                                        select.append(this.m_lines[line].getSelectClause(false));
                                        break block32;
                                    }
                                    if (this.m_columns[col].getPAAmountType() != null) break block33;
                                    insert.append("Cast(NULL AS NUMBER)");
                                    break block30;
                                }
                                select.append(this.m_columns[col].getSelectClause(false));
                            }
                            if (this.p_PA_ReportCube_ID > 0) {
                                select.append(" FROM Fact_Acct_Summary fb WHERE ").append(this.p_AdjPeriodToExclude).append("DateAcct ");
                            } else {
                                select.append(" FROM Fact_Acct fb WHERE ").append(this.p_AdjPeriodToExclude).append("TRUNC(DateAcct) ");
                            }
                            frp = this.getPeriod(this.m_columns[col].getRelativePeriod());
                            if (this.m_lines[line].getPAPeriodType() == null) break block34;
                            if (!this.m_lines[line].isPeriod()) break block35;
                            select.append(frp.getPeriodWhere());
                            break block28;
                        }
                        if (this.m_lines[line].isYear()) {
                            select.append(frp.getYearWhere());
                            break block28;
                        } else if (this.m_lines[line].isNatural()) {
                            select.append(frp.getNaturalWhere("fb"));
                            break block28;
                        } else {
                            select.append(frp.getTotalWhere());
                        }
                        break block28;
                    }
                    if (this.m_columns[col].getPAPeriodType() != null) {
                        if (this.m_columns[col].isPeriod()) {
                            select.append(frp.getPeriodWhere());
                        } else if (this.m_columns[col].isYear()) {
                            select.append(frp.getYearWhere());
                        } else if (this.m_columns[col].isNatural()) {
                            select.append(frp.getNaturalWhere("fb"));
                        } else {
                            select.append(frp.getTotalWhere());
                        }
                    }
                }
                select.append(" AND fb.Fact_Acct_ID=x.Fact_Acct_ID");
                if (!this.m_lines[line].isPostingType()) {
                    String PostingType = this.m_columns[col].getPostingType();
                    if (PostingType != null && PostingType.length() > 0) {
                        select.append(" AND fb.PostingType='").append(PostingType).append("'");
                    }
                    if ("B".equals(PostingType) && this.m_columns[col].getGL_Budget_ID() > 0) {
                        select.append(" AND GL_Budget_ID=" + this.m_columns[col].getGL_Budget_ID());
                    }
                }
                if ((s = this.m_report.getWhereClause()) != null && s.length() > 0) {
                    select.append(" AND ").append(s);
                }
                if (this.m_columns[col].isColumnTypeSegmentValue()) {
                    select.append(this.m_columns[col].getWhereClause(this.p_PA_Hierarchy_ID));
                }
                select.append(this.m_parameterWhere);
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("Col=" + col + ", Line=" + line + ": " + select);
                }
                insert.append("(").append(select).append(")");
            }
            ++col;
        }
        insert.append(" FROM Fact_Acct x WHERE ").append(this.m_lines[line].getWhereClause(this.p_PA_Hierarchy_ID));
        String s = this.m_report.getWhereClause();
        if (s != null && s.length() > 0) {
            insert.append(" AND ").append(s);
        }
        String whereClause = this.m_parameterWhere.toString();
        if (this.p_PA_ReportCube_ID > 0) {
            whereClause = whereClause.replaceAll(" AND PA_ReportCube_ID=" + this.p_PA_ReportCube_ID, "");
        }
        insert.append(whereClause);
        int no = DB.executeUpdate(insert.toString(), this.get_TrxName());
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Trx #=" + no + " - " + insert);
        }
        if (no == 0) {
            return;
        }
    }

    private void deleteUnprintedLines() {
        int line = 0;
        while (line < this.m_lines.length) {
            String sql;
            int no;
            if (!this.m_lines[line].isPrinted() && (no = DB.executeUpdate(sql = "DELETE FROM T_Report WHERE AD_PInstance_ID=" + this.getAD_PInstance_ID() + " AND PA_ReportLine_ID=" + this.m_lines[line].getPA_ReportLine_ID(), this.get_TrxName())) > 0 && this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(this.m_lines[line].getName()) + " - #" + no);
            }
            ++line;
        }
    }

    private void scaleResults() {
        int column = 0;
        while (column < this.m_columns.length) {
            String factor = this.m_columns[column].getFactor();
            if (factor != null) {
                int divisor = 1;
                if (factor.equals("k")) {
                    divisor = 1000;
                } else {
                    if (!factor.equals("M")) break;
                    divisor = 1000000;
                }
                String sql = "UPDATE T_Report SET Col_" + column + "=Col_" + column + "/" + divisor + " WHERE AD_PInstance_ID=" + this.getAD_PInstance_ID();
                int no = DB.executeUpdate(sql, this.get_TrxName());
                if (no > 0 && this.log.isLoggable(Level.FINE)) {
                    this.log.fine(String.valueOf(this.m_columns[column].getName()) + " - #" + no);
                }
            }
            ++column;
        }
    }

    private MPrintFormat getPrintFormat() {
        boolean createNew;
        int AD_PrintFormat_ID = this.m_report.getAD_PrintFormat_ID();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("AD_PrintFormat_ID=" + AD_PrintFormat_ID);
        }
        MPrintFormat pf = null;
        boolean bl = createNew = AD_PrintFormat_ID == 0;
        if (createNew) {
            int AD_Table_ID = 544;
            pf = MPrintFormat.createFromTable(Env.getCtx(), AD_Table_ID);
            AD_PrintFormat_ID = pf.getAD_PrintFormat_ID();
            this.m_report.setAD_PrintFormat_ID(AD_PrintFormat_ID);
            this.m_report.saveEx();
        } else {
            pf = MPrintFormat.get(this.getCtx(), AD_PrintFormat_ID, false);
        }
        if (!this.m_report.getName().equals(pf.getName())) {
            pf.setName(this.m_report.getName());
            MPrintFormat.setUniqueName(pf.getAD_Client_ID(), pf, pf.getName());
        }
        if (this.m_report.getDescription() == null) {
            if (pf.getDescription() != null) {
                pf.setDescription(null);
            }
        } else if (!this.m_report.getDescription().equals(pf.getDescription())) {
            pf.setDescription(this.m_report.getDescription());
        }
        pf.saveEx();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(pf + " - #" + pf.getItemCount());
        }
        int count = pf.getItemCount();
        int i2 = 0;
        while (i2 < count) {
            MPrintFormatItem pfi = pf.getItem(i2);
            String ColumnName = pfi.getColumnName();
            if (ColumnName == null) {
                this.log.log(Level.SEVERE, "No ColumnName for #" + i2 + " - " + pfi);
                if (pfi.isPrinted()) {
                    pfi.setIsPrinted(false);
                }
                if (pfi.isOrderBy()) {
                    pfi.setIsOrderBy(false);
                }
                if (pfi.getSortNo() != 0) {
                    pfi.setSortNo(0);
                }
            } else if (ColumnName.startsWith("Col")) {
                int index = Integer.parseInt(ColumnName.substring(4));
                if (index < this.m_columns.length) {
                    pfi.setIsPrinted(this.m_columns[index].isPrinted());
                    String s = this.m_columns[index].getName();
                    if (this.m_columns[index].isColumnTypeRelativePeriod()) {
                        BigDecimal relativeOffset = this.m_columns[index].getRelativePeriod();
                        FinReportPeriod frp = this.getPeriod(relativeOffset);
                        if (s.contains("@Period@")) {
                            s = s.replace("@Period@", frp.getName());
                        }
                    }
                    if (!pfi.getName().equals(s)) {
                        pfi.setName(s);
                        pfi.setPrintName(s);
                    }
                    int seq = 30 + index;
                    if (pfi.getSeqNo() != seq) {
                        pfi.setSeqNo(seq);
                    }
                    s = this.m_columns[index].getFormatPattern();
                    pfi.setFormatPattern(s);
                } else if (pfi.isPrinted()) {
                    pfi.setIsPrinted(false);
                }
                if (pfi.isOrderBy()) {
                    pfi.setIsOrderBy(false);
                }
                if (pfi.getSortNo() != 0) {
                    pfi.setSortNo(0);
                }
            } else if (ColumnName.equals("SeqNo")) {
                if (pfi.isPrinted()) {
                    pfi.setIsPrinted(false);
                }
                if (!pfi.isOrderBy()) {
                    pfi.setIsOrderBy(true);
                }
                if (pfi.getSortNo() != 10) {
                    pfi.setSortNo(10);
                }
            } else if (ColumnName.equals("LevelNo")) {
                if (pfi.isPrinted()) {
                    pfi.setIsPrinted(false);
                }
                if (!pfi.isOrderBy()) {
                    pfi.setIsOrderBy(true);
                }
                if (pfi.getSortNo() != 20) {
                    pfi.setSortNo(20);
                }
            } else if (ColumnName.equals("Name")) {
                if (pfi.getSeqNo() != 10) {
                    pfi.setSeqNo(10);
                }
                if (!pfi.isPrinted()) {
                    pfi.setIsPrinted(true);
                }
                if (!pfi.isOrderBy()) {
                    pfi.setIsOrderBy(true);
                }
                if (pfi.getSortNo() != 30) {
                    pfi.setSortNo(30);
                }
            } else if (ColumnName.equals("Description")) {
                if (pfi.getSeqNo() != 20) {
                    pfi.setSeqNo(20);
                }
                if (!pfi.isPrinted()) {
                    pfi.setIsPrinted(true);
                }
                if (pfi.isOrderBy()) {
                    pfi.setIsOrderBy(false);
                }
                if (pfi.getSortNo() != 0) {
                    pfi.setSortNo(0);
                }
            } else {
                if (pfi.isPrinted()) {
                    pfi.setIsPrinted(false);
                }
                if (pfi.isOrderBy()) {
                    pfi.setIsOrderBy(false);
                }
                if (pfi.getSortNo() != 0) {
                    pfi.setSortNo(0);
                }
            }
            pfi.saveEx();
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(pfi.toString());
            }
            ++i2;
        }
        pf.setTranslation();
        pf = MPrintFormat.get(this.getCtx(), AD_PrintFormat_ID, true);
        return pf;
    }
}

