/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MPInstance;
import org.compiere.model.PO;
import org.compiere.process.ProcessCall;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoLog;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public abstract class SvrProcess
implements ProcessCall {
    public static final String PROCESS_INFO_CTX_KEY = "ProcessInfo";
    public static final String PROCESS_UI_CTX_KEY = "ProcessUI";
    private List<ProcessInfoLog> listEntryLog;
    private Properties m_ctx;
    private ProcessInfo m_pi;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private boolean m_locked = false;
    private PO m_lockedObject = null;
    private Trx m_trx;
    protected IProcessUI processUI;
    protected static String MSG_SaveErrorRowNotFound = "@SaveErrorRowNotFound@";
    protected static String MSG_InvalidArguments = "@InvalidArguments@";

    public void addBufferLog(int id, Timestamp date, BigDecimal number, String msg, int tableId, int recordId) {
        ProcessInfoLog entryLog = new ProcessInfoLog(id, date, number, msg, tableId, recordId);
        if (this.listEntryLog == null) {
            this.listEntryLog = new ArrayList<ProcessInfoLog>();
        }
        this.listEntryLog.add(entryLog);
    }

    @Override
    public final boolean startProcess(Properties ctx, ProcessInfo pi, Trx trx) {
        boolean localTrx;
        this.m_ctx = ctx == null ? Env.getCtx() : ctx;
        this.m_pi = pi;
        this.m_trx = trx;
        boolean bl = localTrx = this.m_trx == null;
        if (localTrx) {
            this.m_trx = Trx.get(Trx.createTrxName("SvrProcess"), true);
            this.m_trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_startProcess");
        }
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader processLoader = this.getClass().getClassLoader();
        try {
            if (processLoader != contextLoader) {
                Thread.currentThread().setContextClassLoader(processLoader);
            }
            this.lock();
            boolean success = false;
            try {
                this.m_ctx.put(PROCESS_INFO_CTX_KEY, this.m_pi);
                if (this.processUI != null) {
                    this.m_ctx.put(PROCESS_UI_CTX_KEY, this.processUI);
                }
                success = this.process();
            }
            catch (Throwable throwable) {
                this.m_ctx.remove(PROCESS_INFO_CTX_KEY);
                this.m_ctx.remove(PROCESS_UI_CTX_KEY);
                if (localTrx) {
                    if (success) {
                        try {
                            this.m_trx.commit(true);
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, "Commit failed.", e);
                            this.m_pi.addSummary("Commit Failed.");
                            this.m_pi.setError(true);
                        }
                    } else {
                        this.m_trx.rollback();
                    }
                    this.m_trx.close();
                    this.m_trx = null;
                }
                this.unlock();
                this.postProcess(!this.m_pi.isError());
                Thread.currentThread().setContextClassLoader(contextLoader);
                throw throwable;
            }
            this.m_ctx.remove(PROCESS_INFO_CTX_KEY);
            this.m_ctx.remove(PROCESS_UI_CTX_KEY);
            if (localTrx) {
                if (success) {
                    try {
                        this.m_trx.commit(true);
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "Commit failed.", e);
                        this.m_pi.addSummary("Commit Failed.");
                        this.m_pi.setError(true);
                    }
                } else {
                    this.m_trx.rollback();
                }
                this.m_trx.close();
                this.m_trx = null;
            }
            this.unlock();
            this.postProcess(!this.m_pi.isError());
            Thread.currentThread().setContextClassLoader(contextLoader);
        }
        finally {
            if (processLoader != contextLoader) {
                Thread.currentThread().setContextClassLoader(contextLoader);
            }
        }
        return !this.m_pi.isError();
    }

    private boolean process() {
        String msg = null;
        boolean success = true;
        try {
            this.prepare();
            msg = this.doIt();
        }
        catch (Throwable e) {
            msg = e.getLocalizedMessage();
            if (msg == null) {
                msg = e.toString();
            }
            if (e.getCause() != null) {
                this.log.log(Level.SEVERE, msg, e.getCause());
            } else {
                this.log.log(Level.SEVERE, msg, e);
            }
            success = false;
        }
        if (msg != null && msg.startsWith("@Error@")) {
            success = false;
        }
        if (success) {
            this.flushBufferLog();
        }
        msg = Msg.parseTranslation(this.m_ctx, msg);
        this.m_pi.setSummary(msg, !success);
        return success;
    }

    protected abstract void prepare();

    protected abstract String doIt() throws Exception;

    protected void postProcess(boolean success) {
    }

    protected void commit() {
        if (this.m_trx != null) {
            this.m_trx.commit();
        }
    }

    protected void commitEx() throws SQLException {
        if (this.m_trx != null) {
            this.m_trx.commit(true);
        }
    }

    protected void rollback() {
        if (this.m_trx != null) {
            this.m_trx.rollback();
        }
    }

    protected boolean lockObject(PO po) {
        if (this.m_locked || this.m_lockedObject != null) {
            this.unlockObject();
        }
        if (po == null) {
            return false;
        }
        this.m_lockedObject = po;
        this.m_locked = this.m_lockedObject.lock();
        return this.m_locked;
    }

    protected boolean isLocked() {
        return this.m_locked;
    }

    protected boolean unlockObject() {
        boolean success = true;
        if (this.m_locked || this.m_lockedObject != null) {
            success = this.m_lockedObject.unlock(null);
        }
        this.m_locked = false;
        this.m_lockedObject = null;
        return success;
    }

    public ProcessInfo getProcessInfo() {
        return this.m_pi;
    }

    public Properties getCtx() {
        return this.m_ctx;
    }

    protected String getName() {
        return this.m_pi.getTitle();
    }

    protected int getAD_PInstance_ID() {
        return this.m_pi.getAD_PInstance_ID();
    }

    protected int getTable_ID() {
        return this.m_pi.getTable_ID();
    }

    protected int getRecord_ID() {
        return this.m_pi.getRecord_ID();
    }

    protected int getAD_User_ID() {
        block8: {
            if (this.m_pi.getAD_User_ID() == null || this.m_pi.getAD_Client_ID() == null) {
                String sql = "SELECT AD_User_ID, AD_Client_ID FROM AD_PInstance WHERE AD_PInstance_ID=?";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, this.get_TrxName());
                        pstmt.setInt(1, this.m_pi.getAD_PInstance_ID());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            this.m_pi.setAD_User_ID(rs.getInt(1));
                            this.m_pi.setAD_Client_ID(rs.getInt(2));
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, sql, e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                Object var2_2 = null;
            }
        }
        if (this.m_pi.getAD_User_ID() == null) {
            return -1;
        }
        return this.m_pi.getAD_User_ID();
    }

    protected int getAD_Client_ID() {
        if (this.m_pi.getAD_Client_ID() == null) {
            this.getAD_User_ID();
            if (this.m_pi.getAD_Client_ID() == null) {
                return 0;
            }
        }
        return this.m_pi.getAD_Client_ID();
    }

    protected ProcessInfoParameter[] getParameter() {
        ProcessInfoParameter[] retValue = this.m_pi.getParameter();
        if (retValue == null) {
            ProcessInfoUtil.setParameterFromDB(this.m_pi);
            retValue = this.m_pi.getParameter();
        }
        return retValue;
    }

    public void addLog(int id, Timestamp date, BigDecimal number, String msg, int tableId, int recordId) {
        if (this.m_pi != null) {
            this.m_pi.addLog(id, date, number, msg, tableId, recordId);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(String.valueOf(id) + " - " + date + " - " + number + " - " + msg + " - " + tableId + " - " + recordId);
        }
    }

    public void addLog(int id, Timestamp date, BigDecimal number, String msg) {
        if (this.m_pi != null) {
            this.m_pi.addLog(id, date, number, msg);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(String.valueOf(id) + " - " + date + " - " + number + " - " + msg);
        }
    }

    public void addLog(String msg) {
        if (msg != null) {
            this.addLog(0, null, null, msg);
        }
    }

    private void flushBufferLog() {
        if (this.listEntryLog == null) {
            return;
        }
        for (ProcessInfoLog entryLog : this.listEntryLog) {
            if (this.m_pi != null) {
                this.m_pi.addLog(entryLog);
            }
            if (!this.log.isLoggable(Level.INFO)) continue;
            this.log.info(String.valueOf(entryLog.getP_ID()) + " - " + entryLog.getP_Date() + " - " + entryLog.getP_Number() + " - " + entryLog.getP_Msg() + " - " + entryLog.getAD_Table_ID() + " - " + entryLog.getRecord_ID());
        }
    }

    public Object doIt(String className, String methodName, Object[] args) {
        try {
            Class<?> clazz = Class.forName(className);
            Object object = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method[] methods = clazz.getMethods();
            int i2 = 0;
            while (i2 < methods.length) {
                if (methods[i2].getName().equals(methodName)) {
                    return methods[i2].invoke(object, args);
                }
                ++i2;
            }
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "doIt", ex);
            throw new RuntimeException(ex);
        }
        return null;
    }

    private void lock() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("AD_PInstance_ID=" + this.m_pi.getAD_PInstance_ID());
        }
        try {
            DB.executeUpdate("UPDATE AD_PInstance SET IsProcessing='Y' WHERE AD_PInstance_ID=" + this.m_pi.getAD_PInstance_ID(), null);
        }
        catch (Exception e) {
            this.log.severe("lock() - " + e.getLocalizedMessage());
        }
    }

    private void unlock() {
        boolean noContext = Env.getCtx().isEmpty() && Env.getCtx().getProperty("#AD_Client_ID") == null;
        try {
            MPInstance mpi;
            if (noContext) {
                Env.getCtx().put("#AD_Client_ID", this.m_pi.getAD_Client_ID());
            }
            if ((mpi = new MPInstance(this.getCtx(), this.m_pi.getAD_PInstance_ID(), null)).get_ID() == 0) {
                this.log.log(Level.SEVERE, "Did not find PInstance " + this.m_pi.getAD_PInstance_ID());
                return;
            }
            try {
                mpi.setIsProcessing(false);
                mpi.setResult(!this.m_pi.isError());
                mpi.setErrorMsg(this.m_pi.getSummary());
                mpi.saveEx();
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(mpi.toString());
                }
                ProcessInfoUtil.saveLogToDB(this.m_pi);
            }
            catch (Exception e) {
                this.log.severe("unlock() - " + e.getLocalizedMessage());
            }
        }
        finally {
            if (noContext) {
                Env.getCtx().remove("#AD_Client_ID");
            }
        }
    }

    public String get_TrxName() {
        if (this.m_trx != null) {
            return this.m_trx.getTrxName();
        }
        return null;
    }

    @Override
    public void setProcessUI(IProcessUI monitor) {
        this.processUI = monitor;
    }

    protected void statusUpdate(String message) {
        if (this.processUI != null) {
            this.processUI.statusUpdate(message);
        }
    }
}

