/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.InvalidClassException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.adempiere.util.ProcessUtil;
import org.compiere.db.CConnection;
import org.compiere.interfaces.Server;
import org.compiere.model.MPInstance;
import org.compiere.print.ServerReportCtl;
import org.compiere.process.ClientProcess;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.wf.MWFProcess;

public class ServerProcessCtl
implements Runnable {
    private static CLogger log = CLogger.getCLogger(ServerProcessCtl.class);
    ProcessInfo m_pi;
    private Trx m_trx;
    private boolean m_IsServerProcess = false;

    public ServerProcessCtl(ProcessInfo pi, Trx trx) {
        this.m_pi = pi;
        this.m_trx = trx;
    }

    public static ServerProcessCtl process(ProcessInfo pi, Trx trx) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("ServerProcess - " + pi);
        }
        MPInstance instance = null;
        if (pi.getAD_PInstance_ID() <= 0) {
            try {
                instance = new MPInstance(Env.getCtx(), pi.getAD_Process_ID(), pi.getRecord_ID());
            }
            catch (Exception e) {
                pi.setSummary(e.getLocalizedMessage());
                pi.setError(true);
                log.warning(pi.toString());
                return null;
            }
            catch (Error e) {
                pi.setSummary(e.getLocalizedMessage());
                pi.setError(true);
                log.warning(pi.toString());
                return null;
            }
            if (!instance.save()) {
                pi.setSummary(Msg.getMsg(Env.getCtx(), "ProcessNoInstance"));
                pi.setError(true);
                return null;
            }
            pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        } else {
            instance = new MPInstance(Env.getCtx(), pi.getAD_PInstance_ID(), null);
        }
        ServerProcessCtl worker = new ServerProcessCtl(pi, trx);
        worker.run();
        return worker;
    }

    public void start() {
        Thread thread = new Thread(this);
        if (this.m_pi != null) {
            thread.setName(String.valueOf(this.m_pi.getTitle()) + "-" + this.m_pi.getAD_PInstance_ID());
        }
        thread.start();
    }

    @Override
    public void run() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("AD_PInstance_ID=" + this.m_pi.getAD_PInstance_ID() + ", Record_ID=" + this.m_pi.getRecord_ID());
        }
        String ProcedureName = "";
        String JasperReport = "";
        int AD_ReportView_ID = 0;
        int AD_Workflow_ID = 0;
        boolean IsReport = false;
        String sql = "SELECT p.Name, p.ProcedureName,p.ClassName, p.AD_Process_ID, p.isReport,p.IsDirectPrint,p.AD_ReportView_ID,p.AD_Workflow_ID, CASE WHEN COALESCE(p.Statistic_Count,0)=0 THEN 0 ELSE p.Statistic_Seconds/p.Statistic_Count END CASE, p.IsServerProcess, p.JasperReport, p.AD_Process_UU FROM AD_Process p INNER JOIN AD_PInstance i ON (p.AD_Process_ID=i.AD_Process_ID) WHERE p.IsActive='Y' AND i.AD_PInstance_ID=?";
        if (!Env.isBaseLanguage(Env.getCtx(), "AD_Process")) {
            sql = "SELECT t.Name, p.ProcedureName,p.ClassName, p.AD_Process_ID, p.isReport, p.IsDirectPrint,p.AD_ReportView_ID,p.AD_Workflow_ID, CASE WHEN COALESCE(p.Statistic_Count,0)=0 THEN 0 ELSE p.Statistic_Seconds/p.Statistic_Count END CASE, p.IsServerProcess, p.JasperReport, p.AD_Process_UU FROM AD_Process p INNER JOIN AD_PInstance i ON (p.AD_Process_ID=i.AD_Process_ID)  INNER JOIN AD_Process_Trl t ON (p.AD_Process_ID=t.AD_Process_ID AND t.AD_Language='" + Env.getAD_Language(Env.getCtx()) + "') " + "WHERE p.IsActive='Y'" + " AND i.AD_PInstance_ID=?";
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, 1003, 1007, null);
                pstmt.setInt(1, this.m_pi.getAD_PInstance_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.m_pi.setTitle(rs.getString(1));
                    ProcedureName = rs.getString(2);
                    this.m_pi.setClassName(rs.getString(3));
                    this.m_pi.setAD_Process_ID(rs.getInt(4));
                    this.m_pi.setAD_Process_UU(rs.getString(12));
                    if ("Y".equals(rs.getString(5))) {
                        IsReport = true;
                    }
                    AD_ReportView_ID = rs.getInt(7);
                    AD_Workflow_ID = rs.getInt(8);
                    int estimate = rs.getInt(9);
                    if (estimate != 0) {
                        this.m_pi.setEstSeconds(estimate + 1);
                    }
                    this.m_IsServerProcess = "Y".equals(rs.getString(10));
                    JasperReport = rs.getString(11);
                } else {
                    log.log(Level.SEVERE, "No AD_PInstance_ID=" + this.m_pi.getAD_PInstance_ID());
                }
            }
            catch (Throwable e) {
                this.m_pi.setSummary(String.valueOf(Msg.getMsg(Env.getCtx(), "ProcessNoProcedure")) + " " + e.getLocalizedMessage(), true);
                log.log(Level.SEVERE, "run", e);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (ProcedureName == null) {
            ProcedureName = "";
        }
        if (AD_Workflow_ID > 0) {
            this.startWorkflow(AD_Workflow_ID);
            return;
        }
        boolean isJasper = false;
        if (JasperReport != null && JasperReport.trim().length() > 0) {
            isJasper = true;
            if ("org.adempiere.report.jasper.ReportStarter".equals(this.m_pi.getClassName())) {
                this.m_pi.setClassName(null);
            }
        }
        if (this.m_pi.getClassName() != null) {
            if (isJasper) {
                this.m_pi.setReportingProcess(true);
            }
            if (!this.startProcess()) {
                return;
            }
            if (!IsReport && ProcedureName.length() == 0) {
                return;
            }
            if (IsReport && AD_ReportView_ID == 0 && !isJasper) {
                return;
            }
        }
        if (IsReport && ProcedureName.length() > 0) {
            this.m_pi.setReportingProcess(true);
            if (!this.startDBProcess(ProcedureName)) {
                return;
            }
        }
        if (isJasper) {
            this.m_pi.setReportingProcess(true);
            this.m_pi.setClassName("org.adempiere.report.jasper.ReportStarter");
            this.startProcess();
            return;
        }
        if (IsReport) {
            this.m_pi.setReportingProcess(true);
            boolean ok = ServerReportCtl.start(this.m_pi);
            String summ = Util.cleanAmp(Msg.getMsg(Env.getCtx(), "Report"));
            this.m_pi.setSummary(summ, !ok);
        } else {
            if (!this.startDBProcess(ProcedureName)) {
                return;
            }
            ProcessInfoUtil.setSummaryFromDB(this.m_pi);
        }
    }

    protected boolean startWorkflow(int AD_Workflow_ID) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(AD_Workflow_ID) + " - " + this.m_pi);
        }
        boolean started = false;
        if (this.m_IsServerProcess) {
            Server server = CConnection.get().getServer();
            try {
                if (server != null) {
                    this.m_pi = server.workflow(Env.getRemoteCallCtx(Env.getCtx()), this.m_pi, AD_Workflow_ID);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("server => " + this.m_pi);
                    }
                    started = true;
                }
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "AppsServer error", ex);
                started = false;
            }
        }
        if (!started && !this.m_IsServerProcess) {
            MWFProcess wfProcess;
            if (this.m_trx != null) {
                this.m_pi.setTransactionName(this.m_trx.getTrxName());
            }
            started = (wfProcess = ProcessUtil.startWorkFlow(Env.getCtx(), this.m_pi, AD_Workflow_ID)) != null;
        }
        return started;
    }

    protected boolean startProcess() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.m_pi.toString());
        }
        boolean started = false;
        boolean clientOnly = false;
        if (!this.m_pi.getClassName().toLowerCase().startsWith("@script:")) {
            try {
                Class<?> processClass = Class.forName(this.m_pi.getClassName());
                if (ClientProcess.class.isAssignableFrom(processClass)) {
                    clientOnly = true;
                }
            }
            catch (Exception processClass) {
                // empty catch block
            }
        }
        if (this.m_IsServerProcess && !clientOnly) {
            Server server = CConnection.get().getServer();
            try {
                if (server != null) {
                    this.m_pi = server.process(Env.getRemoteCallCtx(Env.getCtx()), this.m_pi);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("server => " + this.m_pi);
                    }
                    started = true;
                }
            }
            catch (UndeclaredThrowableException ex) {
                Throwable cause = ex.getCause();
                if (cause != null) {
                    if (cause instanceof InvalidClassException) {
                        log.log(Level.SEVERE, "Version Server <> Client: " + cause.toString() + " - " + this.m_pi, ex);
                    } else {
                        log.log(Level.SEVERE, "AppsServer error(1b): " + cause.toString() + " - " + this.m_pi, ex);
                    }
                } else {
                    log.log(Level.SEVERE, " AppsServer error(1) - " + this.m_pi, ex);
                }
                started = false;
            }
            catch (Exception ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                }
                log.log(Level.SEVERE, "AppsServer error - " + this.m_pi, cause);
                started = false;
            }
        }
        if (!(started || this.m_IsServerProcess && !clientOnly)) {
            if (this.m_pi.getClassName().toLowerCase().startsWith("@script:")) {
                return ProcessUtil.startScriptProcess(Env.getCtx(), this.m_pi, this.m_trx);
            }
            return ProcessUtil.startJavaProcess(Env.getCtx(), this.m_pi, this.m_trx);
        }
        return !this.m_pi.isError();
    }

    protected boolean startDBProcess(String ProcedureName) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(ProcedureName) + "(" + this.m_pi.getAD_PInstance_ID() + ")");
        }
        boolean started = false;
        if (this.m_IsServerProcess) {
            Server server = CConnection.get().getServer();
            try {
                if (server != null) {
                    this.m_pi = server.dbProcess(Env.getRemoteCallCtx(Env.getCtx()), this.m_pi, ProcedureName);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("server => " + this.m_pi);
                    }
                    started = true;
                }
            }
            catch (UndeclaredThrowableException ex) {
                Throwable cause = ex.getCause();
                if (cause != null) {
                    if (cause instanceof InvalidClassException) {
                        log.log(Level.SEVERE, "Version Server <> Client: " + cause.toString() + " - " + this.m_pi, ex);
                    } else {
                        log.log(Level.SEVERE, "AppsServer error(1b): " + cause.toString() + " - " + this.m_pi, ex);
                    }
                } else {
                    log.log(Level.SEVERE, " AppsServer error(1) - " + this.m_pi, ex);
                    cause = ex;
                }
                this.m_pi.setSummary(String.valueOf(Msg.getMsg(Env.getCtx(), "ProcessRunError")) + " " + cause.getLocalizedMessage());
                this.m_pi.setError(true);
                return false;
            }
            catch (Exception ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                }
                log.log(Level.SEVERE, "AppsServer error - " + this.m_pi, cause);
                this.m_pi.setSummary(String.valueOf(Msg.getMsg(Env.getCtx(), "ProcessRunError")) + " " + cause.getLocalizedMessage());
                this.m_pi.setError(true);
                return false;
            }
        }
        if (!started) {
            return ProcessUtil.startDatabaseProcedure(this.m_pi, ProcedureName, this.m_trx);
        }
        return true;
    }
}

