/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.List;
import java.util.logging.Level;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.model.MPOSKey;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class PosKeyGenerate
extends SvrProcess {
    private int posKeyLayoutId = 0;
    private int productCategoryId = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            if (para.getParameterName().equals("C_POSKeyLayout_ID")) {
                this.posKeyLayoutId = para.getParameterAsInt();
            }
            if (para.getParameterName().equals("M_Product_Category_ID")) {
                this.productCategoryId = para.getParameterAsInt();
            } else if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Parameter not found " + para.getParameterName());
            }
            ++n2;
        }
        if (this.posKeyLayoutId == 0) {
            this.posKeyLayoutId = this.getRecord_ID();
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.posKeyLayoutId == 0) {
            throw new FillMandatoryException(new String[]{"C_POSKeyLayout_ID"});
        }
        int count = 0;
        String where = "";
        Object[] params = new Object[]{};
        if (this.productCategoryId > 0) {
            where = "M_Product_Category_ID = ? ";
            params = new Object[]{this.productCategoryId};
        }
        Query query = new Query(this.getCtx(), "M_Product", where, this.get_TrxName()).setParameters(params).setOnlyActiveRecords(true).setOrderBy("Value");
        List products = query.list();
        for (MProduct product : products) {
            MPOSKey key = new MPOSKey(this.getCtx(), 0, this.get_TrxName());
            key.setName(product.getName());
            key.setM_Product_ID(product.getM_Product_ID());
            key.setC_POSKeyLayout_ID(this.posKeyLayoutId);
            key.setSeqNo(count * 10);
            key.setQty(Env.ONE);
            key.saveEx();
            ++count;
        }
        return "@Created@ " + count;
    }
}

