/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.SQLException;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MElementValue;
import org.compiere.model.MRule;
import org.compiere.model.MSequence;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class FactReconcile
extends SvrProcess {
    private MElementValue account;
    private int ruleID;

    @Override
    protected void prepare() {
        int accountID = 0;
        ProcessInfoParameter[] para = this.getParameter();
        int i2 = 0;
        while (i2 < para.length) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() != null) {
                if (name.equals("AD_Rule_ID")) {
                    this.ruleID = para[i2].getParameterAsInt();
                } else if (name.equals("Account_ID")) {
                    accountID = para[i2].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            if (accountID > 0) {
                this.account = new MElementValue(this.getCtx(), accountID, this.get_TrxName());
            }
            ++i2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        int unmatched;
        int count;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Reconcile Account: " + this.account.getName());
        }
        String subselect = "null";
        MRule rule = MRule.get(this.getCtx(), this.ruleID);
        if (rule == null || rule.is_new() || !rule.getRuleType().equals("Q") || !rule.getEventType().equals("R")) {
            return "Invalid rule for account reconciliation.";
        }
        subselect = rule.getScript();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Rule subselect: " + subselect);
        }
        String sql = "";
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("AD_PInstance_ID= " + this.getAD_PInstance_ID());
        }
        CPreparedStatement pstmt = null;
        MSequence seq = MSequence.get(this.getCtx(), "Fact_Reconciliation");
        if (seq == null) {
            throw new AdempiereException("No sequence for Fact_Reconciliation table");
        }
        try {
            try {
                sql = "INSERT into Fact_Reconciliation (Fact_Reconciliation_ID, AD_Client_ID, AD_Org_ID, Created, CreatedBy, Updated, UpdatedBy, IsActive, Fact_Acct_ID) SELECT nextIDFunc(?, 'N'), AD_Client_ID, AD_Org_ID, Created, CreatedBy, Updated, UpdatedBy, IsActive, Fact_Acct_ID FROM Fact_Acct f WHERE Account_ID = ? AND NOT EXISTS (SELECT 1 FROM Fact_Reconciliation r WHERE r.Fact_Acct_ID = f.Fact_Acct_ID) ";
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, seq.getAD_Sequence_ID());
                pstmt.setInt(2, this.account.get_ID());
                count = pstmt.executeUpdate();
                DB.close(pstmt);
                pstmt = null;
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.log(Level.FINE, "Inserted " + count + " new facts into Fact_Reconciliation");
                }
                sql = "UPDATE Fact_Reconciliation SET MatchCode = (" + subselect + " ) " + "WHERE MatchCode is null " + "AND (SELECT f.Account_ID FROM Fact_Acct f " + "     WHERE f.Fact_Acct_ID = Fact_Reconciliation.Fact_Acct_ID ) = ? " + "AND ( " + subselect + " ) IS NOT NULL ";
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.account.get_ID());
                count = pstmt.executeUpdate();
                DB.close(pstmt);
                pstmt = null;
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.log(Level.FINE, "Updated " + count + " match codes.");
                }
                sql = "UPDATE Fact_Reconciliation SET MatchCode = null  WHERE  (SELECT f1.Account_ID FROM Fact_Acct f1          WHERE f1.Fact_Acct_ID=Fact_Reconciliation.Fact_Acct_ID) = ?  AND (SELECT SUM(f2.amtacctdr-f2.amtacctcr) FROM Fact_Reconciliation r     INNER JOIN Fact_Acct f2 ON (f2.Fact_Acct_ID = r.Fact_Acct_ID)        WHERE r.MatchCode=Fact_Reconciliation.MatchCode       AND f2.Account_ID = ?) <> 0  AND MatchCode IS NOT NULL";
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.account.get_ID());
                pstmt.setInt(2, this.account.get_ID());
                unmatched = pstmt.executeUpdate();
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.log(Level.FINE, "Cleared match codes from " + unmatched + " unreconciled facts.");
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
                String string = e.getLocalizedMessage();
                DB.close(pstmt);
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(pstmt);
            pstmt = null;
            throw throwable;
        }
        DB.close(pstmt);
        pstmt = null;
        return "Matched " + (count - unmatched) + " facts";
    }
}

