/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MTable;
import org.compiere.model.MViewColumn;
import org.compiere.model.MViewComponent;
import org.compiere.process.ProcessInfo;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class DatabaseViewValidate
extends SvrProcess {
    private int p_AD_Table_ID = 0;

    @Override
    protected void prepare() {
        this.p_AD_Table_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        MTable table2 = new MTable(this.getCtx(), this.p_AD_Table_ID, this.get_TrxName());
        this.log.info(table2.toString());
        if (!table2.isView() || !table2.isActive()) {
            throw new AdempiereException(Msg.getMsg(this.getCtx(), "NotActiveDatabaseView"));
        }
        return DatabaseViewValidate.validateDatabaseView(this.getCtx(), table2, this.get_TrxName(), this.getProcessInfo());
    }

    public static String validateDatabaseView(Properties ctx, MTable table2, String trxName, ProcessInfo pi) throws Exception {
        Trx trx = Trx.get(trxName, true);
        DatabaseMetaData md = trx.getConnection().getMetaData();
        String tableName = table2.getTableName();
        if (md.storesUpperCaseIdentifiers()) {
            tableName = tableName.toUpperCase();
        } else if (md.storesLowerCaseIdentifiers()) {
            tableName = tableName.toLowerCase();
        }
        String catalog = null;
        String schema = null;
        String[] types = new String[]{"VIEW"};
        boolean found = false;
        ArrayList<String> viewColumnNames = new ArrayList<String>();
        ResultSet rs = md.getTables(catalog, schema, tableName, types);
        while (rs.next()) {
            String dbViewName = rs.getString("TABLE_NAME");
            if (dbViewName == null || !table2.getTableName().equalsIgnoreCase(dbViewName)) continue;
            found = true;
            viewColumnNames.clear();
            ResultSet rs2 = md.getColumns(rs.getString("TABLE_CAT"), rs.getString("TABLE_SCHEM"), dbViewName, null);
            while (rs2.next()) {
                viewColumnNames.add(rs2.getString("COLUMN_NAME"));
            }
            rs2.close();
        }
        rs.close();
        StringBuilder sb = new StringBuilder("CREATE OR REPLACE VIEW ").append(table2.getTableName());
        MViewComponent[] m_vcs = table2.getViewComponent(true);
        if (m_vcs == null || m_vcs.length == 0) {
            throw new AdempiereException(Msg.getMsg(ctx, "NoViewComponentsSpecified"));
        }
        boolean modified = false;
        MViewColumn[] vCols = null;
        int i2 = 0;
        while (i2 < m_vcs.length) {
            MViewComponent vc = m_vcs[i2];
            if (i2 > 0) {
                sb.append(" UNION ");
            } else {
                vCols = vc.getColumns(true);
                if (vCols == null || vCols.length == 0) {
                    throw new AdempiereException(Msg.getMsg(ctx, "NoViewColumnsSpecified"));
                }
                if (viewColumnNames.size() > vCols.length) {
                    modified = true;
                }
                boolean right = false;
                int j = 0;
                while (j < vCols.length) {
                    if (vCols[j].getColumnName().equals("*")) {
                        modified = true;
                        break;
                    }
                    if (j == 0) {
                        sb.append("(");
                        right = true;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(vCols[j].getColumnName());
                    if (!modified && j < viewColumnNames.size() && !((String)viewColumnNames.get(j)).equalsIgnoreCase(vCols[j].getColumnName())) {
                        modified = true;
                    }
                    ++j;
                }
                if (right) {
                    sb.append(")");
                }
                sb.append(" AS ");
            }
            sb.append(vc.getSelect(false, vCols));
            ++i2;
        }
        if (found && modified) {
            String sql = "DROP VIEW " + table2.getTableName();
            int rvalue = DB.executeUpdate(sql, null, true, trxName);
            if (pi != null) {
                pi.addLog(0, null, new BigDecimal(rvalue), sql);
            }
        }
        String sql = sb.toString();
        int rvalue = DB.executeUpdate(sql, null, true, trxName);
        if (pi != null) {
            pi.addLog(0, null, new BigDecimal(rvalue), sql);
        }
        if (rvalue == -1) {
            throw new AdempiereException(Msg.getMsg(ctx, "FailedCreateOrReplaceView"));
        }
        return Msg.getMsg(ctx, "CreatedOrReplacedViewSuccess");
    }
}

