/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import org.compiere.model.DatabaseKey;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class CreateForeignKey
extends SvrProcess {
    private int p_AD_Table_ID = 0;
    private int p_AD_Column_ID = 0;
    private int countTable = 0;
    private int countForeignKey = 0;
    private int countError = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i2 = 0;
        while (i2 < para.length) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() != null) {
                if (name.equals("AD_Table_ID")) {
                    this.p_AD_Table_ID = para[i2].getParameterAsInt();
                } else if (name.equals("AD_Column_ID")) {
                    this.p_AD_Column_ID = para[i2].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("AD_Table_ID=" + this.p_AD_Table_ID + ", AD_Column_ID=" + this.p_AD_Column_ID);
        }
        Trx trx = Trx.get(this.get_TrxName(), false);
        DatabaseMetaData md = trx.getConnection().getMetaData();
        if (this.p_AD_Column_ID > 0) {
            MTable table2;
            MColumn column = new MColumn(this.getCtx(), this.p_AD_Column_ID, this.get_TrxName());
            if (column != null && (table2 = new MTable(this.getCtx(), column.getAD_Table_ID(), this.get_TrxName())) != null && !column.isKey() && !column.getColumnName().equals(PO.getUUIDColumnName(table2.getTableName()))) {
                this.processDatabaseTableColumn(md, table2, column);
            }
        } else if (this.p_AD_Table_ID > 0) {
            MTable table3 = new MTable(this.getCtx(), this.p_AD_Table_ID, this.get_TrxName());
            if (table3 != null) {
                this.addLog(table3.getAD_Table_ID(), null, null, String.valueOf(Msg.getMsg(this.getCtx(), "CreateForeignKeyProcessTable")) + table3.getTableName(), table3.get_Table_ID(), table3.getAD_Table_ID());
                this.processDatabaseTableColumn(md, table3, null);
            }
        } else {
            this.processDatabase(md);
        }
        return Msg.getMsg(this.getCtx(), "CreateForeignKeyProcessResult", new Object[]{this.countTable, this.countForeignKey, this.countError});
    }

    private void processDatabase(DatabaseMetaData md) throws Exception {
        String tableName = null;
        String catalog = DB.getDatabase().getCatalog();
        String schema = DB.getDatabase().getSchema();
        String[] types = new String[]{"TABLE"};
        ResultSet rs = null;
        try {
            rs = md.getTables(catalog, schema, tableName, types);
            while (rs.next()) {
                MTable table2;
                String dbTableName = rs.getString("TABLE_NAME");
                if (dbTableName == null || (table2 = MTable.get(this.getCtx(), dbTableName)) == null) continue;
                this.addLog(table2.getAD_Table_ID(), null, null, String.valueOf(Msg.getMsg(this.getCtx(), "CreateForeignKeyProcessTable")) + table2.getTableName(), table2.get_Table_ID(), table2.getAD_Table_ID());
                this.processDatabaseTableColumn(md, table2, null);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs);
            rs = null;
            throw throwable;
        }
        DB.close(rs);
        rs = null;
    }

    private void processDatabaseTableColumn(DatabaseMetaData md, MTable table2, MColumn column) throws Exception {
        block44: {
            String fkConstraint;
            Hashtable<String, DatabaseKey> htForeignKeys = new Hashtable<String, DatabaseKey>();
            String catalog = DB.getDatabase().getCatalog();
            String schema = DB.getDatabase().getSchema();
            String tableName = table2.getTableName();
            if (md.storesUpperCaseIdentifiers()) {
                tableName = tableName.toUpperCase();
            } else if (md.storesLowerCaseIdentifiers()) {
                tableName = tableName.toLowerCase();
            }
            ResultSet rs = null;
            try {
                rs = md.getImportedKeys(catalog, schema, tableName);
                while (rs.next()) {
                    String dbFKName = rs.getString("FK_NAME");
                    if (dbFKName == null) continue;
                    String dbFKTable = rs.getString("FKTABLE_NAME");
                    short deleteRule = rs.getShort("DELETE_RULE");
                    String key = dbFKName.toLowerCase();
                    DatabaseKey dbForeignKey = (DatabaseKey)htForeignKeys.get(key);
                    if (dbForeignKey == null) {
                        dbForeignKey = new DatabaseKey(dbFKName, dbFKTable, new String[30], deleteRule);
                    }
                    String columnName = rs.getString("FKCOLUMN_NAME");
                    short pos = rs.getShort("KEY_SEQ");
                    if (pos > 0) {
                        dbForeignKey.getKeyColumns()[pos - 1] = columnName;
                    }
                    htForeignKeys.put(key, dbForeignKey);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs);
                rs = null;
                throw throwable;
            }
            DB.close(rs);
            rs = null;
            Enumeration en = htForeignKeys.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                DatabaseKey dbForeignKey = (DatabaseKey)htForeignKeys.get(key);
                if (dbForeignKey.getKeyColumns()[1] == null) continue;
                htForeignKeys.remove(key);
            }
            ++this.countTable;
            if (column == null) {
                String getColumnIDSql = "SELECT AD_Column_ID FROM AD_Column WHERE AD_Table_ID = ? AND LOWER(ColumnName) = ?";
                try {
                    rs = md.getColumns(catalog, schema, tableName, null);
                    while (rs.next()) {
                        String foreignTable;
                        int AD_Column_ID;
                        String columnName = rs.getString("COLUMN_NAME");
                        if (columnName == null || (AD_Column_ID = DB.getSQLValue(null, "SELECT AD_Column_ID FROM AD_Column WHERE AD_Table_ID = ? AND LOWER(ColumnName) = ?", table2.getAD_Table_ID(), columnName.toLowerCase())) <= 0 || (column = MColumn.get(this.getCtx(), AD_Column_ID)) == null || (foreignTable = column.getReferenceTableName()) == null || "AD_Ref_List".equals(foreignTable)) continue;
                        this.processDatabaseTableColumn(md, table2, column);
                    }
                }
                finally {
                    DB.close(rs);
                    rs = null;
                }
            }
            if (this.processUI != null) {
                this.processUI.statusUpdate(String.valueOf(table2.getTableName()) + "." + column.getColumnName());
            }
            boolean modified = false;
            en = htForeignKeys.keys();
            while (en.hasMoreElements()) {
                String fkConstraintType;
                DatabaseKey dbForeignKey;
                block43: {
                    String key = (String)en.nextElement();
                    dbForeignKey = (DatabaseKey)htForeignKeys.get(key);
                    String dbDeleteRule = null;
                    if (dbForeignKey.getDeleteRule() == 0) {
                        dbDeleteRule = "C";
                    } else if (dbForeignKey.getDeleteRule() == 2) {
                        dbDeleteRule = "S";
                    } else if (dbForeignKey.getDeleteRule() == 3 || dbForeignKey.getDeleteRule() == 1) {
                        dbDeleteRule = "N";
                    }
                    fkConstraintType = column.getFKConstraintType();
                    if (fkConstraintType == null && (fkConstraintType = dbDeleteRule) == null) {
                        fkConstraintType = "AD_Client_ID".equals(column.getColumnName()) || "AD_Org_ID".equals(column.getColumnName()) || "CreatedBy".equals(column.getColumnName()) || "UpdatedBy".equals(column.getColumnName()) ? "D" : "N";
                    }
                    if (!dbForeignKey.getKeyColumns()[0].equalsIgnoreCase(column.getColumnName())) continue;
                    if (dbDeleteRule.equals(fkConstraintType)) {
                        this.addLog(column.getAD_Column_ID(), null, null, String.valueOf(Msg.getMsg(this.getCtx(), "CreateForeignKeyProcessColumn")) + column.getColumnName() + " / " + Msg.getMsg(this.getCtx(), "CreateForeignKeyProcessExists") + dbForeignKey.getKeyName(), column.get_Table_ID(), column.getAD_Column_ID());
                        modified = true;
                        column.setFKConstraintName(dbForeignKey.getKeyName());
                        column.setFKConstraintType(fkConstraintType);
                        column.saveEx();
                        break;
                    }
                    if (!fkConstraintType.equals("D")) continue;
                    this.addLog(column.getAD_Column_ID(), null, null, String.valueOf(Msg.getMsg(this.getCtx(), "CreateForeignKeyProcessColumn")) + column.getColumnName() + " / " + Msg.getMsg(this.getCtx(), "CreateForeignKeyProcessExists") + dbForeignKey.getKeyName(), column.get_Table_ID(), column.getAD_Column_ID());
                    StringBuilder sql = new StringBuilder();
                    sql.append("ALTER TABLE ").append(table2.getTableName());
                    sql.append(" DROP CONSTRAINT ").append(dbForeignKey.getKeyName());
                    Trx trx = null;
                    try {
                        try {
                            trx = Trx.get(Trx.createTrxName("CreateForeignKey"), true);
                            trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_process_dropConstraint");
                            int rvalue = DB.executeUpdate(sql.toString(), null, true, trx.getTrxName());
                            this.addLog(0, null, new BigDecimal(rvalue), sql.toString());
                        }
                        catch (Exception e) {
                            this.addLog(String.valueOf(Msg.getMsg(this.getCtx(), "Error")) + e.getLocalizedMessage());
                            if (trx != null) {
                                trx.rollback();
                            }
                            if (trx != null) {
                                trx.close();
                            }
                            break block43;
                        }
                    }
                    catch (Throwable throwable) {
                        if (trx != null) {
                            trx.close();
                        }
                        throw throwable;
                    }
                    if (trx != null) {
                        trx.close();
                    }
                }
                modified = true;
                column.setFKConstraintName(dbForeignKey.getKeyName());
                column.setFKConstraintType(fkConstraintType);
                column.saveEx();
                break;
            }
            if (modified) {
                return;
            }
            if (!column.isKey() && !column.getColumnName().equals(PO.getUUIDColumnName(table2.getTableName())) && (fkConstraint = MColumn.getForeignKeyConstraint(md, table2, column)) != null && fkConstraint.length() > 0) {
                this.addLog(column.getAD_Column_ID(), null, null, String.valueOf(Msg.getMsg(this.getCtx(), "CreateForeignKeyProcessColumn")) + column.getColumnName(), column.get_Table_ID(), column.getAD_Column_ID());
                StringBuilder sql = new StringBuilder();
                sql.append("ALTER TABLE ").append(table2.getTableName());
                sql.append(" ADD ");
                sql.append(fkConstraint);
                try (Trx trx = null;){
                    try {
                        trx = Trx.get(Trx.createTrxName("CreateForeignKey"), true);
                        trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_process_addConstraint");
                        int rvalue = DB.executeUpdate(sql.toString(), null, true, trx.getTrxName());
                        this.addLog(0, null, new BigDecimal(rvalue), sql.toString());
                        if (rvalue == -1) {
                            ++this.countError;
                            break block44;
                        }
                        ++this.countForeignKey;
                    }
                    catch (Exception e) {
                        this.addLog(String.valueOf(Msg.getMsg(this.getCtx(), "Error")) + e.getLocalizedMessage());
                        if (trx != null) {
                            trx.rollback();
                        }
                        ++this.countError;
                        if (trx != null) {
                            trx.close();
                        }
                    }
                }
            }
        }
    }
}

