/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import java.util.logging.Level;
import org.compiere.print.util.SwapFileSegment;
import org.compiere.util.CLogger;

public class SwapFile {
    private static final CLogger log = CLogger.getCLogger(SwapFile.class);
    private final File swapFile;
    private RandomAccessFile randomAccessFile;
    private final int blockSize;
    private final int minBlockToGrow;
    private final LinkedList<Long> freeBlocks;

    public SwapFile(String prefix, int blockSize, int minBlockToGrow) {
        try {
            this.swapFile = File.createTempFile(prefix, ".swap");
            if (log.isLoggable(Level.INFO)) {
                log.info("Creating swap file " + this.swapFile.getPath());
            }
            this.swapFile.deleteOnExit();
            this.blockSize = blockSize;
            this.minBlockToGrow = minBlockToGrow;
            this.freeBlocks = new LinkedList();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void open() {
        try {
            this.randomAccessFile = new RandomAccessFile(this.swapFile, "rw");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void close() {
        if (this.randomAccessFile != null) {
            try {
                this.randomAccessFile.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public SwapFileSegment write(byte[] data) throws IOException {
        this.verifyOpen();
        int blockCount = (data.length - 1) / this.blockSize + 1;
        long[] offsets = this.allocateFreeBlocks(blockCount);
        int lastBlockSize = (data.length - 1) % this.blockSize + 1;
        SwapFileSegment segment = new SwapFileSegment(offsets, lastBlockSize);
        int i2 = 0;
        while (i2 < blockCount) {
            int dataSize = i2 < blockCount - 1 ? this.blockSize : lastBlockSize;
            int dataOffset = i2 * this.blockSize;
            this.write(data, dataSize, dataOffset, offsets[i2]);
            ++i2;
        }
        return segment;
    }

    private synchronized void write(byte[] data, int dataSize, int dataOffset, long fileOffset) throws IOException {
        this.randomAccessFile.seek(fileOffset);
        this.randomAccessFile.write(data, dataOffset, dataSize);
    }

    public byte[] read(SwapFileSegment segment) throws IOException {
        this.verifyOpen();
        long[] offsets = segment.getOffsets();
        int totalLength = (offsets.length - 1) * this.blockSize + segment.getLastBlockSize();
        byte[] data = new byte[totalLength];
        int i2 = 0;
        while (i2 < offsets.length) {
            int dataOffset = i2 * this.blockSize;
            int dataLength = i2 < offsets.length - 1 ? this.blockSize : segment.getLastBlockSize();
            this.read(data, dataOffset, dataLength, offsets[i2]);
            ++i2;
        }
        return data;
    }

    private synchronized void read(byte[] data, int dataOffset, int dataLength, long fileOffset) throws IOException {
        this.randomAccessFile.seek(fileOffset);
        this.randomAccessFile.readFully(data, dataOffset, dataLength);
    }

    public void free(SwapFileSegment segment) {
        this.verifyOpen();
        this.freeBlocks(segment.getOffsets());
    }

    private synchronized void verifyOpen() {
        if (this.randomAccessFile == null) {
            throw new RuntimeException("Swap file not open for read write access");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        SwapFile swapFile = this;
        synchronized (swapFile) {
            if (this.swapFile.exists()) {
                if (log.isLoggable(Level.INFO)) {
                    log.info("Disposing swap file " + this.swapFile.getPath());
                }
                try {
                    this.close();
                }
                catch (Exception e) {
                    log.warning("Not able to close swap file " + this.swapFile.getPath());
                }
                if (!this.swapFile.delete()) {
                    log.warning("Not able to delete swap file " + this.swapFile.getPath());
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    private synchronized long[] allocateFreeBlocks(int blockCount) throws IOException {
        int growCount = blockCount - this.freeBlocks.size();
        if (growCount > 0) {
            if (growCount < this.minBlockToGrow) {
                growCount = this.minBlockToGrow;
            }
            long length = this.randomAccessFile.length();
            long newLength = length + (long)(growCount * this.blockSize);
            if (log.isLoggable(Level.INFO)) {
                log.info("Growing swap file " + this.swapFile.getPath() + " with " + growCount + " blocks x " + this.blockSize + " bytes to size " + newLength);
            }
            this.randomAccessFile.setLength(newLength);
            int i2 = 0;
            while (i2 < growCount) {
                this.freeBlocks.addLast(length + (long)(i2 * this.blockSize));
                ++i2;
            }
        }
        long[] offsets = new long[blockCount];
        int i3 = 0;
        while (i3 < blockCount) {
            offsets[i3] = this.freeBlocks.pollFirst();
            ++i3;
        }
        return offsets;
    }

    private synchronized void freeBlocks(long[] offsets) {
        int i2 = offsets.length - 1;
        while (i2 >= 0) {
            this.freeBlocks.addFirst(offsets[i2]);
            --i2;
        }
    }
}

