/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.print.DocFlavor;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.event.PrintServiceAttributeEvent;
import javax.print.event.PrintServiceAttributeListener;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.pdf.Document;
import org.adempiere.print.export.PrintDataExcelExporter;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.XhtmlDocument;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.tbody;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.thead;
import org.apache.ecs.xhtml.tr;
import org.compiere.Adempiere;
import org.compiere.model.I_AD_PrintFormat;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MProcess;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.PrintInfo;
import org.compiere.print.ArchiveEngine;
import org.compiere.print.DataEngine;
import org.compiere.print.IHTMLExtension;
import org.compiere.print.IReportEngineEventListener;
import org.compiere.print.MPrintColor;
import org.compiere.print.MPrintFont;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.print.PrintUtil;
import org.compiere.print.ReportEngineEvent;
import org.compiere.print.layout.LayoutEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class ReportEngine
implements PrintServiceAttributeListener {
    private static CLogger log = CLogger.getCLogger(ReportEngine.class);
    private Properties m_ctx;
    private MPrintFormat m_printFormat;
    private PrintInfo m_info;
    private MQuery m_query;
    private PrintData m_printData;
    private LayoutEngine m_layout = null;
    private String m_printerName = Ini.getProperty("Printer");
    private String m_trxName = null;
    private String m_whereExtended = null;
    private int m_windowNo = 0;
    private int m_language_id = 0;
    private boolean m_summary = false;
    private Map<CSSInfo, List<ColumnInfo>> mapCssInfo = new HashMap<CSSInfo, List<ColumnInfo>>();
    private List<IReportEngineEventListener> eventListeners = new ArrayList<IReportEngineEventListener>();
    public static final int ORDER = 0;
    public static final int SHIPMENT = 1;
    public static final int INVOICE = 2;
    public static final int PROJECT = 3;
    public static final int RFQ = 4;
    public static final int REMITTANCE = 5;
    public static final int CHECK = 6;
    public static final int DUNNING = 7;
    public static final int MANUFACTURING_ORDER = 8;
    public static final int DISTRIBUTION_ORDER = 9;
    public static final int INVENTORY = 10;
    public static final int MOVEMENT = 11;
    private static final String[] DOC_BASETABLES = new String[]{"C_Order", "M_InOut", "C_Invoice", "C_Project", "C_RfQResponse", "C_PaySelectionCheck", "C_PaySelectionCheck", "C_DunningRunEntry", "PP_Order", "DD_Order", "M_Inventory", "M_Movement"};
    private static final String[] DOC_IDS = new String[]{"C_Order_ID", "M_InOut_ID", "C_Invoice_ID", "C_Project_ID", "C_RfQResponse_ID", "C_PaySelectionCheck_ID", "C_PaySelectionCheck_ID", "C_DunningRunEntry_ID", "PP_Order_ID", "DD_Order_ID", "M_Inventory_ID", "M_Movement_ID"};
    private static final int[] DOC_TABLE_ID = new int[]{259, 319, 318, 203, 674, 525, 525, 527, 53027, 53037, 321, 323};
    private String reportType;

    public ReportEngine(Properties ctx, MPrintFormat pf, MQuery query, PrintInfo info) {
        this(ctx, pf, query, info, null);
    }

    public ReportEngine(Properties ctx, MPrintFormat pf, MQuery query, PrintInfo info, boolean isSummary) {
        this(ctx, pf, query, info, isSummary, null);
    }

    public ReportEngine(Properties ctx, MPrintFormat pf, MQuery query, PrintInfo info, String trxName) {
        this(ctx, pf, query, info, false, trxName);
    }

    public ReportEngine(Properties ctx, MPrintFormat pf, MQuery query, PrintInfo info, boolean isSummary, String trxName) {
        this.m_summary = isSummary;
        if (pf == null) {
            throw new IllegalArgumentException("ReportEngine - no PrintFormat");
        }
        if (log.isLoggable(Level.INFO)) {
            log.info(pf + " -- " + query);
        }
        this.m_ctx = ctx;
        this.m_printFormat = pf;
        this.m_info = info;
        this.m_trxName = trxName;
        this.setQuery(query);
    }

    public void addEventListener(IReportEngineEventListener listener) {
        this.eventListeners.add(listener);
    }

    public boolean removeEventListener(IReportEngineEventListener listener) {
        return this.eventListeners.remove(listener);
    }

    public void setPrintFormat(MPrintFormat pf) {
        IReportEngineEventListener[] listeners;
        this.m_printFormat = pf;
        pf.reloadItems();
        if (this.m_layout != null) {
            this.setPrintData();
            this.m_layout.setPrintFormat(pf, false);
            this.m_layout.setPrintData(this.m_printData, this.m_query, true);
        }
        IReportEngineEventListener[] iReportEngineEventListenerArray = listeners = this.eventListeners.toArray(new IReportEngineEventListener[0]);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IReportEngineEventListener listener = iReportEngineEventListenerArray[n2];
            listener.onPrintFormatChanged(new ReportEngineEvent(this));
            ++n2;
        }
    }

    public void setQuery(MQuery query) {
        IReportEngineEventListener[] listeners;
        this.m_query = query;
        if (query == null) {
            return;
        }
        this.setPrintData();
        if (this.m_layout != null) {
            this.m_layout.setPrintData(this.m_printData, this.m_query, true);
        }
        IReportEngineEventListener[] iReportEngineEventListenerArray = listeners = this.eventListeners.toArray(new IReportEngineEventListener[0]);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IReportEngineEventListener listener = iReportEngineEventListenerArray[n2];
            listener.onQueryChanged(new ReportEngineEvent(this));
            ++n2;
        }
    }

    public MQuery getQuery() {
        return this.m_query;
    }

    private void setPrintData() {
        if (this.m_query == null) {
            return;
        }
        DataEngine de = new DataEngine(this.m_printFormat.getLanguage(), this.m_trxName);
        this.setPrintData(de.getPrintData(this.m_ctx, this.m_printFormat, this.m_query, this.m_summary));
    }

    public PrintData getPrintData() {
        return this.m_printData;
    }

    public void setPrintData(PrintData printData) {
        if (printData == null) {
            return;
        }
        this.m_printData = printData;
    }

    private void layout() {
        if (this.m_printFormat == null) {
            throw new IllegalStateException("No print format");
        }
        if (this.m_printData == null) {
            throw new IllegalStateException("No print data (Delete Print Format and restart)");
        }
        this.m_layout = new LayoutEngine(this.m_printFormat, this.m_printData, this.m_query, this.m_info, this.m_trxName);
    }

    public LayoutEngine getLayout() {
        if (this.m_layout == null) {
            this.layout();
        }
        return this.m_layout;
    }

    public String getName() {
        return this.m_printFormat.get_Translation("Name");
    }

    public MPrintFormat getPrintFormat() {
        return this.m_printFormat;
    }

    public PrintInfo getPrintInfo() {
        return this.m_info;
    }

    public Properties getCtx() {
        return this.m_ctx;
    }

    public int getRowCount() {
        return this.m_printData.getRowCount();
    }

    public int getColumnCount() {
        if (this.m_layout != null) {
            return this.m_layout.getColumnCount();
        }
        return 0;
    }

    public void print() {
        if (log.isLoggable(Level.INFO)) {
            log.info(this.m_info.toString());
        }
        if (this.m_layout == null) {
            this.layout();
        }
        PrintRequestAttributeSet prats = this.m_layout.getPaper().getPrintRequestAttributeSet();
        if (this.m_info.isDocumentCopy() || this.m_info.getCopies() < 1) {
            prats.add(new Copies(1));
        } else {
            prats.add(new Copies(this.m_info.getCopies()));
        }
        Locale locale = Language.getLoginLanguage().getLocale();
        prats.add(new JobName(this.m_printFormat.getName(), locale));
        prats.add(PrintUtil.getJobPriority(this.m_layout.getNumberOfPages(), this.m_info.getCopies(), true));
        try {
            PrinterJob job = this.getPrinterJob(this.m_info.getPrinterName());
            job.setPageable(this.m_layout.getPageable(false));
            try {
                if (this.m_info.isWithDialog() && !job.printDialog(prats)) {
                    return;
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Operating System Print Issue, check & try again", e);
                return;
            }
            boolean printCopy = this.m_info.isDocumentCopy() && this.m_info.getCopies() > 1;
            ArchiveEngine.get().archive(this.m_layout, this.m_info);
            PrintUtil.print(job, prats, false, printCopy);
            if (printCopy) {
                if (log.isLoggable(Level.INFO)) {
                    log.info("Copy " + (this.m_info.getCopies() - 1));
                }
                prats.add(new Copies(this.m_info.getCopies() - 1));
                job = this.getPrinterJob(this.m_info.getPrinterName());
                job.setPageable(this.m_layout.getPageable(true));
                PrintUtil.print(job, prats, false, false);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    @Override
    public void attributeUpdate(PrintServiceAttributeEvent psae) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("attributeUpdate - " + psae);
        }
    }

    private PrinterJob getPrinterJob(String printerName) {
        if (printerName != null && printerName.length() > 0) {
            return PrintUtil.getPrinterJob(printerName);
        }
        return PrintUtil.getPrinterJob(this.m_printerName);
    }

    public void pageSetupDialog() {
        IReportEngineEventListener[] listeners;
        if (this.m_layout == null) {
            this.layout();
        }
        this.m_layout.pageSetupDialog(this.getPrinterJob(this.m_printerName));
        IReportEngineEventListener[] iReportEngineEventListenerArray = listeners = this.eventListeners.toArray(new IReportEngineEventListener[0]);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IReportEngineEventListener listener = iReportEngineEventListenerArray[n2];
            listener.onPageSetupChanged(new ReportEngineEvent(this));
            ++n2;
        }
    }

    public void setPrinterName(String printerName) {
        this.m_printerName = printerName == null ? Ini.getProperty("Printer") : printerName;
    }

    public String getPrinterName() {
        return this.m_printerName;
    }

    public boolean createHTML(File file, boolean onlyTable, Language language) {
        return this.createHTML(file, onlyTable, language, null);
    }

    public boolean createHTML(File file, boolean onlyTable, Language language, IHTMLExtension extension) {
        try {
            Language lang = language;
            if (lang == null) {
                lang = Language.getLoginLanguage();
            }
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), Ini.getCharset());
            return this.createHTML(new BufferedWriter(fw), onlyTable, lang, extension);
        }
        catch (FileNotFoundException fnfe) {
            log.log(Level.SEVERE, "(f) - " + fnfe.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", e);
        }
        return false;
    }

    public boolean createHTML(Writer writer, boolean onlyTable, Language language) {
        return this.createHTML(writer, onlyTable, language, null);
    }

    public boolean createHTML(Writer writer, boolean onlyTable, Language language, IHTMLExtension extension) {
        return this.createHTML(writer, onlyTable, language, extension, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createHTML(Writer writer, boolean onlyTable, Language language, IHTMLExtension extension, boolean isExport) {
        try {
            String cssPrefix;
            String string = cssPrefix = extension != null ? extension.getClassPrefix() : null;
            if (cssPrefix != null && cssPrefix.trim().length() == 0) {
                cssPrefix = null;
            }
            table table2 = new table();
            if (cssPrefix != null) {
                table2.setClass(String.valueOf(cssPrefix) + "-table");
            }
            table2.setNeedClosingTag(false);
            PrintWriter w = new PrintWriter(writer);
            if (onlyTable) {
                table2.output(w);
            } else {
                XhtmlDocument doc = new XhtmlDocument();
                doc.getHtml().setNeedClosingTag(false);
                doc.getBody().setNeedClosingTag(false);
                doc.appendHead("<meta charset=\"UTF-8\" />");
                doc.appendBody((Element)table2);
                this.appendInlineCss(doc);
                if (extension != null && extension.getStyleURL() != null) {
                    String pathStyleFile = extension.getFullPathStyle();
                    Path path = Paths.get(pathStyleFile, new String[0]);
                    List<String> styleLines = Files.readAllLines(path, Ini.getCharset());
                    Files.delete(path);
                    StringBuilder styleBuild = new StringBuilder();
                    Iterator<String> iterator = styleLines.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            this.appendInlineCss(doc, styleBuild);
                            break;
                        }
                        String styleLine = iterator.next();
                        styleBuild.append(styleLine);
                    }
                }
                if (extension != null && extension.getScriptURL() != null && !isExport) {
                    script jslink = new script();
                    jslink.setLanguage("javascript");
                    jslink.setSrc(extension.getScriptURL());
                    doc.appendHead((Element)jslink);
                }
                if (extension != null && !isExport) {
                    extension.setWebAttribute(doc.getBody());
                }
                doc.output(w);
            }
            thead thead2 = new thead();
            tbody tbody2 = new tbody();
            tbody2.setNeedClosingTag(false);
            Boolean[] colSuppressRepeats = this.m_layout == null || this.m_layout.colSuppressRepeats == null ? LayoutEngine.getColSuppressRepeats(this.m_printFormat) : this.m_layout.colSuppressRepeats;
            Object[] preValues = new Object[colSuppressRepeats.length];
            int printColIndex = -1;
            int row = -1;
            while (true) {
                block41: {
                    tr tr2;
                    block44: {
                        block43: {
                            if (row >= this.m_printData.getRowCount()) {
                                w.println();
                                w.println("</tbody>");
                                w.println("</table>");
                                if (!onlyTable) {
                                    w.println("</body>");
                                    w.println("</html>");
                                }
                                w.flush();
                                w.close();
                                return false;
                            }
                            tr2 = new tr();
                            if (row == -1) break block43;
                            this.m_printData.setRowIndex(row);
                            if (extension != null && !isExport) {
                                extension.extendRowElement((ConcreteElement)tr2, this.m_printData);
                            }
                            if (this.m_printData.isFunctionRow()) {
                                tr2.setClass(String.valueOf(cssPrefix) + "-functionrow");
                                break block44;
                            } else if (row < this.m_printData.getRowCount() && this.m_printData.isFunctionRow(row + 1)) {
                                tr2.setClass(String.valueOf(cssPrefix) + "-lastgrouprow");
                            }
                            break block44;
                        }
                        thead2.addElement((Element)tr2);
                    }
                    printColIndex = -1;
                    int col = 0;
                    while (true) {
                        block45: {
                            Object obj;
                            block48: {
                                PrintDataElement pde;
                                td td2;
                                MPrintFormatItem item;
                                block42: {
                                    String value;
                                    block51: {
                                        boolean isZoom;
                                        block53: {
                                            block52: {
                                                block49: {
                                                    block50: {
                                                        block47: {
                                                            block46: {
                                                                MColumn column;
                                                                if (col >= this.m_printFormat.getItemCount()) {
                                                                    if (row != -1) break;
                                                                    thead2.output(w);
                                                                    tbody2.output(w);
                                                                    break block41;
                                                                }
                                                                item = this.m_printFormat.getItem(col);
                                                                if (!item.isPrinted()) break block45;
                                                                ++printColIndex;
                                                                if (row != -1) break block46;
                                                                th th2 = new th();
                                                                tr2.addElement((Element)th2);
                                                                th2.addElement(Util.maskHTML(item.getPrintName(language)));
                                                                if (cssPrefix != null && (column = MColumn.get(this.getCtx(), item.getAD_Column_ID())) != null && column.getAD_Column_ID() > 0 && DisplayType.isNumeric(column.getAD_Reference_ID())) {
                                                                    th2.setClass(String.valueOf(cssPrefix) + "-number");
                                                                }
                                                                break block45;
                                                            }
                                                            td2 = new td();
                                                            tr2.addElement((Element)td2);
                                                            obj = this.m_printData.getNode((Integer)item.getAD_Column_ID());
                                                            if (obj != null) break block47;
                                                            td2.addElement("&nbsp;");
                                                            if (colSuppressRepeats[printColIndex].booleanValue()) {
                                                                preValues[printColIndex] = null;
                                                            }
                                                            break block45;
                                                        }
                                                        if (!(obj instanceof PrintDataElement)) break block48;
                                                        pde = (PrintDataElement)obj;
                                                        value = pde.getValueDisplay(language);
                                                        if (!colSuppressRepeats[printColIndex].booleanValue()) break block49;
                                                        if (!value.equals(preValues[printColIndex])) break block50;
                                                        td2.addElement("&nbsp;");
                                                        break block45;
                                                    }
                                                    preValues[printColIndex] = value;
                                                }
                                                if (!pde.getColumnName().endsWith("_ID") || extension == null || isExport) break block51;
                                                isZoom = false;
                                                if (!item.getColumnName().equals("Record_ID")) break block52;
                                                Object tablePDE = this.m_printData.getNode("AD_Table_ID");
                                                if (tablePDE != null && tablePDE instanceof PrintDataElement) {
                                                    int tableID = -1;
                                                    try {
                                                        tableID = Integer.parseInt(((PrintDataElement)tablePDE).getValueAsString());
                                                    }
                                                    catch (Exception e) {
                                                        tableID = -1;
                                                    }
                                                    if (tableID > 0) {
                                                        MTable mTable = MTable.get(this.getCtx(), tableID);
                                                        String foreignColumnName = String.valueOf(mTable.getTableName()) + "_ID";
                                                        pde.setForeignColumnName(foreignColumnName);
                                                        isZoom = true;
                                                    }
                                                }
                                                break block53;
                                            }
                                            isZoom = true;
                                        }
                                        if (isZoom) {
                                            MTable mTable = MTable.get(this.getCtx(), pde.getForeignColumnName().substring(0, pde.getForeignColumnName().length() - 3));
                                            int Record_ID = -1;
                                            try {
                                                Record_ID = Integer.parseInt(pde.getValueAsString());
                                            }
                                            catch (Exception e) {
                                                Record_ID = -1;
                                            }
                                            Boolean canAccess = null;
                                            if (Record_ID >= 0 && mTable != null) {
                                                int AD_Window_ID = Env.getZoomWindowID(mTable.get_ID(), Record_ID);
                                                canAccess = MRole.getDefault().getWindowAccess(AD_Window_ID);
                                            }
                                            if (canAccess == null) {
                                                isZoom = false;
                                            }
                                        }
                                        if (isZoom) {
                                            a href = new a("javascript:void(0)");
                                            href.setID(String.valueOf(pde.getColumnName()) + "_" + row + "_a");
                                            td2.addElement((Element)href);
                                            href.addElement(Util.maskHTML(value));
                                            if (cssPrefix != null) {
                                                href.setClass(String.valueOf(cssPrefix) + "-href");
                                            }
                                            extension.extendIDColumn(row, (ConcreteElement)td2, href, pde);
                                            break block42;
                                        } else {
                                            td2.addElement(Util.maskHTML(value));
                                        }
                                        break block42;
                                    }
                                    td2.addElement(Util.maskHTML(value));
                                }
                                if (cssPrefix != null) {
                                    if (DisplayType.isNumeric(pde.getDisplayType())) {
                                        td2.setClass(String.valueOf(cssPrefix) + "-number");
                                    } else if (DisplayType.isDate(pde.getDisplayType())) {
                                        td2.setClass(String.valueOf(cssPrefix) + "-date");
                                    } else {
                                        td2.setClass(String.valueOf(cssPrefix) + "-text");
                                    }
                                }
                                if (row == 0) {
                                    this.addCssInfo(item, printColIndex);
                                }
                                break block45;
                            }
                            if (!(obj instanceof PrintData)) {
                                log.log(Level.SEVERE, "Element not PrintData(Element) " + obj.getClass());
                            }
                        }
                        ++col;
                    }
                    tr2.output(w);
                }
                ++row;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(w)", e);
        }
        return false;
    }

    private String getCSSFontFamily(String fontFamily) {
        if ("Dialog".equals(fontFamily) || "DialogInput".equals(fontFamily) || "Monospaced".equals(fontFamily)) {
            return "monospace";
        }
        if ("SansSerif".equals(fontFamily)) {
            return "sans-serif";
        }
        if ("Serif".equals(fontFamily)) {
            return "serif";
        }
        return null;
    }

    public boolean createCSV(File file, char delimiter, Language language) {
        try {
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), Ini.getCharset());
            return this.createCSV(new BufferedWriter(fw), delimiter, language);
        }
        catch (FileNotFoundException fnfe) {
            log.log(Level.SEVERE, "(f) - " + fnfe.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", e);
        }
        return false;
    }

    public boolean createCSV(Writer writer, char delimiter, Language language) {
        if (delimiter == '\u0000') {
            delimiter = (char)9;
        }
        try {
            Boolean[] colSuppressRepeats = this.m_layout == null || this.m_layout.colSuppressRepeats == null ? LayoutEngine.getColSuppressRepeats(this.m_printFormat) : this.m_layout.colSuppressRepeats;
            Object[] preValues = new Object[colSuppressRepeats.length];
            int printColIndex = -1;
            int row = -1;
            while (row < this.m_printData.getRowCount()) {
                printColIndex = -1;
                StringBuffer sb = new StringBuffer();
                if (row != -1) {
                    this.m_printData.setRowIndex(row);
                }
                boolean first = true;
                int col = 0;
                while (col < this.m_printFormat.getItemCount()) {
                    block10: {
                        String data;
                        block13: {
                            Object obj;
                            block14: {
                                block12: {
                                    MPrintFormatItem item;
                                    block11: {
                                        item = this.m_printFormat.getItem(col);
                                        if (!item.isPrinted()) break block10;
                                        if (first) {
                                            first = false;
                                        } else {
                                            sb.append(delimiter);
                                        }
                                        if (row != -1) break block11;
                                        this.createCSVvalue(sb, delimiter, this.m_printFormat.getItem(col).getPrintName(language));
                                        break block10;
                                    }
                                    ++printColIndex;
                                    obj = this.m_printData.getNode((Integer)item.getAD_Column_ID());
                                    data = "";
                                    if (obj != null) break block12;
                                    if (colSuppressRepeats[printColIndex].booleanValue()) {
                                        preValues[printColIndex] = null;
                                    }
                                    break block13;
                                }
                                if (!(obj instanceof PrintDataElement)) break block14;
                                PrintDataElement pde = (PrintDataElement)obj;
                                data = pde.isPKey() ? pde.getValueAsString() : pde.getValueDisplay(language);
                                if (!colSuppressRepeats[printColIndex].booleanValue()) break block13;
                                if (data.equals(preValues[printColIndex])) break block10;
                                preValues[printColIndex] = data;
                                break block13;
                            }
                            if (!(obj instanceof PrintData)) {
                                log.log(Level.SEVERE, "Element not PrintData(Element) " + obj.getClass());
                            }
                        }
                        this.createCSVvalue(sb, delimiter, data);
                    }
                    ++col;
                }
                writer.write(sb.toString());
                writer.write(Env.NL);
                ++row;
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(w)", e);
        }
        return false;
    }

    private void createCSVvalue(StringBuffer sb, char delimiter, String content) {
        if (content == null || content.length() == 0) {
            return;
        }
        boolean needMask = false;
        StringBuffer buff = new StringBuffer();
        char[] chars = content.toCharArray();
        int i2 = 0;
        while (i2 < chars.length) {
            char c = chars[i2];
            if (c == '\"') {
                needMask = true;
                buff.append(c);
            } else if (!(needMask || c != delimiter && Character.isLetterOrDigit(c))) {
                needMask = true;
            }
            buff.append(c);
            ++i2;
        }
        if (needMask) {
            sb.append('\"').append(buff).append('\"');
        } else {
            sb.append(buff);
        }
    }

    public boolean createXML(File file) {
        try {
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), Ini.getCharset());
            return this.createXML(new BufferedWriter(fw));
        }
        catch (FileNotFoundException fnfe) {
            log.log(Level.SEVERE, "(f) - " + fnfe.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", e);
        }
        return false;
    }

    public boolean createXML(Writer writer) {
        try {
            this.m_printData.createXML(new StreamResult(writer));
            writer.flush();
            writer.close();
            return true;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(w)", e);
            return false;
        }
    }

    public File getPDF() {
        return this.getPDF(null);
    }

    public File getPDF(File file) {
        try {
            if (file == null) {
                file = File.createTempFile("ReportEngine", ".pdf");
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "", e);
        }
        if (this.createPDF(file)) {
            return file;
        }
        return null;
    }

    public boolean createPDF(File file) {
        String fileName = null;
        URI uri = null;
        try {
            if (file == null) {
                file = File.createTempFile("ReportEngine", ".pdf");
            }
            fileName = file.getAbsolutePath();
            uri = file.toURI();
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "file", e);
            return false;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(uri.toString());
        }
        try {
            if (this.m_printFormat != null && this.m_printFormat.getJasperProcess_ID() > 0) {
                ProcessInfo pi = new ProcessInfo("", this.m_printFormat.getJasperProcess_ID(), this.m_printFormat.getAD_Table_ID(), this.m_info.getRecord_ID());
                pi.setIsBatch(true);
                pi.setPDFFileName(fileName);
                ServerProcessCtl.process(pi, this.m_trxName == null ? null : Trx.get(this.m_trxName, false));
            } else {
                if (this.m_layout == null) {
                    this.layout();
                }
                Document.getPDFAsFile(fileName, this.m_layout.getPageable(false));
                ArchiveEngine.get().archive(new File(fileName), this.m_info);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "PDF", e);
            return false;
        }
        File file2 = new File(fileName);
        if (log.isLoggable(Level.INFO)) {
            log.info(String.valueOf(file2.getAbsolutePath()) + " - " + file2.length());
        }
        return file2.exists();
    }

    public byte[] createPDFData() {
        try {
            if (this.m_layout == null) {
                this.layout();
            }
            return Document.getPDFAsArray(this.m_layout.getPageable(false));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "PDF", e);
            return null;
        }
    }

    public boolean createPS(File file) {
        try {
            return this.createPS(new FileOutputStream(file));
        }
        catch (FileNotFoundException fnfe) {
            log.log(Level.SEVERE, "(f) - " + fnfe.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", e);
        }
        return false;
    }

    public boolean createPS(OutputStream os) {
        StreamPrintServiceFactory[] spsfactories;
        block5: {
            String outputMimeType = DocFlavor.BYTE_ARRAY.POSTSCRIPT.getMimeType();
            DocFlavor.SERVICE_FORMATTED docFlavor = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
            spsfactories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(docFlavor, outputMimeType);
            if (spsfactories.length != 0) break block5;
            log.log(Level.SEVERE, "(fos) - No StreamPrintService");
            return false;
        }
        try {
            StreamPrintService sps = spsfactories[0].getPrintService(os);
            if (this.m_layout == null) {
                this.layout();
            }
            sps.createPrintJob().print(this.m_layout.getPageable(false), new HashPrintRequestAttributeSet());
            os.flush();
            if (os instanceof FileOutputStream) {
                ((FileOutputStream)os).close();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(fos)", e);
        }
        return false;
    }

    public void createXLS(File outFile, Language language) throws Exception {
        Boolean[] colSuppressRepeats = this.m_layout == null || this.m_layout.colSuppressRepeats == null ? LayoutEngine.getColSuppressRepeats(this.m_printFormat) : this.m_layout.colSuppressRepeats;
        PrintDataExcelExporter exp = new PrintDataExcelExporter(this.getPrintData(), this.getPrintFormat(), colSuppressRepeats);
        exp.export(outFile, language);
    }

    public static ReportEngine get(Properties ctx, ProcessInfo pi) {
        ResultSet rs;
        CPreparedStatement pstmt;
        StringBuilder sql;
        int Client_ID;
        boolean IsForm;
        int AD_PrintFormat_ID;
        String TableName;
        int AD_ReportView_ID;
        int AD_Table_ID;
        int AD_Client_ID;
        block19: {
            AD_Client_ID = pi.getAD_Client_ID();
            AD_Table_ID = 0;
            AD_ReportView_ID = 0;
            TableName = null;
            AD_PrintFormat_ID = 0;
            IsForm = false;
            Client_ID = -1;
            sql = new StringBuilder("SELECT rv.AD_ReportView_ID,rv.WhereClause,").append(" t.AD_Table_ID,t.TableName, pf.AD_PrintFormat_ID, pf.IsForm, pf.AD_Client_ID ").append("FROM AD_PInstance pi").append(" INNER JOIN AD_Process p ON (pi.AD_Process_ID=p.AD_Process_ID)").append(" INNER JOIN AD_ReportView rv ON (p.AD_ReportView_ID=rv.AD_ReportView_ID)").append(" INNER JOIN AD_Table t ON (rv.AD_Table_ID=t.AD_Table_ID)").append(" LEFT OUTER JOIN AD_PrintFormat pf ON (p.AD_ReportView_ID=pf.AD_ReportView_ID AND pf.AD_Client_ID IN (0,?) AND pf.IsActive='Y') ").append("WHERE pi.AD_PInstance_ID=? ").append("ORDER BY pf.AD_Client_ID DESC, pf.IsDefault DESC");
            pstmt = null;
            rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setInt(1, AD_Client_ID);
                    pstmt.setInt(2, pi.getAD_PInstance_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        AD_ReportView_ID = rs.getInt(1);
                        AD_Table_ID = rs.getInt(3);
                        TableName = rs.getString(4);
                        AD_PrintFormat_ID = rs.getInt(5);
                        IsForm = "Y".equals(rs.getString(6));
                        Client_ID = rs.getInt(7);
                    }
                }
                catch (SQLException e1) {
                    log.log(Level.SEVERE, "(1) - " + sql, e1);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block19;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (AD_ReportView_ID == 0) {
            block21: {
                sql = new StringBuilder("SELECT t.AD_Table_ID,t.TableName, pf.AD_PrintFormat_ID, pf.IsForm ").append("FROM AD_PInstance pi").append(" INNER JOIN AD_Process p ON (pi.AD_Process_ID=p.AD_Process_ID)").append(" INNER JOIN AD_PrintFormat pf ON (p.AD_PrintFormat_ID=pf.AD_PrintFormat_ID)").append(" INNER JOIN AD_Table t ON (pf.AD_Table_ID=t.AD_Table_ID) ").append("WHERE pi.AD_PInstance_ID=?");
                try {
                    try {
                        pstmt = DB.prepareStatement(sql.toString(), null);
                        pstmt.setInt(1, pi.getAD_PInstance_ID());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            AD_Table_ID = rs.getInt(1);
                            TableName = rs.getString(2);
                            AD_PrintFormat_ID = rs.getInt(3);
                            IsForm = "Y".equals(rs.getString(4));
                            Client_ID = AD_Client_ID;
                        }
                    }
                    catch (SQLException e1) {
                        log.log(Level.SEVERE, "(2) - " + sql, e1);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            if (AD_PrintFormat_ID == 0) {
                log.log(Level.SEVERE, "Report Info NOT found AD_PInstance_ID=" + pi.getAD_PInstance_ID() + ",AD_Client_ID=" + AD_Client_ID);
                return null;
            }
        }
        MQuery query = null;
        query = IsForm && pi.getRecord_ID() != 0 && !TableName.startsWith("T_") ? MQuery.getEqualQuery(String.valueOf(TableName) + "_ID", pi.getRecord_ID()) : MQuery.get(ctx, pi.getAD_PInstance_ID(), TableName);
        MPrintFormat format = null;
        Serializable so = pi.getSerializableObject();
        if (so instanceof MPrintFormat) {
            format = (MPrintFormat)so;
        }
        if (format == null && AD_PrintFormat_ID != 0) {
            format = Client_ID == AD_Client_ID ? MPrintFormat.get(ctx, AD_PrintFormat_ID, false) : MPrintFormat.copyToClient(ctx, AD_PrintFormat_ID, AD_Client_ID);
        }
        if (format != null && format.getItemCount() == 0) {
            if (log.isLoggable(Level.INFO)) {
                log.info("No Items - recreating:  " + format);
            }
            format.delete(true);
            format = null;
        }
        if (format == null && AD_ReportView_ID != 0) {
            format = MPrintFormat.createFromReportView(ctx, AD_ReportView_ID, pi.getTitle());
        }
        if (format == null) {
            return null;
        }
        format.setTranslationLanguage(format.getLanguage());
        PrintInfo info = new PrintInfo(pi);
        info.setAD_Table_ID(AD_Table_ID);
        return new ReportEngine(ctx, format, query, info, pi.isSummary(), pi.getTransactionName());
    }

    public static ReportEngine get(Properties ctx, int type, int Record_ID) {
        return ReportEngine.get(ctx, type, Record_ID, null);
    }

    public static ReportEngine get(Properties ctx, int type, int Record_ID, String trxName) {
        Language language;
        int copies;
        String DocumentNo;
        int C_BPartner_ID;
        int AD_PrintFormat_ID;
        block19: {
            int[] what;
            if (Record_ID < 1) {
                log.log(Level.WARNING, "No PrintFormat for Record_ID=" + Record_ID + ", Type=" + type);
                return null;
            }
            if (type == 0 && (what = ReportEngine.getDocumentWhat(Record_ID)) != null) {
                type = what[0];
                Record_ID = what[1];
            }
            AD_PrintFormat_ID = 0;
            C_BPartner_ID = 0;
            DocumentNo = null;
            copies = 1;
            MClient client = MClient.get(ctx);
            language = client.getLanguage();
            StringBuilder sql = null;
            sql = type == 6 ? new StringBuilder("SELECT bad.Check_PrintFormat_ID,").append("\tc.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,d.DocumentNo ").append("FROM C_PaySelectionCheck d").append(" INNER JOIN C_PaySelection ps ON (d.C_PaySelection_ID=ps.C_PaySelection_ID)").append(" INNER JOIN C_BankAccountDoc bad ON (ps.C_BankAccount_ID=bad.C_BankAccount_ID AND d.PaymentRule=bad.PaymentRule)").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) ").append("WHERE d.C_PaySelectionCheck_ID=?") : (type == 7 ? new StringBuilder("SELECT dl.Dunning_PrintFormat_ID,").append(" c.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,dr.DunningDate ").append("FROM C_DunningRunEntry d").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID)").append(" INNER JOIN C_DunningRun dr ON (d.C_DunningRun_ID=dr.C_DunningRun_ID)").append(" INNER JOIN C_DunningLevel dl ON (dl.C_DunningLevel_ID=d.C_DunningLevel_ID) ").append("WHERE d.C_DunningRunEntry_ID=?") : (type == 5 ? new StringBuilder("SELECT pf.Remittance_PrintFormat_ID,").append(" c.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,d.DocumentNo ").append("FROM C_PaySelectionCheck d").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID)").append(" INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) ").append("WHERE d.C_PaySelectionCheck_ID=?").append(" AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ORDER BY pf.AD_Org_ID DESC") : (type == 3 ? new StringBuilder("SELECT pf.Project_PrintFormat_ID,").append(" c.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,d.Value ").append("FROM C_Project d").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID)").append(" LEFT OUTER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) ").append("WHERE d.C_Project_ID=?").append(" AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ORDER BY pf.AD_Org_ID DESC") : (type == 8 ? new StringBuilder("SELECT pf.Manuf_Order_PrintFormat_ID,").append(" c.IsMultiLingualDocument,bp.AD_Language, 0 , d.DocumentNo ").append("FROM PP_Order d").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" LEFT OUTER JOIN AD_User u ON (u.AD_User_ID=d.Planner_ID)").append(" LEFT OUTER JOIN C_BPartner bp ON (u.C_BPartner_ID=bp.C_BPartner_ID) ").append(" INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID)").append("WHERE d.PP_Order_ID=?").append(" AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ORDER BY pf.AD_Org_ID DESC") : (type == 9 ? new StringBuilder("SELECT pf.Distrib_Order_PrintFormat_ID,").append(" c.IsMultiLingualDocument,bp.AD_Language, bp.C_BPartner_ID , d.DocumentNo ").append("FROM DD_Order d").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID)").append(" LEFT OUTER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID) ").append("WHERE d.DD_Order_ID=?").append(" AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ORDER BY pf.AD_Org_ID DESC") : (type == 4 ? new StringBuilder("SELECT COALESCE(t.AD_PrintFormat_ID, pf.AD_PrintFormat_ID),").append(" c.IsMultiLingualDocument,bp.AD_Language,bp.C_BPartner_ID,rr.Name ").append("FROM C_RfQResponse rr").append(" INNER JOIN C_RfQ r ON (rr.C_RfQ_ID=r.C_RfQ_ID)").append(" INNER JOIN C_RfQ_Topic t ON (r.C_RfQ_Topic_ID=t.C_RfQ_Topic_ID)").append(" INNER JOIN AD_Client c ON (rr.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN C_BPartner bp ON (rr.C_BPartner_ID=bp.C_BPartner_ID),").append(" AD_PrintFormat pf ").append("WHERE pf.AD_Client_ID IN (0,rr.AD_Client_ID)").append(" AND pf.AD_Table_ID=725 AND pf.IsTableBased='N'").append(" AND rr.C_RfQResponse_ID=? ").append("ORDER BY t.AD_PrintFormat_ID, pf.AD_Client_ID DESC, pf.AD_Org_ID DESC") : (type == 0 || type == 2 ? new StringBuilder("SELECT pf.Order_PrintFormat_ID,pf.Shipment_PrintFormat_ID,").append(" COALESCE (bp.Invoice_PrintFormat_ID,dt.AD_PrintFormat_ID,pf.Invoice_PrintFormat_ID),").append(" pf.Project_PrintFormat_ID, pf.Remittance_PrintFormat_ID,").append(" c.IsMultiLingualDocument, bp.AD_Language,").append(" COALESCE(dt.DocumentCopies,0)+COALESCE(bp.DocumentCopies,1), ").append(" dt.AD_PrintFormat_ID,bp.C_BPartner_ID,d.DocumentNo ").append("FROM " + DOC_BASETABLES[type] + " d").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID)").append(" INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID)").append(" LEFT OUTER JOIN C_DocType dt ON ((d.C_DocType_ID>0 AND d.C_DocType_ID=dt.C_DocType_ID) OR (d.C_DocType_ID=0 AND d.C_DocTypeTarget_ID=dt.C_DocType_ID)) ").append("WHERE d." + DOC_IDS[type] + "=?").append(" AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ").append("ORDER BY pf.AD_Org_ID DESC") : (type == 10 || type == 11 ? new StringBuilder("SELECT COALESCE (dt.AD_PrintFormat_ID, 0), 0,").append(" NULL, 0 , d.DocumentNo ").append("FROM " + DOC_BASETABLES[type] + " d").append(" LEFT OUTER JOIN C_DocType dt ON (d.C_DocType_ID=dt.C_DocType_ID) ").append("WHERE d." + DOC_IDS[type] + "=?") : new StringBuilder("SELECT pf.Order_PrintFormat_ID,pf.Shipment_PrintFormat_ID,").append(" COALESCE (bp.Invoice_PrintFormat_ID,dt.AD_PrintFormat_ID,pf.Invoice_PrintFormat_ID),").append(" pf.Project_PrintFormat_ID, pf.Remittance_PrintFormat_ID,").append(" c.IsMultiLingualDocument, bp.AD_Language,").append(" COALESCE(dt.DocumentCopies,0)+COALESCE(bp.DocumentCopies,1), ").append(" dt.AD_PrintFormat_ID,bp.C_BPartner_ID,d.DocumentNo, ").append(" pf.Manuf_Order_PrintFormat_ID, pf.Distrib_Order_PrintFormat_ID ").append("FROM " + DOC_BASETABLES[type] + " d").append(" INNER JOIN AD_Client c ON (d.AD_Client_ID=c.AD_Client_ID)").append(" INNER JOIN AD_PrintForm pf ON (c.AD_Client_ID=pf.AD_Client_ID)").append(" INNER JOIN C_BPartner bp ON (d.C_BPartner_ID=bp.C_BPartner_ID)").append(" LEFT OUTER JOIN C_DocType dt ON (d.C_DocType_ID=dt.C_DocType_ID) ").append("WHERE d." + DOC_IDS[type] + "=?").append(" AND pf.AD_Org_ID IN (0,d.AD_Org_ID) ").append("ORDER BY pf.AD_Org_ID DESC")))))))));
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), trxName);
                    pstmt.setInt(1, Record_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        String AD_Language;
                        if (type == 6 || type == 7 || type == 5 || type == 3 || type == 4 || type == 8 || type == 9 || type == 10 || type == 11) {
                            MProcess process;
                            AD_PrintFormat_ID = rs.getInt(1);
                            copies = 1;
                            AD_Language = rs.getString(3);
                            if (AD_Language != null) {
                                language = Language.getLanguage(AD_Language);
                            }
                            C_BPartner_ID = rs.getInt(4);
                            if (type == 7) {
                                Timestamp ts = rs.getTimestamp(5);
                                DocumentNo = ts.toString();
                            } else {
                                DocumentNo = rs.getString(5);
                            }
                            if (AD_PrintFormat_ID == 0 && type == 10) {
                                process = MProcess.get(ctx, 291);
                                AD_PrintFormat_ID = process.getAD_PrintFormat_ID();
                            }
                            if (AD_PrintFormat_ID == 0 && type == 11) {
                                process = MProcess.get(ctx, 290);
                                AD_PrintFormat_ID = process.getAD_PrintFormat_ID();
                            }
                        } else {
                            AD_PrintFormat_ID = rs.getInt(type + 1);
                            if (type != 2 && rs.getInt(9) != 0) {
                                AD_PrintFormat_ID = rs.getInt(9);
                            }
                            copies = rs.getInt(8);
                            AD_Language = rs.getString(7);
                            if (AD_Language != null) {
                                language = Language.getLanguage(AD_Language);
                            }
                            C_BPartner_ID = rs.getInt(10);
                            DocumentNo = rs.getString(11);
                        }
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Record_ID=" + Record_ID + ", SQL=" + sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block19;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (AD_PrintFormat_ID == 0) {
            log.log(Level.SEVERE, "No PrintFormat found for Type=" + type + ", Record_ID=" + Record_ID);
            return null;
        }
        MPrintFormat format = MPrintFormat.get(ctx, AD_PrintFormat_ID, false);
        format.setLanguage(language);
        format.setTranslationLanguage(language);
        MQuery query = new MQuery(format.getAD_Table_ID());
        query.addRestriction(DOC_IDS[type], "=", Record_ID);
        if (DocumentNo == null || DocumentNo.length() == 0) {
            DocumentNo = "DocPrint";
        }
        PrintInfo info = new PrintInfo(DocumentNo, DOC_TABLE_ID[type], Record_ID, C_BPartner_ID);
        info.setCopies(copies);
        info.setDocumentCopy(false);
        info.setPrinterName(format.getPrinterName());
        ReportEngine re = new ReportEngine(ctx, format, query, info, trxName);
        return re;
    }

    private static int[] getDocumentWhat(int C_Order_ID) {
        int[] what = new int[]{0, C_Order_ID};
        StringBuilder sql = new StringBuilder("SELECT dt.DocSubTypeSO ").append("FROM C_DocType dt, C_Order o ").append("WHERE o.C_DocType_ID=dt.C_DocType_ID").append(" AND o.C_Order_ID=?");
        String DocSubTypeSO = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), null);
                pstmt.setInt(1, C_Order_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    DocSubTypeSO = rs.getString(1);
                }
                if (DocSubTypeSO == null || "".equals(DocSubTypeSO)) {
                    sql = new StringBuilder("SELECT dt.DocSubTypeSO ").append("FROM C_DocType dt, C_Order o ").append("WHERE o.C_DocTypeTarget_ID=dt.C_DocType_ID").append(" AND o.C_Order_ID=?");
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setInt(1, C_Order_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        DocSubTypeSO = rs.getString(1);
                    }
                }
            }
            catch (SQLException e1) {
                log.log(Level.SEVERE, "(1) - " + sql, e1);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (DocSubTypeSO == null) {
            DocSubTypeSO = "";
        }
        if (DocSubTypeSO.equals("WR") || DocSubTypeSO.equals("WI")) {
            what[0] = 2;
        } else if (DocSubTypeSO.equals("WP")) {
            what[0] = 1;
        } else {
            return what;
        }
        sql = what[0] == 2 ? new StringBuilder("SELECT C_Invoice_ID REC FROM C_Invoice WHERE C_Order_ID=?").append(" ORDER BY C_Invoice_ID DESC") : new StringBuilder("SELECT M_InOut_ID REC FROM M_InOut WHERE C_Order_ID=?").append(" ORDER BY M_InOut_ID DESC");
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), null);
                pstmt.setInt(1, C_Order_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    what[1] = rs.getInt(1);
                } else {
                    what[0] = 0;
                }
            }
            catch (SQLException e2) {
                log.log(Level.SEVERE, "(2) - " + sql, e2);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Order => " + what[0] + " ID=" + what[1]);
        }
        return what;
    }

    public static void printConfirm(int type, int Record_ID) {
        int no;
        StringBuilder sql = new StringBuilder();
        if (type == 0 || type == 1 || type == 2) {
            sql.append("UPDATE ").append(DOC_BASETABLES[type]).append(" SET DatePrinted=SysDate, IsPrinted='Y' WHERE ").append(DOC_IDS[type]).append("=").append(Record_ID);
        }
        if (sql.length() > 0 && (no = DB.executeUpdate(sql.toString(), null)) != 1) {
            log.log(Level.SEVERE, "Updated records=" + no + " - should be just one");
        }
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment(true);
        int AD_Table_ID = 100;
        MQuery q = new MQuery("AD_Table");
        q.addRestriction("AD_Table_ID", "<", 108);
        MPrintFormat f = MPrintFormat.createFromTable(Env.getCtx(), AD_Table_ID);
        PrintInfo i2 = new PrintInfo("test", AD_Table_ID, 108, 0);
        i2.setAD_Table_ID(AD_Table_ID);
        ReportEngine re = new ReportEngine(Env.getCtx(), f, q, i2);
        re.layout();
        re.print();
        System.exit(0);
    }

    public void setWhereExtended(String whereExtended) {
        this.m_whereExtended = whereExtended;
    }

    public String getWhereExtended() {
        return this.m_whereExtended;
    }

    public void setWindowNo(int windowNo) {
        this.m_windowNo = windowNo;
    }

    public int getWindowNo() {
        return this.m_windowNo;
    }

    public void setSummary(boolean summary) {
        this.m_summary = summary;
    }

    public boolean isSummary() {
        return this.m_summary;
    }

    public void setLanguageID(int languageID) {
        this.m_language_id = languageID;
    }

    public int getLanguageID() {
        return this.m_language_id;
    }

    public void setReportType(String type) {
        this.reportType = type;
    }

    public String getReportType() {
        return this.reportType;
    }

    public void appendInlineCss(XhtmlDocument doc) {
        StringBuilder buildCssInline = new StringBuilder();
        for (Map.Entry<CSSInfo, List<ColumnInfo>> cssClassInfo : this.mapCssInfo.entrySet()) {
            int i2 = 0;
            while (i2 < cssClassInfo.getValue().size()) {
                if (i2 > 0) {
                    buildCssInline.append(",");
                }
                buildCssInline.append(cssClassInfo.getValue().get(i2).getCssSelector());
                ++i2;
            }
            buildCssInline.append(cssClassInfo.getKey().getCssRule());
            buildCssInline.append("\n");
        }
        this.appendInlineCss(doc, buildCssInline);
    }

    public void appendInlineCss(XhtmlDocument doc, StringBuilder buildCssInline) {
        if (buildCssInline.length() > 0) {
            buildCssInline.insert(0, "<style>");
            buildCssInline.append("</style>");
            doc.appendHead(buildCssInline.toString());
        }
    }

    public void addCssInfo(MPrintFormatItem formatItem, int index) {
        CSSInfo cadidateCss = new CSSInfo(formatItem);
        if (this.mapCssInfo.containsKey(cadidateCss)) {
            this.mapCssInfo.get(cadidateCss).add(new ColumnInfo(index, formatItem));
        } else {
            ArrayList<ColumnInfo> newColumnList = new ArrayList<ColumnInfo>();
            newColumnList.add(new ColumnInfo(index, formatItem));
            this.mapCssInfo.put(cadidateCss, newColumnList);
        }
    }

    public class CSSInfo {
        private Font font;
        private Color color;
        private String cssStr;

        public CSSInfo(MPrintFormatItem item) {
            MPrintFont mPrintFont = null;
            I_AD_PrintFormat m_printFormat = item.getAD_PrintFormat();
            if (item.getAD_PrintFont_ID() > 0) {
                mPrintFont = MPrintFont.get(item.getAD_PrintFont_ID());
            } else if (m_printFormat.getAD_PrintFont_ID() > 0) {
                mPrintFont = MPrintFont.get(m_printFormat.getAD_PrintFont_ID());
            }
            if (mPrintFont != null && mPrintFont.getAD_PrintFont_ID() > 0) {
                this.font = mPrintFont.getFont();
            }
            MPrintColor mPrintColor = null;
            if (item.getAD_PrintColor_ID() > 0) {
                mPrintColor = MPrintColor.get(ReportEngine.this.m_ctx, item.getAD_PrintColor_ID());
            } else if (m_printFormat.getAD_PrintColor_ID() > 0) {
                mPrintColor = MPrintColor.get(ReportEngine.this.m_ctx, m_printFormat.getAD_PrintColor_ID());
            }
            if (mPrintColor != null && mPrintColor.getAD_PrintColor_ID() > 0) {
                this.color = mPrintColor.getColor();
            }
        }

        public int hashCode() {
            return (this.color == null ? 0 : this.color.hashCode()) + (this.font == null ? 0 : this.font.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof CSSInfo) || obj.hashCode() != this.hashCode()) {
                return false;
            }
            CSSInfo compareObj = (CSSInfo)obj;
            return this.compareObj(compareObj.color, this.color) && this.compareObj(compareObj.font, this.font);
        }

        protected boolean compareObj(Object obj1, Object obj2) {
            if (obj1 == null && obj2 != null) {
                return false;
            }
            if (obj1 == null && obj2 == null) {
                return true;
            }
            return obj1.equals(obj2);
        }

        protected void addCssRule(StringBuilder cssBuild, String ruleName, String ruleValue) {
            cssBuild.append(ruleName);
            cssBuild.append(":");
            cssBuild.append(ruleValue);
            cssBuild.append(";");
        }

        public String getCssRule() {
            if (this.cssStr != null) {
                return this.cssStr;
            }
            StringBuilder cssBuild = new StringBuilder();
            cssBuild.append("{");
            if (this.font != null) {
                String fontFamily = this.font.getFamily();
                if ((fontFamily = ReportEngine.this.getCSSFontFamily(fontFamily)) != null) {
                    this.addCssRule(cssBuild, "font-family", fontFamily);
                }
                if (this.font.isBold()) {
                    this.addCssRule(cssBuild, "font-weight", "bold");
                }
                if (this.font.isItalic()) {
                    this.addCssRule(cssBuild, "font-style", "italic");
                }
                int size = this.font.getSize();
                this.addCssRule(cssBuild, "font-size", String.valueOf(size) + "pt");
            }
            if (this.color != null) {
                cssBuild.append("color:rgb(");
                cssBuild.append(this.color.getRed());
                cssBuild.append(",");
                cssBuild.append(this.color.getGreen());
                cssBuild.append(",");
                cssBuild.append(this.color.getBlue());
                cssBuild.append(");");
            }
            cssBuild.append("}");
            this.cssStr = cssBuild.toString();
            return this.cssStr;
        }
    }

    public static class ColumnInfo {
        protected static String CSS_SELECTOR_TEMPLATE = "table > tbody > tr > td:nth-child(%1$s)";
        int index = -1;

        public ColumnInfo(int index, MPrintFormatItem formatItem) {
            this.index = index;
        }

        public String getCssSelector() {
            return String.format(CSS_SELECTOR_TEMPLATE, this.index + 1);
        }
    }
}

