/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Properties;
import java.util.logging.Level;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUIFactory;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobPriority;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.compiere.print.MPrintFormat;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Msg;

public class PrintUtil {
    private static CLogger log = CLogger.getCLogger(PrintUtil.class);
    private static PrintRequestAttributeSet s_prats = new HashPrintRequestAttributeSet();

    public static PrintRequestAttributeSet getDefaultPrintRequestAttributes() {
        return s_prats;
    }

    public static DocFlavor getDefaultFlavor() {
        return DocFlavor.SERVICE_FORMATTED.PAGEABLE;
    }

    public static PrintService[] getAllPrintServices() {
        return PrintServiceLookup.lookupPrintServices(null, null);
    }

    public static PrintService[] getPrintServices() {
        return PrintServiceLookup.lookupPrintServices(PrintUtil.getDefaultFlavor(), PrintUtil.getDefaultPrintRequestAttributes());
    }

    public static PrintService getDefaultPrintService() {
        return PrintServiceLookup.lookupDefaultPrintService();
    }

    public static PrinterJob getPrinterJob() {
        return PrintUtil.getPrinterJob(Ini.getProperty("Printer"));
    }

    public static PrinterJob getPrinterJob(String printerName) {
        PrinterJob pj = null;
        PrintService ps = null;
        try {
            PrintService psUsed;
            pj = PrinterJob.getPrinterJob();
            if (printerName == null || printerName.length() == 0) {
                printerName = Ini.getProperty("Printer");
            }
            if (printerName != null && printerName.length() != 0) {
                PrintService[] services = PrintUtil.getAllPrintServices();
                int i2 = 0;
                while (i2 < services.length) {
                    String serviceName = services[i2].getName();
                    if (printerName.equals(serviceName)) {
                        ps = services[i2];
                        break;
                    }
                    ++i2;
                }
            }
            try {
                if (ps != null) {
                    pj.setPrintService(ps);
                }
            }
            catch (Exception e) {
                log.warning("Could not set Print Service: " + e.toString());
            }
            if ((psUsed = pj.getPrintService()) == null) {
                log.warning("Print Service not Found");
            } else {
                String serviceName = psUsed.getName();
                if (printerName != null && !printerName.equals(serviceName)) {
                    log.warning("Not found: " + printerName + " - Used: " + serviceName);
                }
            }
        }
        catch (Exception e) {
            log.warning("Could not create for " + printerName + ": " + e.toString());
        }
        return pj;
    }

    public static void print(Pageable pageable, String printerName, String jobName, int copies, boolean withDialog) {
        if (pageable == null) {
            return;
        }
        String name = "Adempiere_";
        if (jobName != null) {
            name = String.valueOf(name) + jobName;
        }
        PrinterJob job = PrintUtil.getPrinterJob(printerName);
        job.setJobName(name);
        job.setPageable(pageable);
        HashPrintRequestAttributeSet prats = new HashPrintRequestAttributeSet();
        prats.add(new Copies(copies));
        if (pageable.getPageFormat(0).getOrientation() == 1) {
            prats.add(OrientationRequested.PORTRAIT);
        } else {
            prats.add(OrientationRequested.LANDSCAPE);
        }
        prats.add(new JobName(name, Language.getLoginLanguage().getLocale()));
        prats.add(PrintUtil.getJobPriority(pageable.getNumberOfPages(), copies, withDialog));
        PrintUtil.print(job, prats, withDialog, false);
    }

    public static void print(Pageable pageable, PrintRequestAttributeSet prats) {
        PrinterJob job = PrintUtil.getPrinterJob();
        job.setPageable(pageable);
        PrintUtil.print(job, prats, true, false);
    }

    public static void print(final PrinterJob job, final PrintRequestAttributeSet prats, boolean withDialog, boolean waitForIt) {
        if (job == null) {
            return;
        }
        boolean printed = true;
        if (withDialog) {
            printed = job.printDialog(prats);
        }
        if (printed) {
            if (withDialog) {
                Attribute[] atts = prats.toArray();
                int i2 = 0;
                while (i2 < atts.length) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(String.valueOf(atts[i2].getName()) + "=" + atts[i2]);
                    }
                    ++i2;
                }
            }
            if (waitForIt) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("(wait) " + job.getPrintService());
                }
                try {
                    job.print(prats);
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "(wait)", ex);
                }
            } else {
                Thread printThread = new Thread(){

                    @Override
                    public void run() {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("print: " + job.getPrintService());
                        }
                        try {
                            job.print(prats);
                        }
                        catch (Exception ex) {
                            log.log(Level.SEVERE, "print", ex);
                        }
                    }
                };
                printThread.start();
            }
        }
    }

    public static JobPriority getJobPriority(int pages, int copies, boolean withDialog) {
        int priority = copies * pages;
        if (withDialog) {
            priority *= 2;
        }
        if ((priority = 100 - priority) < 10) {
            priority = 10;
        } else if (priority > 100) {
            priority = 100;
        }
        return new JobPriority(priority);
    }

    public static void dump(PrinterJob job) {
        StringBuilder sb = new StringBuilder(job.getJobName());
        sb.append("/").append(job.getUserName()).append(" Service=").append(job.getPrintService().getName()).append(" Copies=").append(job.getCopies());
        PageFormat pf = job.defaultPage();
        sb.append(" DefaultPage ").append("x=").append(pf.getImageableX()).append(",y=").append(pf.getImageableY()).append(" w=").append(pf.getImageableWidth()).append(",h=").append(pf.getImageableHeight());
        System.out.println(sb.toString());
    }

    public static void dump(PrintServiceAttributeSet psas) {
        System.out.println("PrintServiceAttributeSet - length=" + psas.size());
        Attribute[] ats = psas.toArray();
        int i2 = 0;
        while (i2 < ats.length) {
            System.out.println(String.valueOf(ats[i2].getName()) + " = " + ats[i2] + "  (" + ats[i2].getCategory() + ")");
            ++i2;
        }
    }

    public static void dump(PrintRequestAttributeSet prats) {
        System.out.println("PrintRequestAttributeSet - length=" + prats.size());
        Attribute[] ats = prats.toArray();
        int i2 = 0;
        while (i2 < ats.length) {
            System.out.println(String.valueOf(ats[i2].getName()) + " = " + ats[i2] + "  (" + ats[i2].getCategory() + ")");
            ++i2;
        }
    }

    public static void dump(DocFlavor docFlavor, String outputMimeType) {
        System.out.println();
        System.out.println("DocFlavor=" + docFlavor + ", Output=" + outputMimeType);
        StreamPrintServiceFactory[] spsfactories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(docFlavor, outputMimeType);
        int i2 = 0;
        while (i2 < spsfactories.length) {
            System.out.println("- " + spsfactories[i2]);
            DocFlavor[] dfs = spsfactories[i2].getSupportedDocFlavors();
            int j = 0;
            while (j < dfs.length) {
                System.out.println("   -> " + dfs[j]);
                ++j;
            }
            ++i2;
        }
    }

    public static void dump(DocFlavor docFlavor) {
        System.out.println();
        System.out.println("DocFlavor=" + docFlavor);
        HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
        PrintService[] pss = PrintServiceLookup.lookupPrintServices(docFlavor, pras);
        int i2 = 0;
        while (i2 < pss.length) {
            PrintService ps = pss[i2];
            System.out.println("- " + ps);
            System.out.println("  Factory=" + ps.getServiceUIFactory());
            ServiceUIFactory uiF = pss[i2].getServiceUIFactory();
            if (uiF != null) {
                System.out.println("about");
                JDialog about = (JDialog)uiF.getUI(1, "javax.swing.JDialog");
                about.setVisible(true);
                System.out.println("admin");
                JDialog admin = (JDialog)uiF.getUI(2, "javax.swing.JDialog");
                admin.setVisible(true);
                System.out.println("main");
                JDialog main = (JDialog)uiF.getUI(3, "javax.swing.JDialog");
                main.setVisible(true);
                System.out.println("reserved");
                JDialog res = (JDialog)uiF.getUI(99, "javax.swing.JDialog");
                res.setVisible(true);
            }
            DocFlavor[] dfs = pss[i2].getSupportedDocFlavors();
            System.out.println("  - Supported Doc Flavors");
            int j = 0;
            while (j < dfs.length) {
                System.out.println("    -> " + dfs[j]);
                ++j;
            }
            Class<?>[] attCat = pss[i2].getSupportedAttributeCategories();
            System.out.println("  - Supported Attribute Categories");
            int j2 = 0;
            while (j2 < attCat.length) {
                System.out.println("    -> " + attCat[j2].getName() + " = " + pss[i2].getDefaultAttributeValue(attCat[j2]));
                ++j2;
            }
            ++i2;
        }
    }

    private static void testPS() {
        PrintService ps = PrintUtil.getDefaultPrintService();
        ServiceUIFactory factory = ps.getServiceUIFactory();
        System.out.println(factory);
        if (factory != null) {
            System.out.println("Factory");
            JPanel p0 = (JPanel)factory.getUI(1, "javax.swing.JDialog");
            p0.setVisible(true);
            JPanel p1 = (JPanel)factory.getUI(2, "javax.swing.JDialog");
            p1.setVisible(true);
            JPanel p2 = (JPanel)factory.getUI(3, "javax.swing.JDialog");
            p2.setVisible(true);
        }
        System.out.println("1----------");
        PrinterJob pj = PrinterJob.getPrinterJob();
        PrintRequestAttributeSet pratts = PrintUtil.getDefaultPrintRequestAttributes();
        PageFormat pf = pj.pageDialog(pratts);
        System.out.println("Pratts Size = " + pratts.size());
        Attribute[] atts = pratts.toArray();
        int i2 = 0;
        while (i2 < atts.length) {
            System.out.println(String.valueOf(atts[i2].getName()) + " = " + atts[i2] + " - " + atts[i2].getCategory());
            ++i2;
        }
        System.out.println("PageFormat h=" + pf.getHeight() + ",w=" + pf.getWidth() + " - x=" + pf.getImageableX() + ",y=" + pf.getImageableY() + " - ih=" + pf.getImageableHeight() + ",iw=" + pf.getImageableWidth() + " - Orient=" + pf.getOrientation());
        ps = pj.getPrintService();
        System.out.println("PrintService = " + ps.getName());
        System.out.println("2----------");
        pj.printDialog(pratts);
        System.out.println("Pratts Size = " + pratts.size());
        atts = pratts.toArray();
        i2 = 0;
        while (i2 < atts.length) {
            System.out.println(String.valueOf(atts[i2].getName()) + " = " + atts[i2] + " - " + atts[i2].getCategory());
            ++i2;
        }
        pf = pj.defaultPage();
        System.out.println("PageFormat h=" + pf.getHeight() + ",w=" + pf.getWidth() + " - x=" + pf.getImageableX() + ",y=" + pf.getImageableY() + " - ih=" + pf.getImageableHeight() + ",iw=" + pf.getImageableWidth() + " - Orient=" + pf.getOrientation());
        ps = pj.getPrintService();
        System.out.println("PrintService= " + ps.getName());
        System.out.println("3----------");
        try {
            pj.setPrintService(ps);
        }
        catch (PrinterException pe) {
            System.out.println(pe);
        }
        pf = pj.validatePage(pf);
        System.out.println("PageFormat h=" + pf.getHeight() + ",w=" + pf.getWidth() + " - x=" + pf.getImageableX() + ",y=" + pf.getImageableY() + " - ih=" + pf.getImageableHeight() + ",iw=" + pf.getImageableWidth() + " - Orient=" + pf.getOrientation());
        ps = pj.getPrintService();
        System.out.println("PrintService= " + ps.getName());
        System.out.println("4----------");
        pj.printDialog();
    }

    public static void setupPrintForm(int AD_Client_ID) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("AD_Client_ID=" + AD_Client_ID);
        }
        Properties ctx = Env.getCtx();
        CLogMgt.enable(false);
        int Order_PrintFormat_ID = MPrintFormat.copyToClient(ctx, 100, AD_Client_ID).get_ID();
        int OrderLine_PrintFormat_ID = MPrintFormat.copyToClient(ctx, 101, AD_Client_ID).get_ID();
        PrintUtil.updatePrintFormatHeader(Order_PrintFormat_ID, OrderLine_PrintFormat_ID);
        int Invoice_PrintFormat_ID = MPrintFormat.copyToClient(ctx, 102, AD_Client_ID).get_ID();
        int InvoiceLine_PrintFormat_ID = MPrintFormat.copyToClient(ctx, 103, AD_Client_ID).get_ID();
        PrintUtil.updatePrintFormatHeader(Invoice_PrintFormat_ID, InvoiceLine_PrintFormat_ID);
        int Shipment_PrintFormat_ID = MPrintFormat.copyToClient(ctx, 104, AD_Client_ID).get_ID();
        int ShipmentLine_PrintFormat_ID = MPrintFormat.copyToClient(ctx, 105, AD_Client_ID).get_ID();
        PrintUtil.updatePrintFormatHeader(Shipment_PrintFormat_ID, ShipmentLine_PrintFormat_ID);
        int Check_PrintFormat_ID = MPrintFormat.copyToClient(ctx, 106, AD_Client_ID).get_ID();
        int RemittanceLine_PrintFormat_ID = MPrintFormat.copyToClient(ctx, 107, AD_Client_ID).get_ID();
        PrintUtil.updatePrintFormatHeader(Check_PrintFormat_ID, RemittanceLine_PrintFormat_ID);
        int Remittance_PrintFormat_ID = MPrintFormat.copyToClient(ctx, 108, AD_Client_ID).get_ID();
        PrintUtil.updatePrintFormatHeader(Remittance_PrintFormat_ID, RemittanceLine_PrintFormat_ID);
        int AD_PrintForm_ID = DB.getNextID(AD_Client_ID, "AD_PrintForm", null);
        String sql = "INSERT INTO AD_PrintForm(AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,AD_PrintForm_ID,Name,Order_PrintFormat_ID,Invoice_PrintFormat_ID,Remittance_PrintFormat_ID,Shipment_PrintFormat_ID) VALUES (" + AD_Client_ID + ",0,'Y',SysDate,0,SysDate,0," + AD_PrintForm_ID + "," + "'" + Msg.translate(ctx, "Standard") + "'," + Order_PrintFormat_ID + "," + Invoice_PrintFormat_ID + "," + Remittance_PrintFormat_ID + "," + Shipment_PrintFormat_ID + ")";
        int no = DB.executeUpdate(sql, null);
        if (no != 1) {
            log.log(Level.SEVERE, "PrintForm NOT inserted");
        }
        CLogMgt.enable(true);
    }

    private static void updatePrintFormatHeader(int Header_ID, int Line_ID) {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE AD_PrintFormatItem SET AD_PrintFormatChild_ID=").append(Line_ID).append(" WHERE AD_PrintFormatChild_ID IS NOT NULL AND AD_PrintFormat_ID=").append(Header_ID);
        int no = DB.executeUpdate(sb.toString(), null);
    }

    public static void main(String[] args) {
        PrintUtil.testPS();
    }
}

