/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import org.compiere.print.PrintDataFunction;

public class PrintDataGroup {
    public static final String DELIMITER = "~";
    public static final String TOTAL = "=TOTAL=";
    private static final Object NULL = new String();
    private ArrayList<String> m_groups = new ArrayList();
    private HashMap<String, Object> m_groupMap = new HashMap();
    private ArrayList<String> m_functions = new ArrayList();
    private HashMap<String, PrintDataFunction> m_groupFunction = new HashMap();

    public void addGroupColumn(String groupColumnName) {
        this.m_groups.add(groupColumnName);
    }

    public int getGroupColumnCount() {
        return this.m_groups.size();
    }

    public boolean isGroupColumn(String columnName) {
        if (columnName == null || this.m_groups.size() == 0) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.m_groups.size()) {
            if (columnName.equals(this.m_groups.get(i2))) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public Object groupChange(String groupColumnName, Object value, boolean force) {
        if (!this.isGroupColumn(groupColumnName)) {
            return null;
        }
        Object newValue = value;
        if (newValue == null) {
            newValue = NULL;
        }
        if (this.m_groupMap.containsKey(groupColumnName)) {
            Object oldValue = this.m_groupMap.get(groupColumnName);
            if (newValue.equals(oldValue) && !force) {
                return null;
            }
            this.m_groupMap.put(groupColumnName, newValue);
            return oldValue;
        }
        this.m_groupMap.put(groupColumnName, newValue);
        return null;
    }

    public void addFunction(String functionColumnName, char function) {
        this.m_functions.add(String.valueOf(functionColumnName) + DELIMITER + function);
        if (!this.m_groups.contains(TOTAL)) {
            this.m_groups.add(TOTAL);
        }
    }

    public boolean isFunctionColumn(String columnName) {
        if (columnName == null || this.m_functions.size() == 0) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.m_functions.size()) {
            String f = this.m_functions.get(i2);
            if (f.startsWith(columnName)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public char[] getFunctions(String columnName) {
        int i2;
        ArrayList<String> list = new ArrayList<String>();
        for (String group_function : this.m_groupFunction.keySet()) {
            if (!group_function.startsWith(columnName)) continue;
            group_function = group_function.substring(group_function.lastIndexOf(DELIMITER) + 1);
            i2 = 0;
            while (i2 < this.m_functions.size()) {
                String function;
                String col_function = this.m_functions.get(i2);
                if (col_function.startsWith(group_function) && !list.contains(function = col_function.substring(col_function.lastIndexOf(DELIMITER) + 1))) {
                    list.add(function);
                }
                ++i2;
            }
        }
        char[] retValue = new char[list.size()];
        i2 = 0;
        while (i2 < retValue.length) {
            retValue[i2] = ((String)list.get(i2)).charAt(0);
            ++i2;
        }
        return retValue;
    }

    public boolean isFunctionColumn(String columnName, char function) {
        if (columnName == null || this.m_functions.size() == 0) {
            return false;
        }
        String key = String.valueOf(columnName) + DELIMITER + function;
        int i2 = 0;
        while (i2 < this.m_functions.size()) {
            String f = this.m_functions.get(i2);
            if (f.equals(key)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public void addValue(String functionColumnName, BigDecimal functionValue) {
        if (!this.isFunctionColumn(functionColumnName)) {
            return;
        }
        int i2 = 0;
        while (i2 < this.m_groups.size()) {
            String groupColumnName = this.m_groups.get(i2);
            String key = String.valueOf(groupColumnName) + DELIMITER + functionColumnName;
            PrintDataFunction pdf = this.m_groupFunction.get(key);
            if (pdf == null) {
                pdf = new PrintDataFunction();
            }
            pdf.addValue(functionValue);
            this.m_groupFunction.put(key, pdf);
            ++i2;
        }
    }

    public BigDecimal getValue(String groupColumnName, String functionColumnName, char function) {
        String key = String.valueOf(groupColumnName) + DELIMITER + functionColumnName;
        PrintDataFunction pdf = this.m_groupFunction.get(key);
        if (pdf == null) {
            return null;
        }
        return pdf.getValue(function);
    }

    public void reset(String groupColumnName, String functionColumnName) {
        String key = String.valueOf(groupColumnName) + DELIMITER + functionColumnName;
        PrintDataFunction pdf = this.m_groupFunction.get(key);
        if (pdf != null) {
            pdf.reset();
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean withData) {
        Object value;
        StringBuilder sb = new StringBuilder("PrintDataGroup[");
        sb.append("Groups=");
        int i2 = 0;
        while (i2 < this.m_groups.size()) {
            if (i2 != 0) {
                sb.append(",");
            }
            sb.append(this.m_groups.get(i2));
            ++i2;
        }
        if (withData) {
            for (String key : this.m_groupMap.keySet()) {
                value = this.m_groupMap.get(key);
                sb.append(":").append((Object)key).append("=").append(value);
            }
        }
        sb.append(";Functions=");
        i = 0;
        while (i < this.m_functions.size()) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(this.m_functions.get(i));
            ++i;
        }
        if (withData) {
            for (String key : this.m_groupFunction.keySet()) {
                value = this.m_groupFunction.get(key);
                sb.append(":").append((Object)key).append("=").append(value);
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

