/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.Adempiere;
import org.compiere.model.PO;
import org.compiere.model.X_AD_PrintPaper;
import org.compiere.print.CPaper;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Language;

public class MPrintPaper
extends X_AD_PrintPaper {
    private static final long serialVersionUID = -3609557177958141344L;
    private static CLogger s_log = CLogger.getCLogger(MPrintPaper.class);
    private static CCache<Integer, MPrintPaper> s_papers = new CCache("AD_PrintPaper", 5);
    private MediaSize m_mediaSize = null;

    public static MPrintPaper get(int AD_PrintPaper_ID) {
        Integer key = AD_PrintPaper_ID;
        MPrintPaper pp = s_papers.get(key);
        if (pp == null) {
            pp = new MPrintPaper(Env.getCtx(), AD_PrintPaper_ID, null);
            s_papers.put(key, pp);
        } else if (s_log.isLoggable(Level.CONFIG)) {
            s_log.config("AD_PrintPaper_ID=" + AD_PrintPaper_ID);
        }
        return pp;
    }

    static MPrintPaper create(String name, boolean landscape) {
        MPrintPaper pp = new MPrintPaper(Env.getCtx(), 0, null);
        pp.setName(name);
        pp.setIsLandscape(landscape);
        pp.saveEx();
        return pp;
    }

    public MPrintPaper(Properties ctx, int AD_PrintPaper_ID, String trxName) {
        super(ctx, AD_PrintPaper_ID, trxName);
        if (AD_PrintPaper_ID == 0) {
            this.setIsDefault(false);
            this.setIsLandscape(true);
            this.setCode("iso-a4");
            this.setMarginTop(36);
            this.setMarginBottom(36);
            this.setMarginLeft(36);
            this.setMarginRight(36);
        }
    }

    public MPrintPaper(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MediaSize getMediaSize() {
        if (this.m_mediaSize != null) {
            return this.m_mediaSize;
        }
        String nameCode = this.getCode();
        if (nameCode != null) {
            MediaSizeName nameMedia = null;
            CMediaSizeName msn = new CMediaSizeName(4);
            String[] names = msn.getStringTable();
            int i2 = 0;
            while (i2 < names.length) {
                String name = names[i2];
                if (name.equalsIgnoreCase(nameCode)) {
                    nameMedia = (MediaSizeName)msn.getEnumValueTable()[i2];
                    if (!this.log.isLoggable(Level.FINER)) break;
                    this.log.finer("Name=" + nameMedia);
                    break;
                }
                ++i2;
            }
            if (nameMedia != null) {
                this.m_mediaSize = MediaSize.getMediaSizeForName(nameMedia);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Name->Size=" + this.m_mediaSize);
                }
            }
        }
        if (this.m_mediaSize == null) {
            float x = this.getSizeX().floatValue();
            float y = this.getSizeY().floatValue();
            if (x > 0.0f && y > 0.0f) {
                this.m_mediaSize = new MediaSize(x, y, this.getUnitsInt(), MediaSizeName.A);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Size=" + this.m_mediaSize);
                }
            }
        }
        if (this.m_mediaSize == null) {
            this.m_mediaSize = this.getMediaSizeDefault();
        }
        return this.m_mediaSize;
    }

    public MediaSize getMediaSizeDefault() {
        this.m_mediaSize = Language.getLoginLanguage().getMediaSize();
        if (this.m_mediaSize == null) {
            this.m_mediaSize = MediaSize.ISO.A4;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Size=" + this.m_mediaSize);
        }
        return this.m_mediaSize;
    }

    public int getUnitsInt() {
        String du = this.getDimensionUnits();
        if (du == null || "M".equals(du)) {
            return 1000;
        }
        if ("I".equals(du)) {
            return 25400;
        }
        throw new AdempiereException("@NotSupported@ @DimensionUnit@ : " + du);
    }

    public CPaper getCPaper() {
        CPaper retValue = this.getCode().toLowerCase().startsWith("custom") ? new CPaper(this.getSizeX().doubleValue(), this.getSizeY().doubleValue(), this.getUnitsInt(), this.isLandscape(), this.getMarginLeft(), this.getMarginTop(), this.getMarginRight(), this.getMarginBottom()) : new CPaper(this.getMediaSize(), this.isLandscape(), this.getMarginLeft(), this.getMarginTop(), this.getMarginRight(), this.getMarginBottom());
        return retValue;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        this.m_mediaSize = null;
        this.getMediaSize();
        this.getCPaper();
        return true;
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment(true);
        int[] IDs = PO.getAllIDs("AD_PrintPaper", null, null);
        int i2 = 0;
        while (i2 < IDs.length) {
            System.out.println("--");
            MPrintPaper pp = new MPrintPaper(Env.getCtx(), IDs[i2], null);
            pp.dump();
            ++i2;
        }
    }

    static class CMediaSizeName
    extends MediaSizeName {
        private static final long serialVersionUID = 8561532175435930293L;

        public CMediaSizeName(int code) {
            super(code);
        }

        @Override
        public String[] getStringTable() {
            return super.getStringTable();
        }

        @Override
        public EnumSyntax[] getEnumValueTable() {
            return super.getEnumValueTable();
        }
    }
}

