/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class TranslationTable {
    private static Integer s_activeLanguages = null;
    private static CCache<String, TranslationTable> s_cache = new CCache(null, "TranslationTable", 20, true);
    private static CLogger log = CLogger.getCLogger(TranslationTable.class);
    private String m_trlTableName = null;
    private String m_baseTableName = null;
    private ArrayList<String> m_columns = new ArrayList();

    public static boolean save(PO po, boolean newRecord) {
        if (!TranslationTable.isActiveLanguages(false)) {
            return true;
        }
        TranslationTable table2 = TranslationTable.get(po.get_TableName());
        if (newRecord) {
            return table2.createTranslation(po);
        }
        return table2.resetTranslationFlag(po);
    }

    public static boolean delete(PO po) {
        if (!TranslationTable.isActiveLanguages(false)) {
            return true;
        }
        TranslationTable table2 = TranslationTable.get(po.get_TableName());
        return table2.deleteTranslation(po);
    }

    public static synchronized int getActiveLanguages(boolean requery) {
        if (s_activeLanguages != null && !requery) {
            return s_activeLanguages;
        }
        int no = DB.getSQLValue(null, "SELECT COUNT(*) FROM AD_Language WHERE IsActive='Y' AND IsSystemLanguage='Y'");
        s_activeLanguages = no;
        return s_activeLanguages;
    }

    public static boolean isActiveLanguages(boolean requery) {
        int no = TranslationTable.getActiveLanguages(requery);
        return no > 0;
    }

    public static TranslationTable get(String baseTableName) {
        TranslationTable retValue = s_cache.get(baseTableName);
        if (retValue != null) {
            return retValue;
        }
        retValue = new TranslationTable(baseTableName);
        s_cache.put(baseTableName, retValue);
        return retValue;
    }

    protected TranslationTable(String baseTableName) {
        if (baseTableName == null) {
            throw new IllegalArgumentException("Base Table Name is null");
        }
        this.m_baseTableName = baseTableName;
        this.m_trlTableName = String.valueOf(baseTableName) + "_Trl";
        this.initColumns();
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.toString());
        }
    }

    private void initColumns() {
        MTable table2 = MTable.get(Env.getCtx(), this.m_trlTableName);
        if (table2 == null) {
            throw new IllegalArgumentException("Table Not found=" + this.m_trlTableName);
        }
        MColumn[] columns = table2.getColumns(false);
        int i2 = 0;
        while (i2 < columns.length) {
            String columnName;
            MColumn column = columns[i2];
            if (!(column.isStandardColumn() || (columnName = column.getColumnName()).endsWith("_ID") || columnName.startsWith("AD_Language") || columnName.equals("IsTranslated"))) {
                this.m_columns.add(columnName);
            }
            ++i2;
        }
        if (this.m_columns.size() == 0) {
            throw new IllegalArgumentException("No Columns found=" + this.m_trlTableName);
        }
    }

    public boolean createTranslation(PO po) {
        if (!TranslationTable.isActiveLanguages(false)) {
            return true;
        }
        if (po.get_ID() == 0) {
            throw new IllegalArgumentException("PO ID is 0");
        }
        StringBuffer sql1 = new StringBuffer();
        sql1.append("INSERT INTO ").append(this.m_trlTableName).append(" (");
        StringBuffer sql2 = new StringBuffer();
        sql2.append(") SELECT ");
        sql1.append(this.m_baseTableName).append("_ID,AD_Language");
        sql2.append("b.").append(this.m_baseTableName).append("_ID,l.AD_Language");
        sql1.append(", AD_Client_ID,AD_Org_ID,IsActive, Created,CreatedBy,Updated,UpdatedBy, IsTranslated");
        sql2.append(", b.AD_Client_ID,b.AD_Org_ID,b.IsActive, b.Created,b.CreatedBy,b.Updated,b.UpdatedBy, 'N'");
        int i2 = 0;
        while (i2 < this.m_columns.size()) {
            String columnName = this.m_columns.get(i2);
            Object value = po.get_Value(columnName);
            if (value != null) {
                sql1.append(",").append(columnName);
                sql2.append(",b.").append(columnName);
            }
            ++i2;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(sql1).append(sql2).append(" FROM AD_Language l, " + this.m_baseTableName + " b WHERE l.IsActive = 'Y' AND l.IsSystemLanguage = 'Y' AND b." + this.m_baseTableName + "_ID=").append(po.get_ID());
        int no = DB.executeUpdate(sql.toString(), po.get_TrxName());
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(this.m_trlTableName) + ": ID=" + po.get_ID() + " #" + no);
        }
        return no != 0;
    }

    public boolean resetTranslationFlag(PO po) {
        if (!TranslationTable.isActiveLanguages(false)) {
            return true;
        }
        if (po.get_ID() == 0) {
            throw new IllegalArgumentException("PO ID is 0");
        }
        StringBuilder sb = new StringBuilder("UPDATE ");
        sb.append(this.m_trlTableName).append(" SET IsTranslated='N',Updated=SysDate WHERE ").append(this.m_baseTableName).append("_ID=").append(po.get_ID());
        int no = DB.executeUpdate(sb.toString(), po.get_TrxName());
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(this.m_trlTableName) + ": ID=" + po.get_ID() + " #" + no);
        }
        return no != 0;
    }

    public boolean deleteTranslation(PO po) {
        if (!TranslationTable.isActiveLanguages(false)) {
            return true;
        }
        if (po.get_IDOld() == 0) {
            throw new IllegalArgumentException("PO Old ID is 0");
        }
        StringBuilder sb = new StringBuilder("DELETE  FROM  ");
        sb.append(this.m_trlTableName).append(" WHERE ").append(this.m_baseTableName).append("_ID=").append(po.get_IDOld());
        int no = DB.executeUpdate(sb.toString(), po.get_TrxName());
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(this.m_trlTableName) + ": ID=" + po.get_IDOld() + " #" + no);
        }
        return no != 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TranslationTable[");
        sb.append(this.m_trlTableName).append("(").append(this.m_baseTableName).append(")");
        int i2 = 0;
        while (i2 < this.m_columns.size()) {
            sb.append("-").append(this.m_columns.get(i2));
            ++i2;
        }
        sb.append("]");
        return sb.toString();
    }
}

