/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import org.compiere.model.MClient;
import org.compiere.model.MOpportunity;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;

public class SalesMgmtValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(SalesMgmtValidator.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Order", this);
        engine.addModelChange("C_OrderLine", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        if (po == null) {
            return null;
        }
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (po.get_TableName().equals("C_Order") && (type == 4 || type == 5)) {
            MOrder order = (MOrder)po;
            this.syncOpportunity(order);
        }
        if (po.get_TableName().equals("C_OrderLine") && (type == 4 || type == 5)) {
            MOrderLine line = (MOrderLine)po;
            MOrder order = (MOrder)line.getC_Order();
            this.syncOpportunity(order);
        }
        return null;
    }

    private void syncOpportunity(MOrder order) {
        int opId = order.get_ValueAsInt("C_Opportunity_ID");
        if (opId > 0) {
            MOpportunity op = new MOpportunity(order.getCtx(), opId, order.get_TrxName());
            if (op != null && op.getC_Order_ID() == order.getC_Order_ID()) {
                op.setOpportunityAmt(order.getGrandTotal());
            }
            op.saveEx();
        }
    }

    @Override
    public String docValidate(PO po, int timing) {
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SalesMgmtValidator");
        return sb.toString();
    }
}

