/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class PO_Record {
    private static int[] s_parents = new int[]{259, 855};
    private static String[] s_parentNames = new String[]{"C_Order", "CM_Container"};
    private static int[] s_parentChilds = new int[]{260, 860};
    private static String[] s_parentChildNames = new String[]{"C_OrderLine", "CM_Container_Element"};
    private static int[] s_cascades = new int[]{254, 754, 900, 389, 200000, 200215};
    private static String[] s_cascadeNames = new String[]{"AD_Attachment", "AD_Archive", "K_Index", "AD_Note", "AD_RecentItem", "AD_PostIt"};
    private static int[] s_restricts = new int[]{417, 876};
    private static String[] s_restrictNames = new String[]{"R_Request", "CM_Chat"};
    private static CLogger log = CLogger.getCLogger(PO_Record.class);

    static boolean deleteCascade(int AD_Table_ID, int Record_ID, String trxName) {
        int i2 = 0;
        while (i2 < s_cascades.length) {
            if (s_cascades[i2] != AD_Table_ID) {
                Object[] params = new Object[]{AD_Table_ID, Record_ID};
                StringBuffer sql = new StringBuffer("DELETE FROM ").append(s_cascadeNames[i2]).append(" WHERE AD_Table_ID=? AND Record_ID=?");
                int no = DB.executeUpdate(sql.toString(), params, false, trxName);
                if (no > 0) {
                    if (log.isLoggable(Level.CONFIG)) {
                        log.config(String.valueOf(s_cascadeNames[i2]) + " (" + AD_Table_ID + "/" + Record_ID + ") #" + no);
                    }
                } else if (no < 0) {
                    log.severe(String.valueOf(s_cascadeNames[i2]) + " (" + AD_Table_ID + "/" + Record_ID + ") #" + no);
                    return false;
                }
            }
            ++i2;
        }
        int j = 0;
        while (j < s_parents.length) {
            if (s_parents[j] == AD_Table_ID) {
                int AD_Table_IDchild = s_parentChilds[j];
                Object[] params = new Object[]{AD_Table_IDchild, Record_ID};
                int i3 = 0;
                while (i3 < s_cascades.length) {
                    StringBuffer sql = new StringBuffer("DELETE FROM ").append(s_cascadeNames[i3]).append(" WHERE AD_Table_ID=? AND Record_ID IN (SELECT ").append(s_parentChildNames[j]).append("_ID FROM ").append(s_parentChildNames[j]).append(" WHERE ").append(s_parentNames[j]).append("_ID=?)");
                    int no = DB.executeUpdate(sql.toString(), params, false, trxName);
                    if (no > 0) {
                        if (log.isLoggable(Level.CONFIG)) {
                            log.config(String.valueOf(s_cascadeNames[i3]) + " " + s_parentNames[j] + " (" + AD_Table_ID + "/" + Record_ID + ") #" + no);
                        }
                    } else if (no < 0) {
                        log.severe(String.valueOf(s_cascadeNames[i3]) + " " + s_parentNames[j] + " (" + AD_Table_ID + "/" + Record_ID + ") #" + no);
                        return false;
                    }
                    ++i3;
                }
            }
            ++j;
        }
        return true;
    }

    public static void deleteModelCascade(String tableName, int Record_ID, String trxName) {
        String sql = "SELECT t.TableName,        c.ColumnName FROM   AD_Column c        JOIN AD_Table t ON c.AD_Table_ID = t.AD_Table_ID        LEFT JOIN AD_Ref_Table r ON c.AD_Reference_Value_ID = r.AD_Reference_ID        LEFT JOIN AD_Table tr ON r.AD_Table_ID = tr.AD_Table_ID WHERE  t.IsView = 'N'        AND t.IsActive = 'Y'        AND c.IsActive = 'Y'        AND ( ( c.AD_Reference_ID = 19               AND c.ColumnName = ? || '_ID' )               OR ( c.AD_Reference_ID IN ( 18, 30 )                    AND ( tr.TableName = ? OR ( tr.TableName IS NULL AND c.ColumnName = ? || '_ID' ) ) ) )        AND c.FKConstraintType = 'M' ";
        List<List<Object>> dependents = DB.getSQLArrayObjectsEx(trxName, "SELECT t.TableName,        c.ColumnName FROM   AD_Column c        JOIN AD_Table t ON c.AD_Table_ID = t.AD_Table_ID        LEFT JOIN AD_Ref_Table r ON c.AD_Reference_Value_ID = r.AD_Reference_ID        LEFT JOIN AD_Table tr ON r.AD_Table_ID = tr.AD_Table_ID WHERE  t.IsView = 'N'        AND t.IsActive = 'Y'        AND c.IsActive = 'Y'        AND ( ( c.AD_Reference_ID = 19               AND c.ColumnName = ? || '_ID' )               OR ( c.AD_Reference_ID IN ( 18, 30 )                    AND ( tr.TableName = ? OR ( tr.TableName IS NULL AND c.ColumnName = ? || '_ID' ) ) ) )        AND c.FKConstraintType = 'M' ", tableName, tableName, tableName);
        if (dependents != null) {
            for (List<Object> row : dependents) {
                String dependentTableName = (String)row.get(0);
                String dependentColumnName = (String)row.get(1);
                String dependentWhere = String.valueOf(dependentColumnName) + "=?";
                List poList = new Query(Env.getCtx(), dependentTableName, dependentWhere, trxName).setParameters(Record_ID).list();
                for (PO po : poList) {
                    po.deleteEx(true, trxName);
                }
            }
        }
    }

    static String exists(int AD_Table_ID, int Record_ID, String trxName) {
        int i2 = 0;
        while (i2 < s_restricts.length) {
            StringBuffer sql = new StringBuffer("SELECT COUNT(*) FROM ").append(s_restrictNames[i2]).append(" WHERE AD_Table_ID=? AND Record_ID=?");
            int no = DB.getSQLValue(trxName, sql.toString(), AD_Table_ID, Record_ID);
            if (no > 0) {
                return s_restrictNames[i2];
            }
            ++i2;
        }
        return null;
    }

    static void validate() {
        block6: {
            String sql = "SELECT AD_Table_ID, TableName FROM AD_Table WHERE IsView='N' ORDER BY TableName";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        PO_Record.validate(rs.getInt(1), rs.getString(2));
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    static void validate(int AD_Table_ID) {
        MTable table2 = new MTable(Env.getCtx(), AD_Table_ID, null);
        if (table2.isView()) {
            log.warning("Ignored - View " + table2.getTableName());
        } else {
            PO_Record.validate(table2.getAD_Table_ID(), table2.getTableName());
        }
    }

    private static void validate(int AD_Table_ID, String TableName) {
        int i2 = 0;
        while (i2 < s_cascades.length) {
            StringBuffer sql = new StringBuffer("DELETE FROM ").append(s_cascadeNames[i2]).append(" WHERE AD_Table_ID=").append(AD_Table_ID).append(" AND Record_ID NOT IN (SELECT ").append(TableName).append("_ID FROM ").append(TableName).append(")");
            int no = DB.executeUpdate(sql.toString(), null);
            if (no > 0 && log.isLoggable(Level.CONFIG)) {
                log.config(String.valueOf(s_cascadeNames[i2]) + " (" + AD_Table_ID + "/" + TableName + ") Invalid #" + no);
            }
            ++i2;
        }
    }
}

