/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.util.Iterator;
import java.util.List;
import org.compiere.model.MTable;
import org.compiere.model.PO;

public class POIterator<T extends PO>
implements Iterator<T> {
    private MTable table;
    private List<Object[]> idList;
    private int iteratorIndex = -1;
    private String trxName;
    private String keyWhereClause = null;

    public POIterator(MTable table2, List<Object[]> idList, String trxName) {
        this.table = table2;
        this.idList = idList;
        this.trxName = trxName;
    }

    @Override
    public boolean hasNext() {
        return this.iteratorIndex < this.idList.size() - 1;
    }

    @Override
    public T next() {
        if (this.iteratorIndex < this.idList.size() - 1) {
            ++this.iteratorIndex;
            return this.get(this.iteratorIndex);
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove operatiotn not supported.");
    }

    public int size() {
        return this.idList.size();
    }

    public T get(int index) {
        if (index <= this.idList.size() - 1) {
            Object[] ids = this.idList.get(index);
            if (ids.length == 1 && ids[0] instanceof Number) {
                return (T)this.table.getPO(((Number)ids[0]).intValue(), this.trxName);
            }
            if (this.keyWhereClause == null) {
                String[] keys = this.table.getKeyColumns();
                StringBuilder sqlBuffer = new StringBuilder();
                int i2 = 0;
                while (i2 < keys.length) {
                    if (i2 > 0) {
                        sqlBuffer.append(" AND ");
                    }
                    sqlBuffer.append(keys[i2]).append(" = ? ");
                    ++i2;
                }
                this.keyWhereClause = sqlBuffer.toString();
            }
            return (T)this.table.getPO(this.keyWhereClause, ids, this.trxName);
        }
        return null;
    }
}

